/*
 * Decompiled with CFR 0.152.
 */
package com.harium.storage.kdtree;

import com.harium.storage.kdtree.Checker;
import com.harium.storage.kdtree.Editor;
import com.harium.storage.kdtree.HPoint;
import com.harium.storage.kdtree.HRect;
import com.harium.storage.kdtree.NearestNeighborList;
import java.io.Serializable;
import java.util.List;

class KDNode<T>
implements Serializable {
    protected HPoint k;
    T v;
    protected KDNode<T> left;
    protected KDNode<T> right;
    protected boolean deleted;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> int edit(HPoint key, Editor<T> editor, KDNode<T> t2, int lev, int K2) {
        KDNode<T> next_node = null;
        int next_lev = (lev + 1) % K2;
        KDNode<T> kDNode = t2;
        synchronized (kDNode) {
            if (key.equals(t2.k)) {
                boolean was_deleted = t2.deleted;
                t2.v = editor.edit(t2.deleted ? null : (Object)t2.v);
                boolean bl = t2.deleted = t2.v == null;
                if (t2.deleted == was_deleted) {
                    return 0;
                }
                if (was_deleted) {
                    return 1;
                }
                return -1;
            }
            if (key.coord[lev] > t2.k.coord[lev]) {
                next_node = t2.right;
                if (next_node == null) {
                    t2.right = KDNode.create(key, editor);
                    return t2.right.deleted ? 0 : 1;
                }
            } else {
                next_node = t2.left;
                if (next_node == null) {
                    t2.left = KDNode.create(key, editor);
                    return t2.left.deleted ? 0 : 1;
                }
            }
        }
        return KDNode.edit(key, editor, next_node, next_lev, K2);
    }

    protected static <T> KDNode<T> create(HPoint key, Editor<T> editor) {
        KDNode<Object> t2 = new KDNode<Object>(key, editor.edit(null));
        if (t2.v == null) {
            t2.deleted = true;
        }
        return t2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> boolean del(KDNode<T> t2) {
        KDNode<T> kDNode = t2;
        synchronized (kDNode) {
            if (!t2.deleted) {
                t2.deleted = true;
                return true;
            }
        }
        return false;
    }

    protected static <T> KDNode<T> srch(HPoint key, KDNode<T> t2, int K2) {
        int lev = 0;
        while (t2 != null) {
            if (!t2.deleted && key.equals(t2.k)) {
                return t2;
            }
            t2 = key.coord[lev] > t2.k.coord[lev] ? t2.right : t2.left;
            lev = (lev + 1) % K2;
        }
        return null;
    }

    protected static <T> void rsearch(HPoint lowk, HPoint uppk, KDNode<T> t2, int lev, int K2, List<KDNode<T>> v) {
        if (t2 == null) {
            return;
        }
        if (lowk.coord[lev] <= t2.k.coord[lev]) {
            KDNode.rsearch(lowk, uppk, t2.left, (lev + 1) % K2, K2, v);
        }
        if (!t2.deleted) {
            int j;
            for (j = 0; j < K2 && lowk.coord[j] <= t2.k.coord[j] && uppk.coord[j] >= t2.k.coord[j]; ++j) {
            }
            if (j == K2) {
                v.add(t2);
            }
        }
        if (uppk.coord[lev] > t2.k.coord[lev]) {
            KDNode.rsearch(lowk, uppk, t2.right, (lev + 1) % K2, K2, v);
        }
    }

    protected static <T> void nnbr(KDNode<T> kd, HPoint target, HRect hr, double max_dist_sqd, int lev, int K2, NearestNeighborList<KDNode<T>> nnl, Checker<T> checker, long timeout) {
        HRect further_hr;
        KDNode<T> further_kd;
        HRect nearer_hr;
        KDNode<T> nearer_kd;
        boolean target_in_left;
        if (kd == null) {
            return;
        }
        if (timeout > 0L && timeout < System.currentTimeMillis()) {
            return;
        }
        int s2 = lev % K2;
        HPoint pivot = kd.k;
        double pivot_to_target = HPoint.sqrdist(pivot, target);
        HRect left_hr = hr;
        HRect right_hr = (HRect)hr.clone();
        left_hr.max.coord[s2] = pivot.coord[s2];
        right_hr.min.coord[s2] = pivot.coord[s2];
        boolean bl = target_in_left = target.coord[s2] < pivot.coord[s2];
        if (target_in_left) {
            nearer_kd = kd.left;
            nearer_hr = left_hr;
            further_kd = kd.right;
            further_hr = right_hr;
        } else {
            nearer_kd = kd.right;
            nearer_hr = right_hr;
            further_kd = kd.left;
            further_hr = left_hr;
        }
        KDNode.nnbr(nearer_kd, target, nearer_hr, max_dist_sqd, lev + 1, K2, nnl, checker, timeout);
        KDNode<T> nearest = nnl.getHighest();
        double dist_sqd = !nnl.isCapacityReached() ? Double.MAX_VALUE : nnl.getMaxPriority();
        max_dist_sqd = Math.min(max_dist_sqd, dist_sqd);
        HPoint closest = further_hr.closest(target);
        if (HPoint.sqrdist(closest, target) < max_dist_sqd) {
            if (pivot_to_target < dist_sqd) {
                nearest = kd;
                dist_sqd = pivot_to_target;
                if (!kd.deleted && (checker == null || checker.usable(kd.v))) {
                    nnl.insert(kd, dist_sqd);
                }
                max_dist_sqd = nnl.isCapacityReached() ? nnl.getMaxPriority() : Double.MAX_VALUE;
            }
            KDNode.nnbr(further_kd, target, further_hr, max_dist_sqd, lev + 1, K2, nnl, checker, timeout);
        }
    }

    private KDNode(HPoint key, T val) {
        this.k = key;
        this.v = val;
        this.left = null;
        this.right = null;
        this.deleted = false;
    }

    protected String toString(int depth) {
        String s2 = this.k + "  " + this.v + (this.deleted ? "*" : "");
        if (this.left != null) {
            s2 = s2 + "\n" + KDNode.pad(depth) + "L " + this.left.toString(depth + 1);
        }
        if (this.right != null) {
            s2 = s2 + "\n" + KDNode.pad(depth) + "R " + this.right.toString(depth + 1);
        }
        return s2;
    }

    private static String pad(int n) {
        String s2 = "";
        for (int i = 0; i < n; ++i) {
            s2 = s2 + " ";
        }
        return s2;
    }

    private static void hrcopy(HRect hr_src, HRect hr_dst) {
        KDNode.hpcopy(hr_src.min, hr_dst.min);
        KDNode.hpcopy(hr_src.max, hr_dst.max);
    }

    private static void hpcopy(HPoint hp_src, HPoint hp_dst) {
        for (int i = 0; i < hp_dst.coord.length; ++i) {
            hp_dst.coord[i] = hp_src.coord[i];
        }
    }
}

