/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class RenderTextFilter
extends AbstractBufferedImageOp {
    private String text;
    private Font font;
    private Paint paint;
    private Composite composite;
    private AffineTransform transform;

    public RenderTextFilter() {
    }

    public RenderTextFilter(String text, Font font, Paint paint, Composite composite, AffineTransform transform) {
        this.text = text;
        this.font = font;
        this.composite = composite;
        this.paint = paint;
        this.transform = transform;
    }

    public void setComposite(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        Graphics2D g2 = dst.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.font != null) {
            g2.setFont(this.font);
        }
        if (this.transform != null) {
            g2.setTransform(this.transform);
        }
        if (this.composite != null) {
            g2.setComposite(this.composite);
        }
        if (this.paint != null) {
            g2.setPaint(this.paint);
        }
        if (this.text != null) {
            g2.drawString(this.text, 10, 100);
        }
        g2.dispose();
        return dst;
    }
}

