/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom;

import com.moulberry.axiom.Authorization;
import com.moulberry.axiom.BuildConfig;
import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.ServerConfig;
import com.moulberry.axiom.block_maps.BlockColourMap;
import com.moulberry.axiom.blueprint.ServerBlueprintManager;
import com.moulberry.axiom.capabilities.BuildSymmetry;
import com.moulberry.axiom.configuration.Configuration;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.ServerCustomBlocks;
import com.moulberry.axiom.displayentity.ItemList;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.tutorial.TutorialManager;
import com.moulberry.axiom.hooks.ServerLevelExt;
import com.moulberry.axiom.marker.MarkerEntityManipulator;
import com.moulberry.axiom.packets.AxiomClientboundAckWorldProperties;
import com.moulberry.axiom.packets.AxiomClientboundCustomBlocks;
import com.moulberry.axiom.packets.AxiomClientboundEditorWarning;
import com.moulberry.axiom.packets.AxiomClientboundEnable;
import com.moulberry.axiom.packets.AxiomClientboundInitializeHotbars;
import com.moulberry.axiom.packets.AxiomClientboundMarkerData;
import com.moulberry.axiom.packets.AxiomClientboundMarkerNbtResponse;
import com.moulberry.axiom.packets.AxiomClientboundRegisterWorldProperties;
import com.moulberry.axiom.packets.AxiomClientboundResponseChunkData;
import com.moulberry.axiom.packets.AxiomClientboundRestrictions;
import com.moulberry.axiom.packets.AxiomClientboundSetEditorViews;
import com.moulberry.axiom.packets.AxiomClientboundSetWorldProperty;
import com.moulberry.axiom.packets.AxiomServerboundDeleteEntity;
import com.moulberry.axiom.packets.AxiomServerboundHello;
import com.moulberry.axiom.packets.AxiomServerboundManipulateEntity;
import com.moulberry.axiom.packets.AxiomServerboundMarkerNbtRequest;
import com.moulberry.axiom.packets.AxiomServerboundRequestChunkData;
import com.moulberry.axiom.packets.AxiomServerboundSetBlock;
import com.moulberry.axiom.packets.AxiomServerboundSetBuffer;
import com.moulberry.axiom.packets.AxiomServerboundSetEditorViews;
import com.moulberry.axiom.packets.AxiomServerboundSetFlySpeed;
import com.moulberry.axiom.packets.AxiomServerboundSetGameMode;
import com.moulberry.axiom.packets.AxiomServerboundSetHotbarSlot;
import com.moulberry.axiom.packets.AxiomServerboundSetTime;
import com.moulberry.axiom.packets.AxiomServerboundSetWorldProperty;
import com.moulberry.axiom.packets.AxiomServerboundSpawnEntity;
import com.moulberry.axiom.packets.AxiomServerboundSwitchActiveHotbar;
import com.moulberry.axiom.packets.AxiomServerboundTeleport;
import com.moulberry.axiom.packets.blueprint.AxiomClientboundBlueprintManifest;
import com.moulberry.axiom.packets.blueprint.AxiomClientboundResponseBlueprint;
import com.moulberry.axiom.packets.blueprint.AxiomServerboundRequestBlueprint;
import com.moulberry.axiom.packets.blueprint.AxiomServerboundUploadBlueprint;
import com.moulberry.axiom.render.BiomeOverlayRenderer;
import com.moulberry.axiom.render.ChunkRenderOverrider;
import com.moulberry.axiom.render.ShaderManager;
import com.moulberry.axiom.utils.DFUHelper;
import com.moulberry.axiom.utils.StringUtils;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_properties.AxiomGameRules;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.client.player.ClientPickBlockGatherCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_636;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Axiom
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger("axiom");
    private static Axiom INSTANCE;
    private boolean hasCommercialLicense = false;
    public ServerConfig serverConfig = null;
    private Path configDirectory;

    public static Axiom getInstance() {
        return INSTANCE;
    }

    public Path getConfigDirectory() {
        return this.configDirectory;
    }

    public void onInitialize() {
        INSTANCE = this;
        LOGGER.info("Initializing " + Authorization.getUserAgent() + ". Build timestamp: " + BuildConfig.BUILD_TIME);
        AxiomGameRules.register();
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            DFUHelper.checkContainerFormat();
            this.configDirectory = FabricLoader.getInstance().getConfigDir().resolve("axiom");
            Path configPath = this.configDirectory.resolve("axiom.hocon");
            Path internalConfigPath = this.configDirectory.resolve(".axiominternal.hocon");
            Configuration.load(configPath, internalConfigPath);
            try {
                Files.createDirectories(this.configDirectory.resolve("blueprints"), new FileAttribute[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Authorization.checkCommercial().thenAccept(hasCommercialLicense -> {
                Axiom.getInstance().hasCommercialLicense = hasCommercialLicense;
            });
            ClientPickBlockGatherCallback.EVENT.register((player, result) -> {
                if (result.method_17783() == class_239.class_240.field_1332 && result instanceof class_3965) {
                    class_3965 blockHitResult = (class_3965)result;
                    class_2680 blockState = player.method_37908().method_8320(blockHitResult.method_17777());
                    CustomBlockState customBlockState = ServerCustomBlocks.getCustomStateFor(blockState);
                    if (customBlockState != null) {
                        return customBlockState.getCustomBlock().customPickBlockStack();
                    }
                }
                return class_1799.field_8037;
            });
            ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)ShaderManager.INSTANCE);
            ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

                public class_2960 getFabricId() {
                    return new class_2960("axiom:blocklist");
                }

                public void method_14491(class_3300 resourceManager) {
                    EditorUI.getBlockList().reload();
                    ItemList.INSTANCE.markDirty();
                    BlockColourMap.invalidateCache();
                }
            });
            TutorialManager.initialize();
            ClientEvents.register();
            AxiomClientboundAckWorldProperties.register();
            AxiomClientboundSetWorldProperty.register();
            AxiomClientboundInitializeHotbars.register();
            AxiomClientboundEnable.register();
            AxiomClientboundCustomBlocks.register();
            AxiomClientboundEditorWarning.register();
            AxiomClientboundSetEditorViews.register();
            AxiomClientboundResponseChunkData.register();
            AxiomClientboundRegisterWorldProperties.register();
            AxiomClientboundRestrictions.register();
            AxiomClientboundMarkerData.register();
            AxiomClientboundMarkerNbtResponse.register();
            AxiomClientboundBlueprintManifest.register();
            AxiomClientboundResponseBlueprint.register();
        }
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            Path configDirectory = FabricLoader.getInstance().getConfigDir().resolve("axiom");
            Path blueprintDirectory = configDirectory.resolve("blueprints");
            try {
                Files.createDirectories(blueprintDirectory, new FileAttribute[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ServerBlueprintManager.initialize(blueprintDirectory);
        }
        ServerTickEvents.END_WORLD_TICK.register(world -> ((ServerLevelExt)world).axiom$processTasks());
        AxiomServerboundHello.register();
        AxiomServerboundSetHotbarSlot.register();
        AxiomServerboundSwitchActiveHotbar.register();
        AxiomServerboundSetTime.register();
        AxiomServerboundSetWorldProperty.register();
        AxiomServerboundSetGameMode.register();
        AxiomServerboundSetFlySpeed.register();
        AxiomServerboundTeleport.register();
        AxiomServerboundSetBlock.register();
        AxiomServerboundSetBuffer.register();
        AxiomServerboundSetEditorViews.register();
        AxiomServerboundRequestChunkData.register();
        AxiomServerboundManipulateEntity.register();
        AxiomServerboundSpawnEntity.register();
        AxiomServerboundDeleteEntity.register();
        AxiomServerboundMarkerNbtRequest.register();
        AxiomServerboundRequestBlueprint.register();
        AxiomServerboundUploadBlueprint.register();
    }

    public void dimensionChanged(class_5321<class_1937> resourceKey) {
        ChunkRenderOverrider.INSTANCE.clear();
        BiomeOverlayRenderer.INSTANCE.clear();
        Dispatcher.clearHistory();
        BuildSymmetry.clear();
        MarkerEntityManipulator.clear();
        if (this.hasCommercialLicense()) {
            this.loadCommercialLicenseHistory(resourceKey);
        }
    }

    public void loadCommercialLicenseHistory(class_5321<class_1937> resourceKey) {
        if (class_310.method_1551().method_1496()) {
            String resource = StringUtils.convertResourceToPretty(resourceKey.method_29177());
            Dispatcher.historyIdentifier = "Singleplayer/" + class_310.method_1551().method_1576().field_23784.method_27005() + "/" + resource;
        } else {
            String addressIdentifier;
            SocketAddress address = class_310.method_1551().method_1562().method_48296().method_10755();
            if (address instanceof InetSocketAddress) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
                addressIdentifier = inetSocketAddress.getAddress().getHostAddress();
            } else {
                addressIdentifier = address.toString();
            }
            String resource = StringUtils.convertResourceToPretty(resourceKey.method_29177());
            Dispatcher.historyIdentifier = "Multiplayer/" + addressIdentifier + "/" + resource;
        }
        Dispatcher.tryLoadHistory();
    }

    public boolean hasCommercialLicense() {
        return this.hasCommercialLicense || ClientEvents.hasServerCommercialLicense();
    }

    public static void dbg(String string) {
        LOGGER.info(string);
    }

    public static boolean isAxiomActive(class_1934 gameType) {
        if (INSTANCE == null || Axiom.INSTANCE.serverConfig == null) {
            return false;
        }
        if (!ClientEvents.allowedOnServer || !ClientEvents.serverSupportsAxiom || ClientEvents.remotelyDisabled) {
            return false;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        class_636 gameMode = class_310.method_1551().field_1761;
        if (gameMode == null) {
            return false;
        }
        return gameMode.method_2920() == gameType;
    }

    public static boolean isAxiomActive() {
        return Axiom.isAxiomActive(EditorUI.isEnabled() ? class_1934.field_9219 : class_1934.field_9220);
    }
}

