/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom;

import com.google.common.util.concurrent.RateLimiter;
import com.moulberry.axiom.clipboard.Clipboard;
import com.moulberry.axiom.displayentity.DisplayEntityManipulator;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.packets.AxiomClientboundRestrictions;
import net.minecraft.class_2338;

public class Restrictions {
    public static boolean canImportBlocks = true;
    public static boolean canUseEditor = true;
    public static boolean canEditDisplayEntities = true;
    public static RateLimiter rateLimiter = null;
    public static class_2338 boundsMin = null;
    public static class_2338 boundsMax = null;

    public static void update(AxiomClientboundRestrictions restrictions) {
        if (canImportBlocks && !restrictions.canImportBlocks) {
            Clipboard.INSTANCE.clearClipboard();
        }
        if (EditorUI.isActive() && !restrictions.canUseEditor) {
            EditorUI.toggleEnabled();
        }
        if (DisplayEntityManipulator.hasActiveGizmo() && !restrictions.canEditDisplayEntities) {
            DisplayEntityManipulator.disableActive();
        }
        canImportBlocks = restrictions.canImportBlocks;
        canUseEditor = restrictions.canUseEditor;
        canEditDisplayEntities = restrictions.canEditDisplayEntities;
        if (restrictions.maxSectionsPerSecond <= 0) {
            rateLimiter = null;
        } else if (rateLimiter != null) {
            rateLimiter.setRate((double)restrictions.maxSectionsPerSecond);
        } else {
            rateLimiter = RateLimiter.create((double)restrictions.maxSectionsPerSecond);
        }
        boundsMin = restrictions.boundsMin;
        boundsMax = restrictions.boundsMax;
    }

    public static void reset() {
        canImportBlocks = true;
        canUseEditor = true;
        canEditDisplayEntities = true;
        rateLimiter = null;
        boundsMin = null;
        boundsMax = null;
    }
}

