/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.block_maps;

import com.harium.storage.kdtree.KDTree;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2366;
import net.minecraft.class_2397;
import net.minecraft.class_2426;
import net.minecraft.class_2464;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_310;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_7764;
import net.minecraft.class_777;
import net.minecraft.class_7923;

public class BlockColourMap {
    public static int FLAG_SOLID = 1;
    public static int FLAG_OPAQUE = 2;
    public static int FLAG_FULL_CUBE = 4;
    public static int FLAG_SAME_TEXTURE = 8;
    public static int FLAG_NO_ORES = 16;
    public static int FLAG_NO_GLAZED_TERRACOTTA = 32;
    public static int FLAG_NO_TILE_ENTITIES = 64;
    private static final KDTree<class_2680> tree = new KDTree(3);
    private static final Map<class_2248, double[]> colourMap = new HashMap<class_2248, double[]>();
    private static boolean dirty = true;
    private static int lastFlags = -1;
    private static final double[] buffer = new double[3];

    private static void recalculate(int flags) {
        if (!(dirty || flags >= 0 && lastFlags != flags)) {
            return;
        }
        dirty = false;
        if (flags >= 0) {
            lastFlags = flags;
        } else if (lastFlags >= 0) {
            flags = lastFlags;
        } else {
            lastFlags = flags = FLAG_SOLID | FLAG_OPAQUE | FLAG_FULL_CUBE | FLAG_NO_TILE_ENTITIES;
        }
        tree.clear();
        colourMap.clear();
        for (class_2248 block : class_7923.field_41175) {
            class_2680 defaultState = block.method_9564();
            BlockColourResult result = BlockColourMap.calculateLAB(defaultState);
            if (result == null) continue;
            double[] lab = new double[]{result.l, result.a, result.b};
            colourMap.put(block, lab);
            if (defaultState.method_26217() != class_2464.field_11458 || (flags & FLAG_SOLID) != 0 && !BlockColourMap.isSolid(defaultState) || (flags & FLAG_OPAQUE) != 0 && !BlockColourMap.isOpaque(defaultState) || (flags & FLAG_FULL_CUBE) != 0 && !BlockColourMap.isFullCube(defaultState.method_26218((class_1922)class_2682.field_12294, class_2338.field_10980)) || (flags & FLAG_SAME_TEXTURE) != 0 && result.numTextures > 1 || (flags & FLAG_NO_ORES) != 0 && BlockColourMap.isOre(defaultState) || (flags & FLAG_NO_GLAZED_TERRACOTTA) != 0 && BlockColourMap.isGlazedTerracotta(defaultState) || (flags & FLAG_NO_TILE_ENTITIES) != 0 && BlockColourMap.isTileEntity(defaultState)) continue;
            tree.edit(lab, old -> {
                if (old != null) {
                    String oldName = old.method_26204().method_40142().method_40237().method_29177().method_12832();
                    String newName = defaultState.method_26204().method_40142().method_40237().method_29177().method_12832();
                    if (oldName.length() <= newName.length()) {
                        return old;
                    }
                    return defaultState;
                }
                return defaultState;
            });
        }
    }

    public static void invalidateCache() {
        colourMap.clear();
        tree.clear();
        dirty = true;
    }

    public static void rgb2lab(int R, int G, int B, double[] lab) {
        float eps = 0.008856452f;
        float k = 903.2963f;
        float Xr = 0.964221f;
        float Yr = 1.0f;
        float Zr = 0.825211f;
        float r = (float)R / 255.0f;
        float g2 = (float)G / 255.0f;
        float b = (float)B / 255.0f;
        r = (double)r <= 0.04045 ? (r /= 12.0f) : (float)Math.pow(((double)r + 0.055) / 1.055, 2.4);
        g2 = (double)g2 <= 0.04045 ? (g2 /= 12.0f) : (float)Math.pow(((double)g2 + 0.055) / 1.055, 2.4);
        b = (double)b <= 0.04045 ? (b /= 12.0f) : (float)Math.pow(((double)b + 0.055) / 1.055, 2.4);
        float X = 0.43605202f * r + 0.3850816f * g2 + 0.14308742f * b;
        float Y = 0.22249159f * r + 0.71688604f * g2 + 0.060621485f * b;
        float Z = 0.013929122f * r + 0.097097f * g2 + 0.7141855f * b;
        float xr = X / Xr;
        float yr = Y / Yr;
        float zr = Z / Zr;
        float fx = xr > eps ? (float)Math.pow(xr, 0.3333333333333333) : (float)(((double)(k * xr) + 16.0) / 116.0);
        float fy = yr > eps ? (float)Math.pow(yr, 0.3333333333333333) : (float)(((double)(k * yr) + 16.0) / 116.0);
        float fz = zr > eps ? (float)Math.pow(zr, 0.3333333333333333) : (float)(((double)(k * zr) + 16.0) / 116.0);
        float Ls = 116.0f * fy - 16.0f;
        float as = 500.0f * (fx - fy);
        float bs = 200.0f * (fy - fz);
        lab[0] = Ls;
        lab[1] = as;
        lab[2] = bs;
    }

    private static BlockColourResult calculateLAB(class_2680 blockState) {
        class_776 renderManager = class_310.method_1551().method_1541();
        class_5819 rand = class_5819.method_43047();
        double totalL = 0.0;
        double totalA = 0.0;
        double totalB = 0.0;
        double totalAlpha = 0.0;
        double[] lab = new double[3];
        HashSet<class_1058> sprites = new HashSet<class_1058>();
        class_1087 bakedModel = renderManager.method_3349(blockState);
        for (class_2350 direction : class_2350.values()) {
            for (class_777 quad : bakedModel.method_4707(blockState, direction, rand)) {
                class_1058 sprite;
                if (quad == null || (sprite = quad.method_35788()) == null) continue;
                float redMult = 1.0f;
                float greenMult = 1.0f;
                float blueMult = 1.0f;
                if (quad.method_3360()) {
                    int rgb = class_310.method_1551().method_1505().method_1697(blockState, null, null, quad.method_3359());
                    redMult = (float)(rgb >> 16 & 0xFF) / 255.0f;
                    greenMult = (float)(rgb >> 8 & 0xFF) / 255.0f;
                    blueMult = (float)(rgb & 0xFF) / 255.0f;
                }
                sprites.add(sprite);
                class_7764 spriteContents = sprite.method_45851();
                class_1011 image = spriteContents.field_40540[0];
                int width = spriteContents.method_45807();
                int height = spriteContents.method_45815();
                for (int u = 0; u < width; ++u) {
                    for (int v = 0; v < height; ++v) {
                        int abgr = image.method_4315(u, v);
                        int alpha = abgr >> 24 & 0xFF;
                        int blue = (int)((float)(abgr >> 16 & 0xFF) * blueMult);
                        int green = (int)((float)(abgr >> 8 & 0xFF) * greenMult);
                        int red = (int)((float)(abgr & 0xFF) * redMult);
                        BlockColourMap.rgb2lab(red, green, blue, lab);
                        float scale = (float)alpha / 255.0f;
                        totalL += lab[0] * (double)scale;
                        totalA += lab[1] * (double)scale;
                        totalB += lab[2] * (double)scale;
                        totalAlpha += (double)scale;
                    }
                }
            }
        }
        if (totalAlpha < 1.0) {
            return null;
        }
        double finalL = totalL / totalAlpha;
        double finalA = totalA / totalAlpha;
        double finalB = totalB / totalAlpha;
        return new BlockColourResult(finalL, finalA, finalB, sprites.size());
    }

    private static boolean isSolid(class_2680 blockState) {
        return blockState.method_51366();
    }

    private static boolean isOpaque(class_2680 blockState) {
        return class_4696.method_23679((class_2680)blockState) == class_1921.method_23577() && !(blockState.method_26204() instanceof class_2397);
    }

    private static boolean isFullCube(class_265 shape) {
        return shape == class_259.method_1077();
    }

    private static boolean isOre(class_2680 blockState) {
        return blockState.method_26204().method_40142().method_40237().method_29177().method_12832().contains("_ore");
    }

    private static boolean isGlazedTerracotta(class_2680 blockState) {
        return blockState.method_26204() instanceof class_2366 || blockState.method_26204().method_40142().method_40237().method_29177().method_12832().contains("_glazed_terracotta");
    }

    private static boolean isTileEntity(class_2680 blockState) {
        return blockState.method_31709() || blockState.method_26204() instanceof class_2426;
    }

    public static boolean isFullSolidOpaque(class_2680 blockState) {
        return blockState.method_26217() == class_2464.field_11458 && BlockColourMap.isFullCube(blockState.method_26218((class_1922)class_2682.field_12294, class_2338.field_10980)) && BlockColourMap.isSolid(blockState) && BlockColourMap.isOpaque(blockState);
    }

    public static double[] getLab(class_2248 block) {
        BlockColourMap.recalculate(-1);
        return colourMap.get(block);
    }

    public static class_2680 getNearestRgb(int rgb, int flags) {
        BlockColourMap.recalculate(flags);
        BlockColourMap.rgb2lab(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, buffer);
        return tree.nearest(buffer);
    }

    public static class_2680 getNearestLab(double l, double a, double b, int flags) {
        BlockColourMap.recalculate(flags);
        BlockColourMap.buffer[0] = l;
        BlockColourMap.buffer[1] = a;
        BlockColourMap.buffer[2] = b;
        return tree.nearest(buffer);
    }

    private record BlockColourResult(double l, double a, double b, int numTextures) {
    }
}

