/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.block_maps;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.downgrade.Downgrader;
import com.moulberry.axiom.utils.DFUHelper;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2680;

public class LegacyBlocks {
    private static class_2680[] LEGACY_BLOCKS = null;

    public static class_2680[] getLegacyBlocks() {
        if (LEGACY_BLOCKS == null) {
            LEGACY_BLOCKS = new class_2680[4095];
            try {
                URL url = Downgrader.class.getClassLoader().getResource("legacy.json");
                URLConnection connection = url.openConnection();
                connection.setUseCaches(false);
                try (InputStream is = connection.getInputStream();){
                    byte[] bytes = is.readAllBytes();
                    JsonObject jsonObject = (JsonObject)new Gson().fromJson(new String(bytes), JsonObject.class);
                    for (Map.Entry entry : jsonObject.entrySet()) {
                        class_2680 blockState;
                        String key = (String)entry.getKey();
                        String[] split = key.split(":");
                        int blockId = Integer.parseInt(split[0]);
                        int blockData = 0;
                        if (split.length >= 2) {
                            blockData = Integer.parseInt(split[1]);
                        }
                        String value = ((JsonElement)entry.getValue()).getAsString();
                        class_2487 blockTag = DFUHelper.createBlockTag(value);
                        LegacyBlocks.LEGACY_BLOCKS[blockId * 16 + blockData] = blockState = (class_2680)DFUHelper.updateBlockState(blockTag, 1631).getOrThrow(false, Axiom.LOGGER::error);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return LEGACY_BLOCKS;
    }
}

