/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.buildertools;

import com.moulberry.axiom.buildertools.BuilderTool;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.EffectRenderer;
import com.moulberry.axiom.tools.magic_select.MagicSelectionPreciseTask;
import com.moulberry.axiom.utils.Box;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_modification.HistoryEntry;
import java.text.NumberFormat;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.joml.Matrix4f;
import org.lwjgl.glfw.GLFW;

public class EraseBuilderTool
implements BuilderTool {
    private class_2338.class_2339 pos1 = null;
    private class_2338.class_2339 pos2 = null;

    @Override
    public void renderScreen(class_332 guiGraphics, int screenWidth, int screenHeight, float partialTick) {
        if (this.pos1 == null) {
            BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.erase.erase_box"), class_310.method_1551().field_1690.field_1886, 0);
            BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.erase.erase_connected"), class_310.method_1551().field_1690.field_1904, 1);
        } else if (this.pos2 == null) {
            BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.second_point"), class_310.method_1551().field_1690.field_1904, 0);
        } else {
            class_310 mc = class_310.method_1551();
            int n = screenHeight / 2;
            Objects.requireNonNull(mc.field_1772);
            int y = n + (9 + 4);
            String text = "[DEL] " + AxiomI18n.get("axiom.buildertool.erase.delete");
            int width = mc.field_1772.method_1727(text);
            guiGraphics.method_25303(mc.field_1772, text, screenWidth / 2 - width / 2, y, -2130706433);
            BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.scroll_extend"), class_310.method_1551().field_1690.field_1871, 1);
        }
    }

    @Override
    public void renderWorld(class_4184 camera, long time, class_4587 matrices, Matrix4f projection) {
        if (this.pos1 != null && this.pos2 != null) {
            int minX = Math.min(this.pos1.method_10263(), this.pos2.method_10263());
            int minY = Math.min(this.pos1.method_10264(), this.pos2.method_10264());
            int minZ = Math.min(this.pos1.method_10260(), this.pos2.method_10260());
            int maxX = Math.max(this.pos1.method_10263(), this.pos2.method_10263());
            int maxY = Math.max(this.pos1.method_10264(), this.pos2.method_10264());
            int maxZ = Math.max(this.pos1.method_10260(), this.pos2.method_10260());
            BuilderTool.renderBoxWithArrow(null, camera, time, matrices, projection, minX, minY, minZ, maxX, maxY, maxZ);
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                return;
            }
            if (class_310.method_1551().field_1755 == null && GLFW.glfwGetKey((long)class_310.method_1551().method_22683().method_4490(), (int)261) != 0 || GLFW.glfwGetKey((long)class_310.method_1551().method_22683().method_4490(), (int)259) != 0) {
                BuilderTool.delete((class_2338)this.pos1, (class_2338)this.pos2);
                this.pos1 = null;
                this.pos2 = null;
            }
        } else if (this.pos1 != null) {
            float x = this.pos1.method_10263();
            float y = this.pos1.method_10264();
            float z = this.pos1.method_10260();
            EffectRenderer.renderBoundingBox(camera, time, matrices, new class_243((double)x, (double)y, (double)z), new class_243((double)(x + 1.0f), (double)(y + 1.0f), (double)(z + 1.0f)), 3);
        }
    }

    @Override
    public boolean setPos1(class_2338 position) {
        this.pos1 = position.method_25503();
        return true;
    }

    @Override
    public boolean setPos2(class_2338 position) {
        this.pos2 = position.method_25503();
        return true;
    }

    @Override
    public void leftClick(class_239 hitResult) {
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            this.pos1 = ((class_3965)hitResult).method_17777().method_25503();
        }
    }

    @Override
    public void rightClick(class_239 hitResult) {
        if (hitResult.method_17783() == class_239.class_240.field_1332 && hitResult instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)hitResult;
            if (this.pos1 != null) {
                this.pos2 = ((class_3965)hitResult).method_17777().method_25503();
            } else {
                class_2338 hit = blockHitResult.method_17777();
                MagicSelectionPreciseTask task = new MagicSelectionPreciseTask(new PositionSet(), (class_1937)class_310.method_1551().field_1687, hit, 0);
                task.fill(128);
                String countString = NumberFormat.getInstance().format(task.positionSet.count());
                String historyDescription = AxiomI18n.get("axiom.history_description.deleted", countString);
                RegionHelper.pushPositionSetRegionChangeWithNBT(task.positionSet, class_2246.field_10124.method_9564(), hit, historyDescription, Dispatcher.simpleSourceInfo("Erase Builder Tool"), HistoryEntry.MODIFIER_CAN_BE_UNDONE_INGAME, null);
            }
        }
    }

    @Override
    public void middleClick(class_239 hitResult) {
        if (hitResult.method_17783() == class_239.class_240.field_1332 && hitResult instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)hitResult;
            if (this.pos1 == null) {
                this.pos1 = blockHitResult.method_17777().method_25503();
            } else if (this.pos2 == null) {
                this.pos2 = blockHitResult.method_17777().method_25503();
            } else {
                class_2338 pos = blockHitResult.method_17777();
                BuilderTool.extend(pos, this.pos1, this.pos2);
            }
        }
    }

    @Override
    public boolean scroll(int scroll) {
        return false;
    }

    @Override
    public boolean shouldRenderBlockOutline(class_2338 blockPos) {
        return true;
    }

    @Override
    public String getName() {
        return AxiomI18n.get("axiom.buildertool.erase");
    }

    @Override
    public boolean canBeReset() {
        return this.pos1 != null || this.pos2 != null;
    }

    @Override
    public void reset(boolean apply) {
        this.pos1 = null;
        this.pos2 = null;
    }

    @Override
    public Box getBox() {
        if (this.pos1 == null) {
            return null;
        }
        return new Box((class_2338)this.pos1, (class_2338)this.pos2);
    }

    @Override
    public void setBox(Box box) {
        this.pos1 = box.pos1().method_25503();
        this.pos2 = box.pos2() == null ? null : box.pos2().method_25503();
    }
}

