/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.capabilities;

import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.buildertools.BuilderToolManager;
import com.moulberry.axiom.buildertools.MirrorBuilderTool;
import com.moulberry.axiom.render.Shapes;
import com.moulberry.axiom.utils.VerticalBlockFlipping;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class BuildSymmetry {
    private static class_2338 symmetryPoint = null;
    private static boolean flipX = false;
    private static boolean flipY = false;
    private static boolean flipZ = false;
    private static boolean rotY = false;

    public static boolean isActive() {
        return symmetryPoint != null && BuilderToolManager.selectedToolIs(MirrorBuilderTool.class);
    }

    public static void clear() {
        symmetryPoint = null;
        rotY = false;
        flipZ = false;
        flipY = false;
        flipX = false;
    }

    public static void setSymmetryPoint(class_243 vec) {
        symmetryPoint = new class_2338((int)Math.round(vec.field_1352 * 2.0), (int)Math.round(vec.field_1351 * 2.0), (int)Math.round(vec.field_1350 * 2.0));
    }

    @Nullable
    public static class_243 getSymmetryPoint() {
        if (symmetryPoint == null) {
            return null;
        }
        return new class_243((double)((float)symmetryPoint.method_10263() * 0.5f), (double)((float)symmetryPoint.method_10264() * 0.5f), (double)((float)symmetryPoint.method_10260() * 0.5f));
    }

    public static void toggleRotY() {
        rotY = !rotY;
    }

    public static void toggleFlipX() {
        flipX = !flipX;
    }

    public static void toggleFlipY() {
        flipY = !flipY;
    }

    public static void toggleFlipZ() {
        flipZ = !flipZ;
    }

    public static Map<class_2338, class_2680> applySymmetry(Map<class_2338, class_2680> original) {
        int x;
        class_2338 pos;
        if (!BuildSymmetry.isActive()) {
            return original;
        }
        LinkedHashMap<Object, Object> mirrored = new LinkedHashMap<class_2338, class_2680>();
        if (!(flipX || flipY || flipZ || rotY)) {
            return original;
        }
        boolean doFlipX = flipX;
        boolean doFlipY = flipY;
        boolean doFlipZ = flipZ;
        int symmX = symmetryPoint.method_10263();
        int symmY = symmetryPoint.method_10264();
        int symmZ = symmetryPoint.method_10260();
        if (rotY) {
            if (doFlipX && doFlipZ) {
                doFlipZ = false;
            }
            if ((symmX + symmZ & 1) != 0) {
                if (Math.abs(symmZ) > Math.abs(symmX)) {
                    symmZ = (int)((float)symmZ - Math.signum(symmZ));
                } else if (symmX != 0) {
                    symmX = (int)((float)symmX - Math.signum(symmX));
                }
            }
            for (Map.Entry<class_2338, class_2680> entry : original.entrySet()) {
                pos = entry.getKey();
                x = pos.method_10263();
                int z = pos.method_10260();
                int newX = -Math.floorDiv(-(z * 2 - symmZ + symmX), 2);
                int newZ = Math.floorDiv(symmX + symmZ - x * 2 - 2, 2);
                if (newX != x || newZ != z) {
                    if (entry.getValue().method_26215()) {
                        mirrored.put(new class_2338(newX, pos.method_10264(), newZ), class_2246.field_10124.method_9564());
                    } else {
                        mirrored.putIfAbsent(new class_2338(newX, pos.method_10264(), newZ), entry.getValue().method_26186(class_2470.field_11465));
                    }
                }
                newX = symmX - x - 1;
                newZ = symmZ - z - 1;
                if (newX != x || newZ != z) {
                    if (entry.getValue().method_26215()) {
                        mirrored.put(new class_2338(newX, pos.method_10264(), newZ), class_2246.field_10124.method_9564());
                    } else {
                        mirrored.putIfAbsent(new class_2338(newX, pos.method_10264(), newZ), entry.getValue().method_26186(class_2470.field_11464));
                    }
                }
                newX = Math.floorDiv(symmZ + symmX - z * 2 - 2, 2);
                newZ = -Math.floorDiv(-(x * 2 - symmX + symmZ), 2);
                if (newX == x && newZ == z) continue;
                if (entry.getValue().method_26215()) {
                    mirrored.put(new class_2338(newX, pos.method_10264(), newZ), class_2246.field_10124.method_9564());
                    continue;
                }
                mirrored.putIfAbsent(new class_2338(newX, pos.method_10264(), newZ), entry.getValue().method_26186(class_2470.field_11463));
            }
        }
        if (doFlipX) {
            if (!mirrored.isEmpty()) {
                mirrored.putAll(original);
                original = mirrored;
                mirrored = new LinkedHashMap();
            }
            for (Map.Entry<class_2338, class_2680> entry : original.entrySet()) {
                pos = entry.getKey();
                x = pos.method_10263();
                int newX = symmX - x - 1;
                if (newX == x) continue;
                if (entry.getValue().method_26215()) {
                    mirrored.put(new class_2338(newX, pos.method_10264(), pos.method_10260()), class_2246.field_10124.method_9564());
                    continue;
                }
                mirrored.putIfAbsent(new class_2338(newX, pos.method_10264(), pos.method_10260()), entry.getValue().method_26185(class_2415.field_11301));
            }
        }
        if (doFlipZ) {
            if (!mirrored.isEmpty()) {
                mirrored.putAll(original);
                original = mirrored;
                mirrored = new LinkedHashMap();
            }
            for (Map.Entry<class_2338, class_2680> entry : original.entrySet()) {
                pos = entry.getKey();
                int z = pos.method_10260();
                int newZ = symmZ - z - 1;
                if (newZ == z) continue;
                if (entry.getValue().method_26215()) {
                    mirrored.put(new class_2338(pos.method_10263(), pos.method_10264(), newZ), class_2246.field_10124.method_9564());
                    continue;
                }
                mirrored.putIfAbsent(new class_2338(pos.method_10263(), pos.method_10264(), newZ), entry.getValue().method_26185(class_2415.field_11300));
            }
        }
        if (doFlipY) {
            if (!mirrored.isEmpty()) {
                mirrored.putAll(original);
                original = mirrored;
                mirrored = new LinkedHashMap();
            }
            for (Map.Entry<class_2338, class_2680> entry : original.entrySet()) {
                pos = entry.getKey();
                int y = pos.method_10264();
                int newY = symmY - y - 1;
                if (newY == y) continue;
                if (entry.getValue().method_26215()) {
                    mirrored.put(new class_2338(pos.method_10263(), newY, pos.method_10260()), class_2246.field_10124.method_9564());
                    continue;
                }
                mirrored.putIfAbsent(new class_2338(pos.method_10263(), newY, pos.method_10260()), VerticalBlockFlipping.flipY(entry.getValue()));
            }
        }
        mirrored.putAll(original);
        return mirrored;
    }

    public static void renderWorld(class_4184 camera, long time, class_4587 matrices, Matrix4f projection) {
        if (symmetryPoint != null && BuildSymmetry.isActive()) {
            class_243 tip;
            class_243 base;
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                BuildSymmetry.clear();
                return;
            }
            if (player.method_5649((double)((float)symmetryPoint.method_10263() * 0.5f), player.method_23318(), (double)((float)symmetryPoint.method_10260() * 0.5f)) > 16384.0) {
                player.method_43496((class_2561)class_2561.method_43470((String)"[Axiom] Build Symmetry disabled due to travelling more than 128 blocks away").method_27692(class_124.field_1054));
                BuildSymmetry.clear();
                return;
            }
            if (class_310.method_1551().field_1690.field_1842) {
                return;
            }
            matrices.method_22903();
            matrices.method_22904((double)((float)symmetryPoint.method_10263() * 0.5f - 0.1f) - camera.method_19326().field_1352, (double)((float)symmetryPoint.method_10264() * 0.5f - 0.1f) - camera.method_19326().field_1351, (double)((float)symmetryPoint.method_10260() * 0.5f - 0.1f) - camera.method_19326().field_1350);
            RenderSystem.applyModelViewMatrix();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableCull();
            RenderSystem.setShader(class_757::method_34540);
            class_287 bufferBuilder = class_289.method_1348().method_1349();
            Matrix4f pose = matrices.method_23760().method_23761();
            Matrix3f normal = matrices.method_23760().method_23762();
            bufferBuilder.method_1328(class_293.class_5596.field_27379, class_290.field_1576);
            if (!(flipX || flipY || flipZ || rotY)) {
                Shapes.shadedBoxTriangles(bufferBuilder, pose, 0.2f, 0.2f, 0.2f, -6250336);
            } else {
                Shapes.shadedBoxTriangles(bufferBuilder, pose, 0.2f, 0.2f, 0.2f, -256);
            }
            if (flipX) {
                base = new class_243(0.5, (double)0.1f, (double)0.1f);
                tip = new class_243((double)0.8f, (double)0.1f, (double)0.1f);
                Shapes.shadedCone(bufferBuilder, pose, base, tip, 0, 0.2f, -65536);
                base = new class_243((double)-0.3f, (double)0.1f, (double)0.1f);
                tip = new class_243((double)-0.6f, (double)0.1f, (double)0.1f);
                Shapes.shadedCone(bufferBuilder, pose, base, tip, 0, 0.2f, -65536);
            }
            if (flipY) {
                base = new class_243((double)0.1f, 0.5, (double)0.1f);
                tip = new class_243((double)0.1f, (double)0.8f, (double)0.1f);
                Shapes.shadedCone(bufferBuilder, pose, base, tip, 1, 0.2f, -16711936);
                base = new class_243((double)0.1f, (double)-0.3f, (double)0.1f);
                tip = new class_243((double)0.1f, (double)-0.6f, (double)0.1f);
                Shapes.shadedCone(bufferBuilder, pose, base, tip, 1, 0.2f, -16711936);
            }
            if (flipZ) {
                base = new class_243((double)0.1f, (double)0.1f, 0.5);
                tip = new class_243((double)0.1f, (double)0.1f, (double)0.8f);
                Shapes.shadedCone(bufferBuilder, pose, base, tip, 2, 0.2f, -16776961);
                base = new class_243((double)0.1f, (double)0.1f, (double)-0.3f);
                tip = new class_243((double)0.1f, (double)0.1f, (double)-0.6f);
                Shapes.shadedCone(bufferBuilder, pose, base, tip, 2, 0.2f, -16776961);
            }
            class_291 vertexBuffer = null;
            class_287.class_7433 end = bufferBuilder.method_43575();
            if (end != null) {
                vertexBuffer = new class_291(class_291.class_8555.field_44793);
                vertexBuffer.method_1353();
                vertexBuffer.method_1352(end);
                RenderSystem.setShaderColor((float)0.8f, (float)0.8f, (float)0.8f, (float)0.5f);
                RenderSystem.disableDepthTest();
                vertexBuffer.method_34427(RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
                class_291.method_1354();
            }
            if (rotY) {
                RenderSystem.disableCull();
                RenderSystem.setShader(class_757::method_34535);
                bufferBuilder.method_1328(class_293.class_5596.field_27377, class_290.field_29337);
                RenderSystem.lineWidth((float)2.0f);
                float lastX = 0.0f;
                float lastZ = 0.0f;
                for (int i = 0; i <= 36; ++i) {
                    double angle = Math.toRadians(i * 10);
                    double sin2 = Math.sin(angle);
                    double cos2 = Math.cos(angle);
                    float x = (float)sin2 * 0.35f;
                    float z = (float)cos2 * 0.35f;
                    if (i > 0) {
                        float nx = x - lastX;
                        float nz = z - lastZ;
                        float norm = 1.0f / (float)Math.sqrt(nx * nx + nz * nz);
                        bufferBuilder.method_22918(pose, lastX + 0.1f, 0.1f, lastZ + 0.1f).method_39415(-16711936).method_23763(normal, nx *= norm, 0.0f, nz *= norm).method_1344();
                        bufferBuilder.method_22918(pose, x + 0.1f, 0.1f, z + 0.1f).method_39415(-16711936).method_23763(normal, nx, 0.0f, nz).method_1344();
                        bufferBuilder.method_22918(pose, lastX * 0.8f + 0.1f, 0.1f, lastZ * 0.8f + 0.1f).method_39415(-16711936).method_23763(normal, nx, 0.0f, nz).method_1344();
                        bufferBuilder.method_22918(pose, x * 0.8f + 0.1f, 0.1f, z * 0.8f + 0.1f).method_39415(-16711936).method_23763(normal, nx, 0.0f, nz).method_1344();
                    }
                    lastX = x;
                    lastZ = z;
                }
                BuildSymmetry.drawTwice(bufferBuilder.method_1326());
            }
            if (vertexBuffer != null) {
                RenderSystem.enableCull();
                RenderSystem.setShader(class_757::method_34540);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableDepthTest();
                vertexBuffer.method_1353();
                vertexBuffer.method_34427(RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
                class_291.method_1354();
                vertexBuffer.close();
            }
            matrices.method_22909();
        }
    }

    private static void drawTwice(class_287.class_7433 renderedBuffer) {
        class_291 vertexBuffer = class_286.method_43439((class_287.class_7433)renderedBuffer);
        if (vertexBuffer != null) {
            RenderSystem.setShaderColor((float)0.8f, (float)0.8f, (float)0.8f, (float)0.5f);
            RenderSystem.disableDepthTest();
            vertexBuffer.method_34427(RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableDepthTest();
            vertexBuffer.method_34427(RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
        }
    }
}

