/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.clipboard;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.Restrictions;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.blueprint.Blueprint;
import com.moulberry.axiom.clipboard.ClipboardObject;
import com.moulberry.axiom.clipboard.Placement;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.windows.BlueprintCreateWindow;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;

public enum Clipboard {
    INSTANCE;

    private ClipboardObject clipboardObject;
    private AtomicInteger clipboardId = new AtomicInteger();

    public int setClipboard(ChunkedBlockRegion blockBuffer, Long2ObjectMap<CompressedBlockEntity> blockEntities, String name, float preferredYaw) {
        if (blockBuffer.isEmpty()) {
            throw new IllegalArgumentException("blockBuffer must not be empty");
        }
        return this.setClipboard(new ClipboardObject.Anonymous(blockBuffer, blockEntities, name, preferredYaw));
    }

    public int setClipboard(Blueprint blueprint) {
        if (!Restrictions.canImportBlocks) {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                player.method_43496((class_2561)class_2561.method_43470((String)"The server has disallowed the use of blueprints").method_27692(class_124.field_1061));
            }
            return -1;
        }
        if (blueprint.blockRegion().isEmpty()) {
            throw new IllegalArgumentException("blockBuffer must not be empty");
        }
        return this.setClipboard(new ClipboardObject.FromBlueprint(blueprint));
    }

    public int setClipboard(ClipboardObject clipboardObject) {
        if (this.clipboardObject != null) {
            this.clipboardObject.close();
        }
        this.clipboardObject = clipboardObject;
        return this.clipboardId.incrementAndGet();
    }

    public void clearClipboard() {
        if (this.clipboardObject != null) {
            this.clipboardObject.close();
            this.clipboardObject = null;
        }
    }

    public boolean hasClipboardId(int id) {
        if (this.clipboardObject == null) {
            return false;
        }
        return this.clipboardId.get() == id;
    }

    public ClipboardObject getClipboard() {
        return this.clipboardObject;
    }

    public UserAction.ActionResult callAction(UserAction action, Object object) {
        if (!EditorUI.isActive()) {
            return UserAction.ActionResult.NOT_HANDLED;
        }
        if (this.clipboardObject == null || this.clipboardObject.blockRegion().isEmpty()) {
            return UserAction.ActionResult.NOT_HANDLED;
        }
        switch (action) {
            case PASTE: {
                RayCaster.RaycastResult raycast = Tool.raycastBlock();
                if (raycast != null) {
                    ChunkedBlockRegion blockRegion = this.clipboardObject.blockRegion();
                    class_2350.class_2351 axis = raycast.getDirection().method_10166();
                    int max2 = blockRegion.max().method_30558(axis);
                    int min2 = blockRegion.min().method_30558(axis);
                    int count = (max2 - min2 + 1) / 2 + 1;
                    if (Math.abs(max2 - min2) % 2 == 1) {
                        class_2350.class_2352 biasDirection;
                        class_2350.class_2352 class_23522 = biasDirection = Math.abs(max2) > Math.abs(min2) ? class_2350.class_2352.field_11056 : class_2350.class_2352.field_11060;
                        if (biasDirection == raycast.getDirection().method_10171()) {
                            --count;
                        }
                    }
                    class_2338 offset = raycast.getBlockPos().method_10079(raycast.getDirection(), count);
                    Placement.INSTANCE.startPlacement(offset, this.clipboardObject.blockRegion(), this.clipboardObject.blockEntities(), this.clipboardObject.placementDescription());
                    return UserAction.ActionResult.USED_STOP;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case SAVE: {
                BlueprintCreateWindow.open(this.clipboardObject.blockRegion(), this.clipboardObject.blockEntities());
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }
}

