/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.moulberry.axiom.commands.SpannedStyle;
import com.moulberry.axiom.commands.SyntaxStyles;
import java.util.List;

public class BooleanArgument {
    public static Boolean parse(StringReader reader) throws CommandSyntaxException {
        return reader.readBoolean();
    }

    public static void highlight(List<SpannedStyle> styles, StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        BooleanArgument.parse(reader);
        styles.add(new SpannedStyle(SyntaxStyles.BOOLEAN_ARGUMENT, start, reader.getCursor()));
    }

    public static Suggestions suggest(SuggestionsBuilder builder) {
        if ("true".startsWith(builder.getRemainingLowerCase())) {
            builder.suggest("true");
        }
        if ("false".startsWith(builder.getRemainingLowerCase())) {
            builder.suggest("false");
        }
        return builder.build();
    }
}

