/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.commands.operations.impl;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.moulberry.axiom.commands.DispatcherMetadata;
import com.moulberry.axiom.commands.SpannedStyle;
import com.moulberry.axiom.commands.arguments.IntegerArgument;
import com.moulberry.axiom.commands.operations.CommandDefinition;
import com.moulberry.axiom.commands.operations.CommandOperation;
import com.moulberry.axiom.commands.parser.ActiveArgumentParser;
import com.moulberry.axiom.commands.parser.Argument;
import com.moulberry.axiom.commands.parser.ArgumentParser;
import com.moulberry.axiom.world_modification.BlockBuffer;
import de.articdive.jnoise.generators.noise_parameters.simplex_variants.Simplex2DVariant;
import de.articdive.jnoise.generators.noise_parameters.simplex_variants.Simplex3DVariant;
import de.articdive.jnoise.generators.noise_parameters.simplex_variants.Simplex4DVariant;
import de.articdive.jnoise.pipeline.JNoise;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_2680;

public class AxiomNoiseHeightCommand {

    public static class Operation
    extends CommandOperation {
        private final JNoise noise;

        public Operation(int radius) {
            this.noise = JNoise.newBuilder().scale(1.0f / (float)radius).superSimplex(ThreadLocalRandom.current().nextInt(), Simplex2DVariant.CLASSIC, Simplex3DVariant.IMPROVE_XZ, Simplex4DVariant.IMPROVE_XYZ_IMPROVE_XZ).build();
        }

        @Override
        public boolean executeSingle(DispatcherMetadata metadata, int x, int y, int z, float percentage, class_2680 block, BlockBuffer buffer) {
            float n;
            int maxY;
            int minY = metadata.selectionMin().method_10264();
            int thresholdY = Math.round((float)minY + (float)((maxY = metadata.selectionMax().method_10264()) - minY) * (n = (float)(this.noise.evaluateNoise((float)x + 0.5f, (float)z + 0.5f) + 1.0) / 2.0f));
            if (y < thresholdY) {
                return super.executeSingle(metadata, x, y, z, percentage, block, buffer);
            }
            return false;
        }
    }

    public static class Definition
    implements CommandDefinition {
        private final ArgumentParser parser = new ArgumentParser(Argument.positional("radius", IntegerArgument::parse, IntegerArgument::highlight, IntegerArgument::suggest));

        @Override
        public CommandOperation createOperation(StringReader reader) throws CommandSyntaxException {
            try (ActiveArgumentParser parser = this.parser.start(reader);){
                int radius = (Integer)parser.get();
                Operation operation = new Operation(radius);
                return operation;
            }
        }

        @Override
        public void syntaxHighlight(List<SpannedStyle> styles, StringReader reader, boolean isLast) throws CommandSyntaxException {
            this.parser.syntaxHighlight(styles, reader, isLast);
        }

        @Override
        public Suggestions autocomplete(SuggestionsBuilder builder, StringReader reader) {
            return this.parser.autocomplete(builder, reader);
        }
    }
}

