/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.commands.parser;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.moulberry.axiom.commands.SpannedStyle;
import com.moulberry.axiom.commands.SyntaxStyles;
import com.moulberry.axiom.commands.exception.NotEnoughArgumentsCommandExceptionType;
import com.moulberry.axiom.commands.parser.ActiveArgumentParser;
import com.moulberry.axiom.commands.parser.Argument;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;

public class ArgumentParser {
    public static final SimpleCommandExceptionType TOO_MANY_ARGUMENTS = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"axiom.command.too_many_arguments"));
    private final Argument.Positional[] positional;

    public ArgumentParser(Argument ... arguments) {
        ArrayList<Argument.Positional> argumentList = new ArrayList<Argument.Positional>();
        for (Argument argument : arguments) {
            if (!(argument instanceof Argument.Positional)) {
                throw new IncompatibleClassChangeError();
            }
            Argument.Positional positional = (Argument.Positional)argument;
            argumentList.add(positional);
        }
        this.positional = argumentList.toArray(new Argument.Positional[0]);
    }

    public ActiveArgumentParser start(StringReader reader) {
        return new ActiveArgumentParser(this.positional, reader);
    }

    public void syntaxHighlight(List<SpannedStyle> styles, StringReader reader, boolean isLast) throws CommandSyntaxException {
        reader.skipWhitespace();
        int commandNameStart = reader.getCursor();
        reader.readString();
        int commandNameEnd = reader.getCursor();
        if (isLast) {
            styles.add(new SpannedStyle(SyntaxStyles.OPERATION, commandNameStart, commandNameEnd));
        }
        for (int i = 0; i < this.positional.length; ++i) {
            reader.skipWhitespace();
            Argument.Positional argument = this.positional[i];
            if (!reader.canRead()) {
                if (!isLast) {
                    styles.add(0, new SpannedStyle(SyntaxStyles.OPERATION, commandNameStart, commandNameEnd));
                }
                ArgumentParser.throwNotEnoughArguments(reader, i, this.positional);
                return;
            }
            ArrayList<SpannedStyle> argumentStyles = new ArrayList<SpannedStyle>();
            try {
                argument.highlighter().apply(argumentStyles, reader);
                styles.addAll(argumentStyles);
                continue;
            }
            catch (CommandSyntaxException e) {
                for (SpannedStyle style : argumentStyles) {
                    if (style.start() >= e.getCursor()) continue;
                    styles.add(new SpannedStyle(style.style(), style.start(), Math.min(style.end(), e.getCursor())));
                }
                reader.setCursor(e.getCursor());
                reader.readString();
                styles.add(new SpannedStyle(SyntaxStyles.ERROR, e.getCursor(), reader.getCursor()));
                throw e;
            }
        }
        reader.skipWhitespace();
        if (!isLast) {
            styles.add(0, new SpannedStyle(SyntaxStyles.OPERATION, commandNameStart, commandNameEnd));
        }
        if (reader.canRead()) {
            int start = reader.getCursor();
            reader.readString();
            int end = reader.getCursor();
            styles.add(new SpannedStyle(SyntaxStyles.ERROR, start, end));
            throw TOO_MANY_ARGUMENTS.createWithContext((ImmutableStringReader)reader);
        }
    }

    public Suggestions autocomplete(SuggestionsBuilder builder, StringReader reader) {
        try {
            reader.skipWhitespace();
            reader.readString();
            for (Argument.Positional argument : this.positional) {
                reader.skipWhitespace();
                if (!reader.canRead()) {
                    return null;
                }
                int start = reader.getCursor();
                try {
                    argument.parser().apply(reader);
                }
                catch (CommandSyntaxException ignored) {
                    reader.setCursor(start);
                    return argument.suggestions().apply(builder);
                }
                if (reader.canRead()) continue;
                reader.setCursor(start);
                return argument.suggestions().apply(builder);
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return null;
    }

    static void throwNotEnoughArguments(StringReader reader, int i, Argument.Positional[] positional) throws CommandSyntaxException {
        ArrayList<String> names = new ArrayList<String>();
        for (int j = i; j < positional.length; ++j) {
            names.add(positional[j].name());
        }
        throw new NotEnoughArgumentsCommandExceptionType(names).createWithContext((ImmutableStringReader)reader);
    }

    @FunctionalInterface
    public static interface Highlighter {
        public void apply(List<SpannedStyle> var1, StringReader var2) throws CommandSyntaxException;
    }

    @FunctionalInterface
    public static interface Parser<T> {
        public T apply(StringReader var1) throws CommandSyntaxException;
    }
}

