/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.configuration;

import com.moulberry.axiom.configuration.AbstractConfigurationCategory;
import com.moulberry.axiom.configuration.Configuration;
import org.spongepowered.configurate.CommentedConfigurationNode;

public class RenderingConfiguration
extends AbstractConfigurationCategory {
    public float minBrightness = ((Number)this.load(Number.class, "minBrightness", Float.valueOf(0.0f), "Minimum brightness level. 0.0 = default, 1.0 = fullbright")).floatValue();
    public float liquidOpacity = ((Number)this.load(Number.class, "liquidOpacity", Float.valueOf(1.0f), "Liquid opacity multiplier")).floatValue();
    public boolean keypressOverlay = this.load(Boolean.class, "keypressOverlay", false, "Shows keypresses on the screen");
    public boolean showKeyHints = this.load(Boolean.class, "showKeyHints", true, "Shows hints in the bottom right corner of the screen");
    public boolean showDisplayEntities = this.load(Boolean.class, "showDisplayEntities", true, "Shows gizmos for display entities, allowing you to modify them");
    public boolean showMarkerEntities = this.load(Boolean.class, "showMarkerEntities", true, "Shows gizmos for marker entities, allowing you to modify them");

    public RenderingConfiguration(CommentedConfigurationNode node) {
        super(node);
    }

    @Override
    public void save() {
        this.set("minBrightness", Float.valueOf(this.minBrightness));
        this.set("liquidOpacity", Float.valueOf(this.liquidOpacity));
        this.set("keypressOverlay", this.keypressOverlay);
        this.set("showKeyHints", this.showKeyHints);
        this.set("showDisplayEntities", this.showDisplayEntities);
        this.set("showMarkerEntities", this.showMarkerEntities);
    }

    public int getLiquidOpacity() {
        int opacity = Math.round(Configuration.rendering().liquidOpacity * 255.0f);
        if (opacity > 255) {
            opacity = 255;
        }
        if (opacity < 0) {
            opacity = 0;
        }
        return opacity;
    }
}

