/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor;

public record ButtonSpacingSpec(int buttonsPerRow, float spacingX, float spacingY) {
    public static ButtonSpacingSpec calculate(float availableSpace, float sizeX, int maxItems, float maxSpacing, boolean center) {
        float spacingX;
        int buttonsPerRow = (int)Math.floor(availableSpace / sizeX);
        if (maxItems > 0 && buttonsPerRow > maxItems) {
            buttonsPerRow = maxItems;
        }
        if (buttonsPerRow <= 1) {
            buttonsPerRow = 1;
            spacingX = 0.0f;
        } else {
            spacingX = (availableSpace - (float)buttonsPerRow * sizeX) / (float)(buttonsPerRow + (center ? 1 : -1));
            while (spacingX < 2.0f && buttonsPerRow > 1) {
                spacingX = (availableSpace - (float)(--buttonsPerRow) * sizeX) / (float)(buttonsPerRow + (center ? 1 : -1));
            }
            if (spacingX > maxSpacing) {
                spacingX = maxSpacing;
            }
        }
        if (buttonsPerRow == 1) {
            spacingX = center ? availableSpace / 2.0f - sizeX / 2.0f : 0.0f;
        }
        float spacingY = spacingX;
        if (buttonsPerRow == 1) {
            spacingY = 2.0f;
        } else if (spacingY < 2.0f) {
            spacingY = 2.0f;
        }
        return new ButtonSpacingSpec(buttonsPerRow, spacingX, spacingY);
    }
}

