/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor;

import com.moulberry.axiom.ExpressionEvaluator;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.editor.BlockList;
import com.moulberry.axiom.editor.DragDropPayloads;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.keybinds.Keybind;
import com.moulberry.axiom.editor.widgets.SelectBlockWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.BlockRenderCache;
import imgui.ImDrawList;
import imgui.ImGui;
import imgui.ImGuiListClipper;
import imgui.ImVec2;
import imgui.callback.ImListClipperCallback;
import imgui.type.ImBoolean;
import imgui.type.ImString;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import net.minecraft.class_2248;
import net.minecraft.class_6885;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImGuiHelper {
    private static boolean closeableModalOnTopLast = false;
    private static boolean closeableModalOnTop = false;
    private static boolean inputIntScrolledLastFrame = false;
    private static boolean inputIntScrolledThisFrame = false;
    private static boolean wantSpecialInputLastFrame = false;
    private static boolean wantSpecialInputThisFrame = false;
    private static StringBuilder specialInput = new StringBuilder();
    private static int backspaceCount = 0;
    private static Keybind editingKeybindLastFrame = null;
    private static Keybind editingKeybindThisFrame = null;
    private static boolean handledFocusNext = false;
    private static boolean focusNext = false;
    public static float borderIndentation = 0.0f;
    private static int pushedColors = 0;
    private static int pushedStyleVars = 0;

    public static Label translateLabel(String key) {
        String title = AxiomI18n.get(key);
        String descriptionKey = key + ".description";
        String description = AxiomI18n.get(descriptionKey);
        if (description.equals(descriptionKey)) {
            description = null;
        }
        return new Label(key, title, description);
    }

    public static void drawBlockState(ImDrawList drawList, CustomBlockState state, float x, float y, float size) {
        float dpiScale = ImGui.getWindowDpiScale();
        int img = BlockRenderCache.request(state, Math.round(size * dpiScale), Math.round(size * dpiScale), false);
        if (img != -1) {
            drawList.addImage(img, x, y, x + size, y + size, 0.0f, 1.0f, 1.0f, 0.0f);
        }
    }

    public static String getString(ImString string) {
        char c;
        StringBuilder builder = new StringBuilder();
        String str = string.get();
        for (int i = 0; i < str.length() && (c = str.charAt(i)) != '\u0000'; ++i) {
            builder.append(c);
        }
        return builder.toString();
    }

    public static CustomBlockState blockScrollList(final List<BlockList.Entry> blocks, int width, int height, boolean firstOpen) {
        if (ImGui.beginChild("##BlockScroller", (float)width, (float)height, true)) {
            if (firstOpen) {
                ImGui.setScrollY(0.0f);
            }
            float available = ImGui.getContentRegionAvailX() + ImGui.getStyle().getItemSpacingX();
            float itemWidth = (float)((int)(32.0f * EditorUI.getUiScale())) + ImGui.getStyle().getItemSpacingX();
            final int count = (int)Math.floor(available / itemWidth);
            final AtomicReference<Object> clickedBlock = new AtomicReference<Object>(null);
            ImGuiListClipper.forEach((int)Math.ceil((float)blocks.size() / (float)count), new ImListClipperCallback(){

                @Override
                public void accept(int index) {
                    int from = index * count;
                    int to = Math.min(from + count, blocks.size());
                    for (int i = from; i < to; ++i) {
                        BlockList.Entry entry = (BlockList.Entry)blocks.get(i);
                        if (i != from) {
                            ImGui.sameLine();
                        }
                        if (ImGuiHelper.blockStateButton(entry.state(), i, (int)(32.0f * EditorUI.getUiScale()))) {
                            clickedBlock.set(entry.state());
                        }
                        if (!ImGui.isItemHovered()) continue;
                        ImGui.beginTooltip();
                        ImGui.text(AxiomI18n.get(entry.translationKey()));
                        ImGui.textDisabled(entry.location().toString());
                        ImGui.endTooltip();
                    }
                }
            });
            ImGui.endChild();
            if (clickedBlock.get() != null) {
                return clickedBlock.get();
            }
        }
        return null;
    }

    public static class_6885<class_2248> tagScrollList(final List<BlockList.TagEntry> tags, int width, int height, boolean firstOpen) {
        if (ImGui.beginChild("##TagScroller", (float)width, (float)height, true)) {
            if (firstOpen) {
                ImGui.setScrollY(0.0f);
            }
            final AtomicReference<Object> clickedTag = new AtomicReference<Object>(null);
            ImGuiListClipper.forEach(tags.size(), new ImListClipperCallback(){

                @Override
                public void accept(int index) {
                    BlockList.TagEntry entry = (BlockList.TagEntry)tags.get(index);
                    int size = entry.set().method_40247();
                    if (ImGui.button(entry.location().toString() + " (" + size + ")", -1.0f, 0.0f)) {
                        clickedTag.set(entry.set());
                    }
                    if (ImGui.isItemHovered()) {
                        ImGui.beginTooltip();
                        if (size <= 9) {
                            for (int i = 0; i < size; ++i) {
                                class_2248 block = (class_2248)entry.set().method_40240(i).comp_349();
                                float posX = ImGui.getCursorScreenPosX();
                                float posY = ImGui.getCursorScreenPosY();
                                ImGui.dummy(32.0f, 32.0f);
                                ImGuiHelper.drawBlockState(ImGui.getWindowDrawList(), (CustomBlockState)block.method_9564(), posX, posY, 32.0f);
                                if (i == 2 || i == 5) continue;
                                ImGui.sameLine();
                            }
                        } else {
                            float hSpacing = 32.0f + ImGui.getStyle().getItemSpacingX();
                            float vSpacing = 32.0f + ImGui.getStyle().getItemSpacingY();
                            int verticalCount = (size + 2) / 3;
                            long time = System.currentTimeMillis();
                            int scroll = (int)(time / 500L);
                            float partial = (float)(time - time / 500L * 500L) / 500.0f;
                            if ((scroll %= verticalCount) < 0) {
                                scroll += verticalCount;
                            }
                            for (int i = 0; i < 15; ++i) {
                                int j = scroll * 3 + i - 3;
                                if (j < 0) {
                                    j += verticalCount * 3;
                                }
                                if (j / 3 >= verticalCount) {
                                    j -= verticalCount * 3;
                                }
                                if (j >= size) continue;
                                class_2248 block = (class_2248)entry.set().method_40240(j).comp_349();
                                float posX = ImGui.getCursorScreenPosX() + hSpacing * (float)(i % 3);
                                float posY = ImGui.getCursorScreenPosY() + vSpacing * ((float)(i / 3) - partial);
                                if (j == 0) {
                                    ImGui.getWindowDrawList().addLine(ImGui.getCursorScreenPosX(), posY - 3.0f, ImGui.getCursorScreenPosX() + hSpacing * 3.0f, posY - 3.0f, ImGui.getColorU32(27));
                                }
                                ImGuiHelper.drawBlockState(ImGui.getWindowDrawList(), (CustomBlockState)block.method_9564(), posX, posY, 32.0f);
                            }
                            ImGui.dummy(hSpacing * 3.0f - ImGui.getStyle().getItemSpacingX(), vSpacing * 3.0f - ImGui.getStyle().getItemSpacingY());
                        }
                        ImGui.endTooltip();
                    }
                }
            });
            ImGui.endChild();
            if (clickedTag.get() != null) {
                return clickedTag.get();
            }
        }
        return null;
    }

    public static CustomBlockState blockStateWidget(SelectBlockWidget selectBlockWidget, CustomBlockState state, String label, int id) {
        int size = (int)(32.0f * EditorUI.getUiScale());
        ImVec2 originalPos = ImGui.getCursorScreenPos();
        boolean blockButtonClick = ImGuiHelper.blockStateButton(state, id, size);
        CustomBlockState dragDropped = ImGuiHelper.blockStateDragDrop(state);
        if (dragDropped != null) {
            state = dragDropped;
        }
        String blockText = state.getCustomBlock().getResourceLocation().toString();
        String text = label == null ? blockText : label + " (" + blockText + ")";
        ImGui.getWindowDrawList().addText(originalPos.x + (float)size + ImGui.getStyle().getItemSpacingX(), originalPos.y + ((float)size - ImGui.getTextLineHeight()) / 2.0f, ImGui.getColorU32(0), text);
        if (blockButtonClick) {
            selectBlockWidget.open(id);
        }
        selectBlockWidget.render(AxiomI18n.get("axiom.widget.select_block"), EditorUI.getBlockList(), id);
        CustomBlockState result = selectBlockWidget.getResultState();
        if (result != null) {
            state = result;
        }
        return state;
    }

    public static boolean blockStateButton(CustomBlockState state, int id, int size) {
        float x = ImGui.getCursorScreenPosX();
        float y = ImGui.getCursorScreenPosY();
        ImGui.pushID(id);
        boolean pressed = ImGui.button("", size, size);
        if (size > 4 && ImGui.isItemVisible()) {
            ImGuiHelper.drawBlockState(ImGui.getWindowDrawList(), state, x + 2.0f, y + 2.0f, size - 4);
        }
        ImGui.popID();
        return pressed;
    }

    public static int blockStateButtonLeftOrRightClick(CustomBlockState state, int id, int size) {
        int pressed = 0;
        float x = ImGui.getCursorScreenPosX();
        float y = ImGui.getCursorScreenPosY();
        ImGui.pushID(id);
        if (ImGui.button("", size, size)) {
            pressed |= 1;
        }
        if (ImGui.isItemClicked(1)) {
            pressed |= 2;
        }
        if (size > 4 && ImGui.isItemVisible()) {
            ImGuiHelper.drawBlockState(ImGui.getWindowDrawList(), state, x + 2.0f, y + 2.0f, size - 4);
        }
        ImGui.popID();
        return pressed;
    }

    public static void blockStateDragDropSource(CustomBlockState state) {
        if (ImGui.isItemHovered()) {
            ImGui.setMouseCursor(7);
        }
        if (ImGui.beginDragDropSource()) {
            ImGui.setDragDropPayload("BlockState", state);
            ImGuiHelper.drawBlockState(ImGui.getForegroundDrawList(), state, ImGui.getCursorScreenPosX(), ImGui.getCursorScreenPosY(), 32.0f);
            ImGui.dummy(32.0f, 32.0f);
            ImGui.endDragDropSource();
        }
    }

    public static CustomBlockState blockStateDragDropTarget(Runnable customRender) {
        if (ImGui.beginDragDropTarget()) {
            DragDropPayloads.NoisePainterBlock noisePainterBlock;
            DragDropPayloads.PaletteBlock droppedPaletteBlock;
            int flags = customRender == null ? 0 : 3072;
            CustomBlockState droppedBlock = (CustomBlockState)ImGui.acceptDragDropPayload("BlockState", flags);
            if (droppedBlock != null) {
                if (customRender != null) {
                    customRender.run();
                }
                if (customRender == null || ImGui.isMouseReleased(0)) {
                    ImGui.endDragDropTarget();
                    return droppedBlock;
                }
            }
            if ((droppedPaletteBlock = ImGui.acceptDragDropPayload(DragDropPayloads.PaletteBlock.class, flags)) != null) {
                if (customRender != null) {
                    customRender.run();
                }
                if (customRender == null || ImGui.isMouseReleased(0)) {
                    ImGui.endDragDropTarget();
                    return droppedPaletteBlock.state();
                }
            }
            if ((noisePainterBlock = (DragDropPayloads.NoisePainterBlock)ImGui.acceptDragDropPayload("NoisePainterBlock", flags)) != null) {
                if (customRender != null) {
                    customRender.run();
                }
                if (customRender == null || ImGui.isMouseReleased(0)) {
                    ImGui.endDragDropTarget();
                    return noisePainterBlock.block().blockState();
                }
            }
            ImGui.endDragDropTarget();
        }
        return null;
    }

    public static CustomBlockState blockStateDragDropTarget() {
        return ImGuiHelper.blockStateDragDropTarget(null);
    }

    public static CustomBlockState blockStateDragDrop(CustomBlockState state) {
        ImGuiHelper.blockStateDragDropSource(state);
        return ImGuiHelper.blockStateDragDropTarget();
    }

    public static int elementList(String name, List<String> elements, float width, int minLines, int maxLines, boolean framed, IntConsumer buttonConsumer) {
        if (minLines > maxLines) {
            throw new IllegalArgumentException();
        }
        if (width <= 0.0f) {
            width = Math.max(ImGui.getContentRegionAvailX() + width, 4.0f);
        }
        float itemSpacingX = ImGui.getStyle().getItemSpacingX();
        float framePaddingX = ImGui.getStyle().getFramePaddingX();
        float availableSpace = width;
        if (framed) {
            availableSpace -= framePaddingX * 2.0f;
        }
        int lines = 0;
        boolean scrollbar = false;
        if (minLines == maxLines) {
            lines = minLines;
            scrollbar = true;
        } else {
            float consumedWidth = 0.0f;
            for (String element : elements) {
                float elementWidth = framePaddingX * 2.0f + ImGuiHelper.calcTextWidth(element);
                if (consumedWidth + elementWidth < availableSpace && consumedWidth > 0.0f) {
                    consumedWidth += elementWidth + itemSpacingX;
                    continue;
                }
                consumedWidth = elementWidth + itemSpacingX;
                if (++lines <= maxLines) continue;
                lines = maxLines;
                scrollbar = true;
                break;
            }
            if (lines < minLines) {
                lines = minLines;
            }
        }
        float lineHeight = (float)ImGui.getFontSize() + ImGui.getStyle().getFramePaddingY() * 2.0f + ImGui.getStyle().getItemSpacingY();
        boolean visible = framed ? ImGui.beginChildFrame(ImGui.getID(name), width, lineHeight * (float)lines + ImGui.getStyle().getFramePaddingY() * 2.0f - ImGui.getStyle().getItemSpacingY()) : ImGui.beginChild(name, width, lineHeight * (float)lines - ImGui.getStyle().getItemSpacingY());
        int ret = -1;
        if (visible) {
            if (scrollbar) {
                availableSpace -= ImGui.getStyle().getScrollbarSize();
            }
            float consumedWidth = 0.0f;
            for (int i = 0; i < elements.size(); ++i) {
                String element = elements.get(i);
                float elementWidth = framePaddingX * 2.0f + ImGuiHelper.calcTextWidth(element);
                if (consumedWidth + elementWidth < availableSpace && consumedWidth > 0.0f) {
                    ImGui.sameLine();
                    consumedWidth += elementWidth + itemSpacingX;
                } else {
                    consumedWidth = elementWidth + itemSpacingX;
                }
                ImGui.pushID(i);
                if (ImGui.button(element)) {
                    ret = i;
                }
                if (buttonConsumer != null) {
                    buttonConsumer.accept(i);
                }
                ImGui.popID();
            }
        }
        if (framed) {
            ImGui.endChildFrame();
        } else {
            ImGui.endChild();
        }
        return ret;
    }

    public static boolean combo(String label, int[] currentItem, String[] values) {
        return ImGuiHelper.combo(label, currentItem, values, 0);
    }

    public static boolean combo(String label, int[] currentItem, String[] values, int imguiComboFlags) {
        boolean changed = false;
        if (ImGui.beginCombo(label, currentItem[0] < 0 ? "" : values[currentItem[0]], imguiComboFlags)) {
            for (int i = 0; i < values.length; ++i) {
                boolean selected;
                ImGui.pushID(i);
                boolean bl = selected = i == currentItem[0];
                if (ImGui.selectable(values[i], selected) && !selected) {
                    currentItem[0] = i;
                    changed = true;
                }
                if (selected) {
                    ImGui.setItemDefaultFocus();
                }
                ImGui.popID();
            }
            ImGui.endCombo();
        }
        return changed;
    }

    public static void endFrame() {
        closeableModalOnTopLast = closeableModalOnTop;
        inputIntScrolledLastFrame = inputIntScrolledThisFrame;
        inputIntScrolledThisFrame = false;
        wantSpecialInputLastFrame = wantSpecialInputThisFrame;
        wantSpecialInputThisFrame = false;
        editingKeybindLastFrame = editingKeybindThisFrame;
        editingKeybindThisFrame = null;
        handledFocusNext = false;
        focusNext = false;
        if (!wantSpecialInputLastFrame) {
            specialInput.setLength(0);
        }
    }

    public static void setEditingKeybind(Keybind keybind) {
        editingKeybindThisFrame = keybind;
    }

    public static Keybind getEditingKeybind() {
        return editingKeybindLastFrame;
    }

    public static String modifyFromInput(String existing) {
        wantSpecialInputThisFrame = true;
        String newInput = specialInput.toString();
        existing = ((String)existing).substring(0, Math.max(0, ((String)existing).length() - backspaceCount));
        existing = (String)existing + newInput;
        specialInput.setLength(0);
        backspaceCount = 0;
        return existing;
    }

    public static boolean getWantsSpecialInput() {
        return wantSpecialInputLastFrame;
    }

    public static boolean addInputCharacter(char c) {
        if (wantSpecialInputLastFrame) {
            specialInput.append(c);
            return true;
        }
        return false;
    }

    public static boolean backspaceInput(int mods) {
        if (wantSpecialInputLastFrame) {
            if ((mods & 2) != 0) {
                specialInput.setLength(0);
                backspaceCount = 10000;
                return true;
            }
            if (specialInput.length() > 0) {
                specialInput.setLength(specialInput.length() - 1);
            } else {
                ++backspaceCount;
            }
            return true;
        }
        return false;
    }

    public static boolean beginPopup(String id) {
        return ImGuiHelper.beginPopup(id, 0);
    }

    public static boolean beginPopup(String id, int imGuiWindowFlags) {
        if (ImGui.beginPopup(id, imGuiWindowFlags | 4 | 0x100)) {
            closeableModalOnTop = false;
            return true;
        }
        return false;
    }

    public static boolean beginPopupModal(String id) {
        return ImGuiHelper.beginPopupModal(id, 0);
    }

    public static boolean beginPopupModal(String id, int imGuiWindowFlags) {
        if (ImGui.beginPopupModal(id, imGuiWindowFlags | 0x100)) {
            closeableModalOnTop = false;
            return true;
        }
        return false;
    }

    public static boolean beginPopupModalCloseable(String id) {
        return ImGuiHelper.beginPopupModalCloseable(id, 0);
    }

    public static boolean beginPopupModalCloseable(String id, int imGuiWindowFlags) {
        if (ImGui.beginPopupModal(id, new ImBoolean(true), imGuiWindowFlags | 0x100)) {
            closeableModalOnTop = true;
            return true;
        }
        return false;
    }

    public static void endPopupModalCloseable() {
        if (closeableModalOnTop && closeableModalOnTopLast && EditorUI.consumeNavClose()) {
            ImGui.closeCurrentPopup();
        }
        ImGui.endPopup();
    }

    public static void setupBorder() {
        ImGui.beginGroup();
        float windowPadding = ImGui.getStyle().getWindowPaddingX();
        borderIndentation += windowPadding;
        ImGui.indent(windowPadding);
        ImGui.setCursorPosY(ImGui.getCursorPosY() + ImGui.getStyle().getWindowPaddingY());
    }

    public static void finishBorder() {
        float windowPadding = ImGui.getStyle().getWindowPaddingX();
        borderIndentation -= windowPadding;
        ImGui.unindent(windowPadding);
        ImGui.endGroup();
        ImGui.getWindowDrawList().addRect(ImGui.getItemRectMinX(), ImGui.getItemRectMinY(), ImGui.getItemRectMinX() + ImGui.getContentRegionAvailX(), ImGui.getItemRectMaxY() + ImGui.getStyle().getWindowPaddingY(), ImGui.getColorU32(27));
        ImGui.setCursorPosY(ImGui.getCursorPosY() + ImGui.getStyle().getWindowPaddingY());
    }

    public static float calcTextWidth(String text) {
        ImVec2 textSizeVec = new ImVec2();
        ImGui.calcTextSize(textSizeVec, text);
        return textSizeVec.x;
    }

    public static LabelPosition calcLabelPosition(Label ... labels) {
        float availableSpace = ImGui.getWindowWidth() * 0.35f - ImGui.getCursorPosX() - ImGui.getStyle().getItemInnerSpacingX();
        for (Label label : labels) {
            float requiredSpace = ImGuiHelper.calcTextWidth(label.title) + ImGui.getStyle().getWindowPaddingX();
            if (label.description != null) {
                requiredSpace += ImGui.getStyle().getItemSpacingX() + ImGuiHelper.calcTextWidth("(?)");
            }
            if (!(availableSpace < requiredSpace)) continue;
            return LabelPosition.LABEL_ABOVE;
        }
        return LabelPosition.LABEL_RIGHT;
    }

    public static void helpMarker(String message) {
        ImGui.textDisabled("(?)");
        ImGuiHelper.tooltip(message);
    }

    public static void tooltip(String message) {
        ImGuiHelper.tooltip(message, 0);
    }

    public static void tooltip(String message, int imGuiHoveredFlags) {
        if (ImGui.isItemHovered(imGuiHoveredFlags)) {
            ImGui.beginTooltip();
            ImGui.pushTextWrapPos((float)ImGui.getFontSize() * 35.0f);
            ImGui.textUnformatted(message);
            ImGui.popTextWrapPos();
            ImGui.endTooltip();
        }
    }

    public static void disabledMenuItem(String label, String disabledMessage) {
        ImGui.beginDisabled();
        ImGui.menuItem(label);
        ImGui.endDisabled();
        ImGuiHelper.tooltip(disabledMessage, 512);
    }

    public static boolean drawLabelledWidget(Label label, LabelPosition style, Predicate<String> predicate) {
        boolean ret = false;
        switch (style) {
            case LABEL_ABOVE: {
                ImGui.text(label.title);
                if (label.description != null) {
                    ImGui.sameLine();
                    ImGuiHelper.helpMarker(label.description);
                }
                ret = predicate.test("###" + label.key);
                break;
            }
            case LABEL_RIGHT: {
                ret = predicate.test(label.title + "###" + label.key);
                if (label.description == null) break;
                ImGui.sameLine();
                ImGuiHelper.helpMarker(label.description);
            }
        }
        return ret;
    }

    public static void separatorWithText(String text) {
        float textStartX = ImGui.getCursorScreenPosX() + ImGui.getStyle().getIndentSpacing();
        float size = ImGui.getWindowSizeX() - borderIndentation;
        if (ImGui.isRectVisible(size, ImGui.getFontSize())) {
            float textEndX = textStartX + ImGuiHelper.calcTextWidth(text);
            float lineEndX = ImGui.getWindowPosX() + size;
            float lineY = ImGui.getCursorScreenPosY() + (float)ImGui.getFontSize() / 2.0f;
            ImGui.getWindowDrawList().addLine(ImGui.getCursorScreenPosX() - 4.0f, lineY, Math.min(lineEndX, textStartX) - 4.0f, lineY, ImGui.getColorU32(27));
            if (textEndX + 4.0f < lineEndX) {
                ImGui.getWindowDrawList().addLine(textEndX + 4.0f, lineY, lineEndX - 4.0f, lineY, ImGui.getColorU32(27));
            }
        }
        ImGui.setCursorScreenPos(textStartX, ImGui.getCursorScreenPosY());
        ImGui.textColored(ImGui.getColorU32(1), text);
    }

    public static boolean inputInt(String label, int[] value) {
        return ImGuiHelper.inputInt(label, value, false);
    }

    public static boolean inputInt(String label, int[] value, boolean tryUseRemainingSpace) {
        if (value.length == 0) {
            ImGui.text(label);
            return false;
        }
        boolean canScroll = ImGui.getScrollMaxY() <= 0.0f;
        boolean valueChanged = false;
        float availableWidth = ImGui.calcItemWidth();
        if (tryUseRemainingSpace) {
            availableWidth -= (ImGui.getCursorPosX() - ImGui.getStyle().getWindowPaddingX()) * 2.0f / 3.0f;
        }
        float innerSpacing = ImGui.getStyle().getItemInnerSpacingX();
        float widthItemOne = Math.max(1.0f, (float)Math.floor((availableWidth - innerSpacing * (float)(value.length - 1)) / (float)value.length));
        float widthItemLast = Math.max(1.0f, (float)Math.floor(availableWidth - (widthItemOne + innerSpacing) * (float)(value.length - 1)));
        ImGui.beginGroup();
        ImGui.pushID(label);
        for (int i = 0; i < value.length; ++i) {
            block17: {
                ImGui.pushID(i);
                if (i > 0) {
                    ImGui.sameLine(0.0f, innerSpacing);
                }
                ImString imString = new ImString("" + value[i], 100);
                if (i < value.length - 1) {
                    ImGui.setNextItemWidth(widthItemOne);
                } else {
                    ImGui.setNextItemWidth(widthItemLast);
                }
                if (focusNext) {
                    ImGui.setKeyboardFocusHere();
                    focusNext = false;
                }
                int flags = 17;
                if (inputIntScrolledLastFrame) {
                    flags |= 0x4000;
                }
                if (ImGui.inputText("", imString, flags)) {
                    valueChanged = true;
                    try {
                        value[i] = (int)Math.round(ExpressionEvaluator.evaluateFallible(ImGuiHelper.getString(imString)));
                    }
                    catch (Exception e) {
                        if (!ImGui.isItemDeactivatedAfterEdit()) break block17;
                        value[i] = 0;
                    }
                }
            }
            if (!handledFocusNext && ImGui.isItemActive() && ImGui.isKeyPressed(258, false)) {
                handledFocusNext = true;
                focusNext = true;
            }
            if (ImGui.isItemHovered() && canScroll) {
                float scrollY = ImGui.getIO().getMouseWheel();
                if (scrollY > 0.0f) {
                    int n = i;
                    value[n] = value[n] + 1;
                    valueChanged = true;
                    inputIntScrolledThisFrame = true;
                } else if (scrollY < 0.0f) {
                    int n = i;
                    value[n] = value[n] - 1;
                    valueChanged = true;
                    inputIntScrolledThisFrame = true;
                }
            }
            ImGui.popID();
        }
        ImGui.popID();
        String renderedText = label.split("##")[0];
        if (!renderedText.isEmpty()) {
            ImGui.sameLine(0.0f, innerSpacing);
            ImGui.text(renderedText);
        }
        ImGui.endGroup();
        return valueChanged;
    }

    public static boolean inputFloat(String label, float[] value) {
        if (value.length == 0) {
            ImGui.text(label);
            return false;
        }
        boolean valueChanged = false;
        float availableWidth = ImGui.calcItemWidth();
        float innerSpacing = ImGui.getStyle().getItemInnerSpacingX();
        float widthItemOne = Math.max(1.0f, (float)Math.floor((availableWidth - innerSpacing * (float)(value.length - 1)) / (float)value.length));
        float widthItemLast = Math.max(1.0f, (float)Math.floor(availableWidth - (widthItemOne + innerSpacing) * (float)(value.length - 1)));
        ImGui.beginGroup();
        ImGui.pushID(label);
        for (int i = 0; i < value.length; ++i) {
            block14: {
                ImGui.pushID(i);
                if (i > 0) {
                    ImGui.sameLine(0.0f, innerSpacing);
                }
                ImString imString = new ImString("" + value[i], 100);
                if (i < value.length - 1) {
                    ImGui.setNextItemWidth(widthItemOne);
                } else {
                    ImGui.setNextItemWidth(widthItemLast);
                }
                int flags = 17;
                if (inputIntScrolledLastFrame) {
                    flags |= 0x4000;
                }
                if (ImGui.inputText("", imString, flags)) {
                    valueChanged = true;
                    try {
                        value[i] = (float)ExpressionEvaluator.evaluateFallible(ImGuiHelper.getString(imString));
                    }
                    catch (Exception e) {
                        if (!ImGui.isItemDeactivatedAfterEdit()) break block14;
                        value[i] = 0.0f;
                    }
                }
            }
            if (ImGui.isItemHovered()) {
                float scrollY = ImGui.getIO().getMouseWheel();
                if (scrollY > 0.0f) {
                    int n = i;
                    value[n] = value[n] + 1.0f;
                    valueChanged = true;
                    inputIntScrolledThisFrame = true;
                } else if (scrollY < 0.0f) {
                    int n = i;
                    value[n] = value[n] - 1.0f;
                    valueChanged = true;
                    inputIntScrolledThisFrame = true;
                }
            }
            ImGui.popID();
        }
        ImGui.popID();
        String renderedText = label.split("##")[0];
        if (!renderedText.isEmpty()) {
            ImGui.sameLine(0.0f, innerSpacing);
            ImGui.text(renderedText);
        }
        ImGui.endGroup();
        return valueChanged;
    }

    public static boolean radio(String label, int[] currentItem, String[] values) {
        int item = currentItem[0];
        int newItem = -1;
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            if (i > 0) {
                ImGui.sameLine();
            }
            if (item == i) {
                ImGui.beginDisabled();
            }
            if (ImGui.button(value)) {
                newItem = i;
            }
            if (item != i) continue;
            ImGui.endDisabled();
        }
        if (label != null) {
            ImGui.sameLine();
            ImGui.text(label);
        }
        if (newItem != -1) {
            currentItem[0] = newItem;
            return true;
        }
        return false;
    }

    public static int buttons(String ... labels) {
        if (labels.length == 0) {
            return -1;
        }
        float[] widths = new float[labels.length];
        float totalRawWidth = 0.0f;
        for (int i = 0; i < labels.length; ++i) {
            float width;
            String label = labels[i];
            widths[i] = width = ImGuiHelper.calcTextWidth(label);
            totalRawWidth += width;
        }
        float availableWidth = ImGui.getContentRegionAvailX();
        float freeSpace = availableWidth - totalRawWidth - ImGui.getStyle().getItemSpacingX() * (float)(labels.length - 1);
        float extraPadding = Math.max(ImGui.getStyle().getFramePaddingX() * 2.0f, freeSpace / (float)labels.length);
        float height = (float)ImGui.getFontSize() + ImGui.getStyle().getFramePaddingY() * 2.0f;
        int pressed = -1;
        for (int i = 0; i < labels.length; ++i) {
            if (ImGui.button(labels[i], widths[i] + extraPadding, height)) {
                pressed = i;
            }
            if (i == labels.length - 1) continue;
            ImGui.sameLine();
        }
        return pressed;
    }

    public static void popAllStyleColors() {
        ImGui.popStyleColor(pushedColors);
        pushedColors = 0;
    }

    public static void popAllStyleVars() {
        ImGui.popStyleVar(pushedStyleVars);
        pushedStyleVars = 0;
    }

    public static void pushStyleColor(int imGuiCol, float r, float g2, float b, float a) {
        ImGui.pushStyleColor(imGuiCol, r, g2, b, a);
        ++pushedColors;
    }

    public static void pushStyleColor(int imGuiCol, int r, int g2, int b, int a) {
        ImGui.pushStyleColor(imGuiCol, r, g2, b, a);
        ++pushedColors;
    }

    public static void pushStyleColor(int imGuiCol, int col) {
        ImGui.pushStyleColor(imGuiCol, col);
        ++pushedColors;
    }

    public static void popStyleColor() {
        if (pushedColors >= 1) {
            ImGui.popStyleColor();
            --pushedColors;
        }
    }

    public static void popStyleColor(int count) {
        if ((count = Math.min(count, pushedColors)) == 0) {
            return;
        }
        ImGui.popStyleColor(count);
        pushedColors -= count;
    }

    public static void pushStyleVar(int imGuiStyleVar, float val) {
        ImGui.pushStyleVar(imGuiStyleVar, val);
        ++pushedStyleVars;
    }

    public static void pushStyleVar(int imGuiStyleVar, float valX, float valY) {
        ImGui.pushStyleVar(imGuiStyleVar, valX, valY);
        ++pushedStyleVars;
    }

    public static void popStyleVar() {
        if (pushedStyleVars >= 1) {
            ImGui.popStyleVar();
            --pushedStyleVars;
        }
    }

    public static void popStyleVar(int count) {
        if ((count = Math.min(count, pushedStyleVars)) == 0) {
            return;
        }
        ImGui.popStyleVar(count);
        pushedStyleVars -= count;
    }

    public record Label(@NotNull String key, @NotNull String title, @Nullable String description) {
    }

    public static enum LabelPosition {
        LABEL_ABOVE,
        LABEL_RIGHT;

    }
}

