/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.schematic;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.block_maps.LegacyBlocks;
import com.moulberry.axiom.clipboard.ClipboardObject;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.utils.DFUHelper;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_155;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2259;
import net.minecraft.class_2320;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2750;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2843;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class SchematicLoader {
    public static Path getDefaultSchematicDir() {
        Path worldeditSchematicsDir = FabricLoader.getInstance().getConfigDir().resolve("worldedit").resolve("schematics");
        if (Files.exists(worldeditSchematicsDir, new LinkOption[0])) {
            return worldeditSchematicsDir;
        }
        return FabricLoader.getInstance().getGameDir();
    }

    public static ClipboardObject loadSpongeV2(class_2487 compoundTag) throws SchematicLoadException {
        if (!compoundTag.method_10573("Version", 3)) {
            throw new SchematicLoadException("Missing 'Version' int tag");
        }
        if (!compoundTag.method_10573("DataVersion", 3)) {
            throw new SchematicLoadException("Missing 'DataVersion' int tag");
        }
        if (!compoundTag.method_10573("Width", 2)) {
            throw new SchematicLoadException("Missing 'Width' short tag");
        }
        if (!compoundTag.method_10573("Height", 2)) {
            throw new SchematicLoadException("Missing 'Height' short tag");
        }
        if (!compoundTag.method_10573("Length", 2)) {
            throw new SchematicLoadException("Missing 'Length' short tag");
        }
        if (!compoundTag.method_10573("Palette", 10)) {
            throw new SchematicLoadException("Missing 'Palette' compound tag");
        }
        if (!compoundTag.method_10573("BlockData", 7)) {
            throw new SchematicLoadException("Missing 'BlockData' byte array tag");
        }
        int version = compoundTag.method_10550("Version");
        if (version != 2) {
            throw new SchematicLoadException("Incorrect version, expected 2, but got " + version);
        }
        int currentDataVersion = class_155.method_16673().method_37912().method_38494();
        int schematicDataVersion = compoundTag.method_10550("DataVersion");
        class_2487 palette = compoundTag.method_10562("Palette");
        byte[] blockData = compoundTag.method_10547("BlockData");
        int width = compoundTag.method_10568("Width") & 0xFFFF;
        int height = compoundTag.method_10568("Height") & 0xFFFF;
        int length = compoundTag.method_10568("Length") & 0xFFFF;
        String name = "";
        if (compoundTag.method_10573("Metadata", 10)) {
            class_2487 metadata = compoundTag.method_10562("Metadata");
            name = metadata.method_10558("Name");
        }
        Int2ObjectOpenHashMap paletteMap = new Int2ObjectOpenHashMap();
        for (String key : palette.method_10541()) {
            try {
                class_2680 blockState;
                if (currentDataVersion == schematicDataVersion) {
                    class_2259.class_7211 result = class_2259.method_41957((class_7225)class_7923.field_41175.method_46771(), (String)key, (boolean)false);
                    blockState = result.comp_622();
                } else {
                    class_2487 blockTag = DFUHelper.createBlockTag(key);
                    blockState = (class_2680)DFUHelper.updateBlockState(blockTag, schematicDataVersion).getOrThrow(false, Axiom.LOGGER::error);
                }
                paletteMap.put(palette.method_10550(key), (Object)blockState);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SchematicLoadException("Unable to parse BlockState: " + key);
            }
        }
        ChunkedBlockRegion blockRegion = new ChunkedBlockRegion();
        class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])blockData));
        for (int y = 0; y < height; ++y) {
            for (int z = 0; z < length; ++z) {
                for (int x = 0; x < width; ++x) {
                    int blockId = buf.method_10816();
                    class_2680 blockState = (class_2680)paletteMap.get(blockId);
                    if (blockState == null) {
                        blockState = class_2246.field_10124.method_9564();
                    }
                    blockRegion.addBlockWithoutDirty(x - width / 2, y - height / 2, z - length / 2, blockState);
                }
            }
        }
        blockRegion.dirtyAll();
        Long2ObjectOpenHashMap blockEntityMap = new Long2ObjectOpenHashMap();
        if (compoundTag.method_10573("BlockEntities", 9)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            class_2499 blockEntities = compoundTag.method_10554("BlockEntities", 10);
            for (class_2520 blockEntityTag : blockEntities) {
                class_2487 blockEntity = (class_2487)blockEntityTag;
                if (!blockEntity.method_10573("Pos", 11) || !blockEntity.method_10573("Id", 8)) continue;
                int[] pos = blockEntity.method_10561("Pos");
                String id = blockEntity.method_10558("Id");
                class_2591 type2 = (class_2591)class_7923.field_41181.method_10223(new class_2960(id));
                if (type2 == null || !type2.method_20526(blockRegion.getBlockStateOrAir(pos[0], pos[1], pos[2]))) continue;
                blockEntity.method_10551("Pos");
                blockEntity.method_10551("Id");
                CompressedBlockEntity compressedBlockEntity = CompressedBlockEntity.compress(blockEntity, baos);
                blockEntityMap.put(class_2338.method_10064((int)pos[0], (int)pos[1], (int)pos[2]), (Object)compressedBlockEntity);
            }
        }
        compoundTag.method_10551("DataVersion");
        compoundTag.method_10551("Palette");
        compoundTag.method_10551("BlockData");
        compoundTag.method_10551("Width");
        compoundTag.method_10551("Height");
        compoundTag.method_10551("Length");
        compoundTag.method_10551("BlockEntities");
        return new ClipboardObject.Anonymous(blockRegion, (Long2ObjectMap<CompressedBlockEntity>)blockEntityMap, name, 45.0f, compoundTag);
    }

    public static ClipboardObject loadLegacy(class_2487 compoundTag) throws SchematicLoadException {
        if (!compoundTag.method_10573("Width", 99)) {
            throw new SchematicLoadException("Missing 'Width' short tag");
        }
        if (!compoundTag.method_10573("Height", 99)) {
            throw new SchematicLoadException("Missing 'Height' short tag");
        }
        if (!compoundTag.method_10573("Length", 99)) {
            throw new SchematicLoadException("Missing 'Length' short tag");
        }
        if (!compoundTag.method_10573("Blocks", 7)) {
            throw new SchematicLoadException("Missing 'Blocks' byte array tag");
        }
        if (!compoundTag.method_10573("Data", 7)) {
            throw new SchematicLoadException("Missing 'Data' byte array tag");
        }
        int width = compoundTag.method_10550("Width");
        int height = compoundTag.method_10550("Height");
        int length = compoundTag.method_10550("Length");
        int maxIndex = width * height * length;
        int minX = -Math.floorDiv(width, 2);
        int minY = -Math.floorDiv(height, 2);
        int minZ = -Math.floorDiv(length, 2);
        byte[] legacyBlockIds = compoundTag.method_10547("Blocks");
        byte[] legacyBlockData = compoundTag.method_10547("Data");
        ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
        class_2680[] legacyBlocks = LegacyBlocks.getLegacyBlocks();
        for (int index = 0; index < maxIndex; ++index) {
            int blockId = legacyBlockIds[index] & 0xFF;
            int blockData = legacyBlockData[index] & 0xFF;
            class_2680 blockState = legacyBlocks[blockId * 16 + blockData];
            if (blockState == null && (blockState = legacyBlocks[blockId * 16]) == null) continue;
            int x2 = index % width + minX;
            int z2 = index % (width * length) / width + minZ;
            int y2 = index / (width * length) + minY;
            chunkedBlockRegion.addBlockWithoutDirty(x2, y2, z2, blockState);
        }
        class_2350[] directions = class_2350.values();
        class_2338.class_2339 mutableBlockPos1 = new class_2338.class_2339();
        class_2338.class_2339 mutableBlockPos2 = new class_2338.class_2339();
        ChunkedBlockRegion updatedRegion = new ChunkedBlockRegion();
        chunkedBlockRegion.forEachEntry((x, y, z, block) -> {
            if (block.method_26204() instanceof class_2320) {
                class_2680 below;
                class_2756 half = (class_2756)block.method_11654((class_2769)class_2741.field_12533);
                if (half == class_2756.field_12609 && (below = chunkedBlockRegion.getBlockStateOrAir(x, y - 1, z)).method_26204() instanceof class_2320) {
                    block = (class_2680)below.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12609);
                }
            } else if (block.method_26204() instanceof class_2323) {
                class_2756 half = (class_2756)block.method_11654((class_2769)class_2741.field_12533);
                if (half == class_2756.field_12609) {
                    class_2680 below = chunkedBlockRegion.getBlockStateOrAir(x, y - 1, z);
                    if (below.method_26204() instanceof class_2323) {
                        block = (class_2680)block.method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)below.method_11654((class_2769)class_2741.field_12481)));
                        block = (class_2680)block.method_11657((class_2769)class_2741.field_12537, (Comparable)((Boolean)below.method_11654((class_2769)class_2741.field_12537)));
                    }
                } else {
                    class_2680 above = chunkedBlockRegion.getBlockStateOrAir(x, y + 1, z);
                    if (above.method_26204() instanceof class_2323) {
                        block = (class_2680)block.method_11657((class_2769)class_2741.field_12520, (Comparable)((class_2750)above.method_11654((class_2769)class_2741.field_12520)));
                        block = (class_2680)block.method_11657((class_2769)class_2741.field_12484, (Comparable)((Boolean)above.method_11654((class_2769)class_2741.field_12484)));
                    }
                }
            }
            updatedRegion.addBlock(x, y, z, (class_2680)block);
        });
        updatedRegion.forEachEntry((x, y, z, block) -> {
            try {
                for (class_2350 direction : directions) {
                    mutableBlockPos1.method_10103(x, y, z);
                    mutableBlockPos2.method_25505((class_2382)mutableBlockPos1, direction);
                    block = class_2843.method_12351((class_2680)block, (class_2350)direction, (class_1936)updatedRegion, (class_2338)mutableBlockPos1, (class_2338)mutableBlockPos2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            chunkedBlockRegion.addBlockWithoutDirty(x, y, z, (class_2680)block);
        });
        chunkedBlockRegion.dirtyAll();
        return new ClipboardObject.Anonymous(chunkedBlockRegion, (Long2ObjectMap<CompressedBlockEntity>)new Long2ObjectOpenHashMap(), "", 45.0f, compoundTag);
    }

    public static class SchematicLoadException
    extends RuntimeException {
        public SchematicLoadException(String message) {
            super(message);
        }
    }
}

