/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.views;

import com.moulberry.axiom.editor.views.ViewManager;
import com.moulberry.axiom.packets.AxiomServerboundTeleport;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public final class View {
    public String name;
    public final UUID uuid;
    public boolean pinLevel = false;
    public boolean pinLocation = false;
    private class_5321<class_1937> level = null;
    private class_243 position = null;
    private float yaw;
    private float pitch;
    private boolean active = false;

    public View(String name, UUID uuid, @Nullable class_1657 player) {
        this.name = name;
        this.uuid = uuid;
        if (player != null) {
            this.position = player.method_19538();
            this.yaw = player.method_36454();
            this.pitch = player.method_36455();
            this.level = player.method_37908().method_27983();
        }
    }

    public void teleportPinned(class_1657 player) {
        if (player != null && this.level == null) {
            this.level = player.method_37908().method_27983();
        }
        if (this.position != null && this.level != null && this.pinLevel && this.pinLocation) {
            new AxiomServerboundTeleport(this.level, this.position.field_1352, this.position.field_1351, this.position.field_1350, this.yaw, this.pitch).send();
        }
    }

    public void markInactive() {
        if (this.active) {
            this.active = false;
        }
    }

    public void markActive(class_1657 player) {
        if (this.active) {
            if (!this.uuid.equals(ViewManager.activeView)) {
                ViewManager.activeView = this.uuid;
                ViewManager.activeFrames = 0;
                ViewManager.syncViews();
            } else if (ViewManager.activeFrames < 5) {
                ++ViewManager.activeFrames;
            } else {
                if (player == null) {
                    return;
                }
                class_5321 currentDimension = player.method_37908().method_27983();
                if (!this.pinLevel || this.level == null) {
                    this.level = currentDimension;
                }
                if (!(this.pinLevel && this.pinLocation && this.position != null || !currentDimension.equals(this.level) && this.position != null)) {
                    this.position = player.method_19538();
                    this.yaw = player.method_36454();
                    this.pitch = player.method_36455();
                }
            }
        } else {
            this.active = true;
            if (!this.uuid.equals(ViewManager.activeView)) {
                ViewManager.activeView = this.uuid;
                ViewManager.activeFrames = 0;
                ViewManager.syncViews();
                if (player != null && this.level == null) {
                    this.level = player.method_37908().method_27983();
                }
                if (this.position != null && this.level != null) {
                    new AxiomServerboundTeleport(this.level, this.position.field_1352, this.position.field_1351, this.position.field_1350, this.yaw, this.pitch).send();
                }
            }
        }
    }

    public void write(class_2540 byteBuf) {
        byteBuf.method_10788(this.name, 64);
        byteBuf.method_10797(this.uuid);
        byteBuf.writeBoolean(this.pinLevel);
        if (this.pinLevel && this.level != null) {
            byteBuf.writeBoolean(true);
            byteBuf.method_44116(this.level);
        } else {
            byteBuf.writeBoolean(false);
        }
        byteBuf.writeBoolean(this.pinLocation);
        if (this.position != null) {
            byteBuf.writeBoolean(true);
            byteBuf.writeDouble(this.position.field_1352);
            byteBuf.writeDouble(this.position.field_1351);
            byteBuf.writeDouble(this.position.field_1350);
            byteBuf.writeFloat(this.yaw);
            byteBuf.writeFloat(this.pitch);
        } else {
            byteBuf.writeBoolean(false);
        }
    }

    public static View read(class_2540 byteBuf) {
        View view = new View(byteBuf.method_10800(64), byteBuf.method_10790(), null);
        view.pinLevel = byteBuf.readBoolean();
        if (byteBuf.readBoolean()) {
            view.level = byteBuf.method_44112(class_7924.field_41223);
        }
        view.pinLocation = byteBuf.readBoolean();
        if (byteBuf.readBoolean()) {
            view.position = new class_243(byteBuf.readDouble(), byteBuf.readDouble(), byteBuf.readDouble());
            view.yaw = byteBuf.readFloat();
            view.pitch = byteBuf.readFloat();
        }
        return view;
    }

    public class_2487 save() {
        class_2487 tag = new class_2487();
        tag.method_10582("Name", this.name);
        tag.method_25927("UUID", this.uuid);
        tag.method_10556("PinLevel", this.pinLevel);
        if (this.pinLevel && this.level != null) {
            tag.method_10582("Level", this.level.method_29177().toString());
        }
        tag.method_10556("PinLocation", this.pinLocation);
        if (this.position != null) {
            tag.method_10549("X", this.position.field_1352);
            tag.method_10549("Y", this.position.field_1351);
            tag.method_10549("Z", this.position.field_1350);
            tag.method_10549("Yaw", (double)this.yaw);
            tag.method_10549("Pitch", (double)this.pitch);
        }
        return tag;
    }

    public static View load(class_2487 tag) {
        String name = tag.method_10558("Name");
        UUID uuid = tag.method_25926("UUID");
        View view = new View(name, uuid, null);
        view.pinLevel = tag.method_10577("PinLevel");
        if (tag.method_10573("Level", 8)) {
            String level = tag.method_10558("Level");
            view.level = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(level));
        }
        view.pinLocation = tag.method_10577("PinLocation");
        if (tag.method_10545("X") && tag.method_10545("Y") && tag.method_10545("Z")) {
            double x = tag.method_10574("X");
            double y = tag.method_10574("Y");
            double z = tag.method_10574("Z");
            view.position = new class_243(x, y, z);
            view.yaw = tag.method_10583("Yaw");
            view.pitch = tag.method_10583("Pitch");
        }
        return view;
    }
}

