/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.widgets;

import com.moulberry.axiom.custom_blocks.CustomBlock;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.StringProperty;
import com.moulberry.axiom.editor.BlockList;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.SelectBlockWidget;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.utils.BlockCondition;
import com.moulberry.axiom.utils.BooleanWrapper;
import com.moulberry.axiom.utils.StringUtils;
import imgui.ImGui;
import imgui.ImGuiViewport;
import imgui.ImVec2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_6885;
import org.jetbrains.annotations.Nullable;

public class BlockConditionWidget {
    private CustomBlock block = null;
    private CustomBlockState visualBlockState = null;
    private final Map<class_2769<?>, Comparable<?>> selectedProperties = new LinkedHashMap();
    private class_6885<class_2248> tag = null;
    private final SelectBlockWidget selectBlockWidget = new SelectBlockWidget(true);

    public BlockConditionWidget(CustomBlock block) {
        this.switchBlock(block);
    }

    public BlockConditionWidget(class_2248 block) {
        this.switchBlock((CustomBlock)block);
    }

    public void setFilter(Predicate<CustomBlockState> filter) {
        this.selectBlockWidget.setFilter(filter);
    }

    public boolean renderBlockSwitcher(BlockList blockList, String id) {
        return this.renderBlockSwitcher(blockList, id, null);
    }

    public boolean renderBlockSwitcher(BlockList blockList, String id, BooleanWrapper allowDragDropTarget) {
        class_6885<class_2248> selectedTag;
        boolean changed = false;
        if (this.block != null) {
            CustomBlockState dragDropped;
            int buttonSize = (int)(52.0f * EditorUI.getUiScale());
            ImVec2 pos = ImGui.getCursorScreenPos();
            boolean clicked = ImGuiHelper.blockStateButton(this.visualBlockState, ImGui.getID(id), buttonSize);
            ImGuiHelper.blockStateDragDropSource(this.visualBlockState);
            if ((allowDragDropTarget == null || allowDragDropTarget.value) && (dragDropped = allowDragDropTarget != null ? ImGuiHelper.blockStateDragDropTarget(() -> {
                allowDragDropTarget.value = false;
                ImGui.getWindowDrawList().addRect(pos.x - 3.0f, pos.y - 3.0f, pos.x + (float)buttonSize + 3.0f, pos.y + (float)buttonSize + 3.0f, ImGui.getColorU32(50), 0.0f, 0, 2.0f);
            }) : ImGuiHelper.blockStateDragDropTarget()) != null && dragDropped.getCustomBlock() != this.block) {
                this.switchBlock(dragDropped.getCustomBlock());
                changed = true;
            }
            if (clicked) {
                this.selectBlockWidget.open();
            }
        } else if (this.tag != null && ImGui.button("#" + ((class_6885.class_6888)this.tag).method_40251().comp_327() + "###TagButton" + id, 0.0f, 52.0f)) {
            this.selectBlockWidget.open();
        }
        ImGuiViewport viewport = ImGui.getMainViewport();
        ImGui.setNextWindowPos(viewport.getCenterX(), viewport.getCenterY(), 8, 0.5f, 0.5f);
        this.selectBlockWidget.render(AxiomI18n.get("axiom.widget.select_block"), blockList);
        CustomBlockState selectedBlock = this.selectBlockWidget.getResultState();
        if (selectedBlock != null) {
            this.switchBlock(selectedBlock.getCustomBlock());
            changed = true;
        }
        if ((selectedTag = this.selectBlockWidget.getResultTag()) != null) {
            this.block = null;
            this.visualBlockState = null;
            this.selectedProperties.clear();
            this.tag = selectedTag;
            changed = true;
        }
        return changed;
    }

    public PropertySettingsResult renderPropertySettings(String id, boolean compressed) {
        boolean propertiesChanged = false;
        float maxX = 0.0f;
        float start = ImGui.getCursorPosX();
        if (compressed || ImGui.beginTable("##PropertyTable" + id, 2, 65536)) {
            for (Map.Entry<class_2769<?>, Comparable<?>> entry : this.selectedProperties.entrySet()) {
                class_2769<?> property = entry.getKey();
                Comparable<?> value = entry.getValue();
                String prettyName = StringUtils.convertSnakeToWords(property.method_11899());
                if (!compressed) {
                    ImGui.tableNextColumn();
                }
                ImGui.setCursorPosY(ImGui.getCursorPosY() + ImGui.getStyle().getFramePaddingY());
                ImGui.text(prettyName);
                if (compressed) {
                    ImGui.sameLine();
                } else {
                    ImGui.tableNextColumn();
                }
                if (property instanceof class_2754) {
                    Enum enumVal;
                    class_2754 enumProperty = (class_2754)property;
                    String[] values = new String[enumProperty.method_11898().size() + 1];
                    values[0] = AxiomI18n.get("axiom.widget.any_block_property");
                    int currentIndex = 0;
                    Iterator iterator = enumProperty.method_11898().iterator();
                    for (int i = 1; i < values.length; ++i) {
                        enumVal = (Enum)iterator.next();
                        values[i] = StringUtils.convertSnakeToWords(((class_3542)enumVal).method_15434());
                        if (enumVal != value) continue;
                        currentIndex = i;
                    }
                    ImGui.setNextItemWidth(!compressed ? 128.0f : Math.min(ImGui.getContentRegionAvailX(), 128.0f));
                    array = new int[]{currentIndex};
                    ImGuiHelper.combo("##Combo" + prettyName, (int[])array, values);
                    if (array[0] != currentIndex) {
                        propertiesChanged = true;
                        if (array[0] == false) {
                            this.selectedProperties.put(property, null);
                        } else {
                            iterator = enumProperty.method_11898().iterator();
                            enumVal = null;
                            for (int i = 0; i < array[0]; ++i) {
                                enumVal = (Enum)iterator.next();
                            }
                            this.selectedProperties.put(property, (Comparable<?>)((Object)enumVal));
                        }
                    }
                } else if (property instanceof StringProperty) {
                    StringProperty stringProperty = (StringProperty)property;
                    String[] values = new String[stringProperty.method_11898().size() + 1];
                    values[0] = AxiomI18n.get("axiom.widget.any_block_property");
                    int currentIndex = 0;
                    int index = 1;
                    for (String stringValue : stringProperty.method_11898()) {
                        values[index] = StringUtils.convertSnakeToWords(stringValue);
                        if (stringValue.equals(value)) {
                            currentIndex = index;
                        }
                        ++index;
                    }
                    ImGui.setNextItemWidth(!compressed ? 128.0f : Math.min(ImGui.getContentRegionAvailX(), 128.0f));
                    array = new int[]{currentIndex};
                    ImGuiHelper.combo("##Combo" + prettyName, (int[])array, values);
                    if (array[0] != currentIndex) {
                        propertiesChanged = true;
                        if (array[0] == false) {
                            this.selectedProperties.put(property, null);
                        } else {
                            Iterator<String> iterator = stringProperty.method_11898().iterator();
                            String newValue = null;
                            for (int i = 0; i < array[0]; ++i) {
                                newValue = iterator.next();
                            }
                            this.selectedProperties.put(property, (Comparable<?>)((Object)newValue));
                        }
                    }
                } else if (property instanceof class_2746) {
                    if (!compressed || ImGui.getContentRegionAvailX() >= 128.0f) {
                        if (value != null && ((Boolean)value).booleanValue()) {
                            ImGui.beginDisabled();
                        }
                        if (ImGui.button(AxiomI18n.get("axiom.widget.true_block_property") + "##Bool" + prettyName)) {
                            propertiesChanged = true;
                            this.selectedProperties.put(property, Boolean.valueOf(true));
                        }
                        if (value != null && ((Boolean)value).booleanValue()) {
                            ImGui.endDisabled();
                        }
                        ImGui.sameLine();
                        if (value != null && !((Boolean)value).booleanValue()) {
                            ImGui.beginDisabled();
                        }
                        if (ImGui.button(AxiomI18n.get("axiom.widget.false_block_property") + "##Bool" + prettyName)) {
                            propertiesChanged = true;
                            this.selectedProperties.put(property, Boolean.valueOf(false));
                        }
                        if (value != null && !((Boolean)value).booleanValue()) {
                            ImGui.endDisabled();
                        }
                        ImGui.sameLine();
                        if (value == null) {
                            ImGui.beginDisabled();
                        }
                        if (ImGui.button(AxiomI18n.get("axiom.widget.any_block_property") + "##Bool" + prettyName)) {
                            propertiesChanged = true;
                            this.selectedProperties.put(property, null);
                        }
                        if (value == null) {
                            ImGui.endDisabled();
                        }
                    } else {
                        ImGui.setNextItemWidth(ImGui.getContentRegionAvailX());
                        int currentValue = value == null ? 0 : ((Boolean)value != false ? 1 : 2);
                        int[] array = new int[]{currentValue};
                        ImGuiHelper.combo("##BoolCombo" + prettyName, new int[]{0}, new String[]{AxiomI18n.get("axiom.widget.any_block_property"), AxiomI18n.get("axiom.widget.true_block_property"), AxiomI18n.get("axiom.widget.false_block_property")});
                        if (array[0] != currentValue) {
                            propertiesChanged = true;
                            if (array[0] == 1) {
                                this.selectedProperties.put(property, Boolean.valueOf(true));
                            } else if (array[0] == 2) {
                                this.selectedProperties.put(property, Boolean.valueOf(false));
                            } else {
                                this.selectedProperties.put(property, null);
                            }
                        }
                    }
                } else if (property instanceof class_2758) {
                    class_2758 integerProperty = (class_2758)property;
                    if (value == null) {
                        int[] array = new int[]{integerProperty.field_37655 - 1};
                        ImGui.setNextItemWidth(!compressed ? 128.0f : Math.min(ImGui.getContentRegionAvailX(), 128.0f));
                        ImGui.sliderInt("##Slider" + prettyName, array, integerProperty.field_37655 - 1, integerProperty.field_37656, AxiomI18n.get("axiom.widget.any_block_property"));
                        if (array[0] >= integerProperty.field_37655 && array[0] <= integerProperty.field_37656) {
                            propertiesChanged = true;
                            this.selectedProperties.put(property, Integer.valueOf(array[0]));
                        }
                    } else {
                        int[] array = new int[]{(Integer)value};
                        ImGui.setNextItemWidth(!compressed ? 128.0f : Math.min(ImGui.getContentRegionAvailX(), 128.0f));
                        ImGui.sliderInt("##Slider" + prettyName, array, integerProperty.field_37655 - 1, integerProperty.field_37656);
                        if (array[0] != (Integer)value) {
                            propertiesChanged = true;
                            if (array[0] >= integerProperty.field_37655 && array[0] <= integerProperty.field_37656) {
                                this.selectedProperties.put(property, Integer.valueOf(array[0]));
                            } else {
                                this.selectedProperties.put(property, null);
                            }
                        }
                    }
                } else {
                    ImGui.text(String.valueOf(property.getClass()));
                }
                ImGui.sameLine(0.0f, 0.0f);
                maxX = Math.max(ImGui.getCursorPosX(), maxX);
                ImGui.dummy(0.0f, 0.0f);
            }
            if (!compressed) {
                ImGui.endTable();
            }
        }
        if (propertiesChanged) {
            this.visualBlockState = this.block.defaultCustomState();
            for (Map.Entry<class_2769<?>, Comparable<?>> entry : this.selectedProperties.entrySet()) {
                Comparable<?> value = entry.getValue();
                if (value == null) continue;
                this.visualBlockState = this.visualBlockState.setPropertyUnsafe(entry.getKey(), value);
            }
        }
        return new PropertySettingsResult(maxX - start, propertiesChanged);
    }

    public boolean hasEditableProperties() {
        return !this.selectedProperties.isEmpty();
    }

    public BlockCondition createCondition() {
        return BlockConditionWidget.createCondition(this.block, this.selectedProperties, this.tag);
    }

    /*
     * WARNING - void declaration
     */
    private static BlockCondition createCondition(CustomBlock customBlock, Map<class_2769<?>, Comparable<?>> selectedProperties, class_6885<class_2248> tag) {
        void var5_11;
        if (tag != null) {
            return new BlockCondition.MatchesTag(tag);
        }
        List<CustomBlockState> possibleStates = customBlock.getPossibleCustomStates();
        if (possibleStates.size() == 1) {
            return new BlockCondition.SpecificState(possibleStates.get(0).getVanillaState());
        }
        possibleStates = new ArrayList<CustomBlockState>(possibleStates);
        for (Map.Entry<class_2769<?>, Comparable<?>> entry : selectedProperties.entrySet()) {
            class_2769<?> property = entry.getKey();
            Comparable<?> value = entry.getValue();
            if (value == null) continue;
            possibleStates.removeIf(state -> state.getProperty(property) != value);
        }
        if (possibleStates.size() == 0) {
            throw new FaultyImplementationError("No possible states");
        }
        if (possibleStates.size() == 1) {
            return new BlockCondition.SpecificState(possibleStates.get(0).getVanillaState());
        }
        HashSet<class_2680> vanillaStateSet = new HashSet<class_2680>();
        for (CustomBlockState possibleState : possibleStates) {
            vanillaStateSet.add(possibleState.getVanillaState());
        }
        Object var5_7 = null;
        for (class_2680 blockState : vanillaStateSet) {
            void var5_8;
            if (var5_8 == null) {
                class_2248 class_22482 = blockState.method_26204();
                continue;
            }
            if (var5_8 == blockState.method_26204()) continue;
            Object var5_10 = null;
            break;
        }
        if (var5_11 != null && var5_11.method_9595().method_11662().size() == vanillaStateSet.size()) {
            return new BlockCondition.AnyState((class_2248)var5_11);
        }
        return new BlockCondition.StateSet(vanillaStateSet);
    }

    public BlockConditionState createState() {
        if (this.tag != null) {
            return new BlockConditionState(null, null, this.tag);
        }
        return new BlockConditionState(this.block, new HashMap(this.selectedProperties), null);
    }

    public void revertState(BlockConditionState blockConditionState) {
        if (blockConditionState.tag != null) {
            this.tag = blockConditionState.tag;
            this.block = null;
            this.visualBlockState = null;
            this.selectedProperties.clear();
        } else {
            this.tag = null;
            this.block = blockConditionState.block;
            this.visualBlockState = this.block.defaultCustomState();
            this.selectedProperties.clear();
            for (Map.Entry<class_2769<?>, Comparable<?>> entry : blockConditionState.selectedProperties.entrySet()) {
                Comparable<?> value = entry.getValue();
                this.selectedProperties.put(entry.getKey(), value);
                if (value == null) continue;
                this.visualBlockState = this.visualBlockState.setPropertyUnsafe(entry.getKey(), value);
            }
        }
    }

    @Nullable
    public CustomBlock getBlock() {
        return this.block;
    }

    @Nullable
    public class_6885<class_2248> getTag() {
        return this.tag;
    }

    private void switchBlock(CustomBlock block) {
        this.tag = null;
        this.visualBlockState = block.defaultCustomState();
        if (this.block == null || this.block == block) {
            this.selectedProperties.clear();
            for (class_2769<?> class_27692 : this.visualBlockState.getProperties()) {
                this.selectedProperties.put(class_27692, null);
            }
        } else {
            this.selectedProperties.keySet().retainAll(this.visualBlockState.getProperties());
            for (class_2769<?> class_27693 : this.visualBlockState.getProperties()) {
                if (this.selectedProperties.containsKey(class_27693)) continue;
                this.selectedProperties.put(class_27693, null);
            }
            for (Map.Entry entry : this.selectedProperties.entrySet()) {
                Comparable value = (Comparable)entry.getValue();
                if (value == null) continue;
                this.visualBlockState = this.visualBlockState.setPropertyUnsafe((class_2769)entry.getKey(), value);
            }
        }
        this.block = block;
    }

    public record PropertySettingsResult(float width, boolean changed) {
    }

    public record BlockConditionState(CustomBlock block, Map<class_2769<?>, Comparable<?>> selectedProperties, class_6885<class_2248> tag) {
        public BlockCondition createCondition() {
            return BlockConditionWidget.createCondition(this.block, this.selectedProperties, this.tag);
        }
    }
}

