/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows;

import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.keybinds.Keybind;
import com.moulberry.axiom.editor.keybinds.KeybindCategory;
import com.moulberry.axiom.editor.keybinds.KeybindDefaults;
import com.moulberry.axiom.editor.keybinds.Keybinds;
import com.moulberry.axiom.i18n.AxiomI18n;
import imgui.ImGui;
import imgui.ImVec2;
import java.util.Set;
import net.minecraft.class_310;
import org.lwjgl.glfw.GLFW;

public class KeybindsWindow {
    private static String backedUpKeybind = null;
    private static int backupKey;
    private static boolean backupShiftMod;
    private static boolean backupCtrlMod;
    private static boolean backupAltMod;
    private static boolean backupSuperMod;

    public static void render() {
        if (!EditorWindowType.KEYBINDS.isOpen()) {
            return;
        }
        String title = EditorWindowType.KEYBINDS.getName() + "###Keybinds";
        if (!ImGui.isPopupOpen("###Keybinds")) {
            ImGui.openPopup("###Keybinds");
        }
        ImVec2 center = ImGui.getMainViewport().getCenter();
        ImGui.setNextWindowPos(center.x, center.y, 8, 0.5f, 0.5f);
        ImGui.setNextWindowSize(720.0f, 500.0f, 4);
        ImGui.setNextWindowSizeConstraints(510.0f, 350.0f, 5000.0f, 3000.0f);
        if (ImGuiHelper.beginPopupModalCloseable(title)) {
            KeybindsWindow.renderInner();
            ImGuiHelper.endPopupModalCloseable();
        }
        if (!ImGui.isPopupOpen("###Keybinds")) {
            EditorWindowType.KEYBINDS.setOpen(false);
        }
    }

    private static void renderInner() {
        float warningSymbolWidth = ImGuiHelper.calcTextWidth("\u26a0");
        if (ImGui.button(AxiomI18n.get("axiom.editorui.window.keybinds.load_default"))) {
            ImGui.openPopup("##DefaultSelector");
        }
        if (ImGui.beginPopup("##DefaultSelector")) {
            if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.window.keybinds.load_axiom_defaults"))) {
                KeybindDefaults.loadAxiom();
                ImGui.closeCurrentPopup();
            }
            if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.window.keybinds.load_blender_defaults"))) {
                KeybindDefaults.loadBlender();
                ImGui.closeCurrentPopup();
            }
            ImGui.endPopup();
        }
        ImGui.separator();
        for (KeybindCategory category : Keybinds.categories) {
            String translated = AxiomI18n.get(category.name());
            if (!ImGui.treeNode(translated + "##" + category.name())) continue;
            if (category.name().equals("axiom.keybind_categories.basic")) {
                String invertCameraRotateLabel = AxiomI18n.get("axiom.keybind_options.invert_camera_rotate");
                if (ImGui.checkbox(invertCameraRotateLabel + "##InvertCameraRotate", Keybinds.invertCameraRotate)) {
                    Keybinds.invertCameraRotate = !Keybinds.invertCameraRotate;
                }
            } else if (category.name().equals("axiom.keybind_categories.movement")) {
                String useVanillaMovementLabel = AxiomI18n.get("axiom.keybind_options.use_vanilla_movement");
                if (ImGui.checkbox(useVanillaMovementLabel + "##UseVanillaMovement", Keybinds.useVanillaMovement)) {
                    boolean bl = Keybinds.useVanillaMovement = !Keybinds.useVanillaMovement;
                }
                if (Keybinds.useVanillaMovement) {
                    ImGui.treePop();
                    continue;
                }
            }
            for (Keybind keybind : category.keybinds()) {
                String descriptionRaw = keybind.getDescriptionRaw();
                String description = keybind.getDescription();
                if (ImGui.selectable(description + "##" + descriptionRaw, false, 1)) {
                    ImGui.openPopup(descriptionRaw + "##EditKeybind");
                }
                ImGui.sameLine();
                String longKeyIdent = keybind.longKeyIdentifier();
                StringBuilder conflicts = null;
                if (keybind.getKey() != 0) {
                    Set<Keybind> keybindsForKey = Keybinds.keybindsForKey.get(keybind.getKey());
                    for (Keybind other : keybindsForKey) {
                        if (other == keybind || keybind == Keybinds.USE_TOOL || other == Keybinds.USE_TOOL || keybind == Keybinds.QUICK_REPLACE && other == Keybinds.ROTATE_PLACEMENT || keybind == Keybinds.ROTATE_PLACEMENT && other == Keybinds.QUICK_REPLACE || keybind == Keybinds.QUICK_FILL && other == Keybinds.FLIP_PLACEMENT || keybind == Keybinds.FLIP_PLACEMENT && other == Keybinds.QUICK_FILL || !keybind.hasSameMods(other)) continue;
                        if (conflicts == null) {
                            conflicts = new StringBuilder(AxiomI18n.get("axiom.editorui.window.keybinds.conflicts_with"));
                        }
                        conflicts.append('\n').append(other.getDescription());
                    }
                }
                float availX = ImGui.getContentRegionAvailX();
                float width = ImGuiHelper.calcTextWidth(longKeyIdent) + ImGui.getStyle().getFramePaddingX() * 2.0f;
                if (conflicts != null) {
                    width += warningSymbolWidth + ImGui.getStyle().getItemSpacingX();
                }
                ImGui.sameLine(0.0f, availX - width);
                if (conflicts != null) {
                    ImGui.text("\u26a0");
                    ImGuiHelper.tooltip(conflicts.toString());
                    ImGui.sameLine();
                }
                ImGui.smallButton(longKeyIdent);
                if (!ImGuiHelper.beginPopup(descriptionRaw + "##EditKeybind")) continue;
                ImGuiHelper.setEditingKeybind(keybind);
                if (backedUpKeybind == null || !backedUpKeybind.equals(keybind.getDescriptionRaw())) {
                    backedUpKeybind = keybind.getDescriptionRaw();
                    backupKey = keybind.getKey();
                    backupShiftMod = keybind.isShiftMod();
                    backupCtrlMod = keybind.isCtrlMod();
                    backupAltMod = keybind.isAltMod();
                    backupSuperMod = keybind.isSuperMod();
                }
                ImGui.text(description);
                ImGui.button(longKeyIdent + "##KeybindPreview", -1.0f, 0.0f);
                if (ImGui.isItemHovered()) {
                    for (int i = 0; i < 5; ++i) {
                        if (!ImGui.isMouseClicked(i)) continue;
                        long window = ImGui.getWindowViewport().getPlatformHandle();
                        boolean shiftDown = GLFW.glfwGetKey((long)window, (int)340) != 0 || GLFW.glfwGetKey((long)window, (int)344) != 0;
                        boolean ctrlDown = GLFW.glfwGetKey((long)window, (int)341) != 0 || GLFW.glfwGetKey((long)window, (int)345) != 0;
                        boolean altDown = GLFW.glfwGetKey((long)window, (int)342) != 0 || GLFW.glfwGetKey((long)window, (int)346) != 0;
                        boolean superDown = GLFW.glfwGetKey((long)window, (int)343) != 0 || GLFW.glfwGetKey((long)window, (int)347) != 0;
                        keybind.set(-i - 1, shiftDown, class_310.field_1703 ? superDown : ctrlDown, altDown, class_310.field_1703 ? ctrlDown : superDown);
                    }
                }
                if (ImGui.button(AxiomI18n.get("axiom.widget.ok"))) {
                    backedUpKeybind = null;
                    ImGui.closeCurrentPopup();
                }
                ImGui.sameLine();
                if (ImGui.button(AxiomI18n.get("axiom.widget.cancel"))) {
                    keybind.set(backupKey, backupShiftMod, backupCtrlMod, backupAltMod, backupSuperMod);
                    backedUpKeybind = null;
                    ImGui.closeCurrentPopup();
                }
                ImGui.sameLine();
                if (ImGui.button(AxiomI18n.get("axiom.editorui.window.keybinds.unbind"))) {
                    keybind.clear();
                    backedUpKeybind = null;
                    ImGui.closeCurrentPopup();
                }
                ImGui.endPopup();
            }
            ImGui.treePop();
        }
    }
}

