/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows.operations;

import com.moulberry.axiom.block_maps.BlockColourMap;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.ServerCustomBlocks;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.PresetWidget;
import com.moulberry.axiom.editor.widgets.SelectBlockWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.operations.AutoshadeOperation;
import com.moulberry.axiom.utils.BlockWithFloat;
import com.moulberry.axiom.utils.NbtGetter;
import imgui.ImGui;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2246;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3532;

public class AutoshadeWindow {
    private static boolean sunShade = true;
    private static boolean sunShadeFromPlayerPosition = true;
    private static final float[] sunYawRadians = new float[]{0.7853982f};
    private static final float[] sunPitchRadians = new float[]{0.7853982f};
    private static boolean ambientShade = true;
    private static final float[] globalIllumination = new float[]{0.5f};
    private static final float[] dither = new float[]{0.1f};
    private static int paletteFlags = BlockColourMap.FLAG_SOLID | BlockColourMap.FLAG_OPAQUE | BlockColourMap.FLAG_FULL_CUBE | BlockColourMap.FLAG_NO_TILE_ENTITIES;
    private static final int[] paletteMode = new int[]{0};
    private static final List<BlockWithFloat> blockPercentages = new ArrayList<BlockWithFloat>();
    private static final SelectBlockWidget selectBlockWidget = new SelectBlockWidget(false);
    private static final PresetWidget presetWidget = new PresetWidget(AutoshadeWindow::loadSettings, AutoshadeWindow::writeSettings, "autoshade");

    public static void render() {
        if (!EditorWindowType.AUTOSHADE.isOpen()) {
            return;
        }
        if (EditorWindowType.AUTOSHADE.begin("###Autoshade", true)) {
            boolean disable;
            boolean changed = false;
            ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.window.autoshade.sun_shading"));
            if (ImGui.checkbox(AxiomI18n.get("axiom.window.autoshade.sun"), sunShade)) {
                sunShade = !sunShade;
                changed = true;
            }
            if (sunShade) {
                if (ImGui.checkbox(AxiomI18n.get("axiom.window.autoshade.use_player_position"), sunShadeFromPlayerPosition)) {
                    sunShadeFromPlayerPosition = !sunShadeFromPlayerPosition;
                    changed = true;
                }
                if (!sunShadeFromPlayerPosition) {
                    changed |= ImGui.sliderAngle(AxiomI18n.get("axiom.window.autoshade.sun_yaw"), sunYawRadians);
                    changed |= ImGui.sliderAngle(AxiomI18n.get("axiom.window.autoshade.sun_pitch"), sunPitchRadians);
                }
            }
            ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.window.autoshade.ambient_occlusion_shading"));
            if (ImGui.checkbox(AxiomI18n.get("axiom.window.autoshade.ambient_occlusion"), ambientShade)) {
                ambientShade = !ambientShade;
                changed = true;
            }
            if (paletteMode[0] == 0) {
                ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.window.autoshade.global_illumination"));
                changed |= ImGui.sliderFloat("##GlobalIllumination", globalIllumination, 0.0f, 1.0f);
            }
            ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.window.autoshade.dither"));
            changed |= ImGui.sliderFloat("##Dither", dither, 0.0f, 1.0f);
            ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.window.autoshade.palette_options"));
            ImGuiHelper.combo(AxiomI18n.get("axiom.window.autoshade.palette_type"), paletteMode, new String[]{AxiomI18n.get("axiom.window.autoshade.palette_type.automatic"), AxiomI18n.get("axiom.window.autoshade.palette_type.custom")});
            if (paletteMode[0] == 0) {
                if (ImGui.checkbox(AxiomI18n.get("axiom.window.autoshade.palette_solid"), (paletteFlags & BlockColourMap.FLAG_SOLID) != 0)) {
                    paletteFlags ^= BlockColourMap.FLAG_SOLID;
                    changed = true;
                }
                if (ImGui.checkbox(AxiomI18n.get("axiom.window.autoshade.palette_opaque"), (paletteFlags & BlockColourMap.FLAG_OPAQUE) != 0)) {
                    paletteFlags ^= BlockColourMap.FLAG_OPAQUE;
                    changed = true;
                }
                if (ImGui.checkbox(AxiomI18n.get("axiom.window.autoshade.palette_full_cube"), (paletteFlags & BlockColourMap.FLAG_FULL_CUBE) != 0)) {
                    paletteFlags ^= BlockColourMap.FLAG_FULL_CUBE;
                    changed = true;
                }
                if (ImGui.checkbox(AxiomI18n.get("axiom.window.autoshade.palette_same_texture"), (paletteFlags & BlockColourMap.FLAG_SAME_TEXTURE) != 0)) {
                    paletteFlags ^= BlockColourMap.FLAG_SAME_TEXTURE;
                    changed = true;
                }
                if (ImGui.checkbox(AxiomI18n.get("axiom.window.autoshade.palette_no_ores"), (paletteFlags & BlockColourMap.FLAG_NO_ORES) != 0)) {
                    paletteFlags ^= BlockColourMap.FLAG_NO_ORES;
                    changed = true;
                }
                if (ImGui.checkbox(AxiomI18n.get("axiom.window.autoshade.palette_no_glazed_terracotta"), (paletteFlags & BlockColourMap.FLAG_NO_GLAZED_TERRACOTTA) != 0)) {
                    paletteFlags ^= BlockColourMap.FLAG_NO_GLAZED_TERRACOTTA;
                    changed = true;
                }
                if (ImGui.checkbox(AxiomI18n.get("axiom.window.autoshade.palette_no_tile_entities"), (paletteFlags & BlockColourMap.FLAG_NO_TILE_ENTITIES) != 0)) {
                    paletteFlags ^= BlockColourMap.FLAG_NO_TILE_ENTITIES;
                    changed = true;
                }
            } else {
                changed |= BlockWithFloat.renderList(blockPercentages, selectBlockWidget, BlockWithFloat.ExtraRenderType.PERCENTAGE, 1);
            }
            ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.presets"));
            presetWidget.displayImgui(changed);
            ImGui.separator();
            boolean bl = disable = Selection.getSelectionBuffer().isEmpty() || !sunShade && !ambientShade;
            if (disable) {
                ImGui.beginDisabled();
            }
            if (ImGui.button(AxiomI18n.get("axiom.editorui.window.autoshade.do_autoshade"))) {
                class_243 sunVector;
                if (!sunShade || sunShadeFromPlayerPosition) {
                    sunVector = null;
                } else {
                    float yawRadians = -sunYawRadians[0];
                    float pitchRadians = -sunPitchRadians[0];
                    float cosYaw = class_3532.method_15362((float)yawRadians);
                    float sinYaw = class_3532.method_15374((float)yawRadians);
                    float cosPitch = class_3532.method_15362((float)pitchRadians);
                    float sinPitch = class_3532.method_15374((float)pitchRadians);
                    sunVector = new class_243((double)(sinYaw * cosPitch), (double)(-sinPitch), (double)(cosYaw * cosPitch));
                }
                List<BlockWithFloat> customPalette = paletteMode[0] == 0 ? null : blockPercentages;
                float globalIlluminationFloat = paletteMode[0] == 0 ? globalIllumination[0] : 0.0f;
                AutoshadeOperation.autoshade(sunShade, ambientShade, sunVector, globalIlluminationFloat, dither[0], customPalette, paletteFlags);
            }
            if (disable) {
                ImGui.endDisabled();
            }
        }
        EditorWindowType.AUTOSHADE.end();
    }

    private static void loadSettings(class_2487 tag) {
        sunShade = NbtGetter.getBoolOrDefault(tag, "DoSunShading", true);
        sunShadeFromPlayerPosition = NbtGetter.getBoolOrDefault(tag, "SunShadeFromPlayerPosition", true);
        AutoshadeWindow.sunYawRadians[0] = NbtGetter.getFloatOrDefault(tag, "SunYawRadians", 0.7853982f);
        AutoshadeWindow.sunPitchRadians[0] = NbtGetter.getFloatOrDefault(tag, "SunPitchRadians", 0.7853982f);
        ambientShade = NbtGetter.getBoolOrDefault(tag, "DoAmbientShading", true);
        AutoshadeWindow.globalIllumination[0] = NbtGetter.getFloatOrDefault(tag, "GlobalIllumination", 0.5f);
        AutoshadeWindow.dither[0] = NbtGetter.getFloatOrDefault(tag, "Dither", 0.5f);
        paletteFlags = NbtGetter.getIntOrDefault(tag, "PaletteFlags", BlockColourMap.FLAG_SOLID | BlockColourMap.FLAG_OPAQUE | BlockColourMap.FLAG_FULL_CUBE | BlockColourMap.FLAG_NO_TILE_ENTITIES);
        AutoshadeWindow.paletteMode[0] = NbtGetter.getIntOrDefault(tag, "PaletteMode", 0);
        blockPercentages.clear();
        class_2499 blockPercentagesList = tag.method_10554("BlockPercentages", 10);
        for (class_2520 blockPercentageTag : blockPercentagesList) {
            class_2487 blockPercentage = (class_2487)blockPercentageTag;
            String block = blockPercentage.method_10558("Block");
            float percentage = blockPercentage.method_10583("Percentage");
            blockPercentages.add(new BlockWithFloat(Objects.requireNonNullElse(ServerCustomBlocks.deserialize(block), (CustomBlockState)class_2246.field_10340.method_9564()), new float[]{percentage}));
        }
        if (blockPercentages.isEmpty()) {
            BlockWithFloat.addNew(blockPercentages, (CustomBlockState)class_2246.field_37576.method_9564());
            BlockWithFloat.addNew(blockPercentages, (CustomBlockState)class_2246.field_28888.method_9564());
            BlockWithFloat.addNew(blockPercentages, (CustomBlockState)class_2246.field_27165.method_9564());
            BlockWithFloat.addNew(blockPercentages, (CustomBlockState)class_2246.field_10115.method_9564());
        }
    }

    private static void writeSettings(class_2487 tag) {
        tag.method_10556("DoSunShading", sunShade);
        tag.method_10556("SunShadeFromPlayerPosition", sunShadeFromPlayerPosition);
        tag.method_10548("SunYawRadians", sunYawRadians[0]);
        tag.method_10548("SunPitchRadians", sunPitchRadians[0]);
        tag.method_10556("DoAmbientShading", ambientShade);
        tag.method_10548("GlobalIllumination", globalIllumination[0]);
        tag.method_10548("Dither", dither[0]);
        tag.method_10569("PaletteFlags", paletteFlags);
        tag.method_10569("PaletteMode", paletteMode[0]);
        class_2499 blockPercentagesList = new class_2499();
        for (BlockWithFloat blockWithFloat : blockPercentages) {
            class_2487 blockWithFloatTag = new class_2487();
            blockWithFloatTag.method_10582("Block", ServerCustomBlocks.serialize(blockWithFloat.blockState()));
            blockWithFloatTag.method_10548("Percentage", blockWithFloat.percentage()[0]);
            blockPercentagesList.add((Object)blockWithFloatTag);
        }
        tag.method_10566("BlockPercentages", (class_2520)blockPercentagesList);
    }

    static {
        blockPercentages.add(new BlockWithFloat((CustomBlockState)class_2246.field_37576.method_9564(), new float[]{25.0f}));
        blockPercentages.add(new BlockWithFloat((CustomBlockState)class_2246.field_28888.method_9564(), new float[]{25.0f}));
        blockPercentages.add(new BlockWithFloat((CustomBlockState)class_2246.field_27165.method_9564(), new float[]{25.0f}));
        blockPercentages.add(new BlockWithFloat((CustomBlockState)class_2246.field_10115.method_9564(), new float[]{25.0f}));
    }
}

