/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.marker;

import com.moulberry.axiom.VersionUtils;
import java.util.UUID;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2540;
import net.minecraft.class_6335;
import org.jetbrains.annotations.Nullable;

public record MarkerData(UUID uuid, class_243 position, @Nullable String name, @Nullable class_243 minRegion, @Nullable class_243 maxRegion, int lineArgb, float lineThickness, int faceArgb) {
    public static MarkerData read(class_2540 friendlyByteBuf) {
        UUID uuid = friendlyByteBuf.method_10790();
        class_243 position = VersionUtils.helperReadVec3(friendlyByteBuf);
        String name = (String)friendlyByteBuf.method_43827(class_2540::method_19772);
        class_243 minRegion = null;
        class_243 maxRegion = null;
        int lineArgb = 0;
        float lineThickness = 0.0f;
        int faceArgb = 0;
        byte flags = friendlyByteBuf.readByte();
        if (flags != 0) {
            minRegion = VersionUtils.helperReadVec3(friendlyByteBuf);
            maxRegion = VersionUtils.helperReadVec3(friendlyByteBuf);
            if ((flags & 2) != 0) {
                lineArgb = friendlyByteBuf.readInt();
            }
            if ((flags & 4) != 0) {
                lineThickness = friendlyByteBuf.readFloat();
            }
            if ((flags & 8) != 0) {
                faceArgb = friendlyByteBuf.readInt();
            }
        }
        return new MarkerData(uuid, position, name, minRegion, maxRegion, lineArgb, lineThickness, faceArgb);
    }

    public static void write(class_2540 friendlyByteBuf, MarkerData markerData) {
        friendlyByteBuf.method_10797(markerData.uuid);
        friendlyByteBuf.writeDouble(markerData.position.field_1352);
        friendlyByteBuf.writeDouble(markerData.position.field_1351);
        friendlyByteBuf.writeDouble(markerData.position.field_1350);
        friendlyByteBuf.method_43826((Object)markerData.name, class_2540::method_10814);
        if (markerData.minRegion != null && markerData.maxRegion != null) {
            int flags = 1;
            if (markerData.lineArgb != 0) {
                flags = (byte)(flags | 2);
            }
            if (markerData.lineThickness != 0.0f) {
                flags = (byte)(flags | 4);
            }
            if (markerData.faceArgb != 0) {
                flags = (byte)(flags | 8);
            }
            friendlyByteBuf.writeByte(flags);
            friendlyByteBuf.writeDouble(markerData.minRegion.field_1352);
            friendlyByteBuf.writeDouble(markerData.minRegion.field_1351);
            friendlyByteBuf.writeDouble(markerData.minRegion.field_1350);
            friendlyByteBuf.writeDouble(markerData.maxRegion.field_1352);
            friendlyByteBuf.writeDouble(markerData.maxRegion.field_1351);
            friendlyByteBuf.writeDouble(markerData.maxRegion.field_1350);
            if (markerData.lineArgb != 0) {
                friendlyByteBuf.writeInt(markerData.lineArgb);
            }
            if (markerData.lineThickness != 0.0f) {
                friendlyByteBuf.writeFloat(markerData.lineThickness);
            }
            if (markerData.faceArgb != 0) {
                friendlyByteBuf.writeInt(markerData.faceArgb);
            }
        } else {
            friendlyByteBuf.writeByte(0);
        }
    }

    public static MarkerData createFrom(class_6335 marker) {
        class_243 position = marker.method_19538();
        class_2487 data = marker.field_33458;
        String name = data.method_10558("name").trim();
        if (name.isEmpty()) {
            name = null;
        }
        class_243 minRegion = null;
        class_243 maxRegion = null;
        int lineArgb = 0;
        float lineThickness = 0.0f;
        int faceArgb = 0;
        if (data.method_10573("min", 9) && data.method_10573("max", 9)) {
            class_2499 min2 = data.method_10554("min", 6);
            class_2499 max2 = data.method_10554("max", 6);
            if (min2.size() == 3 && max2.size() == 3) {
                double minX = min2.method_10611(0);
                double minY = min2.method_10611(1);
                double minZ = min2.method_10611(2);
                double maxX = max2.method_10611(0);
                double maxY = max2.method_10611(1);
                double maxZ = max2.method_10611(2);
                minRegion = new class_243(minX, minY, minZ);
                maxRegion = new class_243(maxX, maxY, maxZ);
                if (data.method_10573("line_argb", 99)) {
                    lineArgb = data.method_10550("line_argb");
                }
                if (data.method_10573("line_thickness", 99)) {
                    lineThickness = data.method_10550("line_thickness");
                }
                if (data.method_10573("face_argb", 99)) {
                    faceArgb = data.method_10550("face_argb");
                }
            }
        }
        return new MarkerData(marker.method_5667(), position, name, minRegion, maxRegion, lineArgb, lineThickness, faceArgb);
    }
}

