/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.marker;

import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.configuration.Configuration;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.gizmo.Gizmo;
import com.moulberry.axiom.marker.MarkerData;
import com.moulberry.axiom.packets.AxiomClientboundMarkerData;
import com.moulberry.axiom.packets.AxiomServerboundDeleteEntity;
import com.moulberry.axiom.packets.AxiomServerboundManipulateEntity;
import com.moulberry.axiom.packets.AxiomServerboundMarkerNbtRequest;
import com.moulberry.axiom.packets.AxiomServerboundSpawnEntity;
import com.moulberry.axiom.render.EffectRenderer;
import com.moulberry.axiom.render.Shapes;
import com.moulberry.axiom.screen.EditMarkerScreen;
import com.moulberry.axiom.tools.Tool;
import imgui.ImGui;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_8251;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.lwjgl.glfw.GLFW;

public class MarkerEntityManipulator {
    private static final Map<UUID, Gizmo> gizmos = new HashMap<UUID, Gizmo>();
    private static final Map<UUID, MarkerData> markerDataMap = new HashMap<UUID, MarkerData>();
    private static final Map<UUID, class_243> pendingTeleports = new HashMap<UUID, class_243>();
    private static MarkerData activeEntity = null;
    private static boolean hoveredGizmoPart = false;
    private static final List<class_243> undoStates = new ArrayList<class_243>();
    private static final List<class_243> redoStates = new ArrayList<class_243>();
    private static boolean movementDirty = false;
    private static int teleportTicks = 0;

    public static void tick() {
        if (teleportTicks > 0) {
            --teleportTicks;
        }
        class_746 player = class_310.method_1551().field_1724;
        class_638 level = class_310.method_1551().field_1687;
        if (player == null || level == null || !Axiom.isAxiomActive() || !Configuration.rendering().showMarkerEntities) {
            if (activeEntity != null) {
                Gizmo gizmo = gizmos.get(activeEntity.uuid());
                if (gizmo != null) {
                    gizmo.enableAxes = false;
                    gizmo.moveToVec(activeEntity.position());
                }
                teleportTicks = 0;
                activeEntity = null;
                movementDirty = false;
                undoStates.clear();
                redoStates.clear();
            }
            pendingTeleports.clear();
            return;
        }
        if (!pendingTeleports.isEmpty()) {
            ArrayList<AxiomServerboundManipulateEntity.ManipulateEntry> entries = new ArrayList<AxiomServerboundManipulateEntity.ManipulateEntry>();
            for (Map.Entry<UUID, class_243> entry : pendingTeleports.entrySet()) {
                entries.add(new AxiomServerboundManipulateEntity.ManipulateEntry(entry.getKey(), entry.getValue(), null));
            }
            new AxiomServerboundManipulateEntity(entries).send();
        }
        pendingTeleports.clear();
    }

    public static void render(class_4184 camera, long time, class_4587 poseStack, Matrix4f projection) {
        class_243 lookDirection;
        hoveredGizmoPart = false;
        if (!Configuration.rendering().showMarkerEntities) {
            return;
        }
        boolean inEditor = EditorUI.isActive();
        class_243 class_2432 = lookDirection = inEditor ? null : Tool.getLookDirection();
        boolean isLeftDown = !inEditor && (Configuration.keybinds().swapLeftRightClickDisplayEntities ? Tool.isMouseDown(1) : Tool.isMouseDown(0));
        long window = class_310.method_1551().method_22683().method_4490();
        boolean isCtrlDown = !inEditor && (class_310.field_1703 ? GLFW.glfwGetKey((long)window, (int)343) != 0 || GLFW.glfwGetKey((long)window, (int)347) != 0 : GLFW.glfwGetKey((long)window, (int)341) != 0 || GLFW.glfwGetKey((long)window, (int)345) != 0);
        for (Map.Entry<UUID, Gizmo> entry : gizmos.entrySet()) {
            boolean isActiveEntity;
            UUID uuid = entry.getKey();
            Gizmo gizmo = entry.getValue();
            class_243 before = gizmo.getTargetVec();
            boolean bl = isActiveEntity = activeEntity != null && uuid.equals(activeEntity.uuid());
            if (!Configuration.capabilities().infiniteRangeMarkers && before.method_1025(camera.method_19326()) > 576.0 && !isActiveEntity) continue;
            if (gizmo.enableAxes) {
                gizmo.setAxisDirections(camera.method_19326().field_1352 > gizmo.getTargetVec().field_1352, camera.method_19326().field_1351 > gizmo.getTargetVec().field_1351, camera.method_19326().field_1350 > gizmo.getTargetVec().field_1350);
            }
            gizmo.update(time, lookDirection, isLeftDown, isCtrlDown, true);
            class_243 position = gizmo.getTargetVec();
            if (!class_310.method_1551().field_1690.field_1842) {
                if (!inEditor) {
                    gizmo.render(poseStack, camera, isCtrlDown);
                }
                class_327 font = class_310.method_1551().field_1772;
                MarkerData markerData = markerDataMap.get(uuid);
                if (!gizmo.isGrabbed()) {
                    poseStack.method_22903();
                    poseStack.method_22904(-camera.method_19326().field_1352, -camera.method_19326().field_1351, -camera.method_19326().field_1350);
                    float scale = 2.0f * Math.max(1.0f, Math.min(ImGui.getIO().getDisplayFramebufferScaleX(), ImGui.getIO().getDisplayFramebufferScaleY()));
                    float width = (float)class_310.method_1551().method_22683().method_4489() / scale;
                    float height = (float)class_310.method_1551().method_22683().method_4506() / scale;
                    Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, width, height, 0.0f, 1000.0f, 3000.0f);
                    RenderSystem.backupProjectionMatrix();
                    RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (class_8251)class_8251.field_43361);
                    class_4587 modelViewStack = RenderSystem.getModelViewStack();
                    modelViewStack.method_22903();
                    modelViewStack.method_34426();
                    modelViewStack.method_46416(0.0f, 0.0f, -2000.0f);
                    RenderSystem.applyModelViewMatrix();
                    float fog = RenderSystem.getShaderFogStart();
                    RenderSystem.setShaderFogStart((float)Float.MAX_VALUE);
                    MarkerEntityManipulator.renderProjectedText(markerData.name() == null ? "Unnamed Marker" : markerData.name(), poseStack, projection, (float)position.field_1352, (float)position.field_1351 + 0.15f, (float)position.field_1350, scale, width, height, font);
                    class_310.method_1551().method_22940().method_23000().method_22993();
                    RenderSystem.setShaderFogStart((float)fog);
                    modelViewStack.method_22909();
                    RenderSystem.applyModelViewMatrix();
                    RenderSystem.restoreProjectionMatrix();
                    poseStack.method_22909();
                }
                if ((isActiveEntity || activeEntity == null) && markerData.minRegion() != null && markerData.maxRegion() != null) {
                    boolean renderCustomFace;
                    class_243 minRegion = markerData.minRegion();
                    class_243 maxRegion = markerData.maxRegion();
                    boolean renderCustomLine = markerData.lineArgb() != 0;
                    boolean bl2 = renderCustomFace = markerData.faceArgb() != 0;
                    if (!renderCustomLine) {
                        EffectRenderer.renderBoundingBox(camera, time, poseStack, minRegion, maxRegion, 4);
                    }
                    if (renderCustomLine || renderCustomFace) {
                        float minX = (float)Math.min(minRegion.method_10216(), maxRegion.method_10216()) - 1.0E-4f;
                        float minY = (float)Math.min(minRegion.method_10214(), maxRegion.method_10214()) - 1.0E-4f;
                        float minZ = (float)Math.min(minRegion.method_10215(), maxRegion.method_10215()) - 1.0E-4f;
                        float maxX = (float)Math.max(minRegion.method_10216(), maxRegion.method_10216()) + 1.0E-4f;
                        float maxY = (float)Math.max(minRegion.method_10214(), maxRegion.method_10214()) + 1.0E-4f;
                        float maxZ = (float)Math.max(minRegion.method_10215(), maxRegion.method_10215()) + 1.0E-4f;
                        float thickness = markerData.lineThickness() < 1.0f ? 2.0f : markerData.lineThickness();
                        RenderSystem.enableBlend();
                        RenderSystem.defaultBlendFunc();
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        RenderSystem.lineWidth((float)thickness);
                        RenderSystem.disableCull();
                        RenderSystem.setShader(class_757::method_34535);
                        poseStack.method_22903();
                        poseStack.method_22904((double)minX - camera.method_19326().field_1352, (double)minY - camera.method_19326().field_1351, (double)minZ - camera.method_19326().field_1350);
                        RenderSystem.applyModelViewMatrix();
                        class_287 bufferBuilder = class_289.method_1348().method_1349();
                        if (renderCustomLine) {
                            int argb = markerData.lineArgb();
                            float alpha = (float)(argb >> 24 & 0xFF) / 255.0f;
                            float red = (float)(argb >> 16 & 0xFF) / 255.0f;
                            float green = (float)(argb >> 8 & 0xFF) / 255.0f;
                            float blue = (float)(argb & 0xFF) / 255.0f;
                            if ((double)alpha < 0.1) {
                                alpha = 1.0f;
                            }
                            bufferBuilder.method_1328(class_293.class_5596.field_27377, class_290.field_29337);
                            Shapes.lineBox(poseStack, (class_4588)bufferBuilder, 0.0f, 0.0f, 0.0f, maxX - minX, maxY - minY, maxZ - minZ, red, green, blue, alpha, red, green, blue);
                            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
                        }
                        if (renderCustomFace) {
                            int faceArgb = markerData.faceArgb();
                            if ((faceArgb >> 24 & 0xFF) == 0) {
                                faceArgb |= 0x40000000;
                            }
                            RenderSystem.enableDepthTest();
                            RenderSystem.enableCull();
                            RenderSystem.setShader(class_757::method_34540);
                            Shapes.shadedBox(bufferBuilder, poseStack.method_23760().method_23761(), maxX - minX, maxY - minY, maxZ - minZ, faceArgb);
                            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
                        }
                        poseStack.method_22909();
                    }
                }
            }
            if (gizmo.isHovered()) {
                hoveredGizmoPart = true;
            }
            if (!isActiveEntity) continue;
            if (gizmo.isGrabbed()) {
                movementDirty = true;
            } else {
                if (movementDirty) {
                    movementDirty = false;
                    teleportTicks = 10;
                    MarkerEntityManipulator.applyTeleport(uuid, position);
                    MarkerEntityManipulator.addTranslationUndoState(position);
                }
                if (teleportTicks == 0) {
                    gizmo.moveToVec(activeEntity.position());
                }
            }
            if (position.equals((Object)before)) continue;
            String paddedPositionX = String.format("%.4f", position.field_1352);
            String paddedPositionY = String.format("%.4f", position.field_1351);
            String paddedPositionZ = String.format("%.4f", position.field_1350);
            class_310.method_1551().field_1705.method_1758((class_2561)class_2561.method_43470((String)"Position: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(paddedPositionX + " ")).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)(paddedPositionY + " ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)paddedPositionZ).method_27692(class_124.field_1075)), false);
        }
    }

    private static void renderProjectedText(String text, class_4587 matrix, Matrix4f projection, float x, float y, float z, float scale, float width, float height, class_327 font) {
        Vector4f transformed = matrix.method_23760().method_23761().transform(new Vector4f(x, y, z, 1.0f));
        transformed = projection.transform(transformed);
        int stringWidth = class_310.method_1551().field_1772.method_1727(text);
        if (transformed.w < 0.0f) {
            return;
        }
        float screenX = (float)Math.round(((transformed.x / transformed.w * 0.5f + 0.5f) * width - (float)stringWidth / 2.0f) * scale) / scale;
        float f = (-transformed.y / transformed.w * 0.5f + 0.5f) * height;
        Objects.requireNonNull(font);
        float screenY = (float)Math.round((f - 9.0f / 2.0f) * scale) / scale;
        font.method_37296(class_2561.method_43470((String)text).method_30937(), screenX, screenY, -3351041, -13420737, new Matrix4f(), (class_4597)class_310.method_1551().method_22940().method_23000(), 0xF000F0);
    }

    public static void clear() {
        teleportTicks = 0;
        activeEntity = null;
        movementDirty = false;
        gizmos.clear();
        markerDataMap.clear();
        undoStates.clear();
        redoStates.clear();
        pendingTeleports.clear();
    }

    public static void update(AxiomClientboundMarkerData markerData) {
        for (MarkerData entry : markerData.entries) {
            if (activeEntity != null && entry.uuid().equals(activeEntity.uuid())) {
                activeEntity = entry;
            }
            markerDataMap.put(entry.uuid(), entry);
            Gizmo gizmo = gizmos.get(entry.uuid());
            if (gizmo == null) {
                gizmo = new Gizmo(entry.position());
                gizmo.enableAxes = false;
                gizmo.minVisualScale = 2.0f;
                gizmo.translationSnapping = 16;
                gizmos.put(entry.uuid(), gizmo);
                continue;
            }
            if (entry == activeEntity && teleportTicks != 0) continue;
            gizmo.moveToVec(entry.position());
        }
        if (activeEntity != null && markerData.removedMarkers.contains(activeEntity.uuid())) {
            MarkerEntityManipulator.disableActive();
        }
        gizmos.keySet().removeAll(markerData.removedMarkers);
        markerDataMap.keySet().removeAll(markerData.removedMarkers);
    }

    private static void addTranslationUndoState(class_243 position) {
        class_243 first = undoStates.get(undoStates.size() - 1);
        if (first.equals((Object)position)) {
            return;
        }
        if (undoStates.size() >= 2) {
            class_243 second = undoStates.get(undoStates.size() - 2);
            boolean merge = false;
            if (first.field_1352 == position.field_1352 && first.field_1351 == position.field_1351 && second.field_1352 == position.field_1352 && second.field_1351 == position.field_1351) {
                merge = Math.abs(first.field_1350 - position.field_1350) < 1.0 && Math.abs(second.field_1350 - position.field_1350) < 1.0;
            } else if (first.field_1352 == position.field_1352 && first.field_1350 == position.field_1350 && second.field_1352 == position.field_1352 && second.field_1350 == position.field_1350) {
                merge = Math.abs(first.field_1351 - position.field_1351) < 1.0 && Math.abs(second.field_1351 - position.field_1351) < 1.0;
            } else if (first.field_1351 == position.field_1351 && first.field_1350 == position.field_1350 && second.field_1351 == position.field_1351 && second.field_1350 == position.field_1350) {
                boolean bl = merge = Math.abs(first.field_1352 - position.field_1352) < 1.0 && Math.abs(second.field_1352 - position.field_1352) < 1.0;
            }
            if (merge) {
                undoStates.set(undoStates.size() - 1, position);
                redoStates.clear();
                return;
            }
        }
        undoStates.add(position);
        if (undoStates.size() > 256) {
            undoStates.remove(0);
        }
        redoStates.clear();
    }

    public static void disableActive() {
        if (activeEntity != null) {
            Gizmo gizmo = gizmos.get(activeEntity.uuid());
            if (gizmo != null) {
                gizmo.enableAxes = false;
                gizmo.moveToVec(activeEntity.position());
            }
            teleportTicks = 0;
            activeEntity = null;
            movementDirty = false;
            undoStates.clear();
            redoStates.clear();
        }
    }

    public static void deleteActive() {
        if (activeEntity != null) {
            new AxiomServerboundDeleteEntity(List.of(activeEntity.uuid())).send();
        }
        MarkerEntityManipulator.disableActive();
    }

    @Nullable
    public static MarkerData getActiveMarkerData() {
        return activeEntity;
    }

    public static boolean hasActiveGizmo() {
        return activeEntity != null;
    }

    public static boolean hoveredGizmoPart() {
        return hoveredGizmoPart;
    }

    public static boolean canUndo() {
        return undoStates.size() >= 2;
    }

    public static boolean canRedo() {
        return redoStates.size() >= 1;
    }

    private static void applyTeleport(UUID uuid, class_243 position) {
        Gizmo gizmo = gizmos.get(uuid);
        if (gizmo != null) {
            gizmo.moveToVec(position);
        }
        pendingTeleports.put(uuid, position);
    }

    public static void spawnNewMarkerRegion(class_2338 first, class_2338 second) {
        double minX = Math.min(first.method_10263(), second.method_10263());
        double minY = Math.min(first.method_10264(), second.method_10264());
        double minZ = Math.min(first.method_10260(), second.method_10260());
        double maxX = Math.max(first.method_10263(), second.method_10263()) + 1;
        double maxY = Math.max(first.method_10264(), second.method_10264()) + 1;
        double maxZ = Math.max(first.method_10260(), second.method_10260()) + 1;
        class_243 center = new class_243((minX + maxX) / 2.0, (minY + maxY) / 2.0, (minZ + maxZ) / 2.0);
        class_2499 min2 = new class_2499();
        min2.add((Object)class_2489.method_23241((double)minX));
        min2.add((Object)class_2489.method_23241((double)minY));
        min2.add((Object)class_2489.method_23241((double)minZ));
        class_2499 max2 = new class_2499();
        max2.add((Object)class_2489.method_23241((double)maxX));
        max2.add((Object)class_2489.method_23241((double)maxY));
        max2.add((Object)class_2489.method_23241((double)maxZ));
        class_2487 data = new class_2487();
        data.method_10566("min", (class_2520)min2);
        data.method_10566("max", (class_2520)max2);
        class_2487 tag = new class_2487();
        tag.method_10582("id", "minecraft:marker");
        tag.method_10566("data", (class_2520)data);
        new AxiomServerboundSpawnEntity(List.of(new AxiomServerboundSpawnEntity.SpawnEntry(UUID.randomUUID(), center, 0.0f, 0.0f, null, tag))).send();
    }

    public static List<String> getKeyHints() {
        ArrayList<String> keyHints = new ArrayList<String>();
        keyHints.add("RMB - Edit/Move");
        keyHints.add("Scroll - Nudge");
        Gizmo gizmo = gizmos.get(activeEntity.uuid());
        if (gizmo != null && gizmo.isGrabbed()) {
            keyHints.add("Hold Ctrl - Inc Snapping");
            keyHints.add("Hold Shift - No Snapping");
        }
        keyHints.add("Delete - Remove");
        boolean canUndo = MarkerEntityManipulator.canUndo();
        boolean canRedo = MarkerEntityManipulator.canRedo();
        if (canUndo && canRedo) {
            keyHints.add("Ctrl+Z/Y - Undo/Redo");
        } else if (canUndo) {
            keyHints.add("Ctrl+Z - Undo");
        } else if (canRedo) {
            keyHints.add("Ctrl+Y - Redo");
        }
        return keyHints;
    }

    public static UserAction.ActionResult callAction(UserAction userAction, Object object) {
        if (EditorUI.isActive() || !Axiom.isAxiomActive() || !Configuration.rendering().showMarkerEntities) {
            return UserAction.ActionResult.NOT_HANDLED;
        }
        switch (userAction) {
            case UNDO: {
                if (activeEntity != null) {
                    Gizmo gizmo = gizmos.get(activeEntity.uuid());
                    if (gizmo != null && gizmo.isGrabbed()) {
                        return UserAction.ActionResult.USED_STOP;
                    }
                    if (undoStates.size() >= 2) {
                        class_243 current = undoStates.remove(undoStates.size() - 1);
                        redoStates.add(current);
                        class_243 head = undoStates.get(undoStates.size() - 1);
                        MarkerEntityManipulator.applyTeleport(activeEntity.uuid(), head);
                        teleportTicks = 10;
                    }
                    return UserAction.ActionResult.USED_STOP;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case REDO: {
                if (activeEntity != null) {
                    Gizmo gizmo = gizmos.get(activeEntity.uuid());
                    if (gizmo != null && gizmo.isGrabbed()) {
                        return UserAction.ActionResult.USED_STOP;
                    }
                    if (redoStates.size() >= 1) {
                        class_243 head = redoStates.remove(redoStates.size() - 1);
                        undoStates.add(head);
                        MarkerEntityManipulator.applyTeleport(activeEntity.uuid(), head);
                        teleportTicks = 10;
                    }
                    return UserAction.ActionResult.USED_STOP;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case SCROLL: {
                if (activeEntity != null) {
                    UserAction.ScrollAmount amount = (UserAction.ScrollAmount)object;
                    Gizmo gizmo = gizmos.get(activeEntity.uuid());
                    class_243 look = Tool.getLookDirection();
                    if (gizmo != null && look != null) {
                        long window = class_310.method_1551().method_22683().method_4490();
                        boolean isCtrlDown = class_310.field_1703 ? GLFW.glfwGetKey((long)window, (int)343) != 0 || GLFW.glfwGetKey((long)window, (int)347) != 0 : GLFW.glfwGetKey((long)window, (int)341) != 0 || GLFW.glfwGetKey((long)window, (int)345) != 0;
                        gizmo.handleScroll(amount.scrollX(), amount.scrollY(), isCtrlDown, look);
                        movementDirty = true;
                        String paddedPositionX = String.format("%.4f", gizmo.getTargetVec().field_1352);
                        String paddedPositionY = String.format("%.4f", gizmo.getTargetVec().field_1351);
                        String paddedPositionZ = String.format("%.4f", gizmo.getTargetVec().field_1350);
                        class_310.method_1551().field_1705.method_1758((class_2561)class_2561.method_43470((String)"Position: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(paddedPositionX + " ")).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)(paddedPositionY + " ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)paddedPositionZ).method_27692(class_124.field_1075)), false);
                    }
                    return UserAction.ActionResult.USED_STOP;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case LEFT_MOUSE: {
                if (Configuration.keybinds().swapLeftRightClickDisplayEntities) {
                    return MarkerEntityManipulator.handleRightClick();
                }
                return MarkerEntityManipulator.handleLeftClick();
            }
            case RIGHT_MOUSE: {
                if (Configuration.keybinds().swapLeftRightClickDisplayEntities) {
                    return MarkerEntityManipulator.handleLeftClick();
                }
                return MarkerEntityManipulator.handleRightClick();
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @NotNull
    private static UserAction.ActionResult handleRightClick() {
        if (hoveredGizmoPart) {
            Gizmo gizmo;
            if (activeEntity != null && (gizmo = gizmos.get(activeEntity.uuid())) != null && gizmo.isHovered()) {
                new AxiomServerboundMarkerNbtRequest(activeEntity.uuid()).send();
                return UserAction.ActionResult.USED_STOP;
            }
            if (class_310.method_1551().field_1719 == null) {
                return UserAction.ActionResult.NOT_HANDLED;
            }
            class_243 cameraPos = class_310.method_1551().field_1719.method_33571();
            for (Map.Entry<UUID, Gizmo> entry : gizmos.entrySet()) {
                boolean isActiveEntity;
                UUID uuid = entry.getKey();
                Gizmo gizmo2 = entry.getValue();
                class_243 before = gizmo2.getTargetVec();
                boolean bl = isActiveEntity = activeEntity != null && uuid.equals(activeEntity.uuid());
                if (!Configuration.capabilities().infiniteRangeMarkers && before.method_1025(cameraPos) > 576.0 && !isActiveEntity || !gizmo2.isHovered()) continue;
                if (activeEntity != null) {
                    Gizmo activeGizmo = gizmos.get(activeEntity.uuid());
                    if (activeGizmo != null) {
                        activeGizmo.enableAxes = false;
                        activeGizmo.moveToVec(activeEntity.position());
                    }
                    teleportTicks = 0;
                    activeEntity = null;
                    movementDirty = false;
                    undoStates.clear();
                    redoStates.clear();
                }
                gizmo2.enableAxes = true;
                activeEntity = markerDataMap.get(uuid);
                movementDirty = false;
                undoStates.clear();
                redoStates.clear();
                undoStates.add(activeEntity.position());
                new AxiomServerboundMarkerNbtRequest(activeEntity.uuid()).send();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        if (activeEntity != null) {
            class_239 hitResult = class_310.method_1551().field_1765;
            if (hitResult instanceof class_3965) {
                class_3965 blockHitResult = (class_3965)hitResult;
                if (hitResult.method_17783() == class_239.class_240.field_1332) {
                    class_2338 position = blockHitResult.method_17777().method_10093(blockHitResult.method_17780());
                    MarkerEntityManipulator.applyTeleport(activeEntity.uuid(), class_243.method_24953((class_2382)position));
                    teleportTicks = 10;
                }
            }
            return UserAction.ActionResult.USED_STOP;
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    public static void receivedNbtData(UUID uuid, class_2487 data) {
        if (activeEntity != null && activeEntity.uuid().equals(uuid)) {
            class_310.method_1551().method_1507((class_437)new EditMarkerScreen(uuid, data));
        }
    }

    @NotNull
    private static UserAction.ActionResult handleLeftClick() {
        boolean ret = false;
        if (activeEntity != null) {
            Gizmo gizmo = gizmos.get(activeEntity.uuid());
            if (gizmo != null) {
                if (gizmo.leftClick()) {
                    return UserAction.ActionResult.USED_STOP;
                }
                gizmo.enableAxes = false;
                gizmo.moveToVec(activeEntity.position());
                ret = true;
            }
            teleportTicks = 0;
            activeEntity = null;
            movementDirty = false;
            undoStates.clear();
            redoStates.clear();
        }
        if (class_310.method_1551().field_1719 == null) {
            return UserAction.ActionResult.NOT_HANDLED;
        }
        class_243 cameraPos = class_310.method_1551().field_1719.method_33571();
        for (Map.Entry<UUID, Gizmo> entry : gizmos.entrySet()) {
            boolean isActiveEntity;
            UUID uuid = entry.getKey();
            Gizmo gizmo = entry.getValue();
            class_243 before = gizmo.getTargetVec();
            boolean bl = isActiveEntity = activeEntity != null && uuid.equals(activeEntity.uuid());
            if (!Configuration.capabilities().infiniteRangeMarkers && before.method_1025(cameraPos) > 576.0 && !isActiveEntity || !gizmo.leftClick()) continue;
            activeEntity = markerDataMap.get(uuid);
            movementDirty = false;
            undoStates.clear();
            redoStates.clear();
            undoStates.add(activeEntity.position());
            return UserAction.ActionResult.USED_STOP;
        }
        if (ret) {
            return UserAction.ActionResult.USED_STOP;
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }
}

