/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.marker;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.class_156;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2491;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_5627;

public class MarkerSnbtPrinterTagVisitor
implements class_5627 {
    private static final Map<String, List<String>> KEY_ORDER = (Map)class_156.method_654((Object)Maps.newHashMap(), hashMap -> hashMap.put("{}", Lists.newArrayList((Object[])new String[]{"id", "name", "*", "min", "max"})));
    private static final Set<String> NO_INDENTATION = Sets.newHashSet((Object[])new String[]{"{}.min.[]", "{}.max.[]"});
    private static final Pattern SIMPLE_VALUE = Pattern.compile("[A-Za-z0-9._+-]+");
    private static final String NAME_VALUE_SEPARATOR = String.valueOf(':');
    private static final String ELEMENT_SEPARATOR = String.valueOf(',');
    private static final String LIST_OPEN = "[";
    private static final String LIST_CLOSE = "]";
    private static final String LIST_TYPE_SEPARATOR = ";";
    private static final String ELEMENT_SPACING = " ";
    private static final String STRUCT_OPEN = "{";
    private static final String STRUCT_CLOSE = "}";
    private static final String NEWLINE = "\n";
    private final String indentation;
    private final int depth;
    private final List<String> path;
    private String result = "";

    public MarkerSnbtPrinterTagVisitor() {
        this("    ", 0, Lists.newArrayList());
    }

    public MarkerSnbtPrinterTagVisitor(String string, int i, List<String> list) {
        this.indentation = string;
        this.depth = i;
        this.path = list;
    }

    public String visit(class_2520 tag) {
        tag.method_32289((class_5627)this);
        return this.result;
    }

    public void method_32302(class_2519 stringTag) {
        this.result = class_2519.method_10706((String)stringTag.method_10714());
    }

    public void method_32291(class_2481 byteTag) {
        this.result = byteTag.method_10702() + "b";
    }

    public void method_32301(class_2516 shortTag) {
        this.result = shortTag.method_10702() + "s";
    }

    public void method_32297(class_2497 intTag) {
        this.result = String.valueOf(intTag.method_10702());
    }

    public void method_32300(class_2503 longTag) {
        this.result = longTag.method_10702() + "L";
    }

    public void method_32295(class_2494 floatTag) {
        this.result = floatTag.method_10700() + "f";
    }

    public void method_32293(class_2489 doubleTag) {
        this.result = doubleTag.method_10697() + "d";
    }

    public void method_32290(class_2479 byteArrayTag) {
        StringBuilder stringBuilder = new StringBuilder(LIST_OPEN).append("B").append(LIST_TYPE_SEPARATOR);
        byte[] bs = byteArrayTag.method_10521();
        for (int i = 0; i < bs.length; ++i) {
            stringBuilder.append(ELEMENT_SPACING).append(bs[i]).append("B");
            if (i == bs.length - 1) continue;
            stringBuilder.append(ELEMENT_SEPARATOR);
        }
        stringBuilder.append(LIST_CLOSE);
        this.result = stringBuilder.toString();
    }

    public void method_32296(class_2495 intArrayTag) {
        StringBuilder stringBuilder = new StringBuilder(LIST_OPEN).append("I").append(LIST_TYPE_SEPARATOR);
        int[] is = intArrayTag.method_10588();
        for (int i = 0; i < is.length; ++i) {
            stringBuilder.append(ELEMENT_SPACING).append(is[i]);
            if (i == is.length - 1) continue;
            stringBuilder.append(ELEMENT_SEPARATOR);
        }
        stringBuilder.append(LIST_CLOSE);
        this.result = stringBuilder.toString();
    }

    public void method_32299(class_2501 longArrayTag) {
        String string = "L";
        StringBuilder stringBuilder = new StringBuilder(LIST_OPEN).append("L").append(LIST_TYPE_SEPARATOR);
        long[] ls = longArrayTag.method_10615();
        for (int i = 0; i < ls.length; ++i) {
            stringBuilder.append(ELEMENT_SPACING).append(ls[i]).append("L");
            if (i == ls.length - 1) continue;
            stringBuilder.append(ELEMENT_SEPARATOR);
        }
        stringBuilder.append(LIST_CLOSE);
        this.result = stringBuilder.toString();
    }

    public void method_32298(class_2499 listTag) {
        if (listTag.isEmpty()) {
            this.result = "[]";
        } else {
            String string;
            StringBuilder stringBuilder = new StringBuilder(LIST_OPEN);
            this.pushPath("[]");
            String string2 = string = NO_INDENTATION.contains(this.pathString()) ? "" : this.indentation;
            if (!string.isEmpty()) {
                stringBuilder.append(NEWLINE);
            }
            for (int i = 0; i < listTag.size(); ++i) {
                stringBuilder.append(Strings.repeat((String)string, (int)(this.depth + 1)));
                stringBuilder.append(new MarkerSnbtPrinterTagVisitor(string, this.depth + 1, this.path).visit(listTag.method_10534(i)));
                if (i == listTag.size() - 1) continue;
                stringBuilder.append(ELEMENT_SEPARATOR).append(string.isEmpty() ? ELEMENT_SPACING : NEWLINE);
            }
            if (!string.isEmpty()) {
                stringBuilder.append(NEWLINE).append(Strings.repeat((String)string, (int)this.depth));
            }
            stringBuilder.append(LIST_CLOSE);
            this.result = stringBuilder.toString();
            this.popPath();
        }
    }

    public void method_32292(class_2487 compoundTag) {
        if (compoundTag.method_33133()) {
            this.result = "{}";
        } else {
            String string;
            StringBuilder stringBuilder = new StringBuilder(STRUCT_OPEN);
            this.pushPath("{}");
            String string2 = string = NO_INDENTATION.contains(this.pathString()) ? "" : this.indentation;
            if (!string.isEmpty()) {
                stringBuilder.append(NEWLINE);
            }
            List<String> collection = this.getKeys(compoundTag);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string22 = (String)iterator.next();
                class_2520 tag = compoundTag.method_10580(string22);
                this.pushPath(string22);
                stringBuilder.append(Strings.repeat((String)string, (int)(this.depth + 1))).append(MarkerSnbtPrinterTagVisitor.handleEscapePretty(string22)).append(NAME_VALUE_SEPARATOR).append(ELEMENT_SPACING).append(new MarkerSnbtPrinterTagVisitor(string, this.depth + 1, this.path).visit(tag));
                this.popPath();
                if (!iterator.hasNext()) continue;
                stringBuilder.append(ELEMENT_SEPARATOR).append(string.isEmpty() ? ELEMENT_SPACING : NEWLINE);
            }
            if (!string.isEmpty()) {
                stringBuilder.append(NEWLINE).append(Strings.repeat((String)string, (int)this.depth));
            }
            stringBuilder.append(STRUCT_CLOSE);
            this.result = stringBuilder.toString();
            this.popPath();
        }
    }

    private void popPath() {
        this.path.remove(this.path.size() - 1);
    }

    private void pushPath(String string) {
        this.path.add(string);
    }

    protected List<String> getKeys(class_2487 compoundTag) {
        HashSet set = Sets.newHashSet((Iterable)compoundTag.method_10541());
        ArrayList list = Lists.newArrayList();
        List<String> keyOrder = KEY_ORDER.get(this.pathString());
        if (keyOrder != null) {
            int restIndex = 0;
            for (String string : keyOrder) {
                if (set.remove(string)) {
                    list.add(string);
                }
                if (!string.equals("*")) continue;
                restIndex = list.size();
            }
            if (!set.isEmpty()) {
                list.addAll(restIndex, set.stream().sorted().toList());
            }
        } else {
            list.addAll(set);
            Collections.sort(list);
        }
        return list;
    }

    public String pathString() {
        return String.join((CharSequence)".", this.path);
    }

    protected static String handleEscapePretty(String string) {
        return SIMPLE_VALUE.matcher(string).matches() ? string : class_2519.method_10706((String)string);
    }

    public void method_32294(class_2491 endTag) {
    }
}

