/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.mask;

import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.noise.SimplexNoise;
import com.moulberry.axiom.noise.VoronoiEdgesNoise;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LoadState;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.compiler.LuaC;
import org.luaj.vm2.lib.Bit32Lib;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TableLib;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.jse.JseBaseLib;
import org.luaj.vm2.lib.jse.JseMathLib;
import org.luaj.vm2.lib.jse.JseStringLib;

public class LuaHelper {
    private static final LuaValue LUA_X = LuaValue.valueOf("x");
    private static final LuaValue LUA_Y = LuaValue.valueOf("y");
    private static final LuaValue LUA_Z = LuaValue.valueOf("z");
    private static LuaTable luaTableBlock = null;

    public static Globals createSandboxed() {
        Globals globals = new Globals();
        globals.load(new JseBaseLib());
        globals.load(new Bit32Lib());
        globals.load(new TableLib());
        globals.load(new JseStringLib());
        globals.load(new JseMathLib());
        globals.set("dofile", LuaValue.NIL);
        globals.set("loadfile", LuaValue.NIL);
        globals.set("collectgarbage", LuaValue.NIL);
        LuaString.s_metatable = new ReadOnlyLuaTable(LuaString.s_metatable);
        LoadState.install(globals);
        LuaC.install(globals);
        return globals;
    }

    public static void initialize(Globals globals, final MaskContext maskContext, int x, int y, int z) {
        globals.set(LUA_X, (LuaValue)LuaValue.valueOf(x));
        globals.set(LUA_Y, (LuaValue)LuaValue.valueOf(y));
        globals.set(LUA_Z, (LuaValue)LuaValue.valueOf(z));
        globals.set("getBlock", (LuaValue)new ThreeArgFunction(){

            @Override
            public LuaValue call(LuaValue x, LuaValue y, LuaValue z) {
                class_2680 blockState = maskContext.getBlockStateAt(x.toint(), y.toint(), z.toint());
                int id = class_7923.field_41175.method_10206((Object)blockState.method_26204());
                return LuaValue.valueOf(id);
            }
        });
        globals.set("isSolid", (LuaValue)new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue arg) {
                int id = arg.toint();
                Optional holderOpt = class_7923.field_41175.method_40265(id);
                if (!holderOpt.isPresent()) {
                    return LuaValue.NIL;
                }
                class_6880.class_6883 holder = (class_6880.class_6883)holderOpt.get();
                return LuaValue.valueOf(((class_2248)holder.comp_349()).method_9564().method_51366());
            }
        });
        final int randomSeed = ThreadLocalRandom.current().nextInt();
        globals.set("getSimplexNoise", (LuaValue)new VarArgFunction(){

            @Override
            public Varargs onInvoke(Varargs args) {
                LuaValue seedArg = args.arg(4);
                double x = args.arg(1).todouble();
                double y = args.arg(2).todouble();
                double z = args.arg(3).todouble();
                if (!seedArg.isnil()) {
                    return LuaValue.valueOf(SimplexNoise.evaluateStatic(x, y, z, seedArg.toint()));
                }
                return LuaValue.valueOf(SimplexNoise.evaluateStatic(x, y, z, randomSeed));
            }
        });
        globals.set("getVoronoiEdgeNoise", (LuaValue)new VarArgFunction(){

            @Override
            public Varargs onInvoke(Varargs args) {
                LuaValue seedArg = args.arg(4);
                double x = args.arg(1).todouble();
                double y = args.arg(2).todouble();
                double z = args.arg(3).todouble();
                if (!seedArg.isnil()) {
                    return LuaValue.valueOf(VoronoiEdgesNoise.evaluateStatic(x, y, z, seedArg.toint(), 1.0f));
                }
                return LuaValue.valueOf(VoronoiEdgesNoise.evaluateStatic(x, y, z, randomSeed, 1.0f));
            }
        });
        globals.set("getHighestBlockYAt", (LuaValue)new TwoArgFunction(){

            @Override
            public LuaValue call(LuaValue x, LuaValue z) {
                return LuaValue.valueOf(maskContext.getHighestBlock(x.toint(), z.toint()));
            }
        });
        globals.set("blocks", (LuaValue)LuaHelper.getBlockTable());
    }

    public static void setPosition(Globals globals, int x, int y, int z) {
        globals.set(LUA_X, (LuaValue)LuaValue.valueOf(x));
        globals.set(LUA_Y, (LuaValue)LuaValue.valueOf(y));
        globals.set(LUA_Z, (LuaValue)LuaValue.valueOf(z));
    }

    private static LuaTable getBlockTable() {
        if (luaTableBlock != null) {
            return luaTableBlock;
        }
        luaTableBlock = new LuaTable();
        HashMap<String, LuaTable> subTables = new HashMap<String, LuaTable>();
        for (class_2248 block : class_7923.field_41175) {
            class_2960 key = class_7923.field_41175.method_10221((Object)block);
            int value = class_7923.field_41175.method_10206((Object)block);
            String namespace = key.method_12836();
            if (namespace.equals("minecraft")) {
                luaTableBlock.set(key.method_12832(), value);
                continue;
            }
            if (!subTables.containsKey(namespace)) {
                LuaTable subTable = new LuaTable();
                luaTableBlock.set(namespace, (LuaValue)subTable);
                subTables.put(namespace, subTable);
            }
            ((LuaTable)subTables.get(namespace)).set(key.method_12832(), value);
        }
        return luaTableBlock;
    }

    static class ReadOnlyLuaTable
    extends LuaTable {
        public ReadOnlyLuaTable(LuaValue table) {
            this.presize(table.length(), 0);
            Varargs n = table.next(LuaValue.NIL);
            while (!n.arg1().isnil()) {
                LuaValue key = n.arg1();
                LuaValue value = n.arg(2);
                super.rawset(key, value.istable() ? new ReadOnlyLuaTable(value) : value);
                n = table.next(n.arg1());
            }
        }

        @Override
        public LuaValue setmetatable(LuaValue metatable) {
            return ReadOnlyLuaTable.error("table is read-only");
        }

        @Override
        public void set(int key, LuaValue value) {
            ReadOnlyLuaTable.error("table is read-only");
        }

        @Override
        public void rawset(int key, LuaValue value) {
            ReadOnlyLuaTable.error("table is read-only");
        }

        @Override
        public void rawset(LuaValue key, LuaValue value) {
            ReadOnlyLuaTable.error("table is read-only");
        }

        @Override
        public LuaValue remove(int pos) {
            return ReadOnlyLuaTable.error("table is read-only");
        }
    }
}

