/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.mask;

import com.moulberry.axiom.editor.widgets.BlockConditionWidget;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.elements.AllMaskElement;
import com.moulberry.axiom.mask.elements.AngleMaskElement;
import com.moulberry.axiom.mask.elements.AnyMaskElement;
import com.moulberry.axiom.mask.elements.BlockAboveConditionMaskElement;
import com.moulberry.axiom.mask.elements.BlockAdjacentConditionMaskElement;
import com.moulberry.axiom.mask.elements.BlockBelowConditionMaskElement;
import com.moulberry.axiom.mask.elements.BlockConditionMaskElement;
import com.moulberry.axiom.mask.elements.BlockNearConditionMaskElement;
import com.moulberry.axiom.mask.elements.BlockNeighborConditionMaskElement;
import com.moulberry.axiom.mask.elements.BothMaskElement;
import com.moulberry.axiom.mask.elements.ConstantMaskElement;
import com.moulberry.axiom.mask.elements.CoordMaskElement;
import com.moulberry.axiom.mask.elements.EitherMaskElement;
import com.moulberry.axiom.mask.elements.GenericBlockConditionMaskElement;
import com.moulberry.axiom.mask.elements.NotMaskElement;
import com.moulberry.axiom.mask.elements.OffsetMaskElement;
import com.moulberry.axiom.utils.BlockCondition;
import java.util.ArrayList;
import java.util.Arrays;

public class MaskElementOptimizer {
    public static MaskElement optimizeStatic(MaskElement maskElement) {
        MaskElement optimized;
        while ((optimized = MaskElementOptimizer.optimizeStaticInner(maskElement)) != null) {
            maskElement = optimized;
        }
        return maskElement;
    }

    private static MaskElement optimizeStaticInner(MaskElement maskElement) {
        if (maskElement instanceof BothMaskElement || maskElement instanceof AllMaskElement) {
            ArrayList<MaskElement> children = new ArrayList<MaskElement>();
            if (maskElement instanceof BothMaskElement) {
                BothMaskElement bothMaskElement = (BothMaskElement)maskElement;
                children.add(bothMaskElement.getChild1());
                children.add(bothMaskElement.getChild2());
            } else {
                MaskElement[] childArray = ((AllMaskElement)maskElement).getChildren();
                children.addAll(Arrays.asList(childArray));
            }
            boolean changed = false;
            int i = 0;
            while (i < children.size()) {
                MaskElement child = (MaskElement)children.remove(i);
                if (child instanceof BothMaskElement) {
                    BothMaskElement bothMaskElementChild = (BothMaskElement)child;
                    changed = true;
                    children.add(i, bothMaskElementChild.getChild1());
                    children.add(i + 1, bothMaskElementChild.getChild2());
                    continue;
                }
                if (child instanceof AllMaskElement) {
                    AllMaskElement allMaskElementChild = (AllMaskElement)child;
                    changed = true;
                    MaskElement[] childChildren = allMaskElementChild.getChildren();
                    for (int j = 0; j < childChildren.length; ++j) {
                        children.add(i + j, childChildren[j]);
                    }
                    continue;
                }
                if (child instanceof ConstantMaskElement) {
                    ConstantMaskElement constantMaskElement = (ConstantMaskElement)child;
                    if (constantMaskElement.getConstant()) continue;
                    return constantMaskElement;
                }
                MaskElement optimized = MaskElementOptimizer.optimizeStaticInner(child);
                if (optimized != null) {
                    changed = true;
                    children.add(i, optimized);
                    continue;
                }
                children.add(i, child);
                ++i;
            }
            if (children.size() == 0) {
                return new ConstantMaskElement(false);
            }
            if (children.size() == 1) {
                return (MaskElement)children.get(0);
            }
            if (children.size() == 2 && (changed || !(maskElement instanceof BothMaskElement))) {
                return new BothMaskElement((MaskElement)children.get(0), (MaskElement)children.get(1));
            }
            if (!changed) {
                return null;
            }
            MaskElement[] childArray = children.toArray(new MaskElement[0]);
            return new AllMaskElement(childArray);
        }
        if (maskElement instanceof EitherMaskElement || maskElement instanceof AnyMaskElement) {
            MaskElement child;
            ArrayList<MaskElement> children = new ArrayList<MaskElement>();
            if (maskElement instanceof EitherMaskElement) {
                EitherMaskElement eitherMaskElement = (EitherMaskElement)maskElement;
                children.add(eitherMaskElement.getChild1());
                children.add(eitherMaskElement.getChild2());
            } else {
                MaskElement[] childArray = ((AnyMaskElement)maskElement).getChildren();
                children.addAll(Arrays.asList(childArray));
            }
            boolean changed = false;
            int i = 0;
            while (i < children.size()) {
                child = (MaskElement)children.remove(i);
                if (child instanceof EitherMaskElement) {
                    EitherMaskElement eitherMaskElementChild = (EitherMaskElement)child;
                    changed = true;
                    children.add(i, eitherMaskElementChild.getChild1());
                    children.add(i + 1, eitherMaskElementChild.getChild2());
                    continue;
                }
                if (child instanceof AnyMaskElement) {
                    AnyMaskElement anyMaskElementChild = (AnyMaskElement)child;
                    changed = true;
                    MaskElement[] childChildren = anyMaskElementChild.getChildren();
                    for (int j = 0; j < childChildren.length; ++j) {
                        children.add(i + j, childChildren[j]);
                    }
                    continue;
                }
                if (child instanceof ConstantMaskElement) {
                    ConstantMaskElement constantMaskElement = (ConstantMaskElement)child;
                    if (!constantMaskElement.getConstant()) continue;
                    return constantMaskElement;
                }
                MaskElement optimized = MaskElementOptimizer.optimizeStaticInner(child);
                if (optimized != null) {
                    changed = true;
                    children.add(i, optimized);
                    continue;
                }
                children.add(i, child);
                ++i;
            }
            for (i = 0; i < children.size(); ++i) {
                Object otherBlockConditionMaskElement;
                child = (MaskElement)children.get(i);
                if (!(child instanceof GenericBlockConditionMaskElement)) continue;
                GenericBlockConditionMaskElement blockConditionMaskElement = (GenericBlockConditionMaskElement)((Object)child);
                ArrayList<Object> combineAll = new ArrayList<Object>();
                combineAll.add(blockConditionMaskElement);
                for (int j = i + 1; j < children.size(); ++j) {
                    MaskElement other = (MaskElement)children.get(j);
                    if (!(other instanceof GenericBlockConditionMaskElement) || !blockConditionMaskElement.canCombine((GenericBlockConditionMaskElement)(otherBlockConditionMaskElement = (GenericBlockConditionMaskElement)((Object)other)))) continue;
                    combineAll.add(otherBlockConditionMaskElement);
                    children.remove(j);
                    --j;
                }
                if (combineAll.size() < 2) continue;
                ArrayList<BlockCondition> blockConditions = new ArrayList<BlockCondition>();
                ArrayList<BlockConditionWidget.BlockConditionState> blockConditionStates = new ArrayList<BlockConditionWidget.BlockConditionState>();
                otherBlockConditionMaskElement = combineAll.iterator();
                while (otherBlockConditionMaskElement.hasNext()) {
                    GenericBlockConditionMaskElement combine = (GenericBlockConditionMaskElement)otherBlockConditionMaskElement.next();
                    BlockCondition blockCondition = combine.getBlockCondition();
                    if (blockCondition instanceof BlockCondition.AnyCondition) {
                        BlockCondition.AnyCondition anyCondition = (BlockCondition.AnyCondition)blockCondition;
                        blockConditions.addAll(anyCondition.conditions());
                    } else {
                        blockConditions.add(combine.getBlockCondition());
                    }
                    blockConditionStates.addAll(combine.getConditionStates());
                }
                BlockCondition.AnyCondition any = new BlockCondition.AnyCondition(blockConditions);
                if (child instanceof BlockConditionMaskElement) {
                    children.set(i, new BlockConditionMaskElement(any, blockConditionStates));
                    continue;
                }
                if (child instanceof BlockAboveConditionMaskElement) {
                    children.set(i, new BlockAboveConditionMaskElement(any, blockConditionStates));
                    continue;
                }
                if (child instanceof BlockBelowConditionMaskElement) {
                    children.set(i, new BlockBelowConditionMaskElement(any, blockConditionStates));
                    continue;
                }
                if (child instanceof BlockNearConditionMaskElement) {
                    BlockNearConditionMaskElement near = (BlockNearConditionMaskElement)child;
                    children.set(i, new BlockNearConditionMaskElement(any, blockConditionStates, near.radius));
                    continue;
                }
                if (child instanceof BlockNeighborConditionMaskElement) {
                    children.set(i, new BlockNeighborConditionMaskElement(any, blockConditionStates));
                    continue;
                }
                if (child instanceof BlockAdjacentConditionMaskElement) {
                    children.set(i, new BlockAdjacentConditionMaskElement(any, blockConditionStates));
                    continue;
                }
                throw new FaultyImplementationError("Unknown block condition: " + child.getClass());
            }
            if (children.size() == 0) {
                return new ConstantMaskElement(false);
            }
            if (children.size() == 1) {
                return (MaskElement)children.get(0);
            }
            if (children.size() == 2 && (changed || !(maskElement instanceof EitherMaskElement))) {
                return new EitherMaskElement((MaskElement)children.get(0), (MaskElement)children.get(1));
            }
            if (!changed) {
                return null;
            }
            MaskElement[] childArray = children.toArray(new MaskElement[0]);
            return new AnyMaskElement(childArray);
        }
        if (maskElement instanceof NotMaskElement) {
            NotMaskElement notMaskElement = (NotMaskElement)maskElement;
            MaskElement child = notMaskElement.getChild();
            if (child instanceof NotMaskElement) {
                NotMaskElement childNot = (NotMaskElement)child;
                return childNot.getChild();
            }
            if (child instanceof AngleMaskElement) {
                AngleMaskElement angleMaskElement = (AngleMaskElement)child;
                return new AngleMaskElement(angleMaskElement.getAngle(), MaskElement.invertComparison(angleMaskElement.getComparison()));
            }
            if (child instanceof CoordMaskElement) {
                CoordMaskElement coordMaskElement = (CoordMaskElement)child;
                return new CoordMaskElement(coordMaskElement.getAxis(), coordMaskElement.getValue(), MaskElement.invertComparison(coordMaskElement.getComparison()));
            }
            MaskElement optimized = MaskElementOptimizer.optimizeStaticInner(child);
            if (optimized != null) {
                return new NotMaskElement(optimized);
            }
            return null;
        }
        if (maskElement instanceof OffsetMaskElement) {
            OffsetMaskElement offsetMaskElement = (OffsetMaskElement)maskElement;
            MaskElement child = offsetMaskElement.getChild();
            MaskElement optimized = MaskElementOptimizer.optimizeStaticInner(child);
            if (optimized != null) {
                return new OffsetMaskElement(optimized, offsetMaskElement.getOffsetX(), offsetMaskElement.getOffsetY(), offsetMaskElement.getOffsetZ());
            }
            return null;
        }
        return null;
    }
}

