/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.mask;

import com.moulberry.axiom.editor.widgets.BlockConditionWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.AndMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.AngleMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.BiomeMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.BlockAboveMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.BlockAdjacentMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.BlockBelowMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.BlockMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.BlockNearMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.BlockNeighborMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.CanSeeSkyMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.CoordMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.InSelectionMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.MaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.NotMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.OffsetMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.OrMaskWidget;
import com.moulberry.axiom.editor.windows.global_mask.visualcode.SurfaceMaskWidget;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.elements.AllMaskElement;
import com.moulberry.axiom.mask.elements.AngleMaskElement;
import com.moulberry.axiom.mask.elements.AnyMaskElement;
import com.moulberry.axiom.mask.elements.BiomeConditionMaskElement;
import com.moulberry.axiom.mask.elements.BlockAboveConditionMaskElement;
import com.moulberry.axiom.mask.elements.BlockAdjacentConditionMaskElement;
import com.moulberry.axiom.mask.elements.BlockBelowConditionMaskElement;
import com.moulberry.axiom.mask.elements.BlockConditionMaskElement;
import com.moulberry.axiom.mask.elements.BlockNearConditionMaskElement;
import com.moulberry.axiom.mask.elements.BlockNeighborConditionMaskElement;
import com.moulberry.axiom.mask.elements.BothMaskElement;
import com.moulberry.axiom.mask.elements.CanSeeSkyMaskElement;
import com.moulberry.axiom.mask.elements.ConstantMaskElement;
import com.moulberry.axiom.mask.elements.CoordMaskElement;
import com.moulberry.axiom.mask.elements.EitherMaskElement;
import com.moulberry.axiom.mask.elements.NotMaskElement;
import com.moulberry.axiom.mask.elements.OffsetMaskElement;
import com.moulberry.axiom.mask.elements.SelectedMaskElement;
import com.moulberry.axiom.mask.elements.SurfaceMaskElement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class VisualCodeConverter {
    public static MaskElement fromVisualCode(MaskWidget maskWidget) {
        if (maskWidget instanceof AndMaskWidget) {
            AndMaskWidget andMaskWidget = (AndMaskWidget)maskWidget;
            List<MaskWidget> children = andMaskWidget.getChildren();
            ArrayList<MaskElement> maskElements = new ArrayList<MaskElement>();
            for (MaskWidget child : children) {
                MaskElement childElement = VisualCodeConverter.fromVisualCode(child);
                if (childElement == null) continue;
                maskElements.add(childElement);
            }
            if (maskElements.size() == 0) {
                return null;
            }
            return new AllMaskElement(maskElements.toArray(new MaskElement[0]));
        }
        if (maskWidget instanceof OrMaskWidget) {
            OrMaskWidget orMaskWidget = (OrMaskWidget)maskWidget;
            List<MaskWidget> children = orMaskWidget.getChildren();
            ArrayList<MaskElement> maskElements = new ArrayList<MaskElement>();
            for (MaskWidget child : children) {
                MaskElement childElement = VisualCodeConverter.fromVisualCode(child);
                if (childElement == null) continue;
                maskElements.add(childElement);
            }
            if (maskElements.size() == 0) {
                return null;
            }
            return new AnyMaskElement(maskElements.toArray(new MaskElement[0]));
        }
        if (maskWidget instanceof NotMaskWidget) {
            NotMaskWidget notMaskWidget = (NotMaskWidget)maskWidget;
            if (notMaskWidget.getChildren().size() != 1) {
                return null;
            }
            MaskElement childElement = VisualCodeConverter.fromVisualCode(notMaskWidget.getChildren().get(0));
            if (childElement == null) {
                return null;
            }
            return new NotMaskElement(childElement);
        }
        if (maskWidget instanceof OffsetMaskWidget) {
            OffsetMaskWidget offsetMaskWidget = (OffsetMaskWidget)maskWidget;
            if (offsetMaskWidget.getChildren().size() != 1) {
                return null;
            }
            MaskElement childElement = VisualCodeConverter.fromVisualCode(offsetMaskWidget.getChildren().get(0));
            if (childElement == null) {
                return null;
            }
            return new OffsetMaskElement(childElement, offsetMaskWidget.getOffsetX(), offsetMaskWidget.getOffsetY(), offsetMaskWidget.getOffsetZ());
        }
        if (maskWidget instanceof BiomeMaskWidget) {
            BiomeMaskWidget biomeMaskWidget = (BiomeMaskWidget)maskWidget;
            return new BiomeConditionMaskElement(biomeMaskWidget.getBiome());
        }
        if (maskWidget instanceof BlockMaskWidget) {
            BlockMaskWidget blockMaskWidget = (BlockMaskWidget)maskWidget;
            return new BlockConditionMaskElement(blockMaskWidget.createCondition(), List.of(blockMaskWidget.createState()));
        }
        if (maskWidget instanceof BlockAboveMaskWidget) {
            BlockAboveMaskWidget blockAboveMaskWidget = (BlockAboveMaskWidget)maskWidget;
            return new BlockAboveConditionMaskElement(blockAboveMaskWidget.createCondition(), List.of(blockAboveMaskWidget.createState()));
        }
        if (maskWidget instanceof BlockBelowMaskWidget) {
            BlockBelowMaskWidget blockBelowMaskWidget = (BlockBelowMaskWidget)maskWidget;
            return new BlockBelowConditionMaskElement(blockBelowMaskWidget.createCondition(), List.of(blockBelowMaskWidget.createState()));
        }
        if (maskWidget instanceof BlockNearMaskWidget) {
            BlockNearMaskWidget blockNearMaskWidget = (BlockNearMaskWidget)maskWidget;
            return new BlockNearConditionMaskElement(blockNearMaskWidget.createCondition(), List.of(blockNearMaskWidget.createState()), blockNearMaskWidget.getRadius());
        }
        if (maskWidget instanceof BlockNeighborMaskWidget) {
            BlockNeighborMaskWidget blockNeighborMaskWidget = (BlockNeighborMaskWidget)maskWidget;
            return new BlockNeighborConditionMaskElement(blockNeighborMaskWidget.createCondition(), List.of(blockNeighborMaskWidget.createState()));
        }
        if (maskWidget instanceof BlockAdjacentMaskWidget) {
            BlockAdjacentMaskWidget blockAdjacentMaskWidget = (BlockAdjacentMaskWidget)maskWidget;
            return new BlockAdjacentConditionMaskElement(blockAdjacentMaskWidget.createCondition(), List.of(blockAdjacentMaskWidget.createState()));
        }
        if (maskWidget instanceof CoordMaskWidget) {
            CoordMaskWidget coordMaskWidget = (CoordMaskWidget)maskWidget;
            return new CoordMaskElement(coordMaskWidget.getAxis(), coordMaskWidget.getYValue(), coordMaskWidget.getComparisonType());
        }
        if (maskWidget instanceof AngleMaskWidget) {
            AngleMaskWidget angleMaskWidget = (AngleMaskWidget)maskWidget;
            int angle = angleMaskWidget.getAngle();
            int range = angleMaskWidget.getRange();
            if (range == 0) {
                return new AngleMaskElement(angle, 0);
            }
            int minAngle = angle - range;
            int maxAngle = angle + range;
            if (minAngle < -90) {
                minAngle = -90;
            }
            if (maxAngle > 90) {
                maxAngle = 90;
            }
            if (minAngle > maxAngle) {
                return null;
            }
            if (minAngle == -90) {
                if (maxAngle == 90) {
                    return null;
                }
                return new AngleMaskElement(maxAngle, 4);
            }
            if (maxAngle == 90) {
                return new AngleMaskElement(minAngle, 5);
            }
            return new BothMaskElement(new AngleMaskElement(minAngle, 5), new AngleMaskElement(maxAngle, 4));
        }
        if (maskWidget instanceof InSelectionMaskWidget) {
            return new SelectedMaskElement();
        }
        if (maskWidget instanceof CanSeeSkyMaskWidget) {
            return new CanSeeSkyMaskElement();
        }
        if (maskWidget instanceof SurfaceMaskWidget) {
            return new SurfaceMaskElement();
        }
        throw new UnsupportedOperationException("Don't know how to convert " + maskWidget.getClass());
    }

    public static MaskWidget toVisualCode(MaskElement maskElement) {
        if (maskElement instanceof BothMaskElement) {
            BothMaskElement bothMaskElement = (BothMaskElement)maskElement;
            MaskElement maskElement2 = bothMaskElement.getChild1();
            if (maskElement2 instanceof AngleMaskElement) {
                AngleMaskElement angle1 = (AngleMaskElement)maskElement2;
                maskElement2 = bothMaskElement.getChild2();
                if (maskElement2 instanceof AngleMaskElement) {
                    AngleMaskElement angle2 = (AngleMaskElement)maskElement2;
                    if (angle1.getComparison() != 1 && angle2.getComparison() != 1) {
                        return VisualCodeConverter.combineAngles(List.of(angle1, angle2));
                    }
                }
            }
            MaskWidget left = VisualCodeConverter.toVisualCode(bothMaskElement.getChild1());
            MaskWidget right = VisualCodeConverter.toVisualCode(bothMaskElement.getChild2());
            if (left == null) {
                return right;
            }
            if (right == null) {
                return left;
            }
            AndMaskWidget maskWidget = new AndMaskWidget();
            maskWidget.addChild(-1, left);
            maskWidget.addChild(-1, right);
            return maskWidget;
        }
        if (maskElement instanceof AllMaskElement) {
            MaskWidget combinedAngleMask;
            AllMaskElement allMaskElement = (AllMaskElement)maskElement;
            ArrayList<AngleMaskElement> angleMaskElements = new ArrayList<AngleMaskElement>();
            AndMaskWidget maskWidget = new AndMaskWidget();
            for (MaskElement child : allMaskElement.getChildren()) {
                AngleMaskElement angle;
                if (child instanceof AngleMaskElement && (angle = (AngleMaskElement)child).getComparison() != 1) {
                    angleMaskElements.add(angle);
                    continue;
                }
                MaskWidget childWidget = VisualCodeConverter.toVisualCode(child);
                if (childWidget == null) continue;
                maskWidget.addChild(-1, childWidget);
            }
            if (!angleMaskElements.isEmpty() && (combinedAngleMask = VisualCodeConverter.combineAngles(angleMaskElements)) != null) {
                maskWidget.addChild(-1, combinedAngleMask);
            }
            return maskWidget;
        }
        if (maskElement instanceof EitherMaskElement) {
            EitherMaskElement eitherMaskElement = (EitherMaskElement)maskElement;
            MaskWidget left = VisualCodeConverter.toVisualCode(eitherMaskElement.getChild1());
            MaskWidget right = VisualCodeConverter.toVisualCode(eitherMaskElement.getChild2());
            if (left == null) {
                return right;
            }
            if (right == null) {
                return left;
            }
            OrMaskWidget maskWidget = new OrMaskWidget();
            maskWidget.addChild(-1, left);
            maskWidget.addChild(-1, right);
            return maskWidget;
        }
        if (maskElement instanceof AnyMaskElement) {
            AnyMaskElement anyMaskElement = (AnyMaskElement)maskElement;
            OrMaskWidget maskWidget = new OrMaskWidget();
            for (MaskElement child : anyMaskElement.getChildren()) {
                MaskWidget childWidget = VisualCodeConverter.toVisualCode(child);
                if (childWidget == null) continue;
                maskWidget.addChild(-1, VisualCodeConverter.toVisualCode(child));
            }
            return maskWidget;
        }
        if (maskElement instanceof NotMaskElement) {
            NotMaskElement notMaskElement = (NotMaskElement)maskElement;
            MaskWidget child = VisualCodeConverter.toVisualCode(notMaskElement.getChild());
            if (child == null) {
                return null;
            }
            NotMaskWidget maskWidget = new NotMaskWidget();
            maskWidget.addChild(0, child);
            return maskWidget;
        }
        if (maskElement instanceof OffsetMaskElement) {
            OffsetMaskElement offsetMaskElement = (OffsetMaskElement)maskElement;
            MaskWidget child = VisualCodeConverter.toVisualCode(offsetMaskElement.getChild());
            if (child == null) {
                return null;
            }
            OffsetMaskWidget maskWidget = new OffsetMaskWidget(offsetMaskElement.getOffsetX(), offsetMaskElement.getOffsetY(), offsetMaskElement.getOffsetZ());
            maskWidget.addChild(0, child);
            return maskWidget;
        }
        if (maskElement instanceof BiomeConditionMaskElement) {
            BiomeConditionMaskElement biomeConditionMaskElement = (BiomeConditionMaskElement)maskElement;
            return new BiomeMaskWidget(biomeConditionMaskElement.getMatchBiome());
        }
        if (maskElement instanceof BlockConditionMaskElement) {
            BlockConditionMaskElement blockConditionMaskElement = (BlockConditionMaskElement)maskElement;
            return VisualCodeConverter.toVisualCodeBlockCondition(blockConditionMaskElement.getConditionStates(), BlockMaskWidget::new);
        }
        if (maskElement instanceof BlockAboveConditionMaskElement) {
            BlockAboveConditionMaskElement blockAboveConditionMaskElement = (BlockAboveConditionMaskElement)maskElement;
            return VisualCodeConverter.toVisualCodeBlockCondition(blockAboveConditionMaskElement.getConditionStates(), BlockAboveMaskWidget::new);
        }
        if (maskElement instanceof BlockBelowConditionMaskElement) {
            BlockBelowConditionMaskElement blockBelowConditionMaskElement = (BlockBelowConditionMaskElement)maskElement;
            return VisualCodeConverter.toVisualCodeBlockCondition(blockBelowConditionMaskElement.getConditionStates(), BlockBelowMaskWidget::new);
        }
        if (maskElement instanceof BlockNearConditionMaskElement) {
            BlockNearConditionMaskElement blockNearConditionMaskElement = (BlockNearConditionMaskElement)maskElement;
            return VisualCodeConverter.toVisualCodeBlockCondition(blockNearConditionMaskElement.getConditionStates(), condition -> new BlockNearMaskWidget((BlockConditionWidget.BlockConditionState)condition, blockNearConditionMaskElement.radius));
        }
        if (maskElement instanceof BlockNeighborConditionMaskElement) {
            BlockNeighborConditionMaskElement blockNeighborConditionMaskElement = (BlockNeighborConditionMaskElement)maskElement;
            return VisualCodeConverter.toVisualCodeBlockCondition(blockNeighborConditionMaskElement.getConditionStates(), BlockNeighborMaskWidget::new);
        }
        if (maskElement instanceof BlockAdjacentConditionMaskElement) {
            BlockAdjacentConditionMaskElement blockAdjacentConditionMaskElement = (BlockAdjacentConditionMaskElement)maskElement;
            return VisualCodeConverter.toVisualCodeBlockCondition(blockAdjacentConditionMaskElement.getConditionStates(), BlockAdjacentMaskWidget::new);
        }
        if (maskElement instanceof CoordMaskElement) {
            CoordMaskElement coordMaskElement = (CoordMaskElement)maskElement;
            return new CoordMaskWidget(coordMaskElement.getAxis(), coordMaskElement.getValue(), coordMaskElement.getComparison());
        }
        if (maskElement instanceof AngleMaskElement) {
            AngleMaskElement angleMaskElement = (AngleMaskElement)maskElement;
            int angle = angleMaskElement.getAngle();
            switch (angleMaskElement.getComparison()) {
                case 0: {
                    return new AngleMaskWidget(angle, 0);
                }
                case 1: {
                    NotMaskWidget not = new NotMaskWidget();
                    not.addChild(-1, new AngleMaskWidget(angle, 0));
                    return not;
                }
                case 2: 
                case 4: {
                    if (angle < -90) {
                        return null;
                    }
                    int diff = angle + 90;
                    return new AngleMaskWidget(angle - diff / 2, diff / 2);
                }
                case 3: 
                case 5: {
                    if (angle > 90) {
                        return null;
                    }
                    int diff = 90 - angle;
                    return new AngleMaskWidget(angle + diff / 2, diff / 2);
                }
            }
            throw new FaultyImplementationError();
        }
        if (maskElement instanceof SelectedMaskElement) {
            return new InSelectionMaskWidget();
        }
        if (maskElement instanceof CanSeeSkyMaskElement) {
            return new CanSeeSkyMaskWidget();
        }
        if (maskElement instanceof SurfaceMaskElement) {
            return new SurfaceMaskWidget();
        }
        if (maskElement instanceof ConstantMaskElement) {
            return null;
        }
        throw new UnsupportedOperationException("Don't know how to convert " + maskElement.getClass());
    }

    private static MaskWidget toVisualCodeBlockCondition(List<BlockConditionWidget.BlockConditionState> conditions, Function<BlockConditionWidget.BlockConditionState, MaskWidget> provider) {
        if (conditions.size() == 1) {
            return provider.apply(conditions.get(0));
        }
        OrMaskWidget maskWidget = new OrMaskWidget();
        for (BlockConditionWidget.BlockConditionState condition : conditions) {
            maskWidget.addChild(-1, provider.apply(condition));
        }
        return maskWidget;
    }

    private static MaskWidget combineAngles(List<AngleMaskElement> elements) {
        int minAngle = -90;
        int maxAngle = 90;
        block5: for (AngleMaskElement element : elements) {
            int angle = element.getAngle();
            switch (element.getComparison()) {
                case 0: {
                    if (angle < minAngle || angle > maxAngle) {
                        return null;
                    }
                    minAngle = angle;
                    maxAngle = angle;
                    continue block5;
                }
                case 2: 
                case 4: {
                    if (minAngle > angle) {
                        return null;
                    }
                    maxAngle = angle;
                    continue block5;
                }
                case 3: 
                case 5: {
                    if (maxAngle < angle) {
                        return null;
                    }
                    minAngle = angle;
                    continue block5;
                }
            }
            throw new FaultyImplementationError();
        }
        int range = maxAngle - minAngle;
        if (range < 0) {
            return null;
        }
        return new AngleMaskWidget(minAngle + range / 2, range / 2);
    }
}

