/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.mixin;

import com.mojang.authlib.GameProfile;
import com.moulberry.axiom.editor.views.View;
import com.moulberry.axiom.hooks.ServerPlayerExt;
import com.moulberry.axiom.packets.AxiomClientboundEnable;
import com.moulberry.axiom.packets.AxiomClientboundInitializeHotbars;
import com.moulberry.axiom.packets.AxiomClientboundSetEditorViews;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class MixinServerPlayer
extends class_1657
implements ServerPlayerExt {
    @Shadow
    @Final
    public class_3225 field_13974;
    @Shadow
    @Final
    public MinecraftServer field_13995;
    @Unique
    private int activeHotbarIndex = 0;
    @Unique
    private class_1799[] allHotbarItems = new class_1799[81];
    @Unique
    private UUID activeView;
    @Unique
    private List<View> views;

    @Shadow
    public abstract class_3218 method_51469();

    public MixinServerPlayer(class_1937 level, class_2338 blockPos, float f, GameProfile gameProfile) {
        super(level, blockPos, f, gameProfile);
    }

    @Override
    public void axiom$switchActiveHotbar(int oldHotbarIndex, int activeHotbarIndex, class_1799[] hotbarItems) {
        for (int i = 0; i < 9; ++i) {
            if (oldHotbarIndex != activeHotbarIndex) {
                this.allHotbarItems[oldHotbarIndex * 9 + i] = this.method_31548().method_5438(i).method_7972();
            }
            this.allHotbarItems[activeHotbarIndex * 9 + i] = hotbarItems[i].method_7972();
            if (!this.field_13974.method_14268()) continue;
            this.method_31548().method_5447(i, hotbarItems[i]);
        }
        this.activeHotbarIndex = activeHotbarIndex;
        this.field_7498.method_7623();
    }

    @Override
    public void axiom$setHotbarSlot(int index, class_1799 item) {
        this.allHotbarItems[index] = item;
    }

    @Override
    public void axiom$setViews(UUID activeView, List<View> views) {
        this.activeView = activeView;
        this.views = views;
    }

    @Override
    public void axiom$sendInitialPackets() {
        boolean hasHotbarData;
        new AxiomClientboundEnable().send((class_3222)this);
        boolean bl = hasHotbarData = this.activeHotbarIndex != 0;
        if (!hasHotbarData) {
            for (class_1799 item : this.allHotbarItems) {
                if (item == null || item.method_7960()) continue;
                hasHotbarData = true;
                break;
            }
        }
        if (hasHotbarData) {
            new AxiomClientboundInitializeHotbars(this.activeHotbarIndex, this.allHotbarItems).send((class_3222)this);
        }
        if (this.activeView != null) {
            new AxiomClientboundSetEditorViews(this.activeView, this.views).send((class_3222)this);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    public void addAdditionalSaveData(class_2487 compoundTag, CallbackInfo ci) {
        class_2487 axiomHotbarData = new class_2487();
        boolean saveHotbarData = false;
        if (this.activeHotbarIndex != 0) {
            axiomHotbarData.method_10567("ActiveHotbarIndex", (byte)this.activeHotbarIndex);
            saveHotbarData = true;
        }
        for (int i = 0; i < this.allHotbarItems.length; ++i) {
            class_1799 item;
            if (i / 9 == this.activeHotbarIndex || (item = this.allHotbarItems[i]) == null || item.method_7960()) continue;
            axiomHotbarData.method_10566("Slot" + i, (class_2520)item.method_7953(new class_2487()));
            saveHotbarData = true;
        }
        if (saveHotbarData) {
            compoundTag.method_10566("AxiomHotbarData", (class_2520)axiomHotbarData);
        }
        if (this.activeView != null && this.views != null) {
            class_2487 axiomViewData = new class_2487();
            axiomViewData.method_25927("ActiveView", this.activeView);
            class_2499 axiomViews = new class_2499();
            for (View view : this.views) {
                axiomViews.add((Object)view.save());
            }
            axiomViewData.method_10566("Views", (class_2520)axiomViews);
            compoundTag.method_10566("AxiomViewData", (class_2520)axiomViewData);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    public void readAdditionalSaveData(class_2487 compoundTag, CallbackInfo ci) {
        if (compoundTag.method_10573("AxiomHotbarData", 10)) {
            class_2487 axiomHotbarData = compoundTag.method_10562("AxiomHotbarData");
            this.activeHotbarIndex = axiomHotbarData.method_10571("ActiveHotbarIndex");
            for (int i = 0; i < this.allHotbarItems.length; ++i) {
                if (i / 9 == this.activeHotbarIndex) continue;
                if (axiomHotbarData.method_10573("Slot" + i, 10)) {
                    class_1799 item;
                    class_2487 itemNbt = axiomHotbarData.method_10562("Slot" + i);
                    this.allHotbarItems[i] = item = class_1799.method_7915((class_2487)itemNbt);
                    continue;
                }
                this.allHotbarItems[i] = class_1799.field_8037;
            }
        }
        if (compoundTag.method_10573("AxiomViewData", 10)) {
            class_2487 axiomViewData = compoundTag.method_10562("AxiomViewData");
            this.activeView = axiomViewData.method_25926("ActiveView");
            this.views = new ArrayList<View>();
            class_2499 views = axiomViewData.method_10554("Views", 10);
            for (class_2520 view : views) {
                this.views.add(View.load((class_2487)view));
            }
        }
    }

    @Inject(method={"restoreFrom"}, at={@At(value="RETURN")})
    public void restoreFrom(class_3222 serverPlayer, boolean bl, CallbackInfo ci) {
        this.activeHotbarIndex = ((MixinServerPlayer)serverPlayer).activeHotbarIndex;
        System.arraycopy(((MixinServerPlayer)serverPlayer).allHotbarItems, 0, this.allHotbarItems, 0, this.allHotbarItems.length);
        this.activeView = ((MixinServerPlayer)serverPlayer).activeView;
        this.views = this.views == null ? null : new ArrayList<View>(((MixinServerPlayer)serverPlayer).views);
    }
}

