/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.mixinplugin;

import com.llamalad7.mixinextras.MixinExtrasBootstrap;
import com.moulberry.axiom.Authorization;
import com.moulberry.axiom.Axiom;
import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class AxiomMixinPlugin
implements IMixinConfigPlugin {
    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (mixinClassName.startsWith("com.moulberry.axiom.mixin.debug")) {
            return false;
        }
        boolean sodiumLoaded = FabricLoader.getInstance().isModLoaded("sodium") || FabricLoader.getInstance().isModLoaded("embeddium");
        boolean resolutionControlPlusLoaded = FabricLoader.getInstance().isModLoaded("resolutioncontrol");
        boolean satinLoaded = FabricLoader.getInstance().isModLoaded("satin");
        boolean architecturyLoaded = FabricLoader.getInstance().isModLoaded("architectury");
        boolean nbtEditorLoaded = FabricLoader.getInstance().isModLoaded("nbteditor");
        return switch (mixinClassName) {
            case "com.moulberry.axiom.mixin.render.MixinLevelRendererWithoutSodium" -> {
                if (!sodiumLoaded) {
                    yield true;
                }
                yield false;
            }
            case "com.moulberry.axiom.mixin.render.MixinSectionOcclusionGraphWithoutSodium" -> {
                if (!sodiumLoaded) {
                    yield true;
                }
                yield false;
            }
            case "com.moulberry.axiom.mixin.compat.MixinSodiumRegionChunkRenderer" -> sodiumLoaded;
            case "com.moulberry.axiom.mixin.compat.MixinResolutionControlMinecraft" -> resolutionControlPlusLoaded;
            case "com.moulberry.axiom.mixin.render.MixinEffectInstance" -> {
                if (!satinLoaded && !architecturyLoaded) {
                    yield true;
                }
                yield false;
            }
            case "com.moulberry.axiom.mixin.compat.MixinNbtEditorConfigScreen" -> nbtEditorLoaded;
            default -> true;
        };
    }

    public void onLoad(String mixinPackage) {
        MixinExtrasBootstrap.init();
        Axiom.LOGGER.info("Loading Mixin Plugin for " + Authorization.getUserAgent());
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

