/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.operations;

import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.custom_blocks.CustomBlock;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.ServerCustomBlocks;
import com.moulberry.axiom.utils.IntWrapper;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class AnalyzeBlocksOperation {
    public static Information analyze() {
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        if (selectionBuffer instanceof SelectionBuffer.AABB) {
            SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)selectionBuffer;
            return AnalyzeBlocksOperation.analyze(aabb);
        }
        if (selectionBuffer instanceof SelectionBuffer.Set) {
            SelectionBuffer.Set set = (SelectionBuffer.Set)selectionBuffer;
            return AnalyzeBlocksOperation.analyze(set);
        }
        return null;
    }

    private static Information analyze(SelectionBuffer.AABB aabb) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return null;
        }
        int minX = aabb.min().method_10263();
        int minY = aabb.min().method_10264();
        int minZ = aabb.min().method_10260();
        int maxX = aabb.max().method_10263();
        int maxY = aabb.max().method_10264();
        int maxZ = aabb.max().method_10260();
        minY = Math.max(world.method_31607(), minY);
        maxY = Math.min(world.method_31600() - 1, maxY);
        HashMap<CustomBlock, IntWrapper> map = new HashMap<CustomBlock, IntWrapper>();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 blockState = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                    if (blockState.method_26204() == class_2246.field_10243) continue;
                    CustomBlockState customBlockState = ServerCustomBlocks.getCustomStateFor(blockState);
                    if (customBlockState != null) {
                        ++map.computeIfAbsent((CustomBlock)customBlockState.getCustomBlock(), (Function<CustomBlock, IntWrapper>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$analyze$0(com.moulberry.axiom.custom_blocks.CustomBlock ), (Lcom/moulberry/axiom/custom_blocks/CustomBlock;)Lcom/moulberry/axiom/utils/IntWrapper;)()).value;
                        continue;
                    }
                    ++map.computeIfAbsent((CustomBlock)((CustomBlock)blockState.method_26204()), (Function<CustomBlock, IntWrapper>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$analyze$1(com.moulberry.axiom.custom_blocks.CustomBlock ), (Lcom/moulberry/axiom/custom_blocks/CustomBlock;)Lcom/moulberry/axiom/utils/IntWrapper;)()).value;
                }
            }
        }
        return new Information(map);
    }

    private static Information analyze(SelectionBuffer.Set set) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return null;
        }
        HashMap<CustomBlock, IntWrapper> map = new HashMap<CustomBlock, IntWrapper>();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        set.selectionRegion.forEach((x, y, z) -> {
            class_2680 blockState = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
            if (blockState.method_26204() == class_2246.field_10243) {
                return;
            }
            CustomBlockState customBlockState = ServerCustomBlocks.getCustomStateFor(blockState);
            if (customBlockState != null) {
                ++map.computeIfAbsent(customBlockState.getCustomBlock(), (Function<CustomBlock, IntWrapper>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$analyze$2(com.moulberry.axiom.custom_blocks.CustomBlock ), (Lcom/moulberry/axiom/custom_blocks/CustomBlock;)Lcom/moulberry/axiom/utils/IntWrapper;)()).value;
            } else {
                ++map.computeIfAbsent((CustomBlock)blockState.method_26204(), (Function<CustomBlock, IntWrapper>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$analyze$3(com.moulberry.axiom.custom_blocks.CustomBlock ), (Lcom/moulberry/axiom/custom_blocks/CustomBlock;)Lcom/moulberry/axiom/utils/IntWrapper;)()).value;
            }
        });
        return new Information(map);
    }

    private static /* synthetic */ IntWrapper lambda$analyze$3(CustomBlock k) {
        return new IntWrapper();
    }

    private static /* synthetic */ IntWrapper lambda$analyze$2(CustomBlock k) {
        return new IntWrapper();
    }

    private static /* synthetic */ IntWrapper lambda$analyze$1(CustomBlock k) {
        return new IntWrapper();
    }

    private static /* synthetic */ IntWrapper lambda$analyze$0(CustomBlock k) {
        return new IntWrapper();
    }

    public record Information(List<InformationEntry> list, int total) {
        public Information(Map<CustomBlock, IntWrapper> map) {
            this(Information.sort(map));
        }

        public Information(List<InformationEntry> list) {
            this(list, Information.count(list));
        }

        private static int count(List<InformationEntry> list) {
            int count = 0;
            for (InformationEntry informationEntry : list) {
                count += informationEntry.count();
            }
            return count;
        }

        private static List<InformationEntry> sort(Map<CustomBlock, IntWrapper> map) {
            ArrayList<InformationEntry> list = new ArrayList<InformationEntry>();
            for (Map.Entry<CustomBlock, IntWrapper> entry : map.entrySet()) {
                list.add(new InformationEntry(entry.getKey(), entry.getValue().value));
            }
            list.sort(Comparator.comparingInt(k -> -k.count));
            return list;
        }
    }

    public record InformationEntry(CustomBlock block, int count) {
    }
}

