/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.operations;

import com.moulberry.axiom.BlueNoiseArray;
import com.moulberry.axiom.block_maps.BlockColourMap;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.utils.BlockWithFloat;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_modification.HistoryEntry;
import java.text.NumberFormat;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.joml.Vector3f;

public class AutoshadeOperation {
    public static void autoshade(boolean sunShade, boolean ambientShade, class_243 sunVector, float globalIllumination, float dither, List<BlockWithFloat> customPalette, int paletteFlags) {
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        if (sunVector != null) {
            sunVector = sunVector.method_1029();
        }
        globalIllumination = Math.max(0.0f, Math.min(1.0f, globalIllumination));
        dither = Math.max(0.0f, Math.min(1.0f, dither));
        if (selectionBuffer instanceof SelectionBuffer.AABB) {
            SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)selectionBuffer;
            AutoshadeOperation.autoshadeAABB(aabb, sunShade, ambientShade, sunVector, globalIllumination, dither, customPalette, paletteFlags);
        } else if (selectionBuffer instanceof SelectionBuffer.Set) {
            SelectionBuffer.Set set = (SelectionBuffer.Set)selectionBuffer;
            AutoshadeOperation.autoshadeSet(set, sunShade, ambientShade, sunVector, globalIllumination, dither, customPalette, paletteFlags);
        }
    }

    private static void autoshadeSet(SelectionBuffer.Set set, boolean sunShade, boolean ambientShade, class_243 sunVector, float globalIllumination, float dither, List<BlockWithFloat> customPalette, int paletteFlags) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        if (!sunShade && !ambientShade) {
            return;
        }
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        ChunkedBlockRegion blockRegion = new ChunkedBlockRegion();
        float playerX = (float)class_310.method_1551().method_1560().method_23317();
        float playerY = (float)class_310.method_1551().method_1560().method_23320();
        float playerZ = (float)class_310.method_1551().method_1560().method_23321();
        Vector3f playerPos = new Vector3f(playerX, playerY, playerZ);
        float customPaletteTotal = 0.0f;
        if (customPalette != null) {
            for (BlockWithFloat blockWithFloat : customPalette) {
                customPaletteTotal += blockWithFloat.percentage()[0];
            }
        }
        float customPaletteTotalF = customPaletteTotal;
        set.selectionRegion.forEach((x, y, z) -> {
            class_2680 shadedBlock = AutoshadeOperation.getShadedBlock((class_1937)world, x, y, z, mutableBlockPos, sunShade, ambientShade, sunVector, playerPos, globalIllumination, dither, customPalette, customPaletteTotalF, paletteFlags);
            if (shadedBlock != null) {
                blockRegion.addBlock(x, y, z, shadedBlock);
            }
        });
        String blockCountString = NumberFormat.getNumberInstance().format(blockRegion.count());
        RegionHelper.pushBlockRegionChange(blockRegion, "Autoshade (" + blockCountString + " blocks)", Dispatcher.simpleSourceInfo("Autoshade"), HistoryEntry.MODIFIER_SELECT_ON_BACKSTEP);
    }

    private static void autoshadeAABB(SelectionBuffer.AABB aabb, boolean sunShade, boolean ambientShade, class_243 sunVector, float globalIllumination, float dither, List<BlockWithFloat> customPalette, int paletteFlags) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        if (!sunShade && !ambientShade) {
            return;
        }
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        ChunkedBlockRegion blockRegion = new ChunkedBlockRegion();
        float playerX = (float)class_310.method_1551().method_1560().method_23317();
        float playerY = (float)class_310.method_1551().method_1560().method_23320();
        float playerZ = (float)class_310.method_1551().method_1560().method_23321();
        Vector3f playerPos = new Vector3f(playerX, playerY, playerZ);
        float customPaletteTotal = 0.0f;
        if (customPalette != null) {
            for (BlockWithFloat blockWithFloat : customPalette) {
                customPaletteTotal += blockWithFloat.percentage()[0];
            }
        }
        int minX = aabb.min().method_10263();
        int minY = aabb.min().method_10264();
        int minZ = aabb.min().method_10260();
        int maxX = aabb.max().method_10263();
        int maxY = aabb.max().method_10264();
        int maxZ = aabb.max().method_10260();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 shadedBlock = AutoshadeOperation.getShadedBlock((class_1937)world, x, y, z, mutableBlockPos, sunShade, ambientShade, sunVector, playerPos, globalIllumination, dither, customPalette, customPaletteTotal, paletteFlags);
                    if (shadedBlock == null) continue;
                    blockRegion.addBlock(x, y, z, shadedBlock);
                }
            }
        }
        String blockCountString = NumberFormat.getNumberInstance().format(blockRegion.count());
        RegionHelper.pushBlockRegionChange(blockRegion, "Autoshade (" + blockCountString + " blocks)", Dispatcher.simpleSourceInfo("Autoshade"), HistoryEntry.MODIFIER_SELECT_ON_BACKSTEP);
    }

    private static class_2680 getShadedBlock(class_1937 world, int x, int y, int z, class_2338.class_2339 mutableBlockPos, boolean sunShade, boolean ambientShade, class_243 sunVector, Vector3f playerPos, float globalIllumination, float dither, List<BlockWithFloat> customPalette, float customPaletteTotal, int paletteFlags) {
        class_2680 block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
        if (!block.method_51366()) {
            return null;
        }
        double[] lab = BlockColourMap.getLab(block.method_26204());
        if (lab == null) {
            return block;
        }
        if (world.method_8320((class_2338)mutableBlockPos.method_10103(x + 1, y, z)).method_51366() && world.method_8320((class_2338)mutableBlockPos.method_10103(x - 1, y, z)).method_51366() && world.method_8320((class_2338)mutableBlockPos.method_10103(x, y + 1, z)).method_51366() && world.method_8320((class_2338)mutableBlockPos.method_10103(x, y - 1, z)).method_51366() && world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z + 1)).method_51366() && world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z - 1)).method_51366()) {
            return block;
        }
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        float offsetZ = 0.0f;
        float filled = 0.0f;
        float total = 0.0f;
        for (int xo = -8; xo <= 8; ++xo) {
            for (int yo = -8; yo <= 8; ++yo) {
                for (int zo = -8; zo <= 8; ++zo) {
                    int distSq = xo * xo + yo * yo + zo * zo;
                    if (distSq > 72) continue;
                    total += 1.0f;
                    class_2680 neighbor = world.method_8320((class_2338)mutableBlockPos.method_10103(x + xo, y + yo, z + zo));
                    if (!neighbor.method_51366()) continue;
                    float factor = 1.0f / (float)Math.max(1.0, Math.sqrt(distSq));
                    filled += 1.0f;
                    offsetX -= (float)xo * factor;
                    offsetY -= (float)yo * factor;
                    offsetZ -= (float)zo * factor;
                }
            }
        }
        float shade = 1.0f;
        if (ambientShade) {
            float ambientFactor = Math.min(1.0f, Math.max(0.0f, 2.0f * (1.0f - filled / total)));
            shade *= Math.max(globalIllumination, ambientFactor * ambientFactor);
        }
        if (sunShade && (offsetX != 0.0f || offsetY != 0.0f || offsetZ != 0.0f)) {
            float sunDot;
            float invNormalLength = 1.0f / (float)Math.sqrt(offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ);
            float normalX = offsetX * invNormalLength;
            float normalY = offsetY * invNormalLength;
            float normalZ = offsetZ * invNormalLength;
            if (sunVector != null) {
                sunDot = (float)sunVector.field_1352 * normalX + (float)sunVector.field_1351 * normalY + (float)sunVector.field_1350 * normalZ;
            } else {
                float deltaX = playerPos.x - (float)x;
                float deltaY = playerPos.y - (float)y;
                float deltaZ = playerPos.z - (float)z;
                float deltaDist = (float)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
                sunDot = deltaX / deltaDist * normalX + deltaY / deltaDist * normalY + deltaZ / deltaDist * normalZ;
            }
            float sunShadeAmount = sunDot * 0.5f + 0.5f;
            shade *= Math.max(globalIllumination, sunShadeAmount);
        }
        if (shade < 0.0f) {
            shade = 0.0f;
        }
        if (shade > 1.0f) {
            shade = 1.0f;
        }
        if ((double)dither > 0.01) {
            float noise = BlueNoiseArray.NOISE[(x & 0x1F) + (y & 0x1F) * 32 + (z & 0x1F) * 32 * 32];
            if ((shade += noise * dither - dither / 2.0f) < 0.0f) {
                shade = 0.0f;
            }
            if (shade > 1.0f) {
                shade = 1.0f;
            }
        }
        if (customPalette != null) {
            float shadeTimesTotal = shade * customPaletteTotal;
            class_2680 shadedBlock = null;
            for (BlockWithFloat blockWithFloat : customPalette) {
                if (!((shadeTimesTotal -= blockWithFloat.percentage()[0]) <= 0.0f)) continue;
                shadedBlock = blockWithFloat.blockState().getVanillaState();
                break;
            }
            if (shadedBlock == null) {
                shadedBlock = customPalette.get(customPalette.size() - 1).blockState().getVanillaState();
            }
            return shadedBlock;
        }
        double lightness = lab[0] * (double)shade;
        return BlockColourMap.getNearestLab(lightness, lab[1], lab[2], paletteFlags);
    }
}

