/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.operations;

import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.world_modification.BiomeBuffer;
import com.moulberry.axiom.world_modification.BlockOrBiomeBuffer;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_modification.HistoryEntry;
import net.minecraft.class_1959;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6880;

public class SetBiomeOperation {
    public static void setBiome(class_5321<class_1959> biome, boolean fillVertically) {
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        if (selectionBuffer instanceof SelectionBuffer.AABB) {
            SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)selectionBuffer;
            SetBiomeOperation.setBiomeAABB(aabb, biome, fillVertically);
        } else if (selectionBuffer instanceof SelectionBuffer.Set) {
            SelectionBuffer.Set set = (SelectionBuffer.Set)selectionBuffer;
            SetBiomeOperation.setBiomeSet(set, biome, fillVertically);
        }
    }

    private static void setBiomeAABB(SelectionBuffer.AABB aabb, class_5321<class_1959> biome, boolean fillVertically) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        BiomeBuffer setOperation = new BiomeBuffer();
        BiomeBuffer previousBiomesForUndo = new BiomeBuffer();
        int minX = aabb.min().method_10263() >> 2;
        int minZ = aabb.min().method_10260() >> 2;
        int maxX = aabb.max().method_10263() >> 2;
        int maxZ = aabb.max().method_10260() >> 2;
        if (fillVertically) {
            for (int bx = minX; bx <= maxX; ++bx) {
                for (int bz = minZ; bz <= maxZ; ++bz) {
                    class_2818 chunk = (class_2818)world.method_8402(bx >> 2, bz >> 2, class_2806.field_12803, false);
                    if (chunk == null) continue;
                    int sectionCount = chunk.method_32890();
                    int minSection = chunk.method_32891();
                    for (int i = 0; i < sectionCount; ++i) {
                        class_2826 section = chunk.method_38259(i);
                        for (int y = 0; y < 4; ++y) {
                            class_6880.class_6883 reference;
                            class_5321 oldBiomeKey;
                            class_6880 oldBiome = section.method_38293(bx & 3, y, bz & 3);
                            if (!(oldBiome instanceof class_6880.class_6883) || (oldBiomeKey = (reference = (class_6880.class_6883)oldBiome).method_40237()) == biome) continue;
                            int by = (i + minSection << 2) + y;
                            setOperation.set(bx, by, bz, biome);
                            previousBiomesForUndo.set(bx, by, bz, (class_5321<class_1959>)oldBiomeKey);
                        }
                    }
                }
            }
        } else {
            int minY = aabb.min().method_10264() >> 2;
            int maxY = aabb.max().method_10264() >> 2;
            for (int bx = minX; bx <= maxX; ++bx) {
                for (int by = minY; by <= maxY; ++by) {
                    for (int bz = minZ; bz <= maxZ; ++bz) {
                        class_6880.class_6883 reference;
                        class_5321 oldBiomeKey;
                        class_2826 section;
                        class_6880 oldBiome;
                        int sectionIndex;
                        class_2818 chunk = (class_2818)world.method_8402(bx >> 2, bz >> 2, class_2806.field_12803, false);
                        if (chunk == null || (sectionIndex = world.method_31603(by >> 2)) < 0 || sectionIndex >= chunk.method_32890() || !((oldBiome = (section = chunk.method_38259(sectionIndex)).method_38293(bx & 3, by & 3, bz & 3)) instanceof class_6880.class_6883) || (oldBiomeKey = (reference = (class_6880.class_6883)oldBiome).method_40237()) == biome) continue;
                        setOperation.set(bx, by, bz, biome);
                        previousBiomesForUndo.set(bx, by, bz, (class_5321<class_1959>)oldBiomeKey);
                    }
                }
            }
        }
        String historyDescription = "Set biome to " + biome.method_29177();
        Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(setOperation, previousBiomesForUndo, aabb.center(), historyDescription, 0), Dispatcher.simpleSourceInfo("Set Biome Operation"));
    }

    private static void setBiomeSet(SelectionBuffer.Set set, class_5321<class_1959> biome, boolean fillVertically) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        PositionSet alreadyChecked = new PositionSet();
        BiomeBuffer setOperation = new BiomeBuffer();
        BiomeBuffer previousBiomesForUndo = new BiomeBuffer();
        if (fillVertically) {
            set.selectionRegion.forEach((x, y, z) -> {
                int bx = x >> 2;
                int bz = z >> 2;
                if (alreadyChecked.add(bx, 0, bz)) {
                    class_2818 chunk = (class_2818)world.method_8402(bx >> 2, bz >> 2, class_2806.field_12803, false);
                    if (chunk == null) {
                        return;
                    }
                    int sectionCount = chunk.method_32890();
                    int minSection = chunk.method_32891();
                    for (int i = 0; i < sectionCount; ++i) {
                        class_2826 section = chunk.method_38259(i);
                        for (int ly = 0; ly < 4; ++ly) {
                            class_6880.class_6883 reference;
                            class_5321 oldBiomeKey;
                            class_6880 oldBiome = section.method_38293(bx & 3, ly, bz & 3);
                            if (!(oldBiome instanceof class_6880.class_6883) || (oldBiomeKey = (reference = (class_6880.class_6883)oldBiome).method_40237()) == biome) continue;
                            int by = (i + minSection << 2) + ly;
                            setOperation.set(bx, by, bz, biome);
                            previousBiomesForUndo.set(bx, by, bz, (class_5321<class_1959>)oldBiomeKey);
                        }
                    }
                }
            });
        } else {
            set.selectionRegion.forEach((x, y, z) -> {
                int bx = x >> 2;
                int by = y >> 2;
                int bz = z >> 2;
                if (alreadyChecked.add(bx, by, bz)) {
                    class_6880.class_6883 reference;
                    class_5321 oldBiomeKey;
                    class_2818 chunk = (class_2818)world.method_8402(bx >> 2, bz >> 2, class_2806.field_12803, false);
                    if (chunk == null) {
                        return;
                    }
                    int sectionIndex = world.method_31603(by >> 2);
                    if (sectionIndex < 0 || sectionIndex >= chunk.method_32890()) {
                        return;
                    }
                    class_2826 section = chunk.method_38259(sectionIndex);
                    class_6880 oldBiome = section.method_38293(bx & 3, by & 3, bz & 3);
                    if (oldBiome instanceof class_6880.class_6883 && (oldBiomeKey = (reference = (class_6880.class_6883)oldBiome).method_40237()) != biome) {
                        setOperation.set(bx, by, bz, biome);
                        previousBiomesForUndo.set(bx, by, bz, (class_5321<class_1959>)oldBiomeKey);
                    }
                }
            });
        }
        String historyDescription = "Set biome to " + biome.method_29177();
        Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(setOperation, previousBiomesForUndo, set.selectionRegion.getCenter(), historyDescription, 0), Dispatcher.simpleSourceInfo("Set Biome Operation"));
    }
}

