/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.operations;

import com.moulberry.axiom.block_maps.FamilyMap;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.utils.IntWrapper;
import com.moulberry.axiom.world_modification.BlockBuffer;
import com.moulberry.axiom.world_modification.BlockOrBiomeBuffer;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_modification.HistoryEntry;
import java.text.NumberFormat;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_5794;
import net.minecraft.class_638;

public class TypeReplaceOperation {
    public static void replace(class_5794 from, class_5794 to) {
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        if (selectionBuffer instanceof SelectionBuffer.AABB) {
            SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)selectionBuffer;
            TypeReplaceOperation.replaceAABB(aabb, from, to);
        } else if (selectionBuffer instanceof SelectionBuffer.Set) {
            SelectionBuffer.Set set = (SelectionBuffer.Set)selectionBuffer;
            TypeReplaceOperation.replaceSet(set, from, to);
        }
    }

    private static <T extends Comparable<T>> class_2680 copyProperty(class_2680 blockState, class_2680 blockState2, class_2769<T> property) {
        return (class_2680)blockState2.method_11657(property, blockState.method_11654(property));
    }

    private static void replaceAABB(SelectionBuffer.AABB aabb, class_5794 from, class_5794 to) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        BlockBuffer setOperation = new BlockBuffer();
        BlockBuffer previousBlocksForUndo = new BlockBuffer();
        int changeCount = 0;
        int minX = aabb.min().method_10263();
        int minY = aabb.min().method_10264();
        int minZ = aabb.min().method_10260();
        int maxX = aabb.max().method_10263();
        int maxY = aabb.max().method_10264();
        int maxZ = aabb.max().method_10260();
        minY = Math.max(world.method_31607(), minY);
        maxY = Math.min(world.method_31600() - 1, maxY);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_5794.class_5796 variant;
                    class_2248 toBlock;
                    class_2680 blockState = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                    if (blockState.method_26204() == class_2246.field_10243) continue;
                    if (blockState.method_26204() == from.method_33469()) {
                        setOperation.set(x, y, z, to.method_33469().method_9564());
                        previousBlocksForUndo.set(x, y, z, blockState);
                        ++changeCount;
                        continue;
                    }
                    if (FamilyMap.getFamilyFor(blockState.method_26204()) != from || (toBlock = to.method_33470(variant = FamilyMap.getVariantFor(blockState.method_26204()))) == null && (variant == class_5794.class_5796.field_28536 ? (toBlock = to.method_33470(class_5794.class_5796.field_40592)) == null : (variant == class_5794.class_5796.field_40592 ? (toBlock = to.method_33470(class_5794.class_5796.field_28536)) == null : (variant == class_5794.class_5796.field_28537 ? (toBlock = to.method_33470(class_5794.class_5796.field_40593)) == null : variant != class_5794.class_5796.field_40593 || (toBlock = to.method_33470(class_5794.class_5796.field_28537)) == null)))) continue;
                    class_2680 newState = toBlock.method_9564();
                    for (class_2769 property : blockState.method_28501()) {
                        if (!newState.method_28498(property)) continue;
                        newState = TypeReplaceOperation.copyProperty(blockState, newState, property);
                    }
                    setOperation.set(x, y, z, newState);
                    previousBlocksForUndo.set(x, y, z, blockState);
                    ++changeCount;
                }
            }
        }
        if (changeCount == 0) {
            return;
        }
        String countString = NumberFormat.getInstance().format(changeCount);
        String blockName = AxiomI18n.get(to.method_33469().method_9539());
        String historyDescription = AxiomI18n.get("axiom.history_description.set_n_blocks_to", countString, blockName);
        Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(setOperation, previousBlocksForUndo, aabb.center(), historyDescription, 0), Dispatcher.simpleSourceInfo("Type Replace Operation"));
    }

    private static void replaceSet(SelectionBuffer.Set set, class_5794 from, class_5794 to) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        BlockBuffer setOperation = new BlockBuffer();
        BlockBuffer previousBlocksForUndo = new BlockBuffer();
        IntWrapper changeCount = new IntWrapper();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        set.selectionRegion.forEach((x, y, z) -> {
            class_2680 blockState = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
            if (blockState.method_26204() == class_2246.field_10243) {
                return;
            }
            if (blockState.method_26204() == from.method_33469()) {
                setOperation.set(x, y, z, to.method_33469().method_9564());
                previousBlocksForUndo.set(x, y, z, blockState);
                ++changeCount.value;
            } else if (FamilyMap.getFamilyFor(blockState.method_26204()) == from) {
                class_5794.class_5796 variant = FamilyMap.getVariantFor(blockState.method_26204());
                class_2248 toBlock = to.method_33470(variant);
                if (toBlock == null) {
                    if (variant == class_5794.class_5796.field_28536) {
                        toBlock = to.method_33470(class_5794.class_5796.field_40592);
                        if (toBlock == null) {
                            return;
                        }
                    } else if (variant == class_5794.class_5796.field_40592) {
                        toBlock = to.method_33470(class_5794.class_5796.field_28536);
                        if (toBlock == null) {
                            return;
                        }
                    } else if (variant == class_5794.class_5796.field_28537) {
                        toBlock = to.method_33470(class_5794.class_5796.field_40593);
                        if (toBlock == null) {
                            return;
                        }
                    } else if (variant == class_5794.class_5796.field_40593) {
                        toBlock = to.method_33470(class_5794.class_5796.field_28537);
                        if (toBlock == null) {
                            return;
                        }
                    } else {
                        return;
                    }
                }
                class_2680 newState = toBlock.method_9564();
                for (class_2769 property : blockState.method_28501()) {
                    if (!newState.method_28498(property)) continue;
                    newState = TypeReplaceOperation.copyProperty(blockState, newState, property);
                }
                setOperation.set(x, y, z, newState);
                previousBlocksForUndo.set(x, y, z, blockState);
                ++changeCount.value;
            }
        });
        if (changeCount.value == 0) {
            return;
        }
        String countString = NumberFormat.getInstance().format(changeCount.value);
        String blockName = AxiomI18n.get(to.method_33469().method_9539());
        String historyDescription = AxiomI18n.get("axiom.history_description.set_n_blocks_to", countString, blockName);
        Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(setOperation, previousBlocksForUndo, set.selectionRegion.getCenter(), historyDescription, 0), Dispatcher.simpleSourceInfo("Replace Operation"));
    }
}

