/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packets;

import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.packets.AxiomClientboundPacket;
import com.moulberry.axiom.utils.PositionUtils;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import com.moulberry.axiom.world_modification.Dispatcher;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2359;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2841;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5455;

public class AxiomClientboundResponseChunkData
implements AxiomClientboundPacket {
    public static final class_2960 IDENTIFIER = new class_2960("axiom:response_chunk_data");
    private final long id;
    private final boolean finished;
    private final Long2ObjectMap<CompressedBlockEntity> compressedBlockEntities;
    private final Long2ObjectMap<class_2841<class_2680>> chunkSections;

    public AxiomClientboundResponseChunkData(long id, boolean finished, Long2ObjectMap<CompressedBlockEntity> compressedBlockEntities, Long2ObjectMap<class_2841<class_2680>> chunkSections) {
        this.id = id;
        this.finished = finished;
        this.compressedBlockEntities = compressedBlockEntities;
        this.chunkSections = chunkSections;
    }

    public AxiomClientboundResponseChunkData(class_2540 friendlyByteBuf) {
        long pos;
        this.id = friendlyByteBuf.readLong();
        this.compressedBlockEntities = new Long2ObjectOpenHashMap();
        while ((pos = friendlyByteBuf.readLong()) != PositionUtils.MIN_POSITION_LONG) {
            this.compressedBlockEntities.put(pos, (Object)CompressedBlockEntity.read(friendlyByteBuf));
        }
        this.chunkSections = new Long2ObjectOpenHashMap();
        while ((pos = friendlyByteBuf.readLong()) != PositionUtils.MIN_POSITION_LONG) {
            if (friendlyByteBuf.readBoolean()) {
                class_2841 container = new class_2841((class_2359)class_2248.field_10651, (Object)class_2246.field_10124.method_9564(), class_2841.class_6563.field_34569);
                container.method_12326(friendlyByteBuf);
                this.chunkSections.put(pos, (Object)container);
                continue;
            }
            this.chunkSections.put(pos, null);
        }
        this.finished = friendlyByteBuf.readBoolean();
    }

    @Override
    public class_2960 packetIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public void write(class_2540 friendlyByteBuf) {
        friendlyByteBuf.writeLong(this.id);
        for (Long2ObjectMap.Entry entry : this.compressedBlockEntities.long2ObjectEntrySet()) {
            friendlyByteBuf.writeLong(entry.getLongKey());
            ((CompressedBlockEntity)entry.getValue()).write(friendlyByteBuf);
        }
        friendlyByteBuf.writeLong(PositionUtils.MIN_POSITION_LONG);
        for (Long2ObjectMap.Entry entry : this.chunkSections.long2ObjectEntrySet()) {
            friendlyByteBuf.writeLong(entry.getLongKey());
            class_2841 container = (class_2841)entry.getValue();
            if (container == null) {
                friendlyByteBuf.writeBoolean(false);
                continue;
            }
            friendlyByteBuf.writeBoolean(true);
            ((class_2841)entry.getValue()).method_12325(friendlyByteBuf);
        }
        friendlyByteBuf.writeLong(PositionUtils.MIN_POSITION_LONG);
        friendlyByteBuf.writeBoolean(this.finished);
    }

    @Override
    public void handle(class_310 client, class_5455 registryAccess) {
        Dispatcher.finishRequestChunkData(this.id, this.finished, this.compressedBlockEntities, this.chunkSections);
    }

    public static void register() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)IDENTIFIER, (client, handler, buf, responseSender) -> {
            AxiomClientboundResponseChunkData packet = new AxiomClientboundResponseChunkData(buf);
            ClientEvents.clientboundPackets.add(packet);
        });
    }
}

