/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packets;

import com.moulberry.axiom.blueprint.ServerBlueprintManager;
import com.moulberry.axiom.editor.EditorWarningType;
import com.moulberry.axiom.hooks.ServerPlayerExt;
import com.moulberry.axiom.packets.AxiomClientboundEditorWarning;
import com.moulberry.axiom.packets.AxiomServerboundPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_155;
import net.minecraft.class_1928;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class AxiomServerboundHello
implements AxiomServerboundPacket {
    public static final class_2960 IDENTIFIER = new class_2960("axiom:hello");
    private final int apiVersion;
    private final int dataVersion;
    private final class_2487 additionalInfo;

    public AxiomServerboundHello(int apiVersion, int dataVersion, class_2487 additionalInfo) {
        this.apiVersion = apiVersion;
        this.dataVersion = dataVersion;
        this.additionalInfo = additionalInfo;
    }

    public AxiomServerboundHello(class_2540 friendlyByteBuf) {
        this.apiVersion = friendlyByteBuf.method_10816();
        this.dataVersion = friendlyByteBuf.method_10816();
        this.additionalInfo = friendlyByteBuf.method_10798();
    }

    @Override
    public class_2960 packetIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public void write(class_2540 friendlyByteBuf) {
        friendlyByteBuf.method_10804(this.apiVersion);
        friendlyByteBuf.method_10804(this.dataVersion);
        friendlyByteBuf.method_10794(this.additionalInfo);
    }

    @Override
    public void handle(MinecraftServer server, class_3222 player) {
        if (AxiomServerboundPacket.isMissingPermission(server, player)) {
            return;
        }
        int serverDataVersion = class_155.method_16673().method_37912().method_38494();
        if (this.dataVersion != serverDataVersion) {
            player.field_13987.method_14367((class_2561)class_2561.method_43470((String)("Axiom: Incompatible data version detected (client " + this.dataVersion + ", server " + serverDataVersion + "), are you using ViaVersion?")));
            return;
        }
        if (this.apiVersion != 7) {
            player.field_13987.method_14367((class_2561)class_2561.method_43470((String)("Unsupported Axiom API Version. Server supports 7, while client is " + this.apiVersion)));
            return;
        }
        class_1928.class_4310 spectatorsGenerateChunks = (class_1928.class_4310)server.method_3767().method_20746(class_1928.field_19402);
        if (!spectatorsGenerateChunks.method_20753()) {
            new AxiomClientboundEditorWarning(EditorWarningType.SPECTATORS_GENERATE_CHUNKS, true).send(player);
        }
        ((ServerPlayerExt)player).axiom$sendInitialPackets();
        ServerBlueprintManager.sendManifest(player);
    }

    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)IDENTIFIER, (server, player, handler, buf, responseSender) -> {
            AxiomServerboundHello packet = new AxiomServerboundHello(buf);
            server.execute(() -> packet.handle(server, player));
        });
    }
}

