/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packets;

import com.moulberry.axiom.hooks.ServerPlayerExt;
import com.moulberry.axiom.packets.AxiomServerboundPacket;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class AxiomServerboundSwitchActiveHotbar
implements AxiomServerboundPacket {
    private static final class_2960 IDENTIFIER = new class_2960("axiom:switch_active_hotbar");
    private final int oldHotbarIndex;
    private final int activeHotbarIndex;
    private final class_1799[] hotbarItems;

    public AxiomServerboundSwitchActiveHotbar(int oldHotbarIndex, int activeHotbarIndex, class_1799[] hotbarItems) {
        this.oldHotbarIndex = oldHotbarIndex;
        this.activeHotbarIndex = activeHotbarIndex;
        this.hotbarItems = hotbarItems;
        if (hotbarItems.length != 9) {
            throw new RuntimeException("hotbarItems must be of length 9");
        }
    }

    public AxiomServerboundSwitchActiveHotbar(class_2540 friendlyByteBuf) {
        this.oldHotbarIndex = friendlyByteBuf.readByte();
        this.activeHotbarIndex = friendlyByteBuf.readByte();
        this.hotbarItems = new class_1799[9];
        for (int i = 0; i < 9; ++i) {
            this.hotbarItems[i] = friendlyByteBuf.method_10819();
        }
    }

    @Override
    public class_2960 packetIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public void write(class_2540 friendlyByteBuf) {
        friendlyByteBuf.writeByte(this.oldHotbarIndex);
        friendlyByteBuf.writeByte(this.activeHotbarIndex);
        for (class_1799 item : this.hotbarItems) {
            friendlyByteBuf.method_10793(Objects.requireNonNullElse(item, class_1799.field_8037));
        }
    }

    @Override
    public void handle(MinecraftServer server, class_3222 player) {
        if (AxiomServerboundPacket.isMissingPermission(server, player)) {
            return;
        }
        ((ServerPlayerExt)player).axiom$switchActiveHotbar(this.oldHotbarIndex, this.activeHotbarIndex, this.hotbarItems);
    }

    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)IDENTIFIER, (server, player, handler, buf, responseSender) -> {
            AxiomServerboundSwitchActiveHotbar packet = new AxiomServerboundSwitchActiveHotbar(buf);
            server.execute(() -> packet.handle(server, player));
        });
    }
}

