/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.pather;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiomclientapi.funcinterfaces.TriIntConsumer;
import com.moulberry.axiomclientapi.pathers.BallShape;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ToolPatherUnique
implements com.moulberry.axiomclientapi.pathers.ToolPatherUnique {
    private boolean realtimeUpdates;
    private final int[] sphere;
    private final int[][] cardinal;
    @Nullable
    private final PositionSet positions;
    @Nullable
    private final ChunkedBooleanRegion preview;
    private class_2338.class_2339 lastPosition = null;
    private class_243 lastLookDirection = null;

    public ToolPatherUnique(int radius, BallShape ballShape) {
        this(radius, true, ballShape);
    }

    public ToolPatherUnique(int radius, boolean realtimeUpdates, BallShape ballShape) {
        this.realtimeUpdates = realtimeUpdates;
        if (realtimeUpdates) {
            this.positions = new PositionSet();
            this.preview = null;
        } else {
            this.positions = null;
            this.preview = new ChunkedBooleanRegion();
        }
        radius = Math.max(0, radius);
        IntArrayList sphere = new IntArrayList();
        List<IntArrayList> cardinal = List.of(new IntArrayList(), new IntArrayList(), new IntArrayList(), new IntArrayList(), new IntArrayList(), new IntArrayList());
        float radiusSq = ((float)radius + 0.5f) * ((float)radius + 0.5f);
        for (int x = -radius - 1; x <= radius + 1; ++x) {
            for (int y = -radius - 1; y <= radius + 1; ++y) {
                for (int z = -radius - 1; z <= radius + 1; ++z) {
                    float distanceSq = ballShape.distanceSq(x, y, z);
                    if (distanceSq <= radiusSq) {
                        sphere.add(x);
                        sphere.add(y);
                        sphere.add(z);
                        continue;
                    }
                    for (class_2350 direction : class_2350.values()) {
                        int z2;
                        int y2;
                        int x2 = x - direction.method_10163().method_10263();
                        float distanceSq2 = ballShape.distanceSq(x2, y2 = y - direction.method_10163().method_10264(), z2 = z - direction.method_10163().method_10260());
                        if (!(distanceSq2 <= radiusSq)) continue;
                        IntList list = (IntList)cardinal.get(direction.method_10146());
                        list.add(x2);
                        list.add(y2);
                        list.add(z2);
                    }
                }
            }
        }
        this.sphere = sphere.toIntArray();
        this.cardinal = new int[6][];
        for (int i = 0; i < 6; ++i) {
            this.cardinal[i] = ((IntList)cardinal.get(i)).toIntArray();
        }
    }

    public boolean update(TriIntConsumer consumer) {
        class_746 entity = class_310.method_1551().field_1724;
        if (entity == null || entity != class_310.method_1551().method_1560()) {
            return false;
        }
        if (!EditorUI.isActive()) {
            return false;
        }
        if (EditorUI.isMovingCamera()) {
            return false;
        }
        class_243 currentLookDirection = EditorUI.getMouseLookVector();
        if (currentLookDirection == null) {
            return false;
        }
        class_243 start = entity.method_33571();
        boolean includeFluids = Tool.defaultIncludeFluids();
        if (this.lastLookDirection == null || this.lastPosition == null) {
            if (!this.positions.isEmpty()) {
                throw new FaultyImplementationError();
            }
            RayCaster.RaycastResult raycastResult = RayCaster.raycast(entity.method_37908(), start.method_46409(), currentLookDirection.method_46409(), false, includeFluids, true);
            if (raycastResult != null) {
                this.lastLookDirection = currentLookDirection;
                this.lastPosition = raycastResult.getBlockPos().method_25503();
                if (this.realtimeUpdates) {
                    if (this.positions == null) {
                        throw new FaultyImplementationError();
                    }
                    for (int i = 0; i < this.sphere.length; i += 3) {
                        int z2;
                        int y2;
                        int x2 = this.sphere[i] + this.lastPosition.method_10263();
                        if (!this.positions.add(x2, y2 = this.sphere[i + 1] + this.lastPosition.method_10264(), z2 = this.sphere[i + 2] + this.lastPosition.method_10260())) continue;
                        consumer.accept(x2, y2, z2);
                    }
                } else {
                    if (this.preview == null) {
                        throw new FaultyImplementationError();
                    }
                    for (int i = 0; i < this.sphere.length; i += 3) {
                        int x3 = this.sphere[i] + this.lastPosition.method_10263();
                        int y3 = this.sphere[i + 1] + this.lastPosition.method_10264();
                        int z3 = this.sphere[i + 2] + this.lastPosition.method_10260();
                        this.preview.add(x3, y3, z3);
                    }
                }
            }
            return true;
        }
        int oldCount = this.preview != null ? this.preview.count() : this.positions.count();
        List<class_241> mousePositions = EditorUI.imguiGlfw.getCapturedInterframeMousePositions();
        for (int mouseI = 0; mouseI < mousePositions.size(); ++mouseI) {
            class_241 mousePosition = mousePositions.get(mouseI);
            class_243 lookDirection = EditorUI.getMouseLookVector(mousePosition.field_1343, mousePosition.field_1342);
            if (lookDirection == null) continue;
            double dot = this.lastLookDirection.method_1026(lookDirection);
            double angleChange = Math.toDegrees(Math.acos(dot));
            int steps = 1;
            if (angleChange > 1.0) {
                steps = (int)Math.ceil(angleChange);
            }
            for (int i = 1; i <= steps; ++i) {
                float f = (float)i / (float)steps;
                class_243 look = this.lastLookDirection.method_35590(lookDirection, (double)f);
                RayCaster.RaycastResult raycastResult = RayCaster.raycast(entity.method_37908(), start.method_46409(), look.method_46409(), false, includeFluids, true);
                if (raycastResult == null || raycastResult.getBlockPos().equals((Object)this.lastPosition)) continue;
                Rasterization3D.dda((class_2338)this.lastPosition, raycastResult.getBlockPos(), (x, y, z) -> {
                    int[] offsets;
                    int dx = x - this.lastPosition.method_10263();
                    int dy = y - this.lastPosition.method_10264();
                    int dz = z - this.lastPosition.method_10260();
                    if (dx == 0) {
                        if (dy == 0) {
                            if (dz == 0) {
                                return;
                            }
                            if (dz == 1) {
                                offsets = this.cardinal[3];
                            } else {
                                if (dz != -1) throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
                                offsets = this.cardinal[2];
                            }
                        } else {
                            if (dz != 0) throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
                            if (dy == 1) {
                                offsets = this.cardinal[1];
                            } else {
                                if (dy != -1) throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
                                offsets = this.cardinal[0];
                            }
                        }
                    } else {
                        if (dy != 0 || dz != 0) throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
                        if (dx == 1) {
                            offsets = this.cardinal[5];
                        } else {
                            if (dx != -1) throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
                            offsets = this.cardinal[4];
                        }
                    }
                    if (this.realtimeUpdates) {
                        if (this.positions == null) {
                            throw new FaultyImplementationError();
                        }
                        for (int j = 0; j < offsets.length; j += 3) {
                            int offsetX = offsets[j] + x;
                            int offsetY = offsets[j + 1] + y;
                            int offsetZ = offsets[j + 2] + z;
                            if (!this.positions.add(offsetX, offsetY, offsetZ)) continue;
                            consumer.accept(offsetX, offsetY, offsetZ);
                        }
                    } else {
                        if (this.preview == null) {
                            throw new FaultyImplementationError();
                        }
                        for (int j = 0; j < offsets.length; j += 3) {
                            int offsetX = offsets[j] + x;
                            int offsetY = offsets[j + 1] + y;
                            int offsetZ = offsets[j + 2] + z;
                            this.preview.add(offsetX, offsetY, offsetZ);
                        }
                    }
                    this.lastPosition.method_10103(x, y, z);
                });
            }
            this.lastLookDirection = lookDirection;
        }
        int newCount = this.preview != null ? this.preview.count() : this.positions.count();
        return newCount != oldCount;
    }

    public void finish(TriIntConsumer consumer) {
        if (this.realtimeUpdates) {
            return;
        }
        this.realtimeUpdates = true;
        if (this.preview == null) {
            throw new FaultyImplementationError();
        }
        this.preview.forEach(consumer);
    }

    public void renderPreview(class_4184 camera, long time, class_4587 matrices, Matrix4f projection, int effects) {
        if (this.preview != null) {
            this.preview.render(camera, class_243.field_1353, matrices, projection, time, effects);
        }
    }

    public void close() {
        if (this.preview != null) {
            this.preview.close();
        }
    }
}

