/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.rasterization;

import com.moulberry.axiom.funcinterfaces.BiIntConsumer;
import com.moulberry.axiom.funcinterfaces.IntIntFloatConsumer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Arrays;
import javax.imageio.ImageIO;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3f;

public class Rasterization2D {
    public static void triangle(Vector2i one, Vector2i two, Vector2i three, BiIntConsumer consumer) {
        Rasterization2D.triangle(one.x, one.y, two.x, two.y, three.x, three.y, consumer);
    }

    public static void triangle(int x1, int y1, int x2, int y2, int x3, int y3, BiIntConsumer consumer) {
        Vector2i[] extremeIfColinear = Rasterization2D.getExtremePointsIfColinear(x1, y1, x2, y2, x3, y3);
        if (extremeIfColinear != null) {
            Rasterization2D.bresenham(extremeIfColinear[0], extremeIfColinear[1], consumer);
            return;
        }
        int minY = Math.min(y1, Math.min(y2, y3));
        int maxY = Math.max(y1, Math.max(y2, y3));
        Vector3f vector3f = new Vector3f((float)(x2 - x1), (float)(y2 - y1), 0.0f);
        if (vector3f.cross((float)((float)(x3 - x1)), (float)((float)(y3 - y1)), (float)0.0f).z < 0.0f) {
            int temp = x2;
            x2 = x3;
            x3 = temp;
            temp = y2;
            y2 = y3;
            y3 = temp;
        }
        Vector2f center = new Vector2f((float)(x1 + x2 + x3) / 3.0f + 0.5f, (float)(y1 + y2 + y3) / 3.0f + 0.5f);
        int[] leftx = new int[maxY - minY + 1];
        Arrays.fill(leftx, Integer.MAX_VALUE);
        int[] rightx = new int[maxY - minY + 1];
        Arrays.fill(rightx, Integer.MIN_VALUE);
        Rasterization2D.bresenham(new Vector2i(x1, y1), new Vector2i(x2, y2), (x, y) -> {
            if (x < leftx[y - minY]) {
                leftx[y - minY] = x;
            }
            if (x > rightx[y - minY]) {
                rightx[y - minY] = x;
            }
        }, Rasterization2D.bresenhamBias(new Vector2i(x1, y1), new Vector2i(x2, y2), center));
        Rasterization2D.bresenham(new Vector2i(x2, y2), new Vector2i(x3, y3), (x, y) -> {
            if (x < leftx[y - minY]) {
                leftx[y - minY] = x;
            }
            if (x > rightx[y - minY]) {
                rightx[y - minY] = x;
            }
        }, Rasterization2D.bresenhamBias(new Vector2i(x2, y2), new Vector2i(x3, y3), center));
        Rasterization2D.bresenham(new Vector2i(x3, y3), new Vector2i(x1, y1), (x, y) -> {
            if (x < leftx[y - minY]) {
                leftx[y - minY] = x;
            }
            if (x > rightx[y - minY]) {
                rightx[y - minY] = x;
            }
        }, Rasterization2D.bresenhamBias(new Vector2i(x3, y3), new Vector2i(x1, y1), center));
        for (int y4 = minY; y4 <= maxY; ++y4) {
            int left = leftx[y4 - minY];
            int right = rightx[y4 - minY];
            for (int x4 = left; x4 <= right; ++x4) {
                consumer.accept(x4, y4);
            }
        }
    }

    private static Vector2i[] getExtremePointsIfColinear(int x1, int y1, int x2, int y2, int x3, int y3) {
        int secondY;
        int secondX;
        int firstY;
        int firstX;
        boolean colinear;
        boolean bl = colinear = (x2 - x1) * (y3 - y1) == (x3 - x1) * (y2 - y1);
        if (!colinear) {
            return null;
        }
        if (x1 != x2 || x2 != x3) {
            if (x1 <= x2 && x1 <= x3) {
                firstX = x1;
                firstY = y1;
                if (x2 >= x3) {
                    secondX = x2;
                    secondY = y2;
                } else {
                    secondX = x3;
                    secondY = y3;
                }
            } else if (x2 <= x3) {
                if (x1 >= x3) {
                    firstX = x1;
                    firstY = y1;
                    secondX = x2;
                    secondY = y2;
                } else {
                    firstX = x2;
                    firstY = y2;
                    secondX = x3;
                    secondY = y3;
                }
            } else {
                secondX = x3;
                secondY = y3;
                if (x1 >= x2) {
                    firstX = x1;
                    firstY = y1;
                } else {
                    firstX = x2;
                    firstY = y2;
                }
            }
        } else if (y1 <= y2 && y1 <= y3) {
            firstX = x1;
            firstY = y1;
            if (y2 >= y3) {
                secondX = x2;
                secondY = y2;
            } else {
                secondX = x3;
                secondY = y3;
            }
        } else if (y2 <= y3) {
            if (y1 >= y3) {
                firstX = x1;
                firstY = y1;
                secondX = x2;
                secondY = y2;
            } else {
                firstX = x2;
                firstY = y2;
                secondX = x3;
                secondY = y3;
            }
        } else {
            secondX = x3;
            secondY = y3;
            if (y1 >= y2) {
                firstX = x1;
                firstY = y1;
            } else {
                firstX = x2;
                firstY = y2;
            }
        }
        return new Vector2i[]{new Vector2i(firstX, firstY), new Vector2i(secondX, secondY)};
    }

    public static boolean bresenhamBias(Vector2i from, Vector2i to, Vector2f biasTowards) {
        boolean bias;
        boolean bl = bias = (double)(to.x - from.x) * ((double)biasTowards.y - ((double)from.y + 0.5)) - (double)(to.y - from.y) * ((double)biasTowards.x - ((double)from.x + 0.5)) > 0.0;
        if (to.x < from.x) {
            boolean bl2 = bias = !bias;
        }
        if (to.y < from.y) {
            boolean bl3 = bias = !bias;
        }
        if (Math.abs(to.y - from.y) < Math.abs(to.x - from.x)) {
            bias = !bias;
        }
        return bias;
    }

    public static void bresenham(Vector2i from, Vector2i to, BiIntConsumer consumer) {
        Rasterization2D.bresenham(from, to, consumer, false);
    }

    public static void bresenham(Vector2i from, Vector2i to, BiIntConsumer consumer, boolean bias) {
        consumer.accept(from.x, from.y);
        Rasterization2D.bresenhamSkipFrom(from, to, consumer, bias);
    }

    public static void bresenhamSkipFrom(Vector2i from, Vector2i to, BiIntConsumer consumer, boolean bias) {
        int threshold;
        if (to.equals((Object)from)) {
            return;
        }
        int x = from.x;
        int y = from.y;
        int dx = Math.abs(to.x - x);
        int dy = Math.abs(to.y - y);
        int xs = to.x > x ? 1 : -1;
        int ys = to.y > y ? 1 : -1;
        int n = threshold = bias ? 1 : 0;
        if (dx >= dy) {
            int p1 = 2 * dy - dx;
            while (x != to.x) {
                x += xs;
                if (p1 >= threshold) {
                    y += ys;
                    p1 -= 2 * dx;
                }
                p1 += 2 * dy;
                consumer.accept(x, y);
            }
        } else {
            int p1 = 2 * dx - dy;
            while (y != to.y) {
                y += ys;
                if (p1 >= threshold) {
                    x += xs;
                    p1 -= 2 * dy;
                }
                p1 += 2 * dx;
                consumer.accept(x, y);
            }
        }
    }

    private static float fpart(float f) {
        return f - (float)Math.floor(f);
    }

    private static float rfpart(float f) {
        return 1.0f - Rasterization2D.fpart(f);
    }

    public static void main(String[] args) {
        BufferedImage image = new BufferedImage(200, 200, 2);
        Vector2f from = new Vector2f(0.0f, 0.0f);
        for (int x2 = 0; x2 < 200; ++x2) {
            for (int y2 = 0; y2 < 200; ++y2) {
                image.setRGB(x2, y2, -1);
            }
        }
        Rasterization2D.xiaolinWu(from, new Vector2f(10.0f, 5.0f), (x, y, v) -> {
            int col = 255 - (int)(v * 255.0f);
            int argb = 0xFF000000 | col << 16 | col << 8 | col;
            image.setRGB(90 + x, 100 - y, argb);
        });
        Rasterization2D.xiaolinWu(from, new Vector2f(-10.0f, 5.0f), (x, y, v) -> {
            int col = 255 - (int)(v * 255.0f);
            int argb = 0xFF000000 | col << 16 | col << 8 | col;
            image.setRGB(90 + x, 100 - y, argb);
        });
        Rasterization2D.xiaolinWu(from, new Vector2f(10.0f, -5.0f), (x, y, v) -> {
            int col = 255 - (int)(v * 255.0f);
            int argb = 0xFF000000 | col << 16 | col << 8 | col;
            image.setRGB(90 + x, 100 - y, argb);
        });
        Rasterization2D.xiaolinWu(from, new Vector2f(-10.0f, -5.0f), (x, y, v) -> {
            int col = 255 - (int)(v * 255.0f);
            int argb = 0xFF000000 | col << 16 | col << 8 | col;
            image.setRGB(90 + x, 100 - y, argb);
        });
        Rasterization2D.xiaolinWu(from, new Vector2f(5.0f, 10.0f), (x, y, v) -> {
            int col = 255 - (int)(v * 255.0f);
            int argb = 0xFF000000 | col << 16 | col << 8 | col;
            image.setRGB(90 + x, 100 - y, argb);
        });
        Rasterization2D.xiaolinWu(from, new Vector2f(-5.0f, 10.0f), (x, y, v) -> {
            int col = 255 - (int)(v * 255.0f);
            int argb = 0xFF000000 | col << 16 | col << 8 | col;
            image.setRGB(90 + x, 100 - y, argb);
        });
        Rasterization2D.xiaolinWu(from, new Vector2f(5.0f, -10.0f), (x, y, v) -> {
            int col = 255 - (int)(v * 255.0f);
            int argb = 0xFF000000 | col << 16 | col << 8 | col;
            image.setRGB(90 + x, 100 - y, argb);
        });
        Rasterization2D.xiaolinWu(from, new Vector2f(-5.0f, -10.0f), (x, y, v) -> {
            int col = 255 - (int)(v * 255.0f);
            int argb = 0xFF000000 | col << 16 | col << 8 | col;
            image.setRGB(90 + x, 100 - y, argb);
        });
        try {
            ImageIO.write((RenderedImage)image, "PNG", new File("output.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void xiaolinWu(Vector2f from, Vector2f to, IntIntFloatConsumer consumer) {
        float temp;
        boolean steep;
        float x0 = from.x - 0.5f;
        float y0 = from.y - 0.5f;
        float x1 = to.x - 0.5f;
        float y1 = to.y - 0.5f;
        int bx0 = Math.round(x0);
        int by0 = Math.round(y0);
        int bx1 = Math.round(x1);
        int by1 = Math.round(y1);
        if (bx0 == bx1 && by0 == by1) {
            consumer.accept(bx0, by0, Math.max(Math.abs(x0 - x1), Math.abs(y0 - y1)));
            return;
        }
        boolean bl = steep = Math.abs(by0 - by1) > Math.abs(bx0 - bx1);
        if (steep) {
            temp = x0;
            x0 = y0;
            y0 = temp;
            temp = x1;
            x1 = y1;
            y1 = temp;
        }
        if (x0 > x1) {
            temp = x0;
            x0 = x1;
            x1 = temp;
            temp = y0;
            y0 = y1;
            y1 = temp;
        }
        if ((bx0 = Math.round(x0)) == (bx1 = Math.round(x1))) {
            by0 = Math.round(y0);
            if (steep) {
                consumer.accept(by0, bx0, Math.abs(x0 - x1));
            } else {
                consumer.accept(bx0, by0, Math.abs(x0 - x1));
            }
            return;
        }
        float dx = x1 - x0;
        float dy = y1 - y0;
        float gradient = 1.0f;
        if ((double)dx != 0.0) {
            gradient = dy / dx;
        }
        float xgap = Rasterization2D.rfpart(x0 + 0.5f);
        float yend = y0 + gradient * ((float)bx0 - x0);
        int ypxl1 = (int)Math.floor(yend);
        if (steep) {
            consumer.accept(ypxl1, bx0, Rasterization2D.rfpart(yend) * xgap);
            consumer.accept(ypxl1 + 1, bx0, Rasterization2D.fpart(yend) * xgap);
        } else {
            consumer.accept(bx0, ypxl1, Rasterization2D.rfpart(yend) * xgap);
            consumer.accept(bx0, ypxl1 + 1, Rasterization2D.fpart(yend) * xgap);
        }
        float intery = yend + gradient;
        xgap = Rasterization2D.fpart(x1 + 0.5f);
        yend = y1 + gradient * ((float)bx1 - x1);
        int ypxl2 = (int)Math.floor(yend);
        if (steep) {
            consumer.accept(ypxl2, bx1, Rasterization2D.rfpart(yend) * xgap);
            consumer.accept(ypxl2 + 1, bx1, Rasterization2D.fpart(yend) * xgap);
        } else {
            consumer.accept(bx1, ypxl2, Rasterization2D.rfpart(yend) * xgap);
            consumer.accept(bx1, ypxl2 + 1, Rasterization2D.fpart(yend) * xgap);
        }
        if (steep) {
            for (int x = bx0 + 1; x <= bx1 - 1; ++x) {
                int y = (int)Math.floor(intery);
                consumer.accept(y, x, Rasterization2D.rfpart(intery));
                consumer.accept(y + 1, x, Rasterization2D.fpart(intery));
                intery += gradient;
            }
        } else {
            for (int x = bx0 + 1; x <= bx1 - 1; ++x) {
                int y = (int)Math.floor(intery);
                consumer.accept(x, y, Rasterization2D.rfpart(intery));
                consumer.accept(x, y + 1, Rasterization2D.fpart(intery));
                intery += gradient;
            }
        }
    }

    public static void dda(Vector2i from, Vector2i to, BiIntConsumer consumer) {
        consumer.accept(from.x, from.y);
        if (to.equals((Object)from)) {
            return;
        }
        Vector2f ray = new Vector2f((float)(to.x - from.x), (float)(to.y - from.y)).normalize();
        int mapX = from.x;
        int mapY = from.y;
        double deltaDistX = Math.abs(1.0f / ray.x);
        double deltaDistY = Math.abs(1.0f / ray.y);
        int stepX = ray.x < 0.0f ? -1 : 1;
        int stepY = ray.y < 0.0f ? -1 : 1;
        double sideDistX = 0.5 * deltaDistX;
        double sideDistY = 0.5 * deltaDistY;
        boolean limit = false;
        do {
            if (sideDistX < sideDistY) {
                sideDistX += deltaDistX;
                mapX += stepX;
            } else {
                sideDistY += deltaDistY;
                mapY += stepY;
            }
            consumer.accept(mapX, mapY);
        } while (mapX != to.x || mapY != to.y);
    }
}

