/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.render.CustomRenderType;
import com.moulberry.axiom.render.DynamicTextureTarget;
import com.moulberry.axiom.render.InjectPoseVertexConsumer;
import com.moulberry.axiom.utils.EmptyBlockAndTintGetter;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_773;
import net.minecraft.class_777;
import net.minecraft.class_804;
import net.minecraft.class_809;
import net.minecraft.class_811;
import net.minecraft.class_8251;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class BlockRenderCache {
    private static final int MIN_CAPACITY = 32;
    private static final int MIN_AGE = 16;
    private static final int INFLOW_PER_TICK = 8;
    private static final int OUTFLOW_PER_TICK = 8;
    private static final DynamicTextureTarget frameBuffer = new DynamicTextureTarget(true);
    private static final IntList textureIdPool = new IntArrayList();
    private static final Map<SizedBlock, RenderSlot> blockToRenderSlot = new HashMap<SizedBlock, RenderSlot>();
    private static RenderSlot head;
    private static RenderSlot tail;
    private static long currentTick;
    private static long nextTick;
    private static final Set<SizedBlock> desired;
    private static final Set<SizedBlock> desiredPriority;

    public static int request(CustomBlockState blockState, int width, int height, boolean priority) {
        SizedBlock sizedBlock = new SizedBlock(blockState.getVanillaState(), !(blockState instanceof class_2680), width, height);
        RenderSlot slot = blockToRenderSlot.get(sizedBlock);
        if (slot == null) {
            if (priority) {
                if (desiredPriority.size() >= 8) {
                    return -1;
                }
                desiredPriority.add(sizedBlock);
                if (desiredPriority.size() + desired.size() > 8) {
                    Iterator<SizedBlock> iterator = desired.iterator();
                    iterator.next();
                    iterator.remove();
                }
            } else {
                if (desiredPriority.size() + desired.size() >= 8) {
                    return -1;
                }
                desired.add(sizedBlock);
            }
            return -1;
        }
        slot.lastRequestedTick = currentTick;
        if (slot != head) {
            slot.unlink();
            slot.next = head;
            BlockRenderCache.head.previous = slot;
            head = slot;
        }
        return slot.textureId;
    }

    public static void tick() {
        ++nextTick;
    }

    public static void renderTick(class_332 guiGraphics) {
        if (currentTick == nextTick) {
            return;
        }
        currentTick = nextTick;
        RenderSystem.assertOnRenderThread();
        desired.forEach(sizedBlock -> BlockRenderCache.renderSizedBlock(sizedBlock, guiGraphics));
        desiredPriority.forEach(sizedBlock -> BlockRenderCache.renderSizedBlock(sizedBlock, guiGraphics));
        desired.clear();
        desiredPriority.clear();
        int outflow = 0;
        while (outflow < 8 && blockToRenderSlot.size() > 32) {
            RenderSlot toRemove = tail;
            long age = currentTick - toRemove.lastRequestedTick;
            if (age >= -10L && age <= 16L) break;
            toRemove.unlink();
            RenderSlot removedSlot = blockToRenderSlot.remove(toRemove.key);
            if (removedSlot != toRemove) {
                throw new FaultyImplementationError();
            }
            textureIdPool.add(toRemove.textureId);
            ++outflow;
            int textureIdPoolSize = textureIdPool.size();
            if (textureIdPoolSize <= Math.max(32, blockToRenderSlot.size())) continue;
            for (int i = textureIdPoolSize - 1; i >= textureIdPoolSize / 2; --i) {
                int id = textureIdPool.removeInt(i);
                TextureUtil.releaseTextureId((int)id);
            }
        }
    }

    private static void renderSizedBlock(SizedBlock sizedBlock, class_332 guiGraphics) {
        int textureId;
        if (textureIdPool.isEmpty()) {
            for (int i = 0; i < Math.max(32, blockToRenderSlot.size()) / 2 - 1; ++i) {
                textureIdPool.add(TextureUtil.generateTextureId());
            }
            textureId = TextureUtil.generateTextureId();
        } else {
            textureId = textureIdPool.removeInt(textureIdPool.size() - 1);
        }
        if (BlockRenderCache.frameBuffer.field_1482 != sizedBlock.width || BlockRenderCache.frameBuffer.field_1481 != sizedBlock.height) {
            frameBuffer.method_1234(sizedBlock.width, sizedBlock.height, class_310.field_1703);
        }
        frameBuffer.clear(class_310.field_1703, textureId);
        frameBuffer.bindWrite(true, textureId, false);
        class_1799 itemStack = new class_1799((class_1935)sizedBlock.state.method_26204().method_8389());
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        RenderSystem.backupProjectionMatrix();
        Matrix4f projectionMatrix = new Matrix4f().setOrtho(0.0f, (float)sizedBlock.width, (float)sizedBlock.height, 0.0f, 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (class_8251)class_8251.field_43361);
        class_4587 modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.method_22903();
        modelViewStack.method_34426();
        modelViewStack.method_46416(0.0f, 0.0f, -2000.0f);
        modelViewStack.method_22905((float)sizedBlock.width / 16.0f, (float)sizedBlock.height / 16.0f, 1.0f);
        RenderSystem.applyModelViewMatrix();
        if (!sizedBlock.forceAsBlock && BlockRenderCache.shouldRenderAsItem(sizedBlock.state, itemStack)) {
            guiGraphics.method_51427(itemStack, 0, 0);
        } else {
            class_809 transforms;
            class_804 transform;
            boolean useFlatLight;
            class_1091 modelResourceLocation = class_773.method_3340((class_2680)sizedBlock.state);
            class_1087 bakedModel = class_310.method_1551().method_1554().method_4742(modelResourceLocation);
            class_310.method_1551().method_1531().method_4619(class_1059.field_5275).method_4527(false, false);
            RenderSystem.setShaderTexture((int)0, (class_2960)class_1059.field_5275);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            modelViewStack.method_46416(0.0f, 0.0f, 100.0f);
            modelViewStack.method_46416(8.0f, 8.0f, 0.0f);
            modelViewStack.method_22905(1.0f, -1.0f, 1.0f);
            modelViewStack.method_22905(16.0f, 16.0f, 16.0f);
            RenderSystem.applyModelViewMatrix();
            class_4587 poseStack2 = new class_4587();
            boolean bl = useFlatLight = !bakedModel.method_24304();
            if (useFlatLight) {
                class_308.method_24210();
            }
            class_804 class_8042 = transform = (transforms = bakedModel.method_4709()) == null ? class_804.field_4284 : transforms.method_3503(class_811.field_4317);
            if (transform != class_804.field_4284) {
                transform.method_23075(false, poseStack2);
            } else {
                poseStack2.method_22907(new Quaternionf().rotationXYZ((float)Math.toRadians(30.0), (float)Math.toRadians(225.0), 0.0f));
                poseStack2.method_22905(0.625f, 0.625f, 0.625f);
            }
            if (sizedBlock.state.method_26204() instanceof class_2510) {
                poseStack2.method_22907(new Quaternionf().rotateY(-1.5707964f));
            }
            poseStack2.method_46416(-0.5f, -0.5f, -0.5f);
            if (!BlockRenderCache.shouldShade(bakedModel, sizedBlock.state)) {
                RenderSystem.setShaderLights((Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f));
            }
            class_310.method_1551().method_1541().method_3353(sizedBlock.state, poseStack2, (class_4597)bufferSource, 0xF000F0, class_4608.field_21444);
            bufferSource.method_22993();
            class_3610 fluid = sizedBlock.state.method_26227();
            if (!fluid.method_15769()) {
                class_4588 consumer = bufferSource.getBuffer(CustomRenderType.apply(class_4696.method_23680((class_3610)fluid)));
                class_310.method_1551().method_1541().method_3352(class_2338.field_10980, (class_1920)EmptyBlockAndTintGetter.INSTANCE, (class_4588)new InjectPoseVertexConsumer(poseStack2, consumer), sizedBlock.state, fluid);
            }
            bufferSource.method_22993();
            class_308.method_24211();
            RenderSystem.enableDepthTest();
        }
        modelViewStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.restoreProjectionMatrix();
        class_310.method_1551().method_1522().method_1235(true);
        RenderSlot slot = new RenderSlot(sizedBlock, textureId, currentTick);
        if (head == null) {
            head = slot;
            tail = slot;
        } else {
            BlockRenderCache.head.previous = slot;
            slot.next = head;
            head = slot;
        }
        blockToRenderSlot.put(sizedBlock, slot);
    }

    private static boolean shouldRenderAsItem(class_2680 state, class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return false;
        }
        class_1792 item = itemStack.method_7909();
        if (item == class_1802.field_8638) {
            return false;
        }
        if (state.method_28501().isEmpty()) {
            return true;
        }
        class_1087 itemModel = class_310.method_1551().method_1480().method_4019(itemStack, null, null, 0);
        class_5819 rand = class_5819.method_43047();
        for (class_2350 direction : class_2350.values()) {
            rand.method_43052(42L);
            if (itemModel.method_4707(null, direction, rand).size() <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean shouldShade(class_1087 bakedModel, class_2680 blockState) {
        class_5819 randomSource = class_5819.method_43047();
        for (class_2350 direction : class_2350.values()) {
            randomSource.method_43052(42L);
            for (class_777 quad : bakedModel.method_4707(blockState, direction, randomSource)) {
                if (!quad.method_24874()) continue;
                return true;
            }
        }
        randomSource.method_43052(42L);
        for (class_777 quad : bakedModel.method_4707(blockState, null, randomSource)) {
            if (!quad.method_24874()) continue;
            return true;
        }
        return false;
    }

    static {
        currentTick = 0L;
        nextTick = 0L;
        desired = new HashSet<SizedBlock>();
        desiredPriority = new HashSet<SizedBlock>();
    }

    private record SizedBlock(class_2680 state, boolean forceAsBlock, int width, int height) {
    }

    private static class RenderSlot {
        private RenderSlot previous;
        private RenderSlot next;
        private final SizedBlock key;
        private final int textureId;
        private long lastRequestedTick;

        public RenderSlot(SizedBlock key, int textureId, long lastRequestedTick) {
            this.key = key;
            this.textureId = textureId;
            this.lastRequestedTick = lastRequestedTick;
        }

        private void unlink() {
            if (this == head && this == tail) {
                head = null;
                tail = null;
            } else if (this == head) {
                this.next.previous = null;
                head = this.next;
            } else if (this == tail) {
                this.previous.next = null;
                tail = this.previous;
            } else {
                this.next.previous = this.previous;
                this.previous.next = this.next;
            }
            this.previous = null;
            this.next = null;
        }
    }
}

