/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render.regions;

import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.GlobalCleaner;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.collections.list.IntrusiveLinkedElement;
import com.moulberry.axiom.collections.list.IntrusiveLinkedList;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.hooks.VertexBufferExt;
import com.moulberry.axiom.render.CleaningBufferBuilder;
import com.moulberry.axiom.render.EffectRenderer;
import com.moulberry.axiom.render.regions.ChunkedRegionPool;
import com.moulberry.axiom.render.regions.InvertedVertexSorting;
import com.moulberry.axiom.utils.RenderHelper;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.lang.invoke.LambdaMetafactory;
import java.util.Comparator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.ToDoubleFunction;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ColorVertex;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4573;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.system.MemoryStack;

public class OneshotBooleanRegion {
    private boolean closed = false;
    private GlobalCleaner.LeakChecker leakChecker = null;
    private final Long2ObjectMap<ChunkData> chunkDataMap;
    private final IntrusiveLinkedList<ChunkData> sortedChunkData;
    private boolean pendingVertexUpload = true;
    private long compiledSortMillis;
    private float compiledSortX;
    private float compiledSortY;
    private float compiledSortZ;
    private int compiledSortChunkX;
    private int compiledSortChunkY;
    private int compiledSortChunkZ;
    private static final float EPS = 1.0E-5f;
    private static final int SHADE_X = 178;
    private static final int SHADE_PLUS_Y = 255;
    private static final int SHADE_MINUS_Y = 153;
    private static final int SHADE_Z = 222;
    private static final int SHADE_X_ABGR = class_5253.class_8045.method_48344((int)255, (int)178, (int)178, (int)178);
    private static final int SHADE_PLUS_Y_ABGR = class_5253.class_8045.method_48344((int)255, (int)255, (int)255, (int)255);
    private static final int SHADE_MINUS_Y_ABGR = class_5253.class_8045.method_48344((int)255, (int)153, (int)153, (int)153);
    private static final int SHADE_Z_ABGR = class_5253.class_8045.method_48344((int)255, (int)222, (int)222, (int)222);

    public OneshotBooleanRegion(Long2ObjectMap<ChunkData> chunkDataMap, IntrusiveLinkedList<ChunkData> sortedChunkData) {
        this.chunkDataMap = chunkDataMap;
        this.sortedChunkData = sortedChunkData;
    }

    public void render(class_4184 camera, class_243 translation, class_4587 matrix, Matrix4f projection, long time, int effects) {
        if (this.sortedChunkData.isEmpty()) {
            return;
        }
        this.doVertexUpload();
        matrix.method_22903();
        if (camera != null) {
            matrix.method_22904(-camera.method_19326().field_1352, -camera.method_19326().field_1351, -camera.method_19326().field_1350);
        }
        matrix.method_22904(translation.field_1352, translation.field_1351, translation.field_1350);
        class_5944 shader = class_757.method_34540();
        if (shader != null) {
            EffectRenderer.render(() -> {
                Matrix4f modelViewMatrix = matrix.method_23760().method_23761();
                RenderHelper.setupShader(shader, modelViewMatrix, projection);
                Matrix4f translatedMatrix = new Matrix4f();
                for (ChunkData data : this.sortedChunkData) {
                    if (shader.field_29470 != null) {
                        translatedMatrix.set((Matrix4fc)modelViewMatrix);
                        translatedMatrix.translate((float)data.offsetX, (float)data.offsetY, (float)data.offsetZ);
                        shader.field_29470.method_1250(translatedMatrix);
                        shader.field_29470.method_1300();
                    }
                    data.buffer.method_1353();
                    data.buffer.method_35665();
                }
                RenderHelper.finishShader(shader);
            }, time, effects);
        }
        matrix.method_22909();
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        RenderSystem.disablePolygonOffset();
        RenderSystem.enableCull();
    }

    private void doVertexUpload() {
        RenderSystem.assertOnRenderThread();
        if (this.pendingVertexUpload) {
            this.pendingVertexUpload = false;
            for (ChunkData chunkData : this.chunkDataMap.values()) {
                chunkData.upload();
            }
            class_291.method_1354();
        }
    }

    private void setSortInfo(long sortMillis, float sortX, float sortY, float sortZ, int sortChunkX, int sortChunkY, int sortChunkZ) {
        this.compiledSortMillis = sortMillis;
        this.compiledSortX = sortX;
        this.compiledSortY = sortY;
        this.compiledSortZ = sortZ;
        this.compiledSortChunkX = sortChunkX;
        this.compiledSortChunkY = sortChunkY;
        this.compiledSortChunkZ = sortChunkZ;
    }

    public void close() {
        if (this.closed) {
            throw new FaultyImplementationError();
        }
        this.closed = true;
        for (ChunkData chunkDatum : this.chunkDataMap.values()) {
            if (chunkDatum.buffer == null) continue;
            chunkDatum.buffer.close();
            chunkDatum.buffer = null;
        }
        this.chunkDataMap.clear();
        this.sortedChunkData.clear();
        if (this.leakChecker != null) {
            this.leakChecker.disarm();
        }
    }

    public static CompileFuture compile(PositionSet positionSet, class_4184 camera, class_243 translation) {
        CompileFuture future = new CompileFuture();
        ChunkedRegionPool.submit(() -> {
            try {
                LongOpenHashSet dirtyChunks = new LongOpenHashSet();
                LongIterator longIterator = positionSet.chunkKeySet().longIterator();
                while (longIterator.hasNext()) {
                    long pos = longIterator.nextLong();
                    int chunkX = class_2338.method_10061((long)pos);
                    int chunkY = class_2338.method_10071((long)pos);
                    int chunkZ = class_2338.method_10083((long)pos);
                    dirtyChunks.add(class_2338.method_10064((int)(chunkX - 1), (int)chunkY, (int)chunkZ));
                    dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)(chunkY - 1), (int)chunkZ));
                    dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)chunkY, (int)(chunkZ - 1)));
                    dirtyChunks.add(class_2338.method_10064((int)(chunkX + 1), (int)chunkY, (int)chunkZ));
                    dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)(chunkY + 1), (int)chunkZ));
                    dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)chunkY, (int)(chunkZ + 1)));
                    dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)chunkY, (int)chunkZ));
                }
                Long2ObjectOpenHashMap chunkDataMap = new Long2ObjectOpenHashMap();
                IntrusiveLinkedList<ChunkData> sortedChunkData = new IntrusiveLinkedList<ChunkData>();
                OneshotBooleanRegion.compileInner(future, positionSet, (LongSet)dirtyChunks, (Long2ObjectMap<ChunkData>)chunkDataMap, sortedChunkData, camera, translation);
            }
            catch (Exception e) {
                future.exception.set(new ExecutionException(e));
            }
        });
        return future;
    }

    /*
     * Unable to fully structure code
     */
    private static void compileInner(CompileFuture compileFuture, PositionSet positionSet, LongSet dirtyChunks, Long2ObjectMap<ChunkData> chunkDataMap, IntrusiveLinkedList<ChunkData> sortedChunkData, class_4184 camera, class_243 translation) {
        sortX = (float)((camera != null ? camera.method_19326().field_1352 : 0.0) - translation.field_1352);
        sortY = (float)((camera != null ? camera.method_19326().field_1351 : 0.0) - translation.field_1351);
        sortZ = (float)((camera != null ? camera.method_19326().field_1350 : 0.0) - translation.field_1350);
        sortChunkX = class_4076.method_32204((double)sortX);
        sortChunkY = class_4076.method_32204((double)sortY);
        sortChunkZ = class_4076.method_32204((double)sortZ);
        bufferBuilder = new CleaningBufferBuilder(256);
        sodiumLoaded = FabricLoader.getInstance().isModLoaded("sodium");
        memoryStack = null;
        if (sodiumLoaded) {
            memoryStack = MemoryStack.create(835584);
        }
        longIterator = dirtyChunks.longIterator();
        while (longIterator.hasNext()) {
            if (compileFuture.cancelled.get()) {
                RenderSystem.recordRenderCall((class_4573)(class_4573)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$compileInner$2(it.unimi.dsi.fastutil.longs.Long2ObjectMap ), ()V)(chunkDataMap));
                return;
            }
            pos = longIterator.nextLong();
            chunkX = class_2338.method_10061((long)pos);
            chunkY = class_2338.method_10071((long)pos);
            chunkZ = class_2338.method_10083((long)pos);
            offsetX = chunkX * 16;
            offsetY = chunkY * 16;
            offsetZ = chunkZ * 16;
            started = false;
            chunk = positionSet.getChunk(pos);
            if (chunk != null) {
                up = positionSet.getChunk(class_2338.method_10064((int)chunkX, (int)(chunkY + 1), (int)chunkZ));
                down = positionSet.getChunk(class_2338.method_10064((int)chunkX, (int)(chunkY - 1), (int)chunkZ));
                north = positionSet.getChunk(class_2338.method_10064((int)chunkX, (int)chunkY, (int)(chunkZ - 1)));
                south = positionSet.getChunk(class_2338.method_10064((int)chunkX, (int)chunkY, (int)(chunkZ + 1)));
                east = positionSet.getChunk(class_2338.method_10064((int)(chunkX - 1), (int)chunkY, (int)chunkZ));
                west = positionSet.getChunk(class_2338.method_10064((int)(chunkX + 1), (int)chunkY, (int)chunkZ));
                if (sodiumLoaded) {
                    stack = memoryStack.push();
                    try {
                        buffer = stack.nmalloc(835584);
                        bufferEnd = OneshotBooleanRegion.buildChunkSodium(buffer, chunk, up, down, north, south, east, west);
                        if (bufferEnd <= buffer) ** GOTO lbl50
                        started = true;
                        count = (int)(bufferEnd - buffer) / 16;
                        writer = (VertexBufferWriter)bufferBuilder;
                        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
                        writer.push(stack, buffer, count, ColorVertex.FORMAT);
                    }
                    finally {
                        if (stack != null) {
                            stack.close();
                        }
                    }
                } else {
                    started = OneshotBooleanRegion.buildChunkVanilla(bufferBuilder, chunk, up, down, north, south, east, west);
                }
            }
lbl50:
            // 5 sources

            if (started && !bufferBuilder.method_43574()) {
                chunkData = new ChunkData(offsetX, offsetY, offsetZ);
                chunkDataMap.put(pos, (Object)chunkData);
                sortedChunkData.add(chunkData);
                dx = sortChunkX * 16 - chunkX * 16;
                dy = sortChunkY * 16 - chunkY * 16;
                dz = sortChunkZ * 16 - chunkZ * 16;
                chunkData.distanceSqToCamera = dx * dx + dy * dy + dz * dz;
                bufferBuilder.method_49904(InvertedVertexSorting.byDistance(sortX - (float)chunkX * 16.0f, sortY - (float)chunkY * 16.0f, sortZ - (float)chunkZ * 16.0f));
                chunkData.sortState = bufferBuilder.method_1334();
                chunkData.renderedBuffer = bufferBuilder.method_43575();
                continue;
            }
            if (!started) continue;
            bufferBuilder.method_43575();
        }
        sortedChunkData.sort(Comparator.comparingDouble((ToDoubleFunction<ChunkData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)D, lambda$compileInner$3(com.moulberry.axiom.render.regions.OneshotBooleanRegion$ChunkData ), (Lcom/moulberry/axiom/render/regions/OneshotBooleanRegion$ChunkData;)D)()));
        oneshotBlockRegion = new OneshotBooleanRegion(chunkDataMap, sortedChunkData);
        oneshotBlockRegion.setSortInfo(System.currentTimeMillis(), sortX, sortY, sortZ, sortChunkX, sortChunkY, sortChunkZ);
        compileFuture.value.set(oneshotBlockRegion);
        if (compileFuture.cancelled.get()) {
            RenderSystem.recordRenderCall((class_4573)(class_4573)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$compileInner$4(it.unimi.dsi.fastutil.longs.Long2ObjectMap ), ()V)(chunkDataMap));
        }
    }

    private static boolean buildChunkVanilla(class_287 bufferBuilder, short[] chunk, short[] up, short[] down, short[] north, short[] south, short[] east, short[] west) {
        boolean started = false;
        int index = 0;
        for (int z = 0; z < 16; ++z) {
            for (int y = 0; y < 16; ++y) {
                short v;
                if ((v = chunk[index++]) == 0) continue;
                if (!started) {
                    started = true;
                    bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
                }
                for (int x = 0; x < 16; ++x) {
                    boolean minusZ;
                    boolean plusZ;
                    boolean minusY;
                    boolean plusY;
                    boolean minusX;
                    boolean plusX;
                    if ((v & 1 << x) == 0) continue;
                    if (x == 0) {
                        plusX = (v & 2) == 0;
                        minusX = east == null || (east[y + z * 16] & 0x8000) == 0;
                    } else if (x == 15) {
                        plusX = west == null || (west[y + z * 16] & 1) == 0;
                        minusX = (v & 0x4000) == 0;
                    } else {
                        plusX = (v & 1 << x + 1) == 0;
                        boolean bl = minusX = (v & 1 << x - 1) == 0;
                    }
                    if (plusX) {
                        bufferBuilder.method_22912((double)((float)(x + 1) + 1.0E-5f), (double)y, (double)z).method_1336(178, 178, 178, 255).method_1344();
                        bufferBuilder.method_22912((double)((float)(x + 1) + 1.0E-5f), (double)(y + 1), (double)z).method_1336(178, 178, 178, 255).method_1344();
                        bufferBuilder.method_22912((double)((float)(x + 1) + 1.0E-5f), (double)(y + 1), (double)(z + 1)).method_1336(178, 178, 178, 255).method_1344();
                        bufferBuilder.method_22912((double)((float)(x + 1) + 1.0E-5f), (double)y, (double)(z + 1)).method_1336(178, 178, 178, 255).method_1344();
                    }
                    if (minusX) {
                        bufferBuilder.method_22912((double)((float)x - 1.0E-5f), (double)y, (double)(z + 1)).method_1336(178, 178, 178, 255).method_1344();
                        bufferBuilder.method_22912((double)((float)x - 1.0E-5f), (double)(y + 1), (double)(z + 1)).method_1336(178, 178, 178, 255).method_1344();
                        bufferBuilder.method_22912((double)((float)x - 1.0E-5f), (double)(y + 1), (double)z).method_1336(178, 178, 178, 255).method_1344();
                        bufferBuilder.method_22912((double)((float)x - 1.0E-5f), (double)y, (double)z).method_1336(178, 178, 178, 255).method_1344();
                    }
                    if (y == 0) {
                        plusY = (chunk[1 + z * 16] & 1 << x) == 0;
                        minusY = down == null || (down[15 + z * 16] & 1 << x) == 0;
                    } else if (y == 15) {
                        plusY = up == null || (up[z * 16] & 1 << x) == 0;
                        minusY = (chunk[14 + z * 16] & 1 << x) == 0;
                    } else {
                        plusY = (chunk[y + 1 + z * 16] & 1 << x) == 0;
                        boolean bl = minusY = (chunk[y - 1 + z * 16] & 1 << x) == 0;
                    }
                    if (plusY) {
                        bufferBuilder.method_22912((double)x, (double)((float)(y + 1) + 1.0E-5f), (double)(z + 1)).method_1336(255, 255, 255, 255).method_1344();
                        bufferBuilder.method_22912((double)(x + 1), (double)((float)(y + 1) + 1.0E-5f), (double)(z + 1)).method_1336(255, 255, 255, 255).method_1344();
                        bufferBuilder.method_22912((double)(x + 1), (double)((float)(y + 1) + 1.0E-5f), (double)z).method_1336(255, 255, 255, 255).method_1344();
                        bufferBuilder.method_22912((double)x, (double)((float)(y + 1) + 1.0E-5f), (double)z).method_1336(255, 255, 255, 255).method_1344();
                    }
                    if (minusY) {
                        bufferBuilder.method_22912((double)x, (double)((float)y - 1.0E-5f), (double)z).method_1336(153, 153, 153, 255).method_1344();
                        bufferBuilder.method_22912((double)(x + 1), (double)((float)y - 1.0E-5f), (double)z).method_1336(153, 153, 153, 255).method_1344();
                        bufferBuilder.method_22912((double)(x + 1), (double)((float)y - 1.0E-5f), (double)(z + 1)).method_1336(153, 153, 153, 255).method_1344();
                        bufferBuilder.method_22912((double)x, (double)((float)y - 1.0E-5f), (double)(z + 1)).method_1336(153, 153, 153, 255).method_1344();
                    }
                    if (z == 0) {
                        plusZ = (chunk[y + 16] & 1 << x) == 0;
                        minusZ = north == null || (north[y + 240] & 1 << x) == 0;
                    } else if (z == 15) {
                        plusZ = south == null || (south[y] & 1 << x) == 0;
                        minusZ = (chunk[y + 224] & 1 << x) == 0;
                    } else {
                        plusZ = (chunk[y + (z + 1) * 16] & 1 << x) == 0;
                        boolean bl = minusZ = (chunk[y + (z - 1) * 16] & 1 << x) == 0;
                    }
                    if (plusZ) {
                        bufferBuilder.method_22912((double)x, (double)y, (double)((float)(z + 1) + 1.0E-5f)).method_1336(222, 222, 222, 255).method_1344();
                        bufferBuilder.method_22912((double)(x + 1), (double)y, (double)((float)(z + 1) + 1.0E-5f)).method_1336(222, 222, 222, 255).method_1344();
                        bufferBuilder.method_22912((double)(x + 1), (double)(y + 1), (double)((float)(z + 1) + 1.0E-5f)).method_1336(222, 222, 222, 255).method_1344();
                        bufferBuilder.method_22912((double)x, (double)(y + 1), (double)((float)(z + 1) + 1.0E-5f)).method_1336(222, 222, 222, 255).method_1344();
                    }
                    if (!minusZ) continue;
                    bufferBuilder.method_22912((double)x, (double)(y + 1), (double)((float)z - 1.0E-5f)).method_1336(222, 222, 222, 255).method_1344();
                    bufferBuilder.method_22912((double)(x + 1), (double)(y + 1), (double)((float)z - 1.0E-5f)).method_1336(222, 222, 222, 255).method_1344();
                    bufferBuilder.method_22912((double)(x + 1), (double)y, (double)((float)z - 1.0E-5f)).method_1336(222, 222, 222, 255).method_1344();
                    bufferBuilder.method_22912((double)x, (double)y, (double)((float)z - 1.0E-5f)).method_1336(222, 222, 222, 255).method_1344();
                }
            }
        }
        return started;
    }

    private static long buildChunkSodium(long ptr, short[] chunk, short[] up, short[] down, short[] north, short[] south, short[] east, short[] west) {
        int index = 0;
        for (int z = 0; z < 16; ++z) {
            for (int y = 0; y < 16; ++y) {
                short v;
                if ((v = chunk[index++]) == 0) continue;
                for (int x = 0; x < 16; ++x) {
                    boolean minusZ;
                    boolean plusZ;
                    boolean minusY;
                    boolean plusY;
                    boolean minusX;
                    boolean plusX;
                    if ((v & 1 << x) == 0) continue;
                    if (x == 0) {
                        plusX = (v & 2) == 0;
                        minusX = east == null || (east[y + z * 16] & 0x8000) == 0;
                    } else if (x == 15) {
                        plusX = west == null || (west[y + z * 16] & 1) == 0;
                        minusX = (v & 0x4000) == 0;
                    } else {
                        plusX = (v & 1 << x + 1) == 0;
                        boolean bl = minusX = (v & 1 << x - 1) == 0;
                    }
                    if (plusX) {
                        ptr = OneshotBooleanRegion.writeVertex(ptr, (float)(x + 1) + 1.0E-5f, y, z, SHADE_X_ABGR);
                        ptr = OneshotBooleanRegion.writeVertex(ptr, (float)(x + 1) + 1.0E-5f, y + 1, z, SHADE_X_ABGR);
                        ptr = OneshotBooleanRegion.writeVertex(ptr, (float)(x + 1) + 1.0E-5f, y + 1, z + 1, SHADE_X_ABGR);
                        ptr = OneshotBooleanRegion.writeVertex(ptr, (float)(x + 1) + 1.0E-5f, y, z + 1, SHADE_X_ABGR);
                    }
                    if (minusX) {
                        ptr = OneshotBooleanRegion.writeVertex(ptr, (float)x - 1.0E-5f, y, z + 1, SHADE_X_ABGR);
                        ptr = OneshotBooleanRegion.writeVertex(ptr, (float)x - 1.0E-5f, y + 1, z + 1, SHADE_X_ABGR);
                        ptr = OneshotBooleanRegion.writeVertex(ptr, (float)x - 1.0E-5f, y + 1, z, SHADE_X_ABGR);
                        ptr = OneshotBooleanRegion.writeVertex(ptr, (float)x - 1.0E-5f, y, z, SHADE_X_ABGR);
                    }
                    if (y == 0) {
                        plusY = (chunk[1 + z * 16] & 1 << x) == 0;
                        minusY = down == null || (down[15 + z * 16] & 1 << x) == 0;
                    } else if (y == 15) {
                        plusY = up == null || (up[z * 16] & 1 << x) == 0;
                        minusY = (chunk[14 + z * 16] & 1 << x) == 0;
                    } else {
                        plusY = (chunk[y + 1 + z * 16] & 1 << x) == 0;
                        boolean bl = minusY = (chunk[y - 1 + z * 16] & 1 << x) == 0;
                    }
                    if (plusY) {
                        ptr = OneshotBooleanRegion.writeVertex(ptr, x, (float)(y + 1) + 1.0E-5f, z + 1, SHADE_PLUS_Y_ABGR);
                        ptr = OneshotBooleanRegion.writeVertex(ptr, x + 1, (float)(y + 1) + 1.0E-5f, z + 1, SHADE_PLUS_Y_ABGR);
                        ptr = OneshotBooleanRegion.writeVertex(ptr, x + 1, (float)(y + 1) + 1.0E-5f, z, SHADE_PLUS_Y_ABGR);
                        ptr = OneshotBooleanRegion.writeVertex(ptr, x, (float)(y + 1) + 1.0E-5f, z, SHADE_PLUS_Y_ABGR);
                    }
                    if (minusY) {
                        ptr = OneshotBooleanRegion.writeVertex(ptr, x, (float)y - 1.0E-5f, z, SHADE_MINUS_Y_ABGR);
                        ptr = OneshotBooleanRegion.writeVertex(ptr, x + 1, (float)y - 1.0E-5f, z, SHADE_MINUS_Y_ABGR);
                        ptr = OneshotBooleanRegion.writeVertex(ptr, x + 1, (float)y - 1.0E-5f, z + 1, SHADE_MINUS_Y_ABGR);
                        ptr = OneshotBooleanRegion.writeVertex(ptr, x, (float)y - 1.0E-5f, z + 1, SHADE_MINUS_Y_ABGR);
                    }
                    if (z == 0) {
                        plusZ = (chunk[y + 16] & 1 << x) == 0;
                        minusZ = north == null || (north[y + 240] & 1 << x) == 0;
                    } else if (z == 15) {
                        plusZ = south == null || (south[y] & 1 << x) == 0;
                        minusZ = (chunk[y + 224] & 1 << x) == 0;
                    } else {
                        plusZ = (chunk[y + (z + 1) * 16] & 1 << x) == 0;
                        boolean bl = minusZ = (chunk[y + (z - 1) * 16] & 1 << x) == 0;
                    }
                    if (plusZ) {
                        ptr = OneshotBooleanRegion.writeVertex(ptr, x, y, (float)(z + 1) + 1.0E-5f, SHADE_Z_ABGR);
                        ptr = OneshotBooleanRegion.writeVertex(ptr, x + 1, y, (float)(z + 1) + 1.0E-5f, SHADE_Z_ABGR);
                        ptr = OneshotBooleanRegion.writeVertex(ptr, x + 1, y + 1, (float)(z + 1) + 1.0E-5f, SHADE_Z_ABGR);
                        ptr = OneshotBooleanRegion.writeVertex(ptr, x, y + 1, (float)(z + 1) + 1.0E-5f, SHADE_Z_ABGR);
                    }
                    if (!minusZ) continue;
                    ptr = OneshotBooleanRegion.writeVertex(ptr, x, y + 1, (float)z - 1.0E-5f, SHADE_Z_ABGR);
                    ptr = OneshotBooleanRegion.writeVertex(ptr, x + 1, y + 1, (float)z - 1.0E-5f, SHADE_Z_ABGR);
                    ptr = OneshotBooleanRegion.writeVertex(ptr, x + 1, y, (float)z - 1.0E-5f, SHADE_Z_ABGR);
                    ptr = OneshotBooleanRegion.writeVertex(ptr, x, y, (float)z - 1.0E-5f, SHADE_Z_ABGR);
                }
            }
        }
        return ptr;
    }

    private static long writeVertex(long buffer, float x, float y, float z, int color) {
        ColorVertex.put((long)buffer, (float)x, (float)y, (float)z, (int)color);
        return buffer + 16L;
    }

    public boolean wantsResort(class_4184 camera, class_243 translation) {
        if (this.sortedChunkData.isEmpty()) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.compiledSortMillis < 250L) {
            return false;
        }
        float sortX = (float)((camera != null ? camera.method_19326().field_1352 : 0.0) - translation.field_1352);
        float sortY = (float)((camera != null ? camera.method_19326().field_1351 : 0.0) - translation.field_1351);
        float sortZ = (float)((camera != null ? camera.method_19326().field_1350 : 0.0) - translation.field_1350);
        double dX = sortX - this.compiledSortX;
        double dY = sortY - this.compiledSortY;
        double dZ = sortZ - this.compiledSortZ;
        return dX * dX + dY * dY + dZ * dZ > 1.0;
    }

    public CompileFuture copyResort(class_4184 camera, class_243 translation) {
        this.doVertexUpload();
        float sortX = (float)((camera != null ? camera.method_19326().field_1352 : 0.0) - translation.field_1352);
        float sortY = (float)((camera != null ? camera.method_19326().field_1351 : 0.0) - translation.field_1351);
        float sortZ = (float)((camera != null ? camera.method_19326().field_1350 : 0.0) - translation.field_1350);
        int sortChunkX = class_4076.method_32204((double)sortX);
        int sortChunkY = class_4076.method_32204((double)sortY);
        int sortChunkZ = class_4076.method_32204((double)sortZ);
        boolean resortChunkList = sortChunkX != this.compiledSortChunkX || sortChunkY != this.compiledSortChunkY || sortChunkZ != this.compiledSortChunkZ;
        Long2ObjectOpenHashMap chunkDataMap = new Long2ObjectOpenHashMap();
        IntrusiveLinkedList<ChunkData> sortedChunkData = new IntrusiveLinkedList<ChunkData>();
        if (resortChunkList) {
            for (Long2ObjectMap.Entry entry : this.chunkDataMap.long2ObjectEntrySet()) {
                ChunkData newChunkData = new ChunkData((ChunkData)entry.getValue());
                chunkDataMap.put(entry.getLongKey(), (Object)newChunkData);
                sortedChunkData.add(newChunkData);
            }
        } else {
            for (ChunkData chunkData : this.sortedChunkData) {
                int chunkX = chunkData.offsetX >> 4;
                int chunkY = chunkData.offsetY >> 4;
                int chunkZ = chunkData.offsetZ >> 4;
                long pos = class_2338.method_10064((int)chunkX, (int)chunkY, (int)chunkZ);
                ChunkData newChunkData = new ChunkData(chunkData);
                chunkDataMap.put(pos, (Object)newChunkData);
                sortedChunkData.add(newChunkData);
            }
        }
        CompileFuture compileFuture = new CompileFuture();
        ChunkedRegionPool.submit(() -> OneshotBooleanRegion.lambda$copyResort$9(sortedChunkData, compileFuture, (Long2ObjectMap)chunkDataMap, sortX, sortY, sortZ, resortChunkList, sortChunkX, sortChunkY, sortChunkZ));
        return compileFuture;
    }

    public CompileFuture copyCompile(PositionSet positionSet, LongSet changed, class_4184 camera, class_243 translation) {
        if (this.sortedChunkData.isEmpty()) {
            return OneshotBooleanRegion.compile(positionSet, camera, translation);
        }
        this.doVertexUpload();
        LongSet keep = positionSet.chunkKeySet();
        LongOpenHashSet dirtyChunks = new LongOpenHashSet();
        LongIterator longIterator = changed.longIterator();
        while (longIterator.hasNext()) {
            long pos = longIterator.nextLong();
            int chunkX = class_2338.method_10061((long)pos);
            int chunkY = class_2338.method_10071((long)pos);
            int chunkZ = class_2338.method_10083((long)pos);
            dirtyChunks.add(class_2338.method_10064((int)(chunkX - 1), (int)chunkY, (int)chunkZ));
            dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)(chunkY - 1), (int)chunkZ));
            dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)chunkY, (int)(chunkZ - 1)));
            dirtyChunks.add(class_2338.method_10064((int)(chunkX + 1), (int)chunkY, (int)chunkZ));
            dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)(chunkY + 1), (int)chunkZ));
            dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)chunkY, (int)(chunkZ + 1)));
            dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)chunkY, (int)chunkZ));
        }
        for (Long2ObjectMap.Entry entry : this.chunkDataMap.long2ObjectEntrySet()) {
            long pos = entry.getLongKey();
            if (keep.contains(pos)) continue;
            int chunkX = class_2338.method_10061((long)pos);
            int chunkY = class_2338.method_10071((long)pos);
            int chunkZ = class_2338.method_10083((long)pos);
            long nx = class_2338.method_10064((int)(chunkX - 1), (int)chunkY, (int)chunkZ);
            long ny = class_2338.method_10064((int)chunkX, (int)(chunkY - 1), (int)chunkZ);
            long nz = class_2338.method_10064((int)chunkX, (int)chunkY, (int)(chunkZ - 1));
            long px = class_2338.method_10064((int)(chunkX + 1), (int)chunkY, (int)chunkZ);
            long py = class_2338.method_10064((int)chunkX, (int)(chunkY + 1), (int)chunkZ);
            long pz = class_2338.method_10064((int)chunkX, (int)chunkY, (int)(chunkZ + 1));
            if (keep.contains(nx)) {
                dirtyChunks.add(nx);
            }
            if (keep.contains(ny)) {
                dirtyChunks.add(ny);
            }
            if (keep.contains(nz)) {
                dirtyChunks.add(nz);
            }
            if (keep.contains(px)) {
                dirtyChunks.add(px);
            }
            if (keep.contains(py)) {
                dirtyChunks.add(py);
            }
            if (!keep.contains(pz)) continue;
            dirtyChunks.add(pz);
        }
        Long2ObjectOpenHashMap chunkDataMap = new Long2ObjectOpenHashMap();
        IntrusiveLinkedList<ChunkData> sortedChunkData = new IntrusiveLinkedList<ChunkData>();
        longIterator = keep.longIterator();
        while (longIterator.hasNext()) {
            ChunkData chunkData;
            long pos = longIterator.nextLong();
            if (dirtyChunks.contains(pos) || (chunkData = (ChunkData)this.chunkDataMap.get(pos)) == null) continue;
            ChunkData clonedChunkData = new ChunkData(chunkData);
            chunkDataMap.put(pos, (Object)clonedChunkData);
            sortedChunkData.add(clonedChunkData);
        }
        CompileFuture future = new CompileFuture();
        ChunkedRegionPool.submit(() -> OneshotBooleanRegion.lambda$copyCompile$11(future, positionSet, (LongSet)dirtyChunks, (Long2ObjectMap)chunkDataMap, sortedChunkData, camera, translation));
        return future;
    }

    private static /* synthetic */ void lambda$copyCompile$11(CompileFuture future, PositionSet positionSet, LongSet dirtyChunks, Long2ObjectMap chunkDataMap, IntrusiveLinkedList sortedChunkData, class_4184 camera, class_243 translation) {
        try {
            OneshotBooleanRegion.compileInner(future, positionSet, dirtyChunks, (Long2ObjectMap<ChunkData>)chunkDataMap, sortedChunkData, camera, translation);
        }
        catch (Exception e) {
            future.exception.set(new ExecutionException(e));
            RenderSystem.recordRenderCall(() -> {
                for (ChunkData chunkData : chunkDataMap.values()) {
                    if (chunkData.buffer == null) continue;
                    chunkData.buffer.close();
                    chunkData.buffer = null;
                }
            });
        }
    }

    private static /* synthetic */ void lambda$copyResort$9(IntrusiveLinkedList sortedChunkData, CompileFuture compileFuture, Long2ObjectMap chunkDataMap, float sortX, float sortY, float sortZ, boolean resortChunkList, int sortChunkX, int sortChunkY, int sortChunkZ) {
        try {
            CleaningBufferBuilder bufferBuilder = new CleaningBufferBuilder(256);
            for (ChunkData chunkData : sortedChunkData) {
                if (compileFuture.cancelled.get()) {
                    RenderSystem.recordRenderCall(() -> {
                        for (ChunkData chunkDatum : chunkDataMap.values()) {
                            if (chunkDatum.buffer == null) continue;
                            chunkDatum.buffer.close();
                            chunkDatum.buffer = null;
                        }
                    });
                    return;
                }
                float relSortX = sortX - (float)chunkData.offsetX;
                float relSortY = sortY - (float)chunkData.offsetY;
                float relSortZ = sortZ - (float)chunkData.offsetZ;
                bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
                bufferBuilder.method_1324(chunkData.sortState);
                bufferBuilder.method_49904(InvertedVertexSorting.byDistance(relSortX, relSortY, relSortZ));
                chunkData.sortState = bufferBuilder.method_1334();
                chunkData.renderedBuffer = bufferBuilder.method_1326();
                if (!resortChunkList) continue;
                float dx = sortChunkX * 16 - chunkData.offsetX;
                float dy = sortChunkY * 16 - chunkData.offsetY;
                float dz = sortChunkZ * 16 - chunkData.offsetZ;
                chunkData.distanceSqToCamera = dx * dx + dy * dy + dz * dz;
            }
            if (resortChunkList) {
                sortedChunkData.sort(Comparator.comparingDouble(c -> c.distanceSqToCamera));
            }
            OneshotBooleanRegion oneshotBooleanRegion = new OneshotBooleanRegion((Long2ObjectMap<ChunkData>)chunkDataMap, sortedChunkData);
            oneshotBooleanRegion.setSortInfo(System.currentTimeMillis(), sortX, sortY, sortZ, sortChunkX, sortChunkY, sortChunkZ);
            compileFuture.value.set(oneshotBooleanRegion);
            if (compileFuture.cancelled.get()) {
                RenderSystem.recordRenderCall(() -> {
                    for (ChunkData chunkData : chunkDataMap.values()) {
                        if (chunkData.buffer == null) continue;
                        chunkData.buffer.close();
                        chunkData.buffer = null;
                    }
                });
            }
        }
        catch (Exception e) {
            compileFuture.exception.set(new ExecutionException(e));
            RenderSystem.recordRenderCall(() -> {
                for (ChunkData chunkData : chunkDataMap.values()) {
                    if (chunkData.buffer == null) continue;
                    chunkData.buffer.close();
                    chunkData.buffer = null;
                }
            });
        }
    }

    private static /* synthetic */ void lambda$compileInner$4(Long2ObjectMap chunkDataMap) {
        for (ChunkData chunkData : chunkDataMap.values()) {
            if (chunkData.buffer == null) continue;
            chunkData.buffer.close();
            chunkData.buffer = null;
        }
    }

    private static /* synthetic */ double lambda$compileInner$3(ChunkData c) {
        return c.distanceSqToCamera;
    }

    private static /* synthetic */ void lambda$compileInner$2(Long2ObjectMap chunkDataMap) {
        for (ChunkData chunkData : chunkDataMap.values()) {
            if (chunkData.buffer == null) continue;
            chunkData.buffer.close();
            chunkData.buffer = null;
        }
    }

    private static final class ChunkData
    extends IntrusiveLinkedElement<ChunkData> {
        class_291 buffer = null;
        class_287.class_7433 renderedBuffer = null;
        class_287.class_5594 sortState = null;
        final int offsetX;
        final int offsetY;
        final int offsetZ;
        float distanceSqToCamera;

        public ChunkData(int offsetX, int offsetY, int offsetZ) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
        }

        public void upload() {
            if (this.renderedBuffer != null) {
                if (this.buffer == null) {
                    this.buffer = new class_291(class_291.class_8555.field_44793);
                }
                this.buffer.method_1353();
                this.buffer.method_1352(this.renderedBuffer);
                this.renderedBuffer = null;
            }
        }

        public ChunkData(ChunkData other) {
            if (other.buffer == null) {
                throw new IllegalStateException("ChunkData 'other' can't be cloned until uploaded");
            }
            this.buffer = new class_291(class_291.class_8555.field_44793);
            ((VertexBufferExt)this.buffer).copyFrom(other.buffer);
            this.sortState = other.sortState;
            this.offsetX = other.offsetX;
            this.offsetY = other.offsetY;
            this.offsetZ = other.offsetZ;
            this.distanceSqToCamera = other.distanceSqToCamera;
        }
    }

    public static class CompileFuture {
        private final AtomicBoolean cancelled = new AtomicBoolean(false);
        private final AtomicReference<OneshotBooleanRegion> value = new AtomicReference<Object>(null);
        private final AtomicReference<ExecutionException> exception = new AtomicReference();

        public void cancel() {
            this.cancelled.set(true);
            OneshotBooleanRegion value = this.value.get();
            if (value != null) {
                value.close();
            }
        }

        public OneshotBooleanRegion getIfDone() throws ExecutionException {
            OneshotBooleanRegion value = this.value.get();
            boolean cancelled = this.cancelled.get();
            ExecutionException executionException = this.exception.get();
            if (executionException != null) {
                if (value != null) {
                    value.close();
                }
                throw executionException;
            }
            if (cancelled) {
                if (value != null) {
                    value.close();
                }
                throw new CancellationException();
            }
            return value;
        }
    }
}

