/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.annotator;

import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.annotator.QuantizedUnitVector;
import imgui.ImGui;
import imgui.type.ImString;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_8251;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class AnnotatorTool
implements Tool {
    private final List<class_243> points = new ArrayList<class_243>();
    private class_243 textPosition = null;
    private float textRotationDegrees = 0.0f;
    private class_2350 textDirection = null;
    private class_243 movingOffset = null;
    private final ImString text = new ImString(1024);
    private final int[] textDisplayMode = new int[]{0};
    private final int[] textScale = new int[]{100};
    private final int[] textAlignment = new int[]{0};
    private final int[] textSeeThrough = new int[]{0};
    private boolean textBackground = false;
    private final float[] textColor = new float[4];
    private boolean textShadow = false;

    @Override
    public void reset() {
        this.points.clear();
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                RayCaster.RaycastResult result = Tool.raycastBlock(false, true, true);
                if (result != null) {
                    this.textPosition = result.getLocation();
                    this.textDirection = result.getDirection();
                    if (this.textDirection.method_10166() == class_2350.class_2351.field_11052) {
                        class_243 delta = this.textPosition.method_1020(class_310.method_1551().field_1719.method_19538());
                        float directionDegrees = (float)Math.toDegrees(Math.atan2(delta.field_1350, delta.field_1352)) + 90.0f;
                        float cameraDegrees = 180.0f + class_310.method_1551().field_1719.method_36454();
                        this.textRotationDegrees = class_3532.method_17821((float)0.4f, (float)directionDegrees, (float)cameraDegrees);
                    } else {
                        this.textRotationDegrees = 0.0f;
                    }
                }
                return UserAction.ActionResult.USED_STOP;
            }
            case LEFT_MOUSE: {
                break;
            }
            case DELETE: {
                this.points.clear();
                return UserAction.ActionResult.USED_STOP;
            }
            case UNDO: {
                if (this.points.size() > 0) {
                    this.points.remove(this.points.size() - 1);
                }
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        matrices.method_22903();
        matrices.method_22904(-camera.method_19326().field_1352, -camera.method_19326().field_1351, -camera.method_19326().field_1350);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.lineWidth((float)2.0f);
        RenderSystem.setShader(class_757::method_34535);
        RenderSystem.enableDepthTest();
        this.drawPoints(matrices, 1.0f);
        RenderSystem.disableDepthTest();
        this.drawPoints(matrices, 0.35f);
        class_327 font = class_310.method_1551().field_1772;
        if (this.textPosition != null) {
            float backgroundOpacity;
            matrices.method_22903();
            matrices.method_22904(this.textPosition.method_10216() + (double)(0.01f * (float)this.textDirection.method_10148()), this.textPosition.method_10214() + (double)(0.01f * (float)this.textDirection.method_10164()), this.textPosition.method_10215() + (double)(0.01f * (float)this.textDirection.method_10165()));
            matrices.method_22907(this.textDirection.method_23224());
            matrices.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
            matrices.method_22907(class_7833.field_40718.rotationDegrees(-this.textRotationDegrees));
            class_5250 literal = class_2561.method_43470((String)ImGuiHelper.getString(this.text).trim());
            List sequence = font.method_1728((class_5348)literal, Integer.MAX_VALUE);
            class_4597.class_4598 multiBufferSource = class_310.method_1551().method_22940().method_23000();
            int alpha = (int)(this.textColor[3] * 255.0f);
            int seeThroughAlpha = (int)(this.textColor[3] * (float)this.textSeeThrough[0] / 100.0f * 255.0f);
            int height = sequence.size() * 8;
            float y = (float)(-height) / 2.0f;
            int maximumWidth = 0;
            for (class_5481 text : sequence) {
                maximumWidth = Math.max(maximumWidth, font.method_30880(text));
            }
            float x = 0.0f;
            if (this.textAlignment[0] == 0) {
                x = (float)(-maximumWidth) / 2.0f;
            } else if (this.textAlignment[0] == 2) {
                x = -maximumWidth;
            }
            float scale = (float)this.textScale[0] / 100.0f / 8.0f;
            class_287 bufferBuilder = class_289.method_1348().method_1349();
            bufferBuilder.method_1328(class_293.class_5596.field_27377, class_290.field_29337);
            matrices.method_22903();
            matrices.method_22905(scale, scale, scale);
            Matrix4f pose = matrices.method_23760().method_23761();
            Matrix3f normal = matrices.method_23760().method_23762();
            bufferBuilder.method_22918(pose, x - 1.0f, y - 1.0f, 0.0f).method_39415(-16711681).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
            bufferBuilder.method_22918(pose, x - 1.0f, y + (float)height + 1.0f, 0.0f).method_39415(-16711681).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
            bufferBuilder.method_22918(pose, x - 1.0f, y + (float)height + 1.0f, 0.0f).method_39415(-16711681).method_23763(normal, 1.0f, 0.0f, 0.0f).method_1344();
            bufferBuilder.method_22918(pose, x + (float)maximumWidth + 1.0f, y + (float)height + 1.0f, 0.0f).method_39415(-16711681).method_23763(normal, 1.0f, 0.0f, 0.0f).method_1344();
            bufferBuilder.method_22918(pose, x + (float)maximumWidth + 1.0f, y + (float)height + 1.0f, 0.0f).method_39415(-16711681).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
            bufferBuilder.method_22918(pose, x + (float)maximumWidth + 1.0f, y - 1.0f, 0.0f).method_39415(-16711681).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
            bufferBuilder.method_22918(pose, x + (float)maximumWidth + 1.0f, y - 1.0f, 0.0f).method_39415(-16711681).method_23763(normal, -1.0f, 0.0f, 0.0f).method_1344();
            bufferBuilder.method_22918(pose, x - 1.0f, y - 1.0f, 0.0f).method_39415(-16711681).method_23763(normal, -1.0f, 0.0f, 0.0f).method_1344();
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
            matrices.method_22909();
            matrices.method_22905(scale, -scale, scale);
            Matrix4f pose2 = matrices.method_23760().method_23761();
            if (this.textBackground && (backgroundOpacity = 0.5f * this.textColor[3] * 255.0f) > 25.0f) {
                int argb = (int)backgroundOpacity << 24;
                class_4588 vertexConsumer = multiBufferSource.getBuffer(class_1921.method_49045());
                vertexConsumer.method_22918(pose2, x - 1.0f, y - 1.0f, 0.0f).method_39415(argb).method_22916(0xF000F0).method_1344();
                vertexConsumer.method_22918(pose2, x - 1.0f, y + (float)height + 1.0f, 0.0f).method_39415(argb).method_22916(0xF000F0).method_1344();
                vertexConsumer.method_22918(pose2, x + (float)maximumWidth + 1.0f, y + (float)height + 1.0f, 0.0f).method_39415(argb).method_22916(0xF000F0).method_1344();
                vertexConsumer.method_22918(pose2, x + (float)maximumWidth + 1.0f, y - 1.0f, 0.0f).method_39415(argb).method_22916(0xF000F0).method_1344();
            }
            if (alpha > 25) {
                int colour = class_5253.class_5254.method_27764((int)alpha, (int)((int)(this.textColor[0] * 255.0f)), (int)((int)(this.textColor[1] * 255.0f)), (int)((int)(this.textColor[2] * 255.0f)));
                int seeThroughColour = class_5253.class_5254.method_27764((int)seeThroughAlpha, (int)((int)(this.textColor[0] * 255.0f)), (int)((int)(this.textColor[1] * 255.0f)), (int)((int)(this.textColor[2] * 255.0f)));
                for (class_5481 text : sequence) {
                    int width = font.method_30880(text);
                    x = 0.0f;
                    if (this.textAlignment[0] == 0) {
                        x = (float)(-width) / 2.0f;
                    } else if (this.textAlignment[0] == 2) {
                        x = -width;
                    }
                    if (seeThroughAlpha > 25) {
                        font.method_22942(text, x, y, seeThroughColour, this.textShadow, pose2, (class_4597)multiBufferSource, class_327.class_6415.field_33994, 0, 0xF000F0);
                    }
                    font.method_22942(text, x, y, colour, this.textShadow, pose2, (class_4597)multiBufferSource, class_327.class_6415.field_33995, 0, 0xF000F0);
                    y += 8.0f;
                }
            }
            multiBufferSource.method_22993();
            matrices.method_22909();
        }
        RenderSystem.enableCull();
        matrices.method_22909();
    }

    private void drawText(class_4587 matrix, Matrix4f projection) {
        float scale = 2.0f * Math.max(1.0f, Math.min(ImGui.getIO().getDisplayFramebufferScaleX(), ImGui.getIO().getDisplayFramebufferScaleY()));
        float width = (float)class_310.method_1551().method_22683().method_4489() / scale;
        float height = (float)class_310.method_1551().method_22683().method_4506() / scale;
        class_327 font = class_310.method_1551().field_1772;
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, width, height, 0.0f, 1000.0f, 3000.0f);
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (class_8251)class_8251.field_43361);
        class_4587 poseStack = RenderSystem.getModelViewStack();
        poseStack.method_22903();
        poseStack.method_34426();
        poseStack.method_46416(0.0f, 0.0f, -2000.0f);
        RenderSystem.applyModelViewMatrix();
        float fog = RenderSystem.getShaderFogStart();
        RenderSystem.setShaderFogStart((float)Float.MAX_VALUE);
        AnnotatorTool.renderProjectedText("Hello World", matrix, projection, (float)this.textPosition.field_1352 + 0.5f, (float)this.textPosition.field_1351 + 0.5f, (float)this.textPosition.field_1350 + 0.5f, scale, width, height, font);
        class_310.method_1551().method_22940().method_23000().method_22993();
        RenderSystem.setShaderFogStart((float)fog);
        poseStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.restoreProjectionMatrix();
    }

    private static void renderProjectedText(String text, class_4587 matrix, Matrix4f projection, float x, float y, float z, float scale, float width, float height, class_327 font) {
        Vector4f transformed = matrix.method_23760().method_23761().transform(new Vector4f(x, y, z, 1.0f));
        transformed = projection.transform(transformed);
        int stringWidth = class_310.method_1551().field_1772.method_1727(text);
        if (transformed.w < 0.0f) {
            return;
        }
        float screenX = (float)Math.round(((transformed.x / transformed.w * 0.5f + 0.5f) * width - (float)stringWidth / 2.0f) * scale) / scale;
        float f = (-transformed.y / transformed.w * 0.5f + 0.5f) * height;
        Objects.requireNonNull(font);
        float screenY = (float)Math.round((f - 9.0f / 2.0f) * scale) / scale;
        font.method_37296(class_2561.method_43470((String)text).method_30937(), screenX, screenY, -3351041, -13420737, new Matrix4f(), (class_4597)class_310.method_1551().method_22940().method_23000(), 0xF000F0);
    }

    private void addNewPoint() {
        RayCaster.RaycastResult result = Tool.raycastBlock(false, true, true);
        if (result != null) {
            class_243 position = result.getLocation();
            if (this.points.size() > 0) {
                class_243 lastPoint = this.points.get(this.points.size() - 1);
                if (lastPoint.method_1025(position) < 0.25) {
                    return;
                }
                int deltaId = QuantizedUnitVector.getClosest(position.method_1020(lastPoint));
                class_243 delta = QuantizedUnitVector.lookup(deltaId);
                this.points.add(lastPoint.method_1019(delta.method_1021(0.5)));
            } else {
                this.points.add(position);
            }
        }
    }

    private void drawPoints(class_4587 matrices, float opacity) {
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27377, class_290.field_29337);
        Matrix4f pose = matrices.method_23760().method_23761();
        Matrix3f normal = matrices.method_23760().method_23762();
        for (int i = 0; i < this.points.size() - 1; ++i) {
            class_243 from = this.points.get(i);
            class_243 to = this.points.get(i + 1);
            float dx = (float)(to.field_1352 - from.field_1352);
            float dy = (float)(to.field_1351 - from.field_1351);
            float dz = (float)(to.field_1350 - from.field_1350);
            float distanceInv = 1.0f / (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
            bufferBuilder.method_22918(pose, (float)from.field_1352, (float)from.field_1351, (float)from.field_1350).method_22915(1.0f, 0.1f, 0.1f, opacity).method_23763(normal, dx *= distanceInv, dy *= distanceInv, dz *= distanceInv).method_1344();
            bufferBuilder.method_22918(pose, (float)to.field_1352, (float)to.field_1351, (float)to.field_1350).method_22915(1.0f, 0.1f, 0.1f, opacity).method_23763(normal, dx, dy, dz).method_1344();
        }
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    @Override
    public void displayImguiOptions() {
        ImGui.inputTextMultiline("Text", this.text, 0.0f, ImGui.getTextLineHeightWithSpacing() * 3.0f);
        ImGuiHelper.combo("Display Mode", this.textDisplayMode, new String[]{"Screen", "Billboard", "Flat"});
        ImGui.sliderInt("Scale", this.textScale, 0, 500, "%d%%");
        ImGuiHelper.combo("Alignment", this.textAlignment, new String[]{"Center", "Left", "Right"});
        ImGui.sliderInt("See Through", this.textSeeThrough, 0, 100, "%d%%");
        ImGui.colorEdit4("Text Color", this.textColor);
        if (ImGui.checkbox("Background", this.textBackground)) {
            boolean bl = this.textBackground = !this.textBackground;
        }
        if (ImGui.checkbox("Shadow", this.textShadow)) {
            this.textShadow = !this.textShadow;
        }
    }

    @Override
    public String name() {
        return "Annotator";
    }

    @Override
    public void writeSourceInfo(class_2487 tag, boolean includeSettings) {
        throw new UnsupportedOperationException("Annotator Tool is not a source");
    }

    @Override
    public void writeSettings(class_2487 tag) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadSettings(class_2487 tag) {
        throw new UnsupportedOperationException();
    }

    @Override
    public char iconChar() {
        return '\ue909';
    }

    @Override
    public String keybindId() {
        return "annotator";
    }
}

