/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.generator;

import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.tools.generator.SpaceColonization;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class TreeGeneration {
    public static ChunkedBlockRegion generate(class_1937 level, class_2338 pos) {
        SpaceColonization.TreeNode root;
        ChunkedBlockRegion region = new ChunkedBlockRegion();
        ArrayList<class_243> attractionPoints = new ArrayList<class_243>();
        ThreadLocalRandom random2 = ThreadLocalRandom.current();
        int height = 15 + ((Random)random2).nextInt(15);
        for (int i = 0; i < 1000; ++i) {
            float angle = ((Random)random2).nextFloat() * 2.0f * (float)Math.PI;
            float angleX = (float)Math.sin(angle);
            float angleZ = (float)Math.cos(angle);
            double y = ((Random)random2).nextFloat() * (float)(height - 5) + 5.0f;
            double spread = ((double)height - y) * (double)0.7f + 4.0;
            double randomSpread = (double)((Random)random2).nextFloat() * spread;
            attractionPoints.add(new class_243((double)pos.method_10263() + 0.5 + (double)angleX * randomSpread, (double)pos.method_10264() + 0.5 + y, (double)pos.method_10260() + 0.5 + (double)angleZ * randomSpread));
        }
        for (class_243 attractionPoint : attractionPoints) {
            region.addBlockWithoutDirty((int)attractionPoint.field_1352, (int)attractionPoint.field_1351, (int)attractionPoint.field_1350, class_2246.field_10357.method_9564());
        }
        SpaceColonization.TreeNode last = root = new SpaceColonization.TreeNode(class_243.method_24953((class_2382)pos));
        for (int i = 0; i < height; ++i) {
            SpaceColonization.TreeNode newNode = new SpaceColonization.TreeNode(class_243.method_24953((class_2382)pos).method_1031(0.0, (double)i, 0.0));
            last.children.add(newNode);
            last = newNode;
        }
        SpaceColonization.colonize(root, attractionPoints, 3.0f, 6.0f);
        root.generate(region);
        return region;
    }

    private static void addToList(List<TreeNode> nodes, TreeNode node) {
        nodes.add(node);
        for (TreeNode child : node.children) {
            TreeGeneration.addToList(nodes, child);
        }
    }

    private static class TreeNode {
        private final class_243 position;
        private final List<TreeNode> children;
        private float area;
        private float length = 0.0f;
        private float lengthToChildren = 0.0f;
        private Vector4f direction = new Vector4f(0.0f, 1.0f, 0.0f, 1.0f);

        public TreeNode(class_243 position, List<TreeNode> children, float area) {
            this.position = position;
            this.children = children;
            this.area = area;
        }

        private void grow(float feed) {
            if (this.children.isEmpty()) {
                float cbrt = (float)Math.cbrt(feed);
                this.length += cbrt;
                this.area += (feed -= cbrt * this.area) / this.length;
                if (this.length > 1.0f && this.direction != null) {
                    class_243 direction = new class_243((double)(this.direction.x / this.direction.w), (double)(this.direction.y / this.direction.w), (double)(this.direction.z / this.direction.w)).method_1029();
                    TreeNode child = new TreeNode(this.position.method_1019(direction), new ArrayList<TreeNode>(), 0.1f);
                    child.direction = this.direction;
                    this.direction = null;
                    this.children.add(child);
                    this.lengthToChildren = 1.0f;
                    this.length = 0.0f;
                }
            } else {
                float pass;
                if (this.direction != null) {
                    float cbrt = (float)Math.cbrt(feed);
                    this.length += cbrt;
                    feed -= cbrt * this.area;
                    if (this.length > 1.0f) {
                        class_243 direction = new class_243((double)(this.direction.x / this.direction.w), (double)(this.direction.y / this.direction.w), (double)(this.direction.z / this.direction.w)).method_1029();
                        TreeNode child = new TreeNode(this.position.method_1019(direction), new ArrayList<TreeNode>(), 0.1f);
                        child.direction = this.direction;
                        this.direction = null;
                        this.children.add(child);
                        this.lengthToChildren += 1.0f;
                        this.length = 0.0f;
                    }
                }
                if ((double)feed <= 1.0E-5) {
                    return;
                }
                if (this.children.size() == 1) {
                    pass = 0.02f;
                } else {
                    float childSum = 0.0f;
                    for (TreeNode child : this.children) {
                        childSum += child.area;
                    }
                    pass = childSum / (childSum + this.area);
                }
                this.area += pass * feed / this.lengthToChildren;
                feed *= 1.0f - pass;
                if ((double)feed > 1.0E-5) {
                    float perChild = feed / (float)this.children.size();
                    for (TreeNode child : this.children) {
                        child.grow(perChild);
                    }
                }
            }
        }

        private void generate(ChunkedBlockRegion region) {
            Vector3f start = new Vector3f((float)this.position.field_1352, (float)this.position.field_1351, (float)this.position.field_1350);
            boolean radius = false;
            region.addBlockWithoutDirty((int)Math.floor(this.position.field_1352), (int)Math.floor(this.position.field_1351), (int)Math.floor(this.position.field_1350), class_2246.field_9999.method_9564());
            if (this.children.size() > 0) {
                for (TreeNode child : this.children) {
                    Vector3f end = new Vector3f((float)child.position.field_1352, (float)child.position.field_1351, (float)child.position.field_1350);
                    child.generate(region);
                }
            } else if (this.direction != null) {
                Vector3f vector3f = new Vector3f((float)this.position.field_1352 + this.direction.x * this.length, (float)this.position.field_1351 + this.direction.y * this.length, (float)this.position.field_1350 + this.direction.z * this.length);
            }
        }
    }
}

