/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.rock;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.brush_shapes.BrushShape;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.collections.Position2FloatMap;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.BrushWidget;
import com.moulberry.axiom.editor.widgets.PresetWidget;
import com.moulberry.axiom.funcinterfaces.IntIntIntFloatConsumer;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.noise.NoiseInterface;
import com.moulberry.axiom.noise.SimplexNoise;
import com.moulberry.axiom.pather.async.AsyncToolPathProvider;
import com.moulberry.axiom.pather.async.AsyncToolPatherMinSDF;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.GaussianBlurTable;
import com.moulberry.axiom.utils.NbtGetter;
import com.moulberry.axiom.utils.RegionHelper;
import imgui.ImGui;
import imgui.type.ImString;
import java.text.NumberFormat;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.joml.Matrix4f;

public class RockTool
implements Tool {
    private final ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
    private boolean painting = false;
    private final Position2FloatMap influenceMap = new Position2FloatMap();
    private final PositionSet calculatedSet = new PositionSet();
    private final Position2FloatMap smoothedInfluenceMap = new Position2FloatMap();
    private GaussianBlurTable gaussianBlur = null;
    private AsyncToolPathProvider pathProvider = null;
    private NoiseInterface noise = null;
    private MaskElement cachedDestMask = null;
    private MaskContext cachedMaskContext = null;
    private final BrushWidget brushWidget = new BrushWidget();
    private final int[] noiseRadius = new int[]{5};
    private final float[] noisiness = new float[]{0.5f};
    private final float[] smoothingStddev = new float[]{2.0f};
    private final ImString noiseSeed = new ImString();
    private final float[] solidBlockInfluence = new float[]{2.0f};
    private final PresetWidget presetWidget = new PresetWidget(this, "rock");

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case UNDO: {
                if (!this.painting) {
                    return UserAction.ActionResult.NOT_HANDLED;
                }
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
            case ESCAPE: {
                if (this.painting) {
                    this.reset();
                    return UserAction.ActionResult.USED_STOP;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case RIGHT_MOUSE: {
                this.rightClick();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @Override
    public void reset() {
        this.painting = false;
        if (this.pathProvider != null) {
            this.pathProvider.close();
            this.pathProvider = null;
        }
        this.cachedDestMask = null;
        this.cachedMaskContext = null;
        this.influenceMap.clear();
        this.calculatedSet.clear();
        this.smoothedInfluenceMap.clear();
        this.chunkedBlockRegion.clear();
    }

    private void rightClick() {
        if (!this.painting) {
            long seed;
            this.influenceMap.clear();
            this.calculatedSet.clear();
            this.chunkedBlockRegion.clear();
            this.painting = true;
            String seedStr = ImGuiHelper.getString(this.noiseSeed).trim();
            if (seedStr.isEmpty()) {
                seed = ThreadLocalRandom.current().nextLong();
            } else {
                try {
                    seed = Long.parseLong(seedStr);
                }
                catch (NumberFormatException numberFormatException) {
                    seed = 0L;
                    for (char c : seedStr.toCharArray()) {
                        seed = 31L * seed + (long)c;
                    }
                }
            }
            this.noise = new SimplexNoise(seed);
            BrushShape brushShape = this.brushWidget.getBrushShape();
            this.pathProvider = new AsyncToolPathProvider(new AsyncToolPatherMinSDF(brushShape, this.createPatherTask()));
            float threshold = 0.01f;
            if (this.solidBlockInfluence[0] > 1.5f) {
                float solidBlockReinfluenceFactor = (this.solidBlockInfluence[0] - 1.0f) * 2.0f;
                threshold = 0.01f / solidBlockReinfluenceFactor;
            }
            this.gaussianBlur = new GaussianBlurTable(this.smoothingStddev[0], threshold);
        }
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        if (!this.painting) {
            RayCaster.RaycastResult result = Tool.raycastBlock();
            if (result == null) {
                Selection.render(camera, time, matrices, projection, 7);
                return;
            }
            Selection.render(camera, time, matrices, projection, 4);
            this.brushWidget.renderPreview(camera, class_243.method_24954((class_2382)result.getBlockPos()), matrices, projection, time, 1);
        } else if (Tool.cancelUsing()) {
            this.reset();
        } else if (!Tool.isMouseDown(1)) {
            class_2487 sourceInfo = Tool.getSourceInfo(this);
            String countString = NumberFormat.getInstance().format(this.chunkedBlockRegion.count());
            String historyDescription = AxiomI18n.get("axiom.history_description.rock_tool", countString);
            RegionHelper.pushBlockRegionChange(this.chunkedBlockRegion, historyDescription, sourceInfo);
            this.reset();
        } else {
            class_638 world = Objects.requireNonNull(class_310.method_1551().field_1687);
            class_2680 block = Tool.getActiveBlock();
            Selection.render(camera, time, matrices, projection, 4);
            if (this.cachedDestMask == null) {
                this.cachedDestMask = MaskManager.getDestMask();
                this.cachedMaskContext = new MaskContext((class_1937)world);
            }
            this.pathProvider.update();
            this.performSmoothing(world, this.cachedDestMask, this.cachedMaskContext, block);
            this.smoothedInfluenceMap.clear();
            float opacity = (float)Math.sin((float)time / 1000000.0f / 50.0f / 8.0f);
            this.chunkedBlockRegion.render(camera, class_243.field_1353, matrices, projection, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
        }
    }

    private void performSmoothing(class_638 world, MaskElement destMask, MaskContext maskContext, class_2680 block) {
        if (!this.gaussianBlur.isSingleValued()) {
            Position2FloatMap reinfluenceMap = new Position2FloatMap();
            float[] table = this.gaussianBlur.getTable();
            float threshold = 0.08f + table[table.length / 2] * 0.92f;
            float solidBlockReinfluenceFactor = this.solidBlockInfluence[0] < 1.1f ? 0.0f : (this.solidBlockInfluence[0] - 1.0f) * 2.0f;
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            this.gaussianBlur.applyBlurCheckThreshold(this.smoothedInfluenceMap, this.influenceMap, threshold, (x, y, z) -> {
                if (!destMask.test(maskContext.reset(), x, y, z)) {
                    return;
                }
                if (!world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z)).method_51366()) {
                    this.chunkedBlockRegion.addBlock(x, y, z, block);
                } else if (solidBlockReinfluenceFactor > 0.0f) {
                    reinfluenceMap.put(x, y, z, solidBlockReinfluenceFactor);
                }
            });
            if (solidBlockReinfluenceFactor > 0.0f) {
                this.gaussianBlur.applyBlurCheckThreshold(reinfluenceMap, this.influenceMap, threshold, (x, y, z) -> {
                    if (!destMask.test(maskContext.reset(), x, y, z)) {
                        return;
                    }
                    if (world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z)).method_51366()) {
                        return;
                    }
                    this.chunkedBlockRegion.addBlock(x, y, z, block);
                });
            }
        }
    }

    private IntIntIntFloatConsumer createPatherTask() {
        class_638 world = Objects.requireNonNull(class_310.method_1551().field_1687);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        MaskElement destMaskElement = MaskManager.getDestMask();
        MaskContext maskContext = new MaskContext((class_1937)world);
        float noisiness = this.noisiness[0];
        float scale = 1.0f / (float)this.noiseRadius[0];
        class_2680 blockState = Tool.getActiveBlock();
        return (x, y, z, distance) -> {
            float noise;
            if (this.calculatedSet.contains(x, y, z)) {
                return;
            }
            if ((double)noisiness >= 0.01) {
                float v = this.noise.evaluate(((double)x + 0.5) * (double)scale, ((double)y + 0.5) * (double)scale, ((double)z + 0.5) * (double)scale);
                noise = v * noisiness + (1.0f - noisiness);
            } else {
                noise = 1.0f;
            }
            if (distance < noise) {
                boolean isAir;
                this.calculatedSet.add(x, y, z);
                boolean bl = isAir = !world.method_8320((class_2338)mutable.method_10103(x, y, z)).method_51366();
                if (this.gaussianBlur.isSingleValued()) {
                    if (!isAir) {
                        return;
                    }
                    if (!destMaskElement.test(maskContext.reset(), x, y, z)) {
                        return;
                    }
                    this.chunkedBlockRegion.addBlock(x, y, z, blockState);
                } else {
                    this.smoothedInfluenceMap.put(x, y, z, isAir ? 1.0f : 1.0f + Math.min(1.0f, this.solidBlockInfluence[0]));
                }
            }
        };
    }

    @Override
    public void displayImguiOptions() {
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.brush"));
        boolean changed = this.brushWidget.displayImgui();
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.noise"));
        ImGuiHelper.Label noiseRadius = ImGuiHelper.translateLabel("axiom.tool.rock.noise_radius");
        ImGuiHelper.Label noisiness = ImGuiHelper.translateLabel("axiom.tool.rock.noisiness");
        ImGuiHelper.Label noiseFieldSeed = ImGuiHelper.translateLabel("axiom.tool.rock.noise_field_seed");
        ImGuiHelper.LabelPosition labelPosition = ImGuiHelper.calcLabelPosition(noiseRadius, noisiness, noiseFieldSeed);
        changed |= ImGuiHelper.drawLabelledWidget(noiseRadius, labelPosition, label -> ImGui.sliderInt(label, this.noiseRadius, 5, 30));
        changed |= ImGuiHelper.drawLabelledWidget(noisiness, labelPosition, label -> ImGui.sliderFloat(label, this.noisiness, 0.0f, 1.0f, "%.2f"));
        changed |= ImGuiHelper.drawLabelledWidget(noiseFieldSeed, labelPosition, label -> ImGui.inputTextWithHint(label, AxiomI18n.get("axiom.tool.rock.noise_field_seed.hint"), this.noiseSeed));
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.smoothing_options"));
        ImGuiHelper.Label smoothingStdDev = ImGuiHelper.translateLabel("axiom.tool.rock.smoothing_stddev");
        ImGuiHelper.Label meldStrength = ImGuiHelper.translateLabel("axiom.tool.rock.meld_strength");
        labelPosition = ImGuiHelper.calcLabelPosition(smoothingStdDev, meldStrength);
        changed |= ImGuiHelper.drawLabelledWidget(smoothingStdDev, labelPosition, label -> ImGui.sliderFloat(label, this.smoothingStddev, 0.0f, 5.0f, "%.2f"));
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.presets"));
        this.presetWidget.displayImgui(changed |= ImGuiHelper.drawLabelledWidget(meldStrength, labelPosition, label -> ImGui.sliderFloat(label, this.solidBlockInfluence, 0.0f, 3.0f, "%.2f")));
    }

    @Override
    public String listenForEsc() {
        if (!this.painting) {
            return null;
        }
        return AxiomI18n.get("axiom.widget.cancel");
    }

    @Override
    public boolean initiateAdjustment() {
        return this.brushWidget.initiateAdjustment();
    }

    @Override
    public class_241 renderAdjustment(float mouseX, float mouseY, class_241 mouseDelta) {
        return this.brushWidget.renderAdjustment(mouseX, mouseY, mouseDelta);
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.rock");
    }

    @Override
    public void writeSourceInfo(class_2487 tag, boolean includeSettings) {
        tag.method_10582("SourceName", "Rock Tool");
        if (includeSettings) {
            class_2487 settings = new class_2487();
            this.writeSettings(settings);
            tag.method_10566("SourceSettings", (class_2520)settings);
        }
    }

    @Override
    public void writeSettings(class_2487 tag) {
        this.brushWidget.writeSettings(tag);
        tag.method_10569("NoiseRadius", this.noiseRadius[0]);
        tag.method_10548("Noisiness", this.noisiness[0]);
        tag.method_10548("SmoothingStddev", this.smoothingStddev[0]);
        tag.method_10582("NoiseSeed", ImGuiHelper.getString(this.noiseSeed));
        tag.method_10548("SolidBlockInfluence", this.solidBlockInfluence[0]);
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.brushWidget.loadSettings(tag);
        this.noiseRadius[0] = NbtGetter.getIntOrDefault(tag, "NoiseRadius", 5);
        this.noisiness[0] = NbtGetter.getFloatOrDefault(tag, "Noisiness", 0.5f);
        this.smoothingStddev[0] = NbtGetter.getFloatOrDefault(tag, "SmoothingStddev", 2.0f);
        this.noiseSeed.set(NbtGetter.getStringOrDefault(tag, "NoiseSeed", ""), false);
        this.solidBlockInfluence[0] = NbtGetter.getFloatOrDefault(tag, "SolidBlockInfluence", 2.0f);
    }

    @Override
    public char iconChar() {
        return '\ue906';
    }

    @Override
    public String keybindId() {
        return "rock";
    }

    @Override
    public int defaultKeybind() {
        return 72;
    }
}

