/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.ruler;

import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.ToolManager;
import com.moulberry.axiom.utils.NbtGetter;
import imgui.ImGui;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3726;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_8251;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class RulerTool
implements Tool {
    private static final int[] displayMode = new int[]{0};
    private static final List<class_2338> points = new ArrayList<class_2338>();
    private class_2338 minimum = null;
    private class_2338 maximum = null;
    private float totalLengthEuclidean = 0.0f;
    private int totalLengthManhattan = 0;

    @Override
    public void reset() {
        this.totalLengthEuclidean = 0.0f;
        this.totalLengthManhattan = 0;
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                RayCaster.RaycastResult result = Tool.raycastBlock(false, true, true);
                if (result != null) {
                    class_2338 pos = result.getBlockPos();
                    if (!points.isEmpty() && points.get(points.size() - 1).equals((Object)pos)) {
                        return UserAction.ActionResult.USED_STOP;
                    }
                    points.add(result.getBlockPos());
                    this.recalculate();
                }
                return UserAction.ActionResult.USED_STOP;
            }
            case DELETE: {
                points.clear();
                this.totalLengthEuclidean = 0.0f;
                this.totalLengthManhattan = 0;
                this.minimum = null;
                this.maximum = null;
                return UserAction.ActionResult.USED_STOP;
            }
            case UNDO: {
                if (points.size() <= 0) break;
                points.remove(points.size() - 1);
                this.recalculate();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrix, Matrix4f projection) {
    }

    public static void renderPoints(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        if (points.isEmpty()) {
            return;
        }
        matrices.method_22903();
        matrices.method_22904(-camera.method_19326().field_1352, -camera.method_19326().field_1351, -camera.method_19326().field_1350);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.lineWidth((float)2.0f);
        RenderSystem.setShader(class_757::method_34535);
        RenderSystem.enableDepthTest();
        RulerTool.drawPoints(matrices, 1.0f);
        RenderSystem.disableDepthTest();
        RulerTool.drawPoints(matrices, 0.35f);
        RulerTool.drawDistanceText(matrices, projection);
        RenderSystem.setShader(class_757::method_34535);
        RenderSystem.enableDepthTest();
        RulerTool.drawBoundingBoxes(camera, matrices);
        RenderSystem.enableCull();
        matrices.method_22909();
    }

    private static void drawDistanceText(class_4587 matrix, Matrix4f projection) {
        float scale = 2.0f * Math.max(1.0f, Math.min(ImGui.getIO().getDisplayFramebufferScaleX(), ImGui.getIO().getDisplayFramebufferScaleY()));
        float width = (float)class_310.method_1551().method_22683().method_4489() / scale;
        float height = (float)class_310.method_1551().method_22683().method_4506() / scale;
        class_327 font = class_310.method_1551().field_1772;
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, width, height, 0.0f, 1000.0f, 3000.0f);
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (class_8251)class_8251.field_43361);
        class_4587 poseStack = RenderSystem.getModelViewStack();
        poseStack.method_22903();
        poseStack.method_34426();
        poseStack.method_46416(0.0f, 0.0f, -2000.0f);
        RenderSystem.applyModelViewMatrix();
        float fog = RenderSystem.getShaderFogStart();
        RenderSystem.setShaderFogStart((float)Float.MAX_VALUE);
        boolean displayDistance = displayMode[0] == 1;
        for (int i = 0; i < points.size() - 1; ++i) {
            int bz;
            int by;
            class_2338 from = points.get(i);
            class_2338 to = points.get(i + 1);
            float dx = to.method_10263() - from.method_10263();
            float dy = to.method_10264() - from.method_10264();
            float dz = to.method_10260() - from.method_10260();
            if (displayDistance) {
                float distance = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
                if (!(distance > 1.0f)) continue;
                RulerTool.renderProjectedText(String.format("+%.1f", Float.valueOf(distance)), matrix, projection, (float)from.method_10263() + dx * 0.5f + 0.5f, (float)from.method_10264() + dy * 0.5f + 0.5f, (float)from.method_10260() + dz * 0.5f + 0.5f, scale, width, height, font);
                continue;
            }
            int bx = Math.abs(to.method_10263() - from.method_10263()) + 1;
            int distance = Math.max(bx, Math.max(by = Math.abs(to.method_10264() - from.method_10264()) + 1, bz = Math.abs(to.method_10260() - from.method_10260()) + 1));
            if (distance <= 1) continue;
            RulerTool.renderProjectedText(String.format("%d", distance), matrix, projection, (float)from.method_10263() + dx * 0.5f + 0.5f, (float)from.method_10264() + dy * 0.5f + 0.5f, (float)from.method_10260() + dz * 0.5f + 0.5f, scale, width, height, font);
        }
        class_310.method_1551().method_22940().method_23000().method_22993();
        RenderSystem.setShaderFogStart((float)fog);
        poseStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.restoreProjectionMatrix();
    }

    private static void renderProjectedText(String text, class_4587 matrix, Matrix4f projection, float x, float y, float z, float scale, float width, float height, class_327 font) {
        Vector4f transformed = matrix.method_23760().method_23761().transform(new Vector4f(x, y, z, 1.0f));
        transformed = projection.transform(transformed);
        int stringWidth = class_310.method_1551().field_1772.method_1727(text);
        if (transformed.w < 0.0f) {
            return;
        }
        float screenX = (float)Math.round(((transformed.x / transformed.w * 0.5f + 0.5f) * width - (float)stringWidth / 2.0f) * scale) / scale;
        float f = (-transformed.y / transformed.w * 0.5f + 0.5f) * height;
        Objects.requireNonNull(font);
        float screenY = (float)Math.round((f - 9.0f / 2.0f) * scale) / scale;
        font.method_37296(class_2561.method_43470((String)text).method_30937(), screenX, screenY, -3351041, -13420737, new Matrix4f(), (class_4597)class_310.method_1551().method_22940().method_23000(), 0xF000F0);
    }

    private static void drawBoundingBoxes(class_4184 camera, class_4587 matrices) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27377, class_290.field_29337);
        Matrix4f pose = matrices.method_23760().method_23761();
        Matrix3f normal = matrices.method_23760().method_23762();
        for (class_2338 point : points) {
            class_2680 blockState = level.method_8320(point);
            class_265 voxelShape = blockState.method_26172((class_1922)level, point, class_3726.method_16195((class_1297)camera.method_19331()));
            if (voxelShape.method_1110()) {
                voxelShape = class_259.method_1077();
            }
            voxelShape.method_1104((x1, y1, z1, x2, y2, z2) -> {
                float dx = (float)(x2 - x1);
                float dy = (float)(y2 - y1);
                float dz = (float)(z2 - z1);
                float length = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
                bufferBuilder.method_22918(pose, (float)(x1 + (double)point.method_10263()), (float)(y1 + (double)point.method_10264()), (float)(z1 + (double)point.method_10260())).method_39415(-16399395).method_23763(normal, dx /= length, dy /= length, dz /= length).method_1344();
                bufferBuilder.method_22918(pose, (float)(x2 + (double)point.method_10263()), (float)(y2 + (double)point.method_10264()), (float)(z2 + (double)point.method_10260())).method_39415(-16399395).method_23763(normal, dx, dy, dz).method_1344();
            });
        }
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    private static void drawPoints(class_4587 matrices, float opacity) {
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27377, class_290.field_29337);
        Matrix4f pose = matrices.method_23760().method_23761();
        Matrix3f normal = matrices.method_23760().method_23762();
        for (int i = 0; i < points.size() - 1; ++i) {
            class_2338 from = points.get(i);
            class_2338 to = points.get(i + 1);
            float dx = to.method_10263() - from.method_10263();
            float dy = to.method_10264() - from.method_10264();
            float dz = to.method_10260() - from.method_10260();
            float distanceInv = 1.0f / (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
            bufferBuilder.method_22918(pose, (float)from.method_10263() + 0.5f, (float)from.method_10264() + 0.5f, (float)from.method_10260() + 0.5f).method_22915(1.0f, 0.1f, 0.1f, opacity).method_23763(normal, dx *= distanceInv, dy *= distanceInv, dz *= distanceInv).method_1344();
            bufferBuilder.method_22918(pose, (float)to.method_10263() + 0.5f, (float)to.method_10264() + 0.5f, (float)to.method_10260() + 0.5f).method_22915(1.0f, 0.1f, 0.1f, opacity).method_23763(normal, dx, dy, dz).method_1344();
        }
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    @Override
    public void displayImguiOptions() {
        boolean canSelectedCenter;
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.ruler"));
        ImGuiHelper.combo(AxiomI18n.get("axiom.tool.ruler.display"), displayMode, new String[]{AxiomI18n.get("axiom.tool.ruler.display.block_count"), AxiomI18n.get("axiom.tool.ruler.display.distance")});
        boolean bl = canSelectedCenter = this.minimum != null && this.maximum != null;
        if (!canSelectedCenter) {
            ImGui.beginDisabled();
        }
        if (ImGui.button(AxiomI18n.get("axiom.tool.ruler.select_center")) && canSelectedCenter) {
            Selection.clearSelection();
            int minX = Math.floorDiv(this.minimum.method_10263() + this.maximum.method_10263(), 2);
            int minY = Math.floorDiv(this.minimum.method_10264() + this.maximum.method_10264(), 2);
            int minZ = Math.floorDiv(this.minimum.method_10260() + this.maximum.method_10260(), 2);
            int maxX = (this.maximum.method_10263() - this.minimum.method_10263() & 1) == 0 ? minX : minX + 1;
            int maxY = (this.maximum.method_10264() - this.minimum.method_10264() & 1) == 0 ? minY : minY + 1;
            int maxZ = (this.maximum.method_10260() - this.minimum.method_10260() & 1) == 0 ? minZ : minZ + 1;
            Selection.addAABBWithHistory(new class_2338(minX, minY, minZ), new class_2338(maxX, maxY, maxZ), true);
            ToolManager.setToolSelected(false);
        }
        if (!canSelectedCenter) {
            ImGui.endDisabled();
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.ruler.information"));
        NumberFormat format = NumberFormat.getInstance();
        if (points.size() < 2) {
            ImGui.beginDisabled();
            ImGui.text(AxiomI18n.get("axiom.tool.ruler.no_information"));
            ImGui.endDisabled();
        } else {
            ImGui.text(AxiomI18n.get("axiom.tool.ruler.total_length_euclidean", String.format("%.2f", Float.valueOf(this.totalLengthEuclidean))));
            ImGui.text(AxiomI18n.get("axiom.tool.ruler.total_length_manhattan", format.format(this.totalLengthManhattan)));
            ImGui.text(AxiomI18n.get("axiom.tool.ruler.minimum", format.format(this.minimum.method_10263()), format.format(this.minimum.method_10264()), format.format(this.minimum.method_10260())));
            ImGui.text(AxiomI18n.get("axiom.tool.ruler.maximum", format.format(this.maximum.method_10263()), format.format(this.maximum.method_10264()), format.format(this.maximum.method_10260())));
            int boundingX = this.maximum.method_10263() - this.minimum.method_10263() + 1;
            int boundingY = this.maximum.method_10264() - this.minimum.method_10264() + 1;
            int boundingZ = this.maximum.method_10260() - this.minimum.method_10260() + 1;
            ImGui.text(AxiomI18n.get("axiom.tool.ruler.bounding_size", format.format(boundingX), format.format(boundingY), format.format(boundingZ)));
            if (points.size() == 2) {
                class_2338 one = points.get(0);
                class_2338 two = points.get(1);
                float dx = two.method_10263() - one.method_10263();
                float dy = two.method_10264() - one.method_10264();
                float dz = two.method_10260() - one.method_10260();
                double sqr = Math.sqrt(dx * dx + dz * dz);
                float yaw = (float)Math.toDegrees(Math.atan2(dz, dx)) - 90.0f;
                float pitch = (float)Math.toDegrees(-Math.atan2(dy, sqr));
                ImGui.text(AxiomI18n.get("axiom.tool.ruler.yaw", String.format("%.2f", Float.valueOf(yaw))));
                ImGui.text(AxiomI18n.get("axiom.tool.ruler.pitch", String.format("%.2f", Float.valueOf(pitch))));
            }
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.ruler.points"));
        boolean pointsChanged = false;
        int pointToRemove = -1;
        for (int i = 0; i < points.size(); ++i) {
            class_2338 point = points.get(i);
            int[] array = new int[]{point.method_10263(), point.method_10264(), point.method_10260()};
            if (ImGuiHelper.inputInt(AxiomI18n.get("axiom.tool.ruler.point_i", format.format(i + 1)), array)) {
                points.set(i, new class_2338(array[0], array[1], array[2]));
                pointsChanged = true;
            }
            String popupName = "Point" + i + "RemovePopup";
            if (ImGui.isItemClicked(1)) {
                ImGui.openPopup(popupName);
            }
            if (!ImGuiHelper.beginPopup(popupName)) continue;
            if (ImGui.menuItem(AxiomI18n.get("axiom.tool.ruler.remove_point_i", i + 1))) {
                pointToRemove = i;
            }
            ImGui.endPopup();
        }
        if (ImGui.button(AxiomI18n.get("axiom.tool.ruler.add_point"))) {
            points.add(new class_2338(0, 0, 0));
            pointsChanged = true;
        }
        if (pointToRemove >= 0) {
            points.remove(pointToRemove);
            pointsChanged = true;
        }
        if (pointsChanged) {
            this.recalculate();
        }
    }

    private void recalculate() {
        this.totalLengthEuclidean = 0.0f;
        this.totalLengthManhattan = 0;
        this.minimum = null;
        this.maximum = null;
        if (points.size() >= 2) {
            this.minimum = points.get(0);
            this.maximum = points.get(0);
            for (int i = 0; i < points.size() - 1; ++i) {
                class_2338 one = points.get(i);
                class_2338 two = points.get(i + 1);
                this.totalLengthEuclidean = (float)((double)this.totalLengthEuclidean + Math.sqrt(one.method_10262((class_2382)two)));
                this.totalLengthManhattan += one.method_19455((class_2382)two);
            }
            for (class_2338 point : points) {
                this.minimum = new class_2338(Math.min(this.minimum.method_10263(), point.method_10263()), Math.min(this.minimum.method_10264(), point.method_10264()), Math.min(this.minimum.method_10260(), point.method_10260()));
                this.maximum = new class_2338(Math.max(this.maximum.method_10263(), point.method_10263()), Math.max(this.maximum.method_10264(), point.method_10264()), Math.max(this.maximum.method_10260(), point.method_10260()));
            }
        }
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.ruler");
    }

    @Override
    public void writeSourceInfo(class_2487 tag, boolean includeSettings) {
        throw new UnsupportedOperationException("Ruler Tool is not a source");
    }

    @Override
    public void writeSettings(class_2487 tag) {
        tag.method_10569("DisplayMode", displayMode[0]);
    }

    @Override
    public void loadSettings(class_2487 tag) {
        RulerTool.displayMode[0] = NbtGetter.getIntOrDefault(tag, "DisplayMode", 0);
    }

    @Override
    public char iconChar() {
        return '\ue909';
    }

    @Override
    public String keybindId() {
        return "ruler";
    }
}

