/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.shape;

import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.gizmo.ExtrudedGizmo;
import com.moulberry.axiom.gizmo.Gizmo;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.mask.elements.ConstantMaskElement;
import com.moulberry.axiom.rasterization.ConeRasterization;
import com.moulberry.axiom.rasterization.CuboidRasterization;
import com.moulberry.axiom.rasterization.CylinderRasterization;
import com.moulberry.axiom.rasterization.DiskRasterization;
import com.moulberry.axiom.rasterization.DodecahedronRasterization;
import com.moulberry.axiom.rasterization.HullRasterization;
import com.moulberry.axiom.rasterization.IcosahedronRasterization;
import com.moulberry.axiom.rasterization.OctahedronRasterization;
import com.moulberry.axiom.rasterization.PlaneRasterization;
import com.moulberry.axiom.rasterization.PyramidRasterization;
import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiom.rasterization.RegularPolygonRasterization;
import com.moulberry.axiom.rasterization.SmartSurfaceRasterization;
import com.moulberry.axiom.rasterization.SphereRasterization;
import com.moulberry.axiom.rasterization.SpiralRasterization;
import com.moulberry.axiom.rasterization.SuperellipseRasterization;
import com.moulberry.axiom.rasterization.SupersphereRasterization;
import com.moulberry.axiom.rasterization.TorusRasterization;
import com.moulberry.axiom.rasterization.TubeRasterization;
import com.moulberry.axiom.render.ChunkRenderOverrider;
import com.moulberry.axiom.render.Shapes;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_modification.HistoryEntry;
import imgui.ImGui;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_757;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3i;

public class ShapeTool
implements Tool {
    private final ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
    private final List<Gizmo> gizmos = new ArrayList<Gizmo>();
    private boolean hasActiveGizmo = false;
    private boolean cutout = false;
    private boolean recalculate = false;
    private class_2680 lastActiveBlock = null;
    private boolean maskWindowOpen = false;
    private boolean reorientPoint = false;
    private boolean usingRealCoordinates = false;
    private boolean singleGizmoWithRotation = true;
    private static final int SHAPE_CATEGORY_SOLID = 0;
    private static final int SHAPE_CATEGORY_PLANE = 1;
    private static final int SHAPE_CATEGORY_MODELLING = 2;
    private static final int SHAPE_CATEGORY_CUSTOM = 3;
    private final int[] shapeCategory = new int[]{0};
    private static final int SHAPE_SOLID_SPHERE = 0;
    private static final int SHAPE_SOLID_CUBOID = 1;
    private static final int SHAPE_SOLID_OCTAHEDRON = 2;
    private static final int SHAPE_SOLID_SUPERSPHERE = 3;
    private static final int SHAPE_SOLID_CYLINDER = 4;
    private static final int SHAPE_SOLID_TUBE = 5;
    private static final int SHAPE_SOLID_CONE = 6;
    private static final int SHAPE_SOLID_PYRAMID = 7;
    private static final int SHAPE_SOLID_TORUS = 8;
    private static final int SHAPE_SOLID_DODECAHEDRON = 9;
    private static final int SHAPE_SOLID_ICOSAHEDRON = 10;
    private final int[] shapeSolid = new int[]{0};
    private static final int SHAPE_PLANE_DISK = 0;
    private static final int SHAPE_PLANE_PLANE = 1;
    private static final int SHAPE_PLANE_REGULAR_POLYGON = 2;
    private static final int SHAPE_PLANE_SUPERELLIPSE = 3;
    private static final int SHAPE_PLANE_ARCHIMEDEAN_SPIRAL = 4;
    private final int[] shapePlane = new int[]{0};
    private static final int SHAPE_MODELLING_CONVEX_HULL = 0;
    private static final int SHAPE_MODELLING_SMART_SURFACE = 1;
    private static final int SHAPE_MODELLING_TRIANGLE_STRIP = 2;
    private static final int SHAPE_MODELLING_TRIANGLE_FAN = 3;
    private final int[] shapeModelling = new int[]{0};
    private boolean separateXYZ = false;
    private final int[] sizeXYZ = new int[]{5};
    private final int[] sizeX = new int[]{5};
    private final int[] sizeY = new int[]{5};
    private final int[] sizeZ = new int[]{5};
    private final float[] rotationX = new float[]{0.0f};
    private final float[] rotationY = new float[]{0.0f};
    private final float[] rotationZ = new float[]{0.0f};
    private final Quaternionf rotationQuaternion = new Quaternionf();
    private ExtrudedGizmo extrudedGizmo = null;
    private boolean hollow = false;
    private boolean metaball = false;
    private final int[] metaballRange = new int[]{8};
    private final int[] polygonSides = new int[]{3};
    private final int[] thickness = new int[]{1};
    private boolean separateHV = false;
    private final int[] ringH = new int[]{2};
    private final int[] ringV = new int[]{2};
    private final float[] exponent = new float[]{2.0f};
    private final float[] loops = new float[]{5.0f};
    private final float[] coneRounding = new float[]{0.0f};
    private boolean visualizeMesh = false;
    private boolean offsetWhenPlacing = true;
    private static final int GIZMO_SPACE_GLOBAL = 0;
    private static final int GIZMO_SPACE_LOCAL = 1;
    private final int[] gizmoSpace = new int[]{0};
    private static final int PIVOT_CENTER = 0;
    private static final int PIVOT_BASE = 1;
    private final int[] pivot = new int[]{0};
    private static final int PLACE_ROTATION_KEEP = 0;
    private static final int PLACE_ROTATION_AUTO = 1;
    private static final int PLACE_ROTATION_RESET = 2;
    private final int[] placeRotation = new int[]{0};
    private boolean keepExisting = false;

    @Override
    public void reset() {
        this.gizmos.clear();
        this.chunkedBlockRegion.clear();
        this.hasActiveGizmo = false;
        this.recalculate = true;
        if (this.cutout) {
            ChunkRenderOverrider.INSTANCE.release("Shape Tool");
            this.cutout = false;
        }
    }

    public void markDirty() {
        this.recalculate = true;
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case EXTRUDE: {
                if (this.singleGizmoWithRotation) break;
                for (Gizmo gizmo2 : this.gizmos) {
                    if (!gizmo2.enableAxes) continue;
                    this.extrudedGizmo = new ExtrudedGizmo(class_310.method_1551().field_1724, gizmo2.getTargetPosition());
                    gizmo2.enableAxes = false;
                    return UserAction.ActionResult.USED_STOP;
                }
                break;
            }
            case ENTER: {
                if (!this.singleGizmoWithRotation && this.extrudedGizmo != null) {
                    this.finishExtrudeGizmo();
                    return UserAction.ActionResult.USED_STOP;
                }
                this.recalculate();
                if (this.chunkedBlockRegion.isEmpty() || this.gizmos.isEmpty()) {
                    return UserAction.ActionResult.USED_STOP;
                }
                class_2487 sourceInfo = Dispatcher.simpleSourceInfo("Shape Tool");
                String countString = NumberFormat.getInstance().format(this.chunkedBlockRegion.count());
                String historyDescription = AxiomI18n.get("axiom.history_description.placed", countString);
                int modifiers = this.keepExisting ? HistoryEntry.MODIFIER_KEEP_EXISTING : 0;
                MaskContext maskContext = new MaskContext((class_1937)class_310.method_1551().field_1687);
                MaskElement maskElement = MaskManager.getDestMask();
                if (maskElement instanceof ConstantMaskElement) {
                    ConstantMaskElement constantMaskElement = (ConstantMaskElement)maskElement;
                    if (constantMaskElement.getConstant()) {
                        if (this.usingRealCoordinates) {
                            RegionHelper.pushBlockRegionChange(this.chunkedBlockRegion, historyDescription, sourceInfo, modifiers);
                        } else {
                            RegionHelper.pushBlockRegionChangeOffset(this.chunkedBlockRegion, this.gizmos.get(0).getTargetPosition(), historyDescription, sourceInfo, modifiers);
                        }
                    }
                } else if (this.usingRealCoordinates) {
                    ChunkedBlockRegion newChunkedBlockRegion = new ChunkedBlockRegion();
                    this.chunkedBlockRegion.forEachEntry((x, y, z, block) -> {
                        if (maskElement.test(maskContext.reset(), x, y, z)) {
                            newChunkedBlockRegion.addBlockWithoutDirty(x, y, z, (class_2680)block);
                        }
                    });
                    RegionHelper.pushBlockRegionChange(newChunkedBlockRegion, historyDescription, sourceInfo, modifiers);
                } else {
                    class_2338 target = this.gizmos.get(0).getTargetPosition();
                    int offsetX = target.method_10263();
                    int offsetY = target.method_10264();
                    int offsetZ = target.method_10260();
                    ChunkedBlockRegion newChunkedBlockRegion = new ChunkedBlockRegion();
                    this.chunkedBlockRegion.forEachEntry((x, y, z, block) -> {
                        if (maskElement.test(maskContext.reset(), x + offsetX, y + offsetY, z + offsetZ)) {
                            newChunkedBlockRegion.addBlockWithoutDirty(x + offsetX, y + offsetY, z + offsetZ, (class_2680)block);
                        }
                    });
                    RegionHelper.pushBlockRegionChange(newChunkedBlockRegion, historyDescription, sourceInfo, modifiers);
                }
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
            case RIGHT_MOUSE: {
                RayCaster.RaycastResult result;
                if (!this.singleGizmoWithRotation && this.extrudedGizmo != null) {
                    this.finishExtrudeGizmo();
                    return UserAction.ActionResult.USED_STOP;
                }
                if (!(this.shapeCategory[0] != 2 || this.shapeModelling[0] != 2 && this.shapeModelling[0] != 3 || this.singleGizmoWithRotation || this.gizmos.isEmpty())) {
                    Gizmo gizmoToAdd = null;
                    for (Gizmo gizmo3 : this.gizmos) {
                        if (!gizmo3.isCenterHovered()) continue;
                        gizmoToAdd = gizmo3;
                        break;
                    }
                    if (gizmoToAdd != null) {
                        if (gizmoToAdd == this.gizmos.get(this.gizmos.size() - 1)) {
                            return UserAction.ActionResult.USED_STOP;
                        }
                        for (Gizmo gizmo3 : this.gizmos) {
                            gizmo3.enableAxes = false;
                        }
                        this.gizmos.add(gizmoToAdd);
                        gizmoToAdd.enableAxes = true;
                        this.hasActiveGizmo = true;
                        this.recalculate = true;
                        return UserAction.ActionResult.USED_STOP;
                    }
                }
                if ((result = Tool.raycastBlock(false, true, true)) != null) {
                    int placeRotationMode = this.getPlaceRotation();
                    if (placeRotationMode == 2) {
                        this.rotationZ[0] = 0.0f;
                        this.rotationY[0] = 0.0f;
                        this.rotationX[0] = 0.0f;
                        this.rotationQuaternion.identity();
                    } else if (placeRotationMode == 1) {
                        this.setRotationAuto(result.blockPos());
                    }
                    class_2338 blockPos = result.blockPos();
                    if (this.offsetWhenPlacing) {
                        blockPos = blockPos.method_10093(result.direction());
                    }
                    if (this.singleGizmoWithRotation && !this.gizmos.isEmpty()) {
                        Gizmo gizmo4 = this.gizmos.get(0);
                        gizmo4.moveTo(blockPos);
                        gizmo4.enableAxes = true;
                        this.reorientPoint = true;
                        this.hasActiveGizmo = true;
                        this.recalculate = true;
                        return UserAction.ActionResult.USED_STOP;
                    }
                    if (this.gizmos.size() >= 256) {
                        return UserAction.ActionResult.USED_STOP;
                    }
                    for (Gizmo gizmo5 : this.gizmos) {
                        gizmo5.enableAxes = false;
                    }
                    this.gizmos.add(new Gizmo(blockPos));
                    this.reorientPoint = true;
                    this.hasActiveGizmo = true;
                    this.recalculate = true;
                }
                return UserAction.ActionResult.USED_STOP;
            }
            case LEFT_MOUSE: {
                if (!this.singleGizmoWithRotation && this.extrudedGizmo != null) {
                    this.finishExtrudeGizmo();
                    return UserAction.ActionResult.USED_STOP;
                }
                for (Gizmo gizmo6 : this.gizmos) {
                    if (!gizmo6.enableAxes || !gizmo6.leftClick()) continue;
                    return UserAction.ActionResult.USED_STOP;
                }
                Gizmo disableExcept = null;
                for (int i = 0; i < this.gizmos.size(); ++i) {
                    Gizmo gizmo7 = this.gizmos.get(i);
                    if (gizmo7.enableAxes || !gizmo7.leftClick()) continue;
                    this.hasActiveGizmo = true;
                    disableExcept = gizmo7;
                    break;
                }
                if (disableExcept != null) {
                    for (Gizmo gizmo7 : this.gizmos) {
                        if (gizmo7 == disableExcept) continue;
                        gizmo7.enableAxes = false;
                    }
                    return UserAction.ActionResult.USED_STOP;
                }
                if (!EditorUI.isCtrlOrCmdDown()) {
                    for (Gizmo gizmo7 : this.gizmos) {
                        gizmo7.enableAxes = false;
                    }
                    this.hasActiveGizmo = false;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case ESCAPE: {
                if (this.extrudedGizmo != null) {
                    this.extrudedGizmo = null;
                    return UserAction.ActionResult.USED_STOP;
                }
                boolean disabledGizmo = false;
                for (Gizmo gizmo8 : this.gizmos) {
                    if (!gizmo8.enableAxes) continue;
                    gizmo8.enableAxes = false;
                    disabledGizmo = true;
                }
                if (disabledGizmo) {
                    this.hasActiveGizmo = false;
                    return UserAction.ActionResult.USED_STOP;
                }
                if (this.gizmos.isEmpty()) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
            case DELETE: {
                if (this.extrudedGizmo != null) {
                    this.extrudedGizmo = null;
                    return UserAction.ActionResult.USED_STOP;
                }
                if (this.gizmos.removeIf(gizmo -> gizmo.enableAxes)) {
                    this.hasActiveGizmo = false;
                    this.recalculate = true;
                    return UserAction.ActionResult.USED_STOP;
                }
                if (this.gizmos.isEmpty()) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
            case SCROLL: {
                UserAction.ScrollAmount scrollAmount = (UserAction.ScrollAmount)object;
                if (!this.handleScroll(scrollAmount.scrollX(), scrollAmount.scrollY())) break;
                return UserAction.ActionResult.USED_STOP;
            }
            case REDO: {
                if (this.gizmos.size() <= 0) break;
                return UserAction.ActionResult.USED_STOP;
            }
            case UNDO: {
                if (this.gizmos.removeIf(gizmo -> gizmo.enableAxes)) {
                    this.hasActiveGizmo = false;
                    this.recalculate = true;
                    return UserAction.ActionResult.USED_STOP;
                }
                if (this.gizmos.size() <= 0) break;
                int removeIndex = this.gizmos.size() - 1;
                this.gizmos.remove(removeIndex);
                this.recalculate = true;
                this.hasActiveGizmo = false;
                for (Gizmo gizmo9 : this.gizmos) {
                    if (!gizmo9.enableAxes) continue;
                    this.hasActiveGizmo = true;
                    break;
                }
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    private void finishExtrudeGizmo() {
        class_243 lookDirection = Tool.getLookDirection();
        if (lookDirection != null && this.gizmos.size() < 256) {
            for (Gizmo gizmo : this.gizmos) {
                gizmo.enableAxes = false;
            }
            class_2338 pos = this.extrudedGizmo.getBlockPos(lookDirection);
            if (pos != null) {
                this.gizmos.add(new Gizmo(pos));
                this.hasActiveGizmo = true;
                this.recalculate = true;
            }
        }
        this.extrudedGizmo = null;
    }

    public boolean handleScroll(int xScroll, int yScroll) {
        for (Gizmo gizmo : this.gizmos) {
            if (!gizmo.isCenterGrabbed()) continue;
            class_243 look = Tool.getLookDirection();
            gizmo.handleScroll(xScroll, yScroll, EditorUI.isCtrlOrCmdDown(), look);
            return true;
        }
        return false;
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        boolean maskWindowOpen;
        boolean showGizmo;
        class_243 lookDirection = Tool.getLookDirection();
        boolean isLeftDown = Tool.isMouseDown(0);
        boolean isCtrlDown = EditorUI.isCtrlOrCmdDown();
        boolean renderGizmos = showGizmo = !EditorUI.isActive() || !isCtrlDown;
        if (lookDirection != null && this.extrudedGizmo != null) {
            this.extrudedGizmo.render(matrices, camera, lookDirection);
        }
        if (this.singleGizmoWithRotation) {
            if (this.gizmos.size() > 1) {
                this.gizmos.clear();
            }
            this.extrudedGizmo = null;
        }
        if (Tool.isMouseDown(1) && !this.gizmos.isEmpty() && this.reorientPoint) {
            RayCaster.RaycastResult result;
            Gizmo gizmo = this.gizmos.get(this.gizmos.size() - 1);
            if (gizmo.enableAxes && (result = Tool.raycastBlock(false, true, Tool.defaultIncludeFluids())) != null) {
                class_2338 blockPos = result.blockPos();
                if (this.offsetWhenPlacing) {
                    blockPos = blockPos.method_10093(result.direction());
                }
                if (!gizmo.getTargetPosition().equals((Object)blockPos)) {
                    int placeRotationMode = this.getPlaceRotation();
                    if (placeRotationMode == 2) {
                        this.rotationZ[0] = 0.0f;
                        this.rotationY[0] = 0.0f;
                        this.rotationX[0] = 0.0f;
                        this.rotationQuaternion.identity();
                    } else if (placeRotationMode == 1) {
                        this.setRotationAuto(result.blockPos());
                    }
                    gizmo.moveTo(blockPos);
                    gizmo.enableAxes = true;
                    this.recalculate = true;
                }
            }
        } else {
            this.reorientPoint = false;
        }
        this.hasActiveGizmo = false;
        for (Gizmo gizmo : this.gizmos) {
            Gizmo.GizmoRotation rotation;
            if (this.singleGizmoWithRotation) {
                gizmo.enableRotation = true;
                gizmo.rotationSnapRadians = (float)Math.PI / 180;
                gizmo.localRotation = this.getGizmoSpace() == 1 ? new Quaternionf((Quaternionfc)this.rotationQuaternion).invert() : null;
            } else {
                gizmo.enableRotation = false;
                gizmo.rotationSnapRadians = 1.5707964f;
                gizmo.localRotation = null;
            }
            if (gizmo.enableAxes) {
                this.hasActiveGizmo = true;
            }
            class_2338 before = gizmo.getTargetPosition();
            gizmo.update(time, lookDirection, isLeftDown, isCtrlDown, showGizmo);
            if (this.getGizmoSpace() == 0) {
                gizmo.setAxisDirections(camera.method_19326().field_1352 > (double)gizmo.getTargetPosition().method_10263(), camera.method_19326().field_1351 > (double)gizmo.getTargetPosition().method_10264(), camera.method_19326().field_1350 > (double)gizmo.getTargetPosition().method_10260());
            } else {
                gizmo.setAxisDirections(true, true, true);
            }
            if (gizmo.isGrabbed()) {
                renderGizmos = true;
            }
            if ((rotation = gizmo.popRotation()) != null) {
                this.performRotation(rotation.axis(), rotation.radians());
                this.recalculate = true;
            }
            if (!this.usingRealCoordinates || gizmo.getTargetPosition().equals((Object)before)) continue;
            this.recalculate = true;
        }
        if (Tool.getActiveBlock() != this.lastActiveBlock) {
            this.lastActiveBlock = Tool.getActiveBlock();
            this.recalculate = true;
        }
        if (this.maskWindowOpen != (maskWindowOpen = EditorWindowType.TOOL_MASKS.isOpen())) {
            this.maskWindowOpen = maskWindowOpen;
            this.recalculate = true;
        }
        if (this.recalculate) {
            this.recalculate();
        }
        if (this.gizmos.isEmpty()) {
            return;
        }
        float opacity = (float)Math.sin((float)time / 1000000.0f / 50.0f / 8.0f);
        if (this.usingRealCoordinates) {
            this.chunkedBlockRegion.render(camera, class_243.field_1353, matrices, projection, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
            this.renderShapeBounds(matrices, camera);
        } else if (this.gizmoSpace[0] == 1) {
            Quaternionf rotation;
            Gizmo.GizmoRotation gizmoRotation = this.gizmos.get(0).peekGizmoRotation();
            if (gizmoRotation != null) {
                rotation = new Quaternionf((Quaternionfc)this.rotationQuaternion).invert();
                switch (gizmoRotation.axis()) {
                    case field_11048: {
                        rotation.rotateX(gizmoRotation.radians());
                        break;
                    }
                    case field_11052: {
                        rotation.rotateY(gizmoRotation.radians());
                        break;
                    }
                    case field_11051: {
                        rotation.rotateZ(gizmoRotation.radians());
                    }
                }
                rotation.mul((Quaternionfc)this.rotationQuaternion);
            } else {
                rotation = null;
            }
            Vector3f offset = new Vector3f(-0.5f, -0.5f, -0.5f);
            if (rotation != null) {
                rotation.transform(offset);
            }
            this.chunkedBlockRegion.render(camera, this.gizmos.get(0).getInterpPosition().method_1031((double)offset.x, (double)offset.y, (double)offset.z), rotation, matrices, projection, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
            this.renderShapeBounds(matrices, camera);
        } else {
            Quaternionf rotation = this.gizmos.get(0).peekRotation();
            Vector3f offset = new Vector3f(-0.5f, -0.5f, -0.5f);
            if (rotation != null) {
                rotation.transform(offset);
            }
            this.chunkedBlockRegion.render(camera, this.gizmos.get(0).getInterpPosition().method_1031((double)offset.x, (double)offset.y, (double)offset.z), rotation, matrices, projection, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
            this.renderShapeBounds(matrices, camera);
        }
        if (renderGizmos) {
            for (Gizmo gizmo : this.gizmos) {
                gizmo.render(matrices, camera, isCtrlDown);
            }
        }
    }

    private void renderShapeBounds(class_4587 matrices, class_4184 camera) {
        switch (this.shapeCategory[0]) {
            case 0: {
                Quaternionf rotation;
                int diameterX = this.sizeX[0];
                int diameterY = this.sizeY[0];
                int diameterZ = this.sizeZ[0];
                if (!this.separateXYZ) {
                    diameterY = diameterZ = this.sizeXYZ[0];
                    diameterX = diameterZ;
                }
                if (this.gizmoSpace[0] == 0) {
                    rotation = this.gizmos.get(0).peekRotation();
                } else if (this.gizmoSpace[0] == 1) {
                    Gizmo.GizmoRotation gizmoRotation = this.gizmos.get(0).peekGizmoRotation();
                    if (gizmoRotation != null) {
                        rotation = new Quaternionf((Quaternionfc)this.rotationQuaternion).invert();
                        switch (gizmoRotation.axis()) {
                            case field_11048: {
                                rotation.rotateX(gizmoRotation.radians());
                                break;
                            }
                            case field_11052: {
                                rotation.rotateY(gizmoRotation.radians());
                                break;
                            }
                            case field_11051: {
                                rotation.rotateZ(gizmoRotation.radians());
                            }
                        }
                        rotation.mul((Quaternionfc)this.rotationQuaternion);
                    } else {
                        rotation = null;
                    }
                } else {
                    throw new UnsupportedOperationException();
                }
                class_2338 center = this.gizmos.get(0).getTargetPosition();
                matrices.method_22903();
                matrices.method_22904(-camera.method_19326().field_1352 + (double)center.method_10263(), -camera.method_19326().field_1351 + (double)center.method_10264(), -camera.method_19326().field_1350 + (double)center.method_10260());
                if (rotation != null) {
                    matrices.method_22907(rotation);
                }
                matrices.method_22907(new Quaternionf((Quaternionfc)this.rotationQuaternion).invert());
                switch (this.shapeSolid[0]) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 9: 
                    case 10: {
                        class_2338 pivot = this.calculateRawPivot(diameterY);
                        matrices.method_46416((float)pivot.method_10263(), (float)pivot.method_10264(), (float)pivot.method_10260());
                        this.renderBoundingBox(matrices, diameterX, diameterY, diameterZ);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        class_2338 pivot = this.calculateRawPivot(this.sizeY[0]);
                        matrices.method_46416((float)pivot.method_10263(), (float)pivot.method_10264(), (float)pivot.method_10260());
                        this.renderBoundingBox(matrices, diameterX, this.sizeY[0], diameterZ);
                        break;
                    }
                    case 8: {
                        class_2338 pivot = this.calculateRawPivot(this.ringV[0]);
                        matrices.method_46416((float)pivot.method_10263(), (float)pivot.method_10264(), (float)pivot.method_10260());
                        this.renderBoundingBox(matrices, diameterX, this.ringV[0], diameterZ);
                        break;
                    }
                    default: {
                        throw new FaultyImplementationError();
                    }
                }
                matrices.method_22909();
                break;
            }
            case 2: {
                matrices.method_22903();
                matrices.method_22904(-camera.method_19326().field_1352, -camera.method_19326().field_1351, -camera.method_19326().field_1350);
                class_287 bufferBuilder = class_289.method_1348().method_1349();
                bufferBuilder.method_1328(class_293.class_5596.field_27377, class_290.field_29337);
                Matrix4f pose = matrices.method_23760().method_23761();
                Matrix3f normal = matrices.method_23760().method_23762();
                switch (this.shapeModelling[0]) {
                    case 2: {
                        RayCaster.RaycastResult result;
                        boolean selectedGizmoThatIsntLast;
                        for (int i = 0; i < this.gizmos.size() - 1; ++i) {
                            class_243 from = this.gizmos.get(i).getInterpPosition();
                            class_243 to = this.gizmos.get(i + 1).getInterpPosition();
                            Shapes.line(bufferBuilder, pose, normal, from, to);
                            if (i >= this.gizmos.size() - 2) continue;
                            to = this.gizmos.get(i + 2).getInterpPosition();
                            Shapes.line(bufferBuilder, pose, normal, from, to);
                        }
                        boolean bl = selectedGizmoThatIsntLast = this.hasActiveGizmo && !this.gizmos.get((int)(this.gizmos.size() - 1)).enableAxes;
                        if (Tool.isMouseDown(1) || Tool.isMouseDown(0) || EditorUI.isCtrlOrCmdDown() || selectedGizmoThatIsntLast || (result = Tool.raycastBlock(false, true, Tool.defaultIncludeFluids())) == null) break;
                        class_2338 blockPos = result.blockPos();
                        if (this.offsetWhenPlacing) {
                            blockPos = blockPos.method_10093(result.direction());
                        }
                        class_243 pos = class_243.method_24953((class_2382)blockPos);
                        if (this.gizmos.size() >= 1) {
                            Shapes.line(bufferBuilder, pose, normal, this.gizmos.get(this.gizmos.size() - 1).getInterpPosition(), pos);
                        }
                        if (this.gizmos.size() < 2) break;
                        Shapes.line(bufferBuilder, pose, normal, this.gizmos.get(this.gizmos.size() - 2).getInterpPosition(), pos);
                        break;
                    }
                    case 3: {
                        RayCaster.RaycastResult result;
                        boolean selectedGizmoThatIsntLast;
                        class_243 start = this.gizmos.get(0).getInterpPosition();
                        for (int i = 1; i < this.gizmos.size(); ++i) {
                            class_243 curr = this.gizmos.get(i).getInterpPosition();
                            Shapes.line(bufferBuilder, pose, normal, start, curr);
                            if (i >= this.gizmos.size() - 1) continue;
                            class_243 next2 = this.gizmos.get(i + 1).getInterpPosition();
                            Shapes.line(bufferBuilder, pose, normal, curr, next2);
                        }
                        boolean bl = selectedGizmoThatIsntLast = this.hasActiveGizmo && !this.gizmos.get((int)(this.gizmos.size() - 1)).enableAxes;
                        if (Tool.isMouseDown(1) || Tool.isMouseDown(0) || EditorUI.isCtrlOrCmdDown() || selectedGizmoThatIsntLast || (result = Tool.raycastBlock(false, true, Tool.defaultIncludeFluids())) == null) break;
                        class_2338 blockPos = result.blockPos();
                        if (this.offsetWhenPlacing) {
                            blockPos = blockPos.method_10093(result.direction());
                        }
                        class_243 pos = class_243.method_24953((class_2382)blockPos);
                        if (this.gizmos.size() >= 1) {
                            Shapes.line(bufferBuilder, pose, normal, this.gizmos.get(0).getInterpPosition(), pos);
                        }
                        if (this.gizmos.size() < 2) break;
                        Shapes.line(bufferBuilder, pose, normal, this.gizmos.get(this.gizmos.size() - 1).getInterpPosition(), pos);
                    }
                }
                class_291 vertexBuffer = class_286.method_43439((class_287.class_7433)bufferBuilder.method_1326());
                class_5944 lineShader = class_757.method_34535();
                if (vertexBuffer != null && lineShader != null) {
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.lineWidth((float)2.0f);
                    RenderSystem.disableCull();
                    RenderSystem.disableDepthTest();
                    RenderSystem.setShaderColor((float)1.0f, (float)0.1f, (float)0.1f, (float)0.5f);
                    vertexBuffer.method_34427(RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix(), lineShader);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.enableDepthTest();
                    RenderSystem.enableCull();
                }
                matrices.method_22909();
            }
        }
    }

    private void renderBoundingBox(class_4587 matrices, int sizeX, int sizeY, int sizeZ) {
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.enablePolygonOffset();
        RenderSystem.polygonOffset((float)3.0f, (float)3.0f);
        this.renderBoundingBox(matrices, sizeX, sizeY, sizeZ, 0.4f);
        RenderSystem.disableDepthTest();
        this.renderBoundingBox(matrices, sizeX, sizeY, sizeZ, 0.1f);
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.disablePolygonOffset();
    }

    private void renderBoundingBox(class_4587 matrices, int sizeX, int sizeY, int sizeZ, float alpha) {
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        RenderSystem.setShader(class_757::method_34535);
        float offsetX = 1.0f - (float)sizeX / 2.0f % 1.0f;
        float offsetY = 1.0f - (float)sizeY / 2.0f % 1.0f;
        float offsetZ = 1.0f - (float)sizeZ / 2.0f % 1.0f;
        bufferBuilder.method_1328(class_293.class_5596.field_27377, class_290.field_29337);
        RenderSystem.lineWidth((float)2.0f);
        Shapes.lineBox(matrices, (class_4588)bufferBuilder, (float)(-sizeX) / 2.0f + offsetX, (float)(-sizeY) / 2.0f + offsetY, (float)(-sizeZ) / 2.0f + offsetZ, (float)sizeX / 2.0f + offsetX, (float)sizeY / 2.0f + offsetY, (float)sizeZ / 2.0f + offsetZ, 1.0f, 1.0f, 1.0f, alpha, 1.0f, 1.0f, 1.0f);
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    private void performRotation(class_2350.class_2351 axis, float radians2) {
        Quaternionf rotation = new Quaternionf();
        rotation.rotateYXZ((float)Math.toRadians(this.rotationY[0]), (float)Math.toRadians(this.rotationX[0]), (float)Math.toRadians(this.rotationZ[0]));
        if (this.getGizmoSpace() == 1) {
            switch (axis) {
                case field_11048: {
                    rotation.rotateLocalX(-radians2);
                    break;
                }
                case field_11052: {
                    rotation.rotateLocalY(-radians2);
                    break;
                }
                case field_11051: {
                    rotation.rotateLocalZ(-radians2);
                }
            }
        } else {
            switch (axis) {
                case field_11048: {
                    rotation.rotateX(-radians2);
                    break;
                }
                case field_11052: {
                    rotation.rotateY(-radians2);
                    break;
                }
                case field_11051: {
                    rotation.rotateZ(-radians2);
                }
            }
        }
        Vector3f euler = rotation.getEulerAnglesYXZ(new Vector3f());
        this.rotationX[0] = Math.round(Math.toDegrees(euler.x));
        this.rotationY[0] = Math.round(Math.toDegrees(euler.y));
        this.rotationZ[0] = Math.round(Math.toDegrees(euler.z));
        this.rotationQuaternion.identity();
        this.rotationQuaternion.rotateYXZ((float)Math.toRadians(this.rotationY[0]), (float)Math.toRadians(this.rotationX[0]), (float)Math.toRadians(this.rotationZ[0]));
    }

    private void recalculate() {
        block52: {
            this.recalculate = false;
            this.chunkedBlockRegion.clear();
            if (this.gizmos.isEmpty()) {
                if (this.cutout) {
                    ChunkRenderOverrider.INSTANCE.release("Shape Tool");
                    this.cutout = false;
                }
                return;
            }
            class_2680 block = Tool.getActiveBlock();
            block1 : switch (this.shapeCategory[0]) {
                case 0: {
                    class_2338 center = this.gizmos.get(0).getTargetPosition();
                    int diameterX = this.sizeX[0];
                    int diameterY = this.sizeY[0];
                    int diameterZ = this.sizeZ[0];
                    if (!this.separateXYZ) {
                        diameterY = diameterZ = this.sizeXYZ[0];
                        diameterX = diameterZ;
                    }
                    switch (this.shapeSolid[0]) {
                        case 0: {
                            if (this.metaball) {
                                SphereRasterization.sphereMetaball(this.chunkedBlockRegion, this.metaballRange[0] * 2, block, center.method_10081((class_2382)this.calculatePivot(diameterY)), diameterX, diameterY, diameterZ, this.hollow, this.rotationQuaternion);
                                break block1;
                            }
                            SphereRasterization.sphere(this.chunkedBlockRegion, block, this.calculatePivot(diameterY), diameterX, diameterY, diameterZ, this.hollow, this.rotationQuaternion);
                            break block1;
                        }
                        case 1: {
                            if (this.metaball) {
                                CuboidRasterization.cuboidMetaball(this.chunkedBlockRegion, this.metaballRange[0] * 2, block, center.method_10081((class_2382)this.calculatePivot(diameterY)), diameterX, diameterY, diameterZ, this.hollow, this.rotationQuaternion);
                                break block1;
                            }
                            CuboidRasterization.cuboid(this.chunkedBlockRegion, block, this.calculatePivot(diameterY), diameterX, diameterY, diameterZ, this.hollow, this.rotationQuaternion);
                            break block1;
                        }
                        case 2: {
                            if (this.metaball) {
                                OctahedronRasterization.octahedronMetaball(this.chunkedBlockRegion, this.metaballRange[0] * 2, block, center.method_10081((class_2382)this.calculatePivot(diameterY)), diameterX, diameterY, diameterZ, this.hollow, this.rotationQuaternion);
                                break block1;
                            }
                            OctahedronRasterization.octahedron(this.chunkedBlockRegion, block, this.calculatePivot(diameterY), diameterX, diameterY, diameterZ, this.hollow, this.rotationQuaternion);
                            break block1;
                        }
                        case 3: {
                            if (this.metaball) {
                                SupersphereRasterization.supersphereMetaball(this.chunkedBlockRegion, this.metaballRange[0] * 2, block, center.method_10081((class_2382)this.calculatePivot(diameterY)), diameterX, diameterY, diameterZ, this.hollow, this.exponent[0], this.rotationQuaternion);
                                break block1;
                            }
                            SupersphereRasterization.supersphere(this.chunkedBlockRegion, block, this.calculatePivot(diameterY), diameterX, diameterY, diameterZ, this.hollow, this.exponent[0], this.rotationQuaternion);
                            break block1;
                        }
                        case 4: {
                            if (this.metaball) {
                                CylinderRasterization.cylinderMetaball(this.chunkedBlockRegion, this.metaballRange[0] * 2, block, center.method_10081((class_2382)this.calculatePivot(this.sizeY[0])), diameterX, this.sizeY[0], diameterZ, this.hollow, this.rotationQuaternion);
                                break block1;
                            }
                            CylinderRasterization.cylinder(this.chunkedBlockRegion, block, this.calculatePivot(this.sizeY[0]), diameterX, this.sizeY[0], diameterZ, this.hollow, this.rotationQuaternion);
                            break block1;
                        }
                        case 5: {
                            if (this.metaball) {
                                TubeRasterization.tubeMetaball(this.chunkedBlockRegion, this.metaballRange[0] * 2, block, center.method_10081((class_2382)this.calculatePivot(this.sizeY[0])), diameterX, this.sizeY[0], diameterZ, this.hollow, this.thickness[0], this.rotationQuaternion);
                                break block1;
                            }
                            TubeRasterization.tube(this.chunkedBlockRegion, block, this.calculatePivot(this.sizeY[0]), diameterX, this.sizeY[0], diameterZ, this.hollow, this.thickness[0], this.rotationQuaternion);
                            break block1;
                        }
                        case 6: {
                            if (this.metaball) {
                                ConeRasterization.coneMetaball(this.chunkedBlockRegion, this.metaballRange[0] * 2, block, center.method_10081((class_2382)this.calculatePivot(this.sizeY[0])), diameterX, this.sizeY[0], diameterZ, this.hollow, this.coneRounding[0], this.rotationQuaternion);
                                break block1;
                            }
                            ConeRasterization.cone(this.chunkedBlockRegion, block, this.calculatePivot(this.sizeY[0]), diameterX, this.sizeY[0], diameterZ, this.hollow, this.coneRounding[0], this.rotationQuaternion);
                            break block1;
                        }
                        case 7: {
                            if (this.metaball) {
                                PyramidRasterization.pyramidMetaball(this.chunkedBlockRegion, this.metaballRange[0] * 2, block, center.method_10081((class_2382)this.calculatePivot(this.sizeY[0])), diameterX, this.sizeY[0], diameterZ, this.hollow, this.rotationQuaternion);
                                break block1;
                            }
                            PyramidRasterization.pyramid(this.chunkedBlockRegion, block, this.calculatePivot(this.sizeY[0]), diameterX, this.sizeY[0], diameterZ, this.hollow, this.rotationQuaternion);
                            break block1;
                        }
                        case 8: {
                            if (this.metaball) {
                                TorusRasterization.torusMetaball(this.chunkedBlockRegion, this.metaballRange[0] * 2, block, center.method_10081((class_2382)this.calculatePivot(this.ringV[0])), diameterX, diameterZ, this.hollow, this.ringH[0], this.ringV[0], this.rotationQuaternion);
                                break block1;
                            }
                            TorusRasterization.torus(this.chunkedBlockRegion, block, this.calculatePivot(this.ringV[0]), diameterX, diameterZ, this.hollow, this.ringH[0], this.ringV[0], this.rotationQuaternion);
                            break block1;
                        }
                        case 9: {
                            if (this.metaball) {
                                DodecahedronRasterization.dodhecahedronMetaball(this.chunkedBlockRegion, this.metaballRange[0] * 2, block, center.method_10081((class_2382)this.calculatePivot(diameterY)), diameterX, diameterY, diameterZ, this.hollow, this.rotationQuaternion);
                                break block1;
                            }
                            DodecahedronRasterization.dodhecahedron(this.chunkedBlockRegion, block, this.calculatePivot(diameterY), diameterX, diameterY, diameterZ, this.hollow, this.rotationQuaternion);
                            break block1;
                        }
                        case 10: {
                            if (this.metaball) {
                                IcosahedronRasterization.icosahedronMetaball(this.chunkedBlockRegion, this.metaballRange[0] * 2, block, center.method_10081((class_2382)this.calculatePivot(diameterY)), diameterX, diameterY, diameterZ, this.hollow, this.rotationQuaternion);
                                break block1;
                            }
                            IcosahedronRasterization.icosahedron(this.chunkedBlockRegion, block, this.calculatePivot(diameterY), diameterX, diameterY, diameterZ, this.hollow, this.rotationQuaternion);
                            break block1;
                        }
                    }
                    throw new FaultyImplementationError();
                }
                case 1: {
                    int sizeX = this.sizeX[0];
                    int sizeZ = this.sizeZ[0];
                    if (!this.separateXYZ) {
                        sizeX = sizeZ = this.sizeXYZ[0];
                    }
                    switch (this.shapePlane[0]) {
                        case 0: {
                            DiskRasterization.disk(new Vector3i(0, 0, 0), sizeX, sizeZ, this.hollow, this.rotationQuaternion, (x, y, z) -> this.chunkedBlockRegion.addBlock(x, y, z, block));
                            break;
                        }
                        case 1: {
                            PlaneRasterization.plane(new Vector3i(0, 0, 0), sizeX, sizeZ, this.hollow, this.rotationQuaternion, (x, y, z) -> this.chunkedBlockRegion.addBlock(x, y, z, block));
                            break;
                        }
                        case 2: {
                            RegularPolygonRasterization.regularPolygon(new Vector3i(0, 0, 0), sizeX, sizeZ, this.hollow, this.polygonSides[0], this.rotationQuaternion, (x, y, z) -> this.chunkedBlockRegion.addBlock(x, y, z, block));
                            break;
                        }
                        case 3: {
                            SuperellipseRasterization.superellipse(new Vector3i(0, 0, 0), sizeX, sizeZ, this.hollow, this.exponent[0], this.rotationQuaternion, (x, y, z) -> this.chunkedBlockRegion.addBlock(x, y, z, block));
                            break;
                        }
                        case 4: {
                            SpiralRasterization.archimedean(new Vector3i(0, 0, 0), sizeX, sizeZ, this.loops[0], this.rotationQuaternion, (x, y, z) -> this.chunkedBlockRegion.addBlock(x, y, z, block));
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.shapeModelling[0]) {
                        case 0: {
                            try {
                                double[] points = new double[this.gizmos.size() * 3];
                                for (int i = 0; i < this.gizmos.size(); ++i) {
                                    Gizmo gizmo = this.gizmos.get(i);
                                    class_2338 pos = gizmo.getTargetPosition();
                                    points[i * 3] = pos.method_10263();
                                    points[i * 3 + 1] = pos.method_10264();
                                    points[i * 3 + 2] = pos.method_10260();
                                }
                                HullRasterization.quickHull(this.chunkedBlockRegion, block, points, false);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            break block52;
                        }
                        case 1: {
                            class_2338[] points = new class_2338[this.gizmos.size()];
                            for (int i = 0; i < this.gizmos.size(); ++i) {
                                Gizmo gizmo = this.gizmos.get(i);
                                points[i] = gizmo.getTargetPosition();
                            }
                            SmartSurfaceRasterization.smartSurface(this.chunkedBlockRegion, block, points, this.visualizeMesh);
                            break block1;
                        }
                        case 2: {
                            for (int i = 0; i < this.gizmos.size() - 2; ++i) {
                                Rasterization3D.triangle(this.gizmos.get(i).getTargetPosition(), this.gizmos.get(i + 1).getTargetPosition(), this.gizmos.get(i + 2).getTargetPosition(), (x, y, z) -> this.chunkedBlockRegion.addBlock(x, y, z, block));
                            }
                            break block52;
                        }
                        case 3: {
                            class_2338 start = this.gizmos.get(0).getTargetPosition();
                            for (int i = 1; i < this.gizmos.size() - 1; ++i) {
                                Rasterization3D.triangle(start, this.gizmos.get(i).getTargetPosition(), this.gizmos.get(i + 1).getTargetPosition(), (x, y, z) -> this.chunkedBlockRegion.addBlock(x, y, z, block));
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void displayImguiOptions() {
        this.usingRealCoordinates = true;
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape"));
        boolean changed = ImGuiHelper.combo(AxiomI18n.get("axiom.tool.shape.shape_category"), this.shapeCategory, new String[]{AxiomI18n.get("axiom.tool.shape.shape_category.solid"), AxiomI18n.get("axiom.tool.shape.shape_category.flat"), AxiomI18n.get("axiom.tool.shape.shape_category.modelling")});
        switch (this.shapeCategory[0]) {
            case 0: {
                changed |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.shape"), this.shapeSolid, new String[]{AxiomI18n.get("axiom.tool.shape.sphere"), AxiomI18n.get("axiom.tool.shape.cuboid"), AxiomI18n.get("axiom.tool.shape.octahedron"), AxiomI18n.get("axiom.tool.shape.supersphere"), AxiomI18n.get("axiom.tool.shape.cylinder"), AxiomI18n.get("axiom.tool.shape.tube"), AxiomI18n.get("axiom.tool.shape.cone"), AxiomI18n.get("axiom.tool.shape.pyramid"), AxiomI18n.get("axiom.tool.shape.torus"), AxiomI18n.get("axiom.tool.shape.dodecahedron"), AxiomI18n.get("axiom.tool.shape.icosahedron")});
                switch (this.shapeSolid[0]) {
                    case 0: 
                    case 9: 
                    case 10: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
                        changed |= this.displayDiameterXYZ(AxiomI18n.get("axiom.tool.shape.diameter"));
                        changed |= this.displayGenericShape(true, true);
                        this.usingRealCoordinates = this.metaball;
                        break;
                    }
                    case 1: 
                    case 2: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
                        changed |= this.displayDiameterXYZ(AxiomI18n.get("axiom.tool.shape.width"));
                        changed |= this.displayGenericShape(true, true);
                        this.usingRealCoordinates = this.metaball;
                        break;
                    }
                    case 3: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.supersphere"));
                        changed |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.shape.supersphere.exponent"), this.exponent, 0.5f, 20.0f, "%.2f", 32);
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
                        changed |= this.displayDiameterXYZ(AxiomI18n.get("axiom.tool.shape.width"));
                        changed |= this.displayGenericShape(true, true);
                        this.usingRealCoordinates = this.metaball;
                        break;
                    }
                    case 4: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
                        changed |= this.displayDiameterXZ(AxiomI18n.get("axiom.tool.shape.diameter"));
                        changed |= this.displayHeight();
                        changed |= this.displayGenericShape(true, true);
                        this.usingRealCoordinates = this.metaball;
                        break;
                    }
                    case 6: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.cone"));
                        changed |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.shape.cone.rounding"), this.coneRounding, 0.0f, 1.0f);
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
                        changed |= this.displayDiameterXZ(AxiomI18n.get("axiom.tool.shape.diameter"));
                        changed |= this.displayHeight();
                        changed |= this.displayGenericShape(true, true);
                        this.usingRealCoordinates = this.metaball;
                        break;
                    }
                    case 5: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.tube"));
                        changed |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.shape.tube.thickness"), this.thickness, 1, 64);
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
                        changed |= this.displayDiameterXZ(AxiomI18n.get("axiom.tool.shape.diameter"));
                        changed |= this.displayHeight();
                        changed |= this.displayGenericShape(true, true);
                        this.usingRealCoordinates = this.metaball;
                        break;
                    }
                    case 7: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
                        changed |= this.displayDiameterXZ(AxiomI18n.get("axiom.tool.shape.width"));
                        changed |= this.displayHeight();
                        changed |= this.displayGenericShape(true, true);
                        this.usingRealCoordinates = this.metaball;
                        break;
                    }
                    case 8: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.torus.outer"));
                        changed |= this.displayDiameterXZ(AxiomI18n.get("axiom.tool.shape.diameter"));
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.torus.ring"));
                        changed |= this.displayRingHV(AxiomI18n.get("axiom.tool.shape.diameter"));
                        changed |= this.displayGenericShape(true, true);
                        this.usingRealCoordinates = this.metaball;
                        break;
                    }
                    default: {
                        throw new FaultyImplementationError();
                    }
                }
                this.singleGizmoWithRotation = true;
                break;
            }
            case 1: {
                changed |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.shape"), this.shapePlane, new String[]{AxiomI18n.get("axiom.tool.shape.disk"), AxiomI18n.get("axiom.tool.shape.plane"), AxiomI18n.get("axiom.tool.shape.regular_polygon"), AxiomI18n.get("axiom.tool.shape.superellipse"), AxiomI18n.get("axiom.tool.shape.archimedean_spiral")});
                switch (this.shapePlane[0]) {
                    case 0: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
                        changed |= this.displayDiameterXZ(AxiomI18n.get("axiom.tool.shape.diameter"));
                        changed |= this.displayGenericShape(true, false);
                        break;
                    }
                    case 1: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
                        changed |= this.displayDiameterXZ(AxiomI18n.get("axiom.tool.shape.width"));
                        changed |= this.displayGenericShape(true, false);
                        break;
                    }
                    case 2: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.regular_polygon"));
                        changed |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.shape.regular_polygon.sides"), this.polygonSides, 3, 9);
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
                        changed |= this.displayDiameterXZ(AxiomI18n.get("axiom.tool.shape.width"));
                        changed |= this.displayGenericShape(true, false);
                        break;
                    }
                    case 3: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.superellipse"));
                        changed |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.shape.supersphere.exponent"), this.exponent, 0.5f, 20.0f, "%.2f", 32);
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
                        changed |= this.displayDiameterXZ(AxiomI18n.get("axiom.tool.shape.diameter"));
                        changed |= this.displayGenericShape(true, false);
                        break;
                    }
                    case 4: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.archimedean_spiral"));
                        changed |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.shape.archimedean_spiral.loops"), this.loops, 0.1f, 20.0f);
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
                        changed |= this.displayDiameterXZ(AxiomI18n.get("axiom.tool.shape.diameter"));
                        changed |= this.displayGenericShape(false, false);
                    }
                }
                this.usingRealCoordinates = false;
                this.singleGizmoWithRotation = true;
                break;
            }
            case 2: {
                changed |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.shape"), this.shapeModelling, new String[]{AxiomI18n.get("axiom.tool.shape.convex_hull"), AxiomI18n.get("axiom.tool.shape.smart_surface"), AxiomI18n.get("axiom.tool.shape.triangle_strip"), AxiomI18n.get("axiom.tool.shape.triangle_fan")});
                switch (this.shapeModelling[0]) {
                    case 1: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.smart_surface"));
                        if (!ImGui.checkbox(AxiomI18n.get("axiom.tool.shape.smart_surface.visualize_mesh"), this.visualizeMesh)) break;
                        this.visualizeMesh = !this.visualizeMesh;
                        changed = true;
                    }
                }
                this.usingRealCoordinates = true;
                this.singleGizmoWithRotation = false;
                break;
            }
            case 3: {
                this.usingRealCoordinates = false;
                this.singleGizmoWithRotation = true;
                break;
            }
            default: {
                throw new FaultyImplementationError();
            }
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.placement_options"));
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.shape.offset_when_placing"), this.offsetWhenPlacing)) {
            this.offsetWhenPlacing = !this.offsetWhenPlacing;
            changed = true;
        }
        if (this.shapeCategory[0] != 2) {
            changed |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.shape.gizmo_space"), this.gizmoSpace, new String[]{AxiomI18n.get("axiom.tool.shape.gizmo_space.global"), AxiomI18n.get("axiom.tool.shape.gizmo_space.local")});
            if (this.shapeCategory[0] != 1) {
                changed |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.shape.pivot"), this.pivot, new String[]{AxiomI18n.get("axiom.tool.shape.pivot.center"), AxiomI18n.get("axiom.tool.shape.pivot.base")});
            }
            changed |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.shape.rotation"), this.placeRotation, new String[]{AxiomI18n.get("axiom.tool.shape.rotation.keep"), AxiomI18n.get("axiom.tool.shape.rotation.auto"), AxiomI18n.get("axiom.tool.shape.rotation.reset")});
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.paste_options"));
        if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.clipboard.placement_options.keep_existing"), this.keepExisting)) {
            this.keepExisting = !this.keepExisting;
            changed = true;
        }
        if (!this.singleGizmoWithRotation && this.hasActiveGizmo) {
            ImGui.separator();
            ImGui.text(AxiomI18n.get("axiom.tool.shape.extrude_tip"));
        }
        if (changed) {
            this.recalculate = true;
        }
    }

    private boolean displayDiameterXYZ(String diameterTerm) {
        boolean settingsChanged = false;
        if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.create_shape.separate_xyz") + "##SeparateXYZ", this.separateXYZ)) {
            boolean bl = this.separateXYZ = !this.separateXYZ;
            if (this.separateXYZ) {
                this.sizeX[0] = this.sizeXYZ[0];
                this.sizeY[0] = this.sizeXYZ[0];
                this.sizeZ[0] = this.sizeXYZ[0];
            } else {
                this.sizeXYZ[0] = Math.round((float)this.sizeX[0] / 3.0f + (float)this.sizeY[0] / 3.0f + (float)this.sizeZ[0] / 3.0f);
            }
            settingsChanged = true;
        }
        if (this.separateXYZ) {
            settingsChanged |= ImGui.sliderInt(diameterTerm + " X##SizeX", this.sizeX, 1, 64);
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
            settingsChanged |= ImGui.sliderInt(diameterTerm + " Y##SizeY", this.sizeY, 1, 64);
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
            settingsChanged |= ImGui.sliderInt(diameterTerm + " Z##SizeZ", this.sizeZ, 1, 64);
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
            this.sizeXYZ[0] = Math.round((float)this.sizeX[0] / 3.0f + (float)this.sizeY[0] / 3.0f + (float)this.sizeZ[0] / 3.0f);
        } else {
            settingsChanged |= ImGui.sliderInt(diameterTerm + "##Size", this.sizeXYZ, 1, 64);
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
            this.sizeX[0] = this.sizeXYZ[0];
            this.sizeY[0] = this.sizeXYZ[0];
            this.sizeZ[0] = this.sizeXYZ[0];
        }
        return settingsChanged;
    }

    private boolean displayDiameterXZ(String diameterTerm) {
        boolean settingsChanged = false;
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.shape.separate_xz"), this.separateXYZ)) {
            boolean bl = this.separateXYZ = !this.separateXYZ;
            if (this.separateXYZ) {
                this.sizeX[0] = this.sizeXYZ[0];
                this.sizeZ[0] = this.sizeXYZ[0];
            } else {
                this.sizeXYZ[0] = Math.round((float)this.sizeX[0] / 2.0f + (float)this.sizeZ[0] / 2.0f);
            }
            settingsChanged = true;
        }
        if (this.separateXYZ) {
            settingsChanged |= ImGui.sliderInt(diameterTerm + " X##SizeX", this.sizeX, 1, 64);
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
            settingsChanged |= ImGui.sliderInt(diameterTerm + " Z##SizeZ", this.sizeZ, 1, 64);
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
            this.sizeXYZ[0] = Math.round((float)this.sizeX[0] / 2.0f + (float)this.sizeZ[0] / 2.0f);
        } else {
            settingsChanged |= ImGui.sliderInt(diameterTerm + "##Size", this.sizeXYZ, 1, 64);
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
            this.sizeX[0] = this.sizeXYZ[0];
            this.sizeZ[0] = this.sizeXYZ[0];
        }
        return settingsChanged;
    }

    private boolean displayRingHV(String diameterTerm) {
        boolean settingsChanged = false;
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.shape.separate_hv"), this.separateHV)) {
            this.separateHV = !this.separateHV;
            settingsChanged = true;
        }
        if (this.separateHV) {
            settingsChanged |= ImGui.sliderInt(diameterTerm + " H##RingH", this.ringH, 1, 64);
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
            settingsChanged |= ImGui.sliderInt(diameterTerm + " V##RingV", this.ringV, 1, 64);
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
        } else {
            settingsChanged |= ImGui.sliderInt(diameterTerm + "##RingHV", this.ringH, 1, 64);
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
            this.ringV[0] = this.ringH[0];
        }
        return settingsChanged;
    }

    private boolean displayHeight() {
        boolean settingsChanged = ImGui.sliderInt(AxiomI18n.get("axiom.tool.shape.height") + "##SizeY", this.sizeY, 1, 64);
        ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
        return settingsChanged;
    }

    private boolean displayGenericShape(boolean hollow, boolean metaball) {
        boolean settingsChanged = this.displayAdvancedRotation();
        if (hollow || metaball) {
            ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.modifiers"));
            if (hollow) {
                settingsChanged |= this.displayHollow();
            }
            if (metaball) {
                settingsChanged |= this.displayMetaball();
            }
        }
        return settingsChanged;
    }

    private boolean displayHollow() {
        if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.create_shape.hollow") + "##Hollow", this.hollow)) {
            this.hollow = !this.hollow;
            return true;
        }
        return false;
    }

    private boolean displayMetaball() {
        boolean settingsChanged = false;
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.shape.metaball") + "##Metaball", this.metaball)) {
            this.metaball = !this.metaball;
            settingsChanged = true;
        }
        if (this.metaball) {
            settingsChanged |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.shape.metaball_range"), this.metaballRange, 2, 16);
        }
        return settingsChanged;
    }

    private boolean displayAdvancedRotation() {
        boolean settingsChanged = false;
        if (ImGui.collapsingHeader(AxiomI18n.get("axiom.editorui.window.create_shape.advanced"))) {
            ImGui.indent(8.0f * EditorUI.getUiScale());
            if (ImGui.button(AxiomI18n.get("axiom.tool.shape.reset_rotation"), ImGui.calcItemWidth(), 0.0f)) {
                this.rotationX[0] = 0.0f;
                this.rotationY[0] = 0.0f;
                this.rotationZ[0] = 0.0f;
                settingsChanged = true;
            }
            settingsChanged |= ImGui.sliderFloat(AxiomI18n.get("axiom.editorui.window.create_shape.yaw"), this.rotationY, -180.0f, 180.0f, "%.2f\u00b0");
            settingsChanged |= ImGui.sliderFloat(AxiomI18n.get("axiom.editorui.window.create_shape.pitch"), this.rotationX, -180.0f, 180.0f, "%.2f\u00b0");
            settingsChanged |= ImGui.sliderFloat(AxiomI18n.get("axiom.editorui.window.create_shape.roll"), this.rotationZ, -180.0f, 180.0f, "%.2f\u00b0");
            ImGui.unindent(8.0f * EditorUI.getUiScale());
        }
        if (settingsChanged) {
            this.rotationQuaternion.identity();
            this.rotationQuaternion.rotateYXZ((float)Math.toRadians(this.rotationY[0]), (float)Math.toRadians(this.rotationX[0]), (float)Math.toRadians(this.rotationZ[0]));
        }
        return settingsChanged;
    }

    private int getGizmoSpace() {
        if (!this.singleGizmoWithRotation) {
            return 0;
        }
        return this.gizmoSpace[0];
    }

    private int getPivot() {
        if (!this.singleGizmoWithRotation) {
            return 0;
        }
        if (this.shapeCategory[0] != 0 && this.shapeCategory[0] != 3) {
            return 0;
        }
        return this.pivot[0];
    }

    private class_2338 calculateRawPivot(int height) {
        int pivot = this.getPivot();
        if (pivot == 0) {
            return class_2338.field_10980;
        }
        if (pivot == 1) {
            return new class_2338(0, (int)Math.floor((float)(height - 1) / 2.0f), 0);
        }
        throw new FaultyImplementationError();
    }

    private class_2338 calculatePivot(int height) {
        int pivot = this.getPivot();
        if (pivot == 0) {
            return class_2338.field_10980;
        }
        if (pivot == 1) {
            Vector3d vector = new Vector3d(0.0, Math.floor((float)(height - 1) / 2.0f), 0.0);
            this.rotationQuaternion.transformInverse(vector);
            return class_2338.method_49637((double)(vector.x + 0.5), (double)(vector.y + 0.5), (double)(vector.z + 0.5));
        }
        throw new FaultyImplementationError();
    }

    private int getPlaceRotation() {
        if (!this.singleGizmoWithRotation) {
            return 2;
        }
        return this.placeRotation[0];
    }

    private void setRotationAuto(class_2338 at) {
        this.rotationZ[0] = 0.0f;
        this.rotationY[0] = 0.0f;
        this.rotationX[0] = 0.0f;
        this.rotationQuaternion.identity();
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        float offsetZ = 0.0f;
        int checkRadiusSq = 12;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        int x = at.method_10263();
        int y = at.method_10264();
        int z = at.method_10260();
        for (int xo = -3; xo <= 3; ++xo) {
            for (int yo = -3; yo <= 3; ++yo) {
                for (int zo = -3; zo <= 3; ++zo) {
                    class_2680 block;
                    int distSq = xo * xo + yo * yo + zo * zo;
                    if (distSq > checkRadiusSq || !(block = world.method_8320((class_2338)mutableBlockPos.method_10103(x + xo, y + yo, z + zo))).method_51366()) continue;
                    float factor = 1.0f / (float)Math.max(1.0, Math.sqrt(distSq));
                    offsetX -= (float)xo * factor;
                    offsetY -= (float)yo * factor;
                    offsetZ -= (float)zo * factor;
                }
            }
        }
        float lengthSq = offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ;
        if (lengthSq > 0.01f) {
            float invNormalLength = 1.0f / (float)Math.sqrt(lengthSq);
            float normalX = offsetX * invNormalLength;
            float normalY = offsetY * invNormalLength;
            float normalZ = offsetZ * invNormalLength;
            if ((double)Math.abs(normalX) < 1.0E-4) {
                normalX = 0.0f;
            }
            if ((double)Math.abs(normalY) < 1.0E-4) {
                normalY = 0.0f;
            }
            if ((double)Math.abs(normalZ) < 1.0E-4) {
                normalZ = 0.0f;
            }
            double horizontal = Math.sqrt(normalX * normalX + normalZ * normalZ);
            float pitch = class_3532.method_15393((float)((float)(-(class_3532.method_15349((double)normalY, (double)horizontal) * 57.2957763671875)) + 90.0f));
            float yaw = class_3532.method_15393((float)((float)(class_3532.method_15349((double)normalZ, (double)normalX) * 57.2957763671875) + 90.0f));
            this.rotationQuaternion.rotateXYZ((float)Math.toRadians(pitch), (float)Math.toRadians(yaw), 0.0f);
            Vector3f euler = this.rotationQuaternion.getEulerAnglesYXZ(new Vector3f());
            this.rotationX[0] = Math.round(Math.toDegrees(euler.x));
            this.rotationY[0] = Math.round(Math.toDegrees(euler.y));
            this.rotationZ[0] = Math.round(Math.toDegrees(euler.z));
            this.rotationQuaternion.identity();
            this.rotationQuaternion.rotateYXZ((float)Math.toRadians(this.rotationY[0]), (float)Math.toRadians(this.rotationX[0]), (float)Math.toRadians(this.rotationZ[0]));
        }
    }

    @Override
    public String listenForEsc() {
        if (this.hasActiveGizmo) {
            return "Deselect Point";
        }
        if (!this.gizmos.isEmpty()) {
            return AxiomI18n.get("axiom.widget.cancel");
        }
        return null;
    }

    @Override
    public String listenForEnter() {
        if (!this.chunkedBlockRegion.isEmpty()) {
            return AxiomI18n.get("axiom.widget.confirm");
        }
        return null;
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.shape");
    }

    @Override
    public void writeSourceInfo(class_2487 tag, boolean includeSettings) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeSettings(class_2487 tag) {
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.recalculate = true;
    }

    @Override
    public char iconChar() {
        return '\ue91c';
    }

    @Override
    public String keybindId() {
        return "shape";
    }
}

