/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.stamp;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.Restrictions;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.blueprint.Blueprint;
import com.moulberry.axiom.blueprint.BlueprintIo;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.collections.Position2dSet;
import com.moulberry.axiom.collections.Position2dToIntMap;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.PresetWidget;
import com.moulberry.axiom.editor.windows.clipboard.BlueprintBrowserWindow;
import com.moulberry.axiom.gizmo.Gizmo;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.noise.WhiteNoise;
import com.moulberry.axiom.noise.generic.PositionalRandom;
import com.moulberry.axiom.pather.ToolPatherSurface;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.render.regions.InstancedBlockRegion;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.ToolManager;
import com.moulberry.axiom.tools.stamp.IntermediatePlacement;
import com.moulberry.axiom.tools.stamp.StampBlueprintConfig;
import com.moulberry.axiom.tools.stamp.StampPlacement;
import com.moulberry.axiom.tools.stamp.TransformedBlockRegions;
import com.moulberry.axiom.utils.NbtGetter;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import com.moulberry.axiom.world_modification.HistoryEntry;
import com.moulberry.axiomclientapi.pathers.BallShape;
import com.moulberry.axiomclientapi.regions.BooleanRegion;
import imgui.ImGui;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import net.minecraft.class_1011;
import net.minecraft.class_124;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Matrix4f;

public class StampTool
implements Tool {
    private final List<StampPlacement> brushPlacements = new ArrayList<StampPlacement>();
    private final List<IntermediatePlacement> intermediatePlacements = new ArrayList<IntermediatePlacement>();
    private final Map<ChunkedBlockRegion, InstancedBlockRegion> renderMap = new IdentityHashMap<ChunkedBlockRegion, InstancedBlockRegion>();
    private final ChunkedBooleanRegion previewSphere = new ChunkedBooleanRegion();
    private final ChunkedBooleanRegion stampBlocksPreview = new ChunkedBooleanRegion();
    private int oldRadius = -1;
    private int oldBrushShape = -1;
    private boolean usingTool = false;
    private ToolPatherSurface toolPather = null;
    private class_243 lastPlayerPos = class_243.field_1353;
    private boolean updateRenderMap = false;
    private final Position2dToIntMap heightMap = new Position2dToIntMap(Integer.MIN_VALUE);
    private Future<AsyncComputationResult> asyncComputationFuture = null;
    private boolean heightMapDirty = false;
    private boolean selectedGizmo = false;
    private final int[] brushShape = new int[]{0};
    private final int[] radius = new int[]{4};
    private final int[] placeMode = new int[]{0};
    private final float[] baseChance = new float[]{1.0f};
    private final int[] minSpacing = new int[]{5};
    private boolean randomYaw = true;
    private boolean randomXZFlip = true;
    private boolean keepExisting = true;
    private boolean extendFoundationToGround = false;
    private final List<Blueprint> blueprints = new ArrayList<Blueprint>();
    private final List<TransformedBlockRegions> transformedBlueprints = new ArrayList<TransformedBlockRegions>();
    private final List<StampBlueprintConfig> blueprintSettings = new ArrayList<StampBlueprintConfig>();
    private final Map<String, class_2338> savedOffsets = new HashMap<String, class_2338>();
    private final PresetWidget presetWidget = new PresetWidget(this, "stamp");
    private boolean settingsChanged = false;

    @Override
    public void reset() {
        this.partialReset();
        this.renderMap.values().forEach(InstancedBlockRegion::close);
        this.renderMap.clear();
        this.intermediatePlacements.clear();
        this.selectedGizmo = false;
    }

    @Override
    public void toolDeselected() {
        BlueprintBrowserWindow.resetCallback();
    }

    private void partialReset() {
        this.usingTool = false;
        this.brushPlacements.clear();
        this.stampBlocksPreview.clear();
        if (this.asyncComputationFuture != null) {
            this.asyncComputationFuture.cancel(true);
            this.asyncComputationFuture = null;
        }
        this.heightMap.clear();
        this.heightMapDirty = false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                this.partialReset();
                if (!this.blueprints.isEmpty()) {
                    this.usingTool = true;
                    this.toolPather = new ToolPatherSurface(this.radius[0], BallShape.getByIndex((int)this.brushShape[0]), MaskManager.getSourceMask());
                }
                for (IntermediatePlacement intermediatePlacement : this.intermediatePlacements) {
                    intermediatePlacement.gizmo.enableAxes = false;
                }
                this.selectedGizmo = false;
                return UserAction.ActionResult.USED_STOP;
            }
            case LEFT_MOUSE: {
                for (IntermediatePlacement intermediatePlacement : this.intermediatePlacements) {
                    if (!intermediatePlacement.gizmo.enableAxes || !intermediatePlacement.gizmo.leftClick()) continue;
                    this.selectedGizmo = true;
                    return UserAction.ActionResult.USED_STOP;
                }
                Gizmo disableExcept = null;
                for (IntermediatePlacement intermediate : this.intermediatePlacements) {
                    if (intermediate.gizmo.enableAxes || !intermediate.gizmo.leftClick()) continue;
                    this.selectedGizmo = true;
                    disableExcept = intermediate.gizmo;
                    break;
                }
                if (disableExcept != null) {
                    for (IntermediatePlacement intermediate : this.intermediatePlacements) {
                        if (intermediate.gizmo == disableExcept) continue;
                        intermediate.gizmo.enableAxes = false;
                    }
                    return UserAction.ActionResult.USED_STOP;
                }
                if (!EditorUI.isCtrlOrCmdDown()) {
                    for (IntermediatePlacement intermediate : this.intermediatePlacements) {
                        intermediate.gizmo.enableAxes = false;
                    }
                    this.selectedGizmo = false;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case ENTER: {
                if (this.brushPlacements.isEmpty() && this.intermediatePlacements.isEmpty()) break;
                ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
                if (this.extendFoundationToGround) {
                    for (StampPlacement placement : this.brushPlacements) {
                        placement.pasteIntoExtendToGround(chunkedBlockRegion, (class_1937)class_310.method_1551().field_1687);
                    }
                    for (IntermediatePlacement intermediate : this.intermediatePlacements) {
                        intermediate.placement.pasteIntoExtendToGround(chunkedBlockRegion, (class_1937)class_310.method_1551().field_1687);
                    }
                } else {
                    for (StampPlacement placement : this.brushPlacements) {
                        placement.pasteInto(chunkedBlockRegion);
                    }
                    for (IntermediatePlacement intermediate : this.intermediatePlacements) {
                        intermediate.placement.pasteInto(chunkedBlockRegion);
                    }
                }
                int n = this.keepExisting ? HistoryEntry.MODIFIER_KEEP_EXISTING : 0;
                String countString = NumberFormat.getInstance().format(chunkedBlockRegion.count());
                String historyDescription = AxiomI18n.get("axiom.history_description.placed", countString);
                RegionHelper.pushBlockRegionChange(chunkedBlockRegion, historyDescription, Tool.getSourceInfo(this), n);
                this.reset();
                break;
            }
            case REDO: {
                if (!this.usingTool && this.intermediatePlacements.isEmpty()) break;
                return UserAction.ActionResult.USED_STOP;
            }
            case ESCAPE: {
                boolean disabled = false;
                this.updateRenderMap = true;
                for (IntermediatePlacement intermediatePlacement : this.intermediatePlacements) {
                    if (!intermediatePlacement.gizmo.enableAxes) continue;
                    intermediatePlacement.gizmo.enableAxes = false;
                    disabled = true;
                }
                this.selectedGizmo = false;
                if (disabled) {
                    return UserAction.ActionResult.USED_STOP;
                }
                if (this.usingTool) {
                    this.partialReset();
                    this.updateRenderMap();
                    return UserAction.ActionResult.USED_STOP;
                }
                if (this.intermediatePlacements.isEmpty()) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
            case DELETE: 
            case UNDO: {
                void var4_21;
                this.updateRenderMap = true;
                boolean removed = false;
                boolean bl = false;
                while (var4_21 < this.intermediatePlacements.size()) {
                    if (this.intermediatePlacements.get((int)var4_21).gizmo.enableAxes) {
                        this.intermediatePlacements.remove((int)var4_21);
                        --var4_21;
                        removed = true;
                    }
                    ++var4_21;
                }
                this.selectedGizmo = false;
                if (removed) {
                    return UserAction.ActionResult.USED_STOP;
                }
                if (!this.usingTool && this.intermediatePlacements.isEmpty()) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        block43: {
            float opacity;
            int maxPlacements;
            boolean placementMoved;
            boolean renderGizmos;
            boolean isCtrlDown;
            block42: {
                boolean showGizmo;
                if (this.blueprints.isEmpty() && this.intermediatePlacements.isEmpty()) {
                    return;
                }
                class_243 lookDirection = Tool.getLookDirection();
                boolean isLeftDown = Tool.isMouseDown(0);
                isCtrlDown = EditorUI.isCtrlOrCmdDown();
                renderGizmos = showGizmo = !isCtrlDown;
                boolean gizmoHovered = false;
                placementMoved = false;
                class_243 playerPos = class_310.method_1551().field_1724.method_33571();
                if (playerPos.method_1025(this.lastPlayerPos) > 1.0) {
                    this.lastPlayerPos = playerPos;
                    this.updateClosestGizmos(playerPos);
                }
                maxPlacements = Math.min(64, this.intermediatePlacements.size());
                for (int i = 0; i < maxPlacements; ++i) {
                    class_2338 newTarget;
                    IntermediatePlacement intermediate2 = this.intermediatePlacements.get(i);
                    Gizmo gizmo = intermediate2.gizmo;
                    class_2338 previousTarget = gizmo.getTargetPosition();
                    gizmo.update(time, lookDirection, isLeftDown, isCtrlDown, showGizmo);
                    if (gizmo.enableAxes) {
                        gizmo.setAxisDirections(camera.method_19326().field_1352 > (double)gizmo.getTargetPosition().method_10263(), camera.method_19326().field_1351 > (double)gizmo.getTargetPosition().method_10264(), camera.method_19326().field_1350 > (double)gizmo.getTargetPosition().method_10260());
                        gizmoHovered = true;
                        this.selectedGizmo = true;
                    }
                    if (gizmo.isGrabbed()) {
                        renderGizmos = true;
                    }
                    if (gizmo.isHovered()) {
                        gizmoHovered = true;
                    }
                    if ((newTarget = gizmo.getTargetPosition()).equals((Object)previousTarget)) continue;
                    intermediate2.placement = intermediate2.placement.withBasePosition(newTarget.method_10263(), newTarget.method_10264(), newTarget.method_10260());
                    placementMoved = true;
                }
                opacity = (float)Math.sin((float)time / 1000000.0f / 50.0f / 8.0f);
                if (this.usingTool) break block42;
                RayCaster.RaycastResult result = Tool.raycastBlock();
                if (result == null) {
                    Selection.render(camera, time, matrices, projection, this.intermediatePlacements.isEmpty() ? 7 : 4);
                } else if (!gizmoHovered) {
                    int radius = this.radius[0];
                    int brushShape = this.brushShape[0];
                    if (this.oldRadius != radius || this.oldBrushShape != brushShape) {
                        this.oldRadius = radius;
                        this.oldBrushShape = brushShape;
                        this.previewSphere.clear();
                        BallShape.getByIndex((int)brushShape).fillRegion((BooleanRegion)this.previewSphere, radius);
                    }
                    Selection.render(camera, time, matrices, projection, 4);
                    this.previewSphere.render(camera, class_243.method_24954((class_2382)result.getBlockPos()), matrices, projection, time, 1);
                }
                if (placementMoved || this.updateRenderMap) {
                    this.updateRenderMap();
                }
                for (InstancedBlockRegion blockRegion : this.renderMap.values()) {
                    blockRegion.render(camera, matrices, projection, 0.15f - opacity * 0.1f, true);
                }
                if (!renderGizmos) break block43;
                maxPlacements = Math.min(64, this.intermediatePlacements.size());
                for (int i = 0; i < maxPlacements; ++i) {
                    IntermediatePlacement intermediate3 = this.intermediatePlacements.get(i);
                    intermediate3.gizmo.render(matrices, camera, isCtrlDown);
                }
                break block43;
            }
            if (Tool.cancelUsing()) {
                this.partialReset();
                this.updateRenderMap();
            } else if (!Tool.isMouseDown(1)) {
                if (this.placeMode[0] == 0) {
                    ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
                    if (this.extendFoundationToGround) {
                        for (StampPlacement placement : this.brushPlacements) {
                            placement.pasteIntoExtendToGround(chunkedBlockRegion, (class_1937)class_310.method_1551().field_1687);
                        }
                    } else {
                        for (StampPlacement placement : this.brushPlacements) {
                            placement.pasteInto(chunkedBlockRegion);
                        }
                    }
                    int modifiers = this.keepExisting ? HistoryEntry.MODIFIER_KEEP_EXISTING : 0;
                    String countString = NumberFormat.getInstance().format(chunkedBlockRegion.count());
                    String historyDescription = AxiomI18n.get("axiom.history_description.placed", countString);
                    RegionHelper.pushBlockRegionChange(chunkedBlockRegion, historyDescription, Tool.getSourceInfo(this), modifiers);
                    this.reset();
                } else {
                    for (StampPlacement placement : this.brushPlacements) {
                        Gizmo gizmo = new Gizmo(new class_2338(placement.baseX(), placement.baseY(), placement.baseZ()));
                        gizmo.enableAxes = false;
                        this.intermediatePlacements.add(new IntermediatePlacement(gizmo, placement));
                    }
                    this.partialReset();
                    this.updateClosestGizmos(class_310.method_1551().field_1724.method_33571());
                }
            } else {
                class_638 level = class_310.method_1551().field_1687;
                if (level == null) {
                    return;
                }
                Selection.render(camera, time, matrices, projection, 4);
                WhiteNoise whiteNoise = new WhiteNoise(428362042L);
                this.heightMapDirty |= this.toolPather.update((x, y, z) -> {
                    this.stampBlocksPreview.add(x, y, z);
                    if ((double)this.baseChance[0] > 0.99 || whiteNoise.evaluate(x, z) < this.baseChance[0]) {
                        this.heightMap.put(x, z, y + 1);
                    }
                });
                boolean changed = false;
                if (this.asyncComputationFuture != null) {
                    if (this.asyncComputationFuture.isDone()) {
                        try {
                            AsyncComputationResult result = this.asyncComputationFuture.get();
                            this.brushPlacements.clear();
                            this.brushPlacements.addAll(result.newBrushPlacements);
                            this.intermediatePlacements.removeIf(intermediate -> {
                                StampPlacement placement = intermediate.placement;
                                return result.spacingBlacklistSet.contains(placement.baseX(), placement.baseZ());
                            });
                            changed = true;
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                        this.asyncComputationFuture = null;
                    }
                } else if (this.heightMapDirty) {
                    Position2dToIntMap heightMap = this.heightMap.copy();
                    int minSpacing = this.minSpacing[0];
                    ArrayList<StampBlueprintConfig> blueprintSettings = new ArrayList<StampBlueprintConfig>();
                    for (StampBlueprintConfig blueprintSetting : this.blueprintSettings) {
                        blueprintSettings.add(blueprintSetting.copy());
                    }
                    if (this.transformedBlueprints.size() < this.blueprints.size()) {
                        for (int i = this.transformedBlueprints.size(); i < this.blueprints.size(); ++i) {
                            this.transformedBlueprints.add(new TransformedBlockRegions(this.blueprints.get(i).blockRegion()));
                        }
                    } else if (this.transformedBlueprints.size() > this.blueprints.size()) {
                        int toRemove = this.transformedBlueprints.size() - this.blueprints.size();
                        for (int i = 0; i < toRemove; ++i) {
                            this.transformedBlueprints.remove(this.transformedBlueprints.size() - 1);
                        }
                    }
                    for (int i = 0; i < this.transformedBlueprints.size(); ++i) {
                        TransformedBlockRegions transformed = this.transformedBlueprints.get(i);
                        ChunkedBlockRegion blockRegion = this.blueprints.get(i).blockRegion();
                        if (transformed.get(0, false, false) == blockRegion) continue;
                        this.transformedBlueprints.set(i, new TransformedBlockRegions(blockRegion));
                    }
                    this.asyncComputationFuture = Tool.sharedSingleThreadExecutor.submit(() -> StampTool.update(heightMap, blueprintSettings, new ArrayList<TransformedBlockRegions>(this.transformedBlueprints), minSpacing, this.randomYaw, this.randomXZFlip));
                    this.heightMapDirty = false;
                }
                if (changed || placementMoved || this.updateRenderMap) {
                    this.updateRenderMap();
                }
                for (InstancedBlockRegion blockRegion : this.renderMap.values()) {
                    blockRegion.render(camera, matrices, projection, 0.15f - opacity * 0.1f, true);
                }
                this.stampBlocksPreview.render(camera, class_243.field_1353, matrices, projection, time, 1);
                if (renderGizmos) {
                    maxPlacements = Math.min(64, this.intermediatePlacements.size());
                    for (int i = 0; i < maxPlacements; ++i) {
                        IntermediatePlacement intermediate4 = this.intermediatePlacements.get(i);
                        intermediate4.gizmo.render(matrices, camera, isCtrlDown);
                    }
                }
            }
        }
    }

    private void updateClosestGizmos(class_243 playerPos) {
        this.intermediatePlacements.sort(Comparator.comparingDouble(intermediate -> {
            if (intermediate.gizmo.enableAxes) {
                return 0.0;
            }
            return intermediate.gizmo.getTargetPosition().method_19770((class_2374)playerPos);
        }));
    }

    private void updateRenderMap() {
        this.updateRenderMap = false;
        IdentityHashMap<ChunkedBlockRegion, List> instancedRenders = new IdentityHashMap<ChunkedBlockRegion, List>();
        for (StampPlacement stampPlacement : this.brushPlacements) {
            instancedRenders.computeIfAbsent(stampPlacement.blockRegion(), k -> new ArrayList()).add(stampPlacement.getRenderOffset());
        }
        for (IntermediatePlacement intermediatePlacement : this.intermediatePlacements) {
            StampPlacement placement = intermediatePlacement.placement;
            instancedRenders.computeIfAbsent(placement.blockRegion(), k -> new ArrayList()).add(placement.getRenderOffset());
        }
        for (Map.Entry entry : instancedRenders.entrySet()) {
            InstancedBlockRegion instancedBlockRegion = this.renderMap.get(entry.getKey());
            if (instancedBlockRegion == null) {
                instancedBlockRegion = new InstancedBlockRegion((ChunkedBlockRegion)entry.getKey());
                this.renderMap.put((ChunkedBlockRegion)entry.getKey(), instancedBlockRegion);
            }
            instancedBlockRegion.setTranslations((List)entry.getValue());
        }
        Iterator<Map.Entry<ChunkedBlockRegion, InstancedBlockRegion>> iterator = this.renderMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ChunkedBlockRegion, InstancedBlockRegion> entry = iterator.next();
            if (instancedRenders.containsKey(entry.getKey())) continue;
            entry.getValue().close();
            iterator.remove();
        }
    }

    private static AsyncComputationResult update(Position2dToIntMap heightMap, List<StampBlueprintConfig> blueprintSettings, List<TransformedBlockRegions> transformedBlueprints, int minSpacing, boolean randomYaw, boolean randomXZFlip) {
        PositionalRandom positionalRandom = new PositionalRandom(0L, 0L);
        class_1923 chunkPos = heightMap.getLastChunk();
        int relX = chunkPos.field_9181 * 16 + 8;
        int relZ = chunkPos.field_9180 * 16 + 8;
        LongArrayList positions = new LongArrayList();
        heightMap.forEachEntry((arg_0, arg_1, arg_2) -> StampTool.lambda$update$6(positionalRandom, relX, relZ, (LongList)positions, arg_0, arg_1, arg_2));
        positions.unstableSort(null);
        Position2dSet spacingBlacklistSet = new Position2dSet();
        ArrayList<StampPlacement> newBrushPlacements = new ArrayList<StampPlacement>();
        int minSpacingSq = minSpacing * minSpacing + minSpacing;
        float totalWeight = 0.0f;
        for (StampBlueprintConfig config : blueprintSettings) {
            totalWeight += config.chance()[0];
        }
        float invTotalWeight = 1.0f / totalWeight;
        for (int index = 0; index < positions.size(); ++index) {
            long pos = positions.getLong(index);
            int x = (short)(pos >>> 16 & 0xFFFFL) + relX;
            int z = (short)(pos & 0xFFFFL) + relZ;
            int y = heightMap.get(x, z);
            if (spacingBlacklistSet.contains(x, z)) continue;
            positionalRandom.at(x, y, z);
            int blueprintIndex = -1;
            float blueprintFloat = positionalRandom.nextFloat();
            for (int i = 0; i < blueprintSettings.size(); ++i) {
                StampBlueprintConfig config = blueprintSettings.get(i);
                if (!((blueprintFloat -= config.chance()[0] * invTotalWeight) <= 0.0f)) continue;
                blueprintIndex = i;
                break;
            }
            if (blueprintIndex < 0) {
                blueprintIndex = blueprintSettings.size() - 1;
            }
            StampBlueprintConfig config = blueprintSettings.get(blueprintIndex);
            int rotation = randomYaw ? positionalRandom.nextInt(4) : 0;
            boolean flipX = randomXZFlip && positionalRandom.nextBoolean();
            boolean flipZ = !randomYaw && randomXZFlip && positionalRandom.nextBoolean();
            StampPlacement stampPlacement = new StampPlacement(transformedBlueprints.get(blueprintIndex).get(rotation, flipX, flipZ), x + config.offset()[0], y + config.offset()[1], z + config.offset()[2], x, y, z);
            newBrushPlacements.add(stampPlacement);
            if (minSpacing <= 0) continue;
            for (int xo = -minSpacing; xo <= minSpacing; ++xo) {
                for (int zo = -minSpacing; zo <= minSpacing; ++zo) {
                    if (xo * xo + zo * zo > minSpacingSq) continue;
                    spacingBlacklistSet.add(x + xo, z + zo);
                }
            }
        }
        return new AsyncComputationResult(spacingBlacklistSet, newBrushPlacements);
    }

    @Override
    public void displayImguiOptions() {
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.brush"));
        this.settingsChanged |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.generic.brush_shape"), this.brushShape, BallShape.getAllNames());
        this.settingsChanged |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.generic.brush_radius"), this.radius, 0, 64);
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.stamp"));
        this.settingsChanged |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.stamp.base_chance"), this.baseChance, 0.001f, 1.0f, "%.3f", 32);
        this.settingsChanged |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.stamp.min_spacing"), this.minSpacing, 0, 64);
        this.settingsChanged |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.stamp.place"), this.placeMode, new String[]{AxiomI18n.get("axiom.tool.stamp.place_immediate"), AxiomI18n.get("axiom.tool.stamp.place_deferred")});
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.smooth.modifiers"));
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.stamp.random_yaw"), this.randomYaw)) {
            this.randomYaw = !this.randomYaw;
            this.settingsChanged = true;
        }
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.stamp.random_xz_flip"), this.randomXZFlip)) {
            this.randomXZFlip = !this.randomXZFlip;
            this.settingsChanged = true;
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.stamp.paste_options"));
        if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.clipboard.placement_options.keep_existing"), this.keepExisting)) {
            this.keepExisting = !this.keepExisting;
            this.settingsChanged = true;
        }
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.stamp.extend_foundation_to_ground"), this.extendFoundationToGround)) {
            this.extendFoundationToGround = !this.extendFoundationToGround;
            this.settingsChanged = true;
        }
        ImGui.sameLine();
        ImGuiHelper.helpMarker(AxiomI18n.get("axiom.tool.stamp.extend_foundation_to_ground_tooltip"));
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.stamp.blueprints"));
        if (ImGui.button(AxiomI18n.get("axiom.tool.stamp.add_blueprint"))) {
            if (!Restrictions.canImportBlocks) {
                class_746 player = class_310.method_1551().field_1724;
                if (player != null) {
                    player.method_43496((class_2561)class_2561.method_43470((String)"The server has disallowed the use of blueprints").method_27692(class_124.field_1061));
                }
            } else {
                Predicate<Blueprint> callback = blueprint -> {
                    float newChance;
                    if (!ToolManager.isToolActive() || !(ToolManager.getCurrentTool() instanceof StampTool)) {
                        return false;
                    }
                    float total = 0.0f;
                    for (StampBlueprintConfig config : this.blueprintSettings) {
                        total += config.chance()[0];
                    }
                    if (total < 100.0f) {
                        newChance = 100.0f - total;
                    } else {
                        float factor = (float)this.blueprintSettings.size() / (float)(this.blueprintSettings.size() + 1);
                        for (StampBlueprintConfig config : this.blueprintSettings) {
                            float[] fArray = config.chance();
                            fArray[0] = fArray[0] * factor;
                        }
                        newChance = 100.0f / (float)(this.blueprintSettings.size() + 1);
                    }
                    int[] offset = new int[3];
                    String name = blueprint.header().name();
                    if (!name.isBlank() && this.savedOffsets.containsKey(name)) {
                        class_2338 savedOffset = this.savedOffsets.get(name);
                        offset[0] = savedOffset.method_10263();
                        offset[1] = savedOffset.method_10264();
                        offset[2] = savedOffset.method_10260();
                    } else {
                        int minY = blueprint.blockRegion().min().method_10264();
                        int maxY = blueprint.blockRegion().max().method_10264();
                        offset[1] = (minY + maxY) / 2 - minY;
                    }
                    this.blueprints.add((Blueprint)blueprint);
                    this.blueprintSettings.add(new StampBlueprintConfig(offset, new float[]{newChance}));
                    this.settingsChanged = true;
                    return true;
                };
                BlueprintBrowserWindow.open(callback, true);
            }
        }
        ImGui.sameLine();
        if (ImGui.button(AxiomI18n.get("axiom.editorui.window.clipboard.clear"))) {
            for (Blueprint blueprint2 : this.blueprints) {
                blueprint2.close();
            }
            this.blueprints.clear();
            this.blueprintSettings.clear();
            this.settingsChanged = true;
        }
        int removeIndex = -1;
        for (int i = 0; i < this.blueprints.size(); ++i) {
            Blueprint blueprint3 = this.blueprints.get(i);
            StampBlueprintConfig blueprintConfig = this.blueprintSettings.get(i);
            ImGui.imageButton(blueprint3.thumbnail().method_4624(), 64.0f, 64.0f, 0.0f, 1.0f, 1.0f, 0.0f, 2);
            if (ImGui.isItemClicked(1)) {
                ImGui.openPopup("##EditBlueprint" + i);
            }
            if (ImGuiHelper.beginPopup("##EditBlueprint" + i)) {
                if (ImGui.menuItem(AxiomI18n.get("axiom.tool.path.remove"))) {
                    removeIndex = i;
                }
                ImGui.endPopup();
            }
            ImGui.sameLine();
            ImGui.beginGroup();
            String name = blueprint3.header().name();
            boolean blankName = name.isBlank();
            String displayName = !blankName ? name : AxiomI18n.get("axiom.editorui.window.blueprint_browser.unnamed_blueprint");
            String formattedCount = NumberFormat.getNumberInstance().format(blueprint3.blockRegion().count());
            String blockCount = AxiomI18n.get("axiom.editorui.window.clipboard.n_blocks", formattedCount);
            ImGui.text(displayName + " (" + blockCount + ")");
            if (ImGuiHelper.inputInt(AxiomI18n.get("axiom.tool.stamp.offset") + "##" + i, blueprintConfig.offset(), true)) {
                if (!blankName) {
                    this.savedOffsets.put(name, new class_2338(blueprintConfig.offset()[0], blueprintConfig.offset()[1], blueprintConfig.offset()[2]));
                }
                this.settingsChanged = true;
            }
            ImGui.setNextItemWidth(ImGui.calcItemWidth() - (ImGui.getCursorPosX() - ImGui.getStyle().getWindowPaddingX()) * 2.0f / 3.0f);
            this.settingsChanged |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.stamp.chance") + "##" + i, blueprintConfig.chance(), 0.0f, 100.0f, "%.1f%%");
            ImGui.endGroup();
        }
        if (removeIndex >= 0) {
            this.blueprints.remove(removeIndex).close();
            this.blueprintSettings.remove(removeIndex);
            this.settingsChanged = true;
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.presets"));
        this.presetWidget.displayImgui(this.settingsChanged);
        this.settingsChanged = false;
    }

    @Override
    public String listenForEsc() {
        if (!this.intermediatePlacements.isEmpty() && this.selectedGizmo) {
            return "Deselect Gizmo";
        }
        if (this.usingTool || !this.intermediatePlacements.isEmpty()) {
            return AxiomI18n.get("axiom.widget.cancel");
        }
        return null;
    }

    @Override
    public String listenForEnter() {
        if (!this.brushPlacements.isEmpty() || !this.intermediatePlacements.isEmpty()) {
            return AxiomI18n.get("axiom.widget.confirm");
        }
        return null;
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.stamp");
    }

    @Override
    public void writeSourceInfo(class_2487 tag, boolean includeSettings) {
        tag.method_10582("SourceName", "Stamp Tool");
        if (includeSettings) {
            class_2487 settings = new class_2487();
            this.writeSettingsWithoutBlockData(settings);
            tag.method_10566("SourceSettings", (class_2520)settings);
        }
    }

    public void writeSettingsWithoutBlockData(class_2487 tag) {
        tag.method_10567("BrushShape", (byte)this.brushShape[0]);
        tag.method_10569("BrushRadius", this.radius[0]);
        tag.method_10569("PlaceMode", this.placeMode[0]);
        tag.method_10548("BaseChance", this.baseChance[0]);
        tag.method_10569("MinSpacing", this.minSpacing[0]);
        tag.method_10556("RandomYaw", this.randomYaw);
        tag.method_10556("RandomXZFlip", this.randomXZFlip);
    }

    @Override
    public void writeSettings(class_2487 tag) {
        this.writeSettingsWithoutBlockData(tag);
        class_2499 blueprintsTag = new class_2499();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < this.blueprints.size(); ++i) {
            baos.reset();
            Blueprint blueprint = this.blueprints.get(i);
            StampBlueprintConfig blueprintConfig = this.blueprintSettings.get(i);
            try {
                class_2487 stampBlueprint = new class_2487();
                class_1011 image = blueprint.thumbnail().field_5200;
                boolean closeNativeImage = false;
                if (image == null) {
                    image = new class_1011(96, 96, true);
                    closeNativeImage = true;
                }
                BlueprintIo.write(baos, blueprint.header(), image, blueprint.blockRegion(), (Long2ObjectMap<CompressedBlockEntity>)new Long2ObjectOpenHashMap());
                stampBlueprint.method_10570("Blueprint", baos.toByteArray());
                stampBlueprint.method_10569("OffsetX", blueprintConfig.offset()[0]);
                stampBlueprint.method_10569("OffsetY", blueprintConfig.offset()[1]);
                stampBlueprint.method_10569("OffsetZ", blueprintConfig.offset()[2]);
                stampBlueprint.method_10548("Chance", blueprintConfig.chance()[0]);
                blueprintsTag.add((Object)stampBlueprint);
                if (!closeNativeImage) continue;
                image.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        tag.method_10566("Blueprints", (class_2520)blueprintsTag);
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.brushShape[0] = NbtGetter.getIntOrDefault(tag, "BrushShape", 0);
        this.radius[0] = NbtGetter.getIntOrDefault(tag, "BrushRadius", 4);
        this.placeMode[0] = NbtGetter.getIntOrDefault(tag, "PlaceMode", 0);
        this.baseChance[0] = NbtGetter.getFloatOrDefault(tag, "BaseChance", 1.0f);
        this.minSpacing[0] = NbtGetter.getIntOrDefault(tag, "MinSpacing", 5);
        this.randomYaw = NbtGetter.getBoolOrDefault(tag, "RandomYaw", true);
        this.randomXZFlip = NbtGetter.getBoolOrDefault(tag, "RandomXZFlip", true);
        for (Blueprint blueprint : this.blueprints) {
            blueprint.close();
        }
        this.blueprints.clear();
        this.blueprintSettings.clear();
        class_2499 blueprintsTag = tag.method_10554("Blueprints", 10);
        for (class_2520 blueprintTag : blueprintsTag) {
            class_2487 blueprint = (class_2487)blueprintTag;
            try {
                byte[] blueprintData = blueprint.method_10547("Blueprint");
                Blueprint fullBlueprint = BlueprintIo.readBlueprint(new ByteArrayInputStream(blueprintData));
                int[] offset = new int[]{blueprint.method_10550("OffsetX"), blueprint.method_10550("OffsetY"), blueprint.method_10550("OffsetZ")};
                float chance = blueprint.method_10583("Chance");
                this.blueprints.add(fullBlueprint);
                this.blueprintSettings.add(new StampBlueprintConfig(offset, new float[]{chance}));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public char iconChar() {
        return '\ue91b';
    }

    @Override
    public String keybindId() {
        return "stamp";
    }

    private static /* synthetic */ void lambda$update$6(PositionalRandom positionalRandom, int relX, int relZ, LongList positions, int x, int z, int y) {
        positionalRandom.at(z, x, y);
        int weight = positionalRandom.nextInt();
        long position = ((long)weight & 0xFFFFFFFFL) << 32 | ((long)((short)(x - relX)) & 0xFFFFL) << 16 | (long)((short)(z - relZ)) & 0xFFFFL;
        positions.add(position);
    }

    record AsyncComputationResult(Position2dSet spacingBlacklistSet, List<StampPlacement> newBrushPlacements) {
    }
}

