/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.terraform.decoration;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.moulberry.axiom.collections.Position2dSet;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.ServerCustomBlocks;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.SelectBlockWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.noise.WhiteNoise;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.tools.terraform.ClentaminatorDecorationPlacer;
import com.moulberry.axiom.tools.terraform.ClentaminatorSettings;
import imgui.ImGui;
import java.util.List;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2802;
import net.minecraft.class_2806;
import net.minecraft.class_2874;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3233;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4543;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4651;
import net.minecraft.class_4658;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5141;
import net.minecraft.class_5201;
import net.minecraft.class_5204;
import net.minecraft.class_5207;
import net.minecraft.class_5210;
import net.minecraft.class_5212;
import net.minecraft.class_5214;
import net.minecraft.class_5217;
import net.minecraft.class_5281;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import net.minecraft.class_5575;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_638;
import net.minecraft.class_6677;
import net.minecraft.class_6748;
import net.minecraft.class_6756;
import net.minecraft.class_6760;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7699;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class TreeDecorationPlacer
implements ClentaminatorDecorationPlacer {
    private static final SelectBlockWidget selectBlockWidget = new SelectBlockWidget(false);
    private final WhiteNoise whiteNoiseBase = new WhiteNoise(1705875030L);
    private final class_5819 randomSource = new class_6677(0L);
    private final FakeWorldGenLevel fakeWorldGenLevel;
    private final FakeChunkGenerator fakeChunkGenerator;
    private final Position2dSet position2dSet = new Position2dSet();
    private final int type;
    private final float baseChance;
    private final int minimumDistance;
    private final class_2680 logState;
    private final class_2680 leavesState;

    public TreeDecorationPlacer(Settings settings) {
        this.type = settings.type[0];
        this.baseChance = settings.baseChance[0];
        this.minimumDistance = settings.minimumDistance[0];
        this.logState = settings.logState.getVanillaState();
        this.leavesState = settings.leavesState.getVanillaState();
        class_638 clientLevel = class_310.method_1551().field_1687;
        this.fakeWorldGenLevel = new FakeWorldGenLevel(clientLevel);
        this.fakeChunkGenerator = new FakeChunkGenerator(clientLevel);
    }

    @Override
    public void place(class_1922 blockGetter, ChunkedBlockRegion blockRegion, MaskElement element, MaskContext maskContext, int x, int y, int z) {
        if (this.position2dSet.contains(x, z)) {
            return;
        }
        float whiteBase = this.whiteNoiseBase.evaluate(x, z);
        if (whiteBase > this.baseChance) {
            return;
        }
        try {
            this.fakeWorldGenLevel.setBlockRegion(blockRegion);
            class_4643 config = this.type == 0 ? new class_4643.class_4644((class_4651)class_4651.method_38432((class_2248)class_2246.field_10037), (class_5141)new class_5214(13, 2, 14), (class_4651)class_4651.method_38432((class_2248)class_2246.field_9988), (class_4647)new class_5210((class_6017)class_6016.method_34998((int)0), (class_6017)class_6016.method_34998((int)0), (class_6017)class_6019.method_35017((int)3, (int)7)), (class_5201)new class_5204(1, 1, 2)).method_27376((List)ImmutableList.of((Object)new class_4658((class_4651)class_4651.method_38432((class_2248)class_2246.field_10520)))).method_23445() : new class_4643.class_4644((class_4651)class_4651.method_38433((class_2680)this.logState), (class_5141)new class_5212(3, 11, 0), (class_4651)class_4651.method_38433((class_2680)this.leavesState), (class_4647)new class_5207((class_6017)class_6016.method_34998((int)2), (class_6017)class_6016.method_34998((int)4), 4), (class_5201)new class_5204(0, 0, 0, OptionalInt.of(4))).method_27374().method_23445();
            boolean success = class_3031.field_24134.method_40163((class_3037)config, (class_5281)this.fakeWorldGenLevel, (class_2794)this.fakeChunkGenerator, this.randomSource, new class_2338(x, y, z));
            if (success && this.minimumDistance > 0) {
                int radius = this.minimumDistance;
                for (int xo = -radius; xo <= radius; ++xo) {
                    for (int zo = -radius; zo <= radius; ++zo) {
                        if (xo * xo + zo * zo > radius * radius + radius) continue;
                        this.position2dSet.add(x + xo, z + zo);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Settings
    implements ClentaminatorSettings {
        private final int[] type = new int[]{0};
        private float[] baseChance = new float[]{0.05f};
        private int[] minimumDistance = new int[]{5};
        private CustomBlockState logState = (CustomBlockState)class_2246.field_10431.method_9564();
        private CustomBlockState leavesState = (CustomBlockState)class_2246.field_10503.method_9564();

        @Override
        public void displayImguiOptions() {
            ImGuiHelper.combo(AxiomI18n.get("axiom.tool.clentaminator.tree_type"), this.type, new String[]{"Straight", "Fancy", "Dark Oak", "Acacia", "Spruce", "Pine", "Jungle", "Swamp Oak"});
            ImGui.sliderFloat(AxiomI18n.get("axiom.tool.clentaminator.base_chance"), this.baseChance, 0.001f, 1.0f, "%.3f", 32);
            ImGui.sliderInt(AxiomI18n.get("axiom.tool.clentaminator.minimum_distance"), this.minimumDistance, 1, 64);
            int buttonSize = (int)(32.0f * EditorUI.getUiScale());
            boolean blockButtonClick = ImGuiHelper.blockStateButton(this.leavesState, 1, buttonSize);
            CustomBlockState dragDropped = ImGuiHelper.blockStateDragDrop(this.leavesState);
            if (dragDropped != null) {
                this.leavesState = dragDropped;
            }
            ImGui.sameLine();
            float originalY = ImGui.getCursorPosY();
            ImGui.setCursorPosY(originalY + ((float)buttonSize - ImGui.getTextLineHeightWithSpacing()) / 2.0f - 1.0f);
            ImGui.text("Leaves Block (" + this.leavesState.getCustomBlock().getResourceLocation().toString() + ")");
            ImGui.setCursorPosY(originalY + (float)buttonSize + ImGui.getStyle().getItemSpacingY());
            if (blockButtonClick) {
                selectBlockWidget.open(1);
            }
            selectBlockWidget.render(AxiomI18n.get("axiom.widget.select_block"), EditorUI.getBlockList(), 1);
            CustomBlockState result = selectBlockWidget.getResultState();
            if (result != null) {
                this.leavesState = result;
            }
        }

        @Override
        public void writeSettings(class_2487 tag) {
            tag.method_10548("TreeType", (float)this.type[0]);
            tag.method_10548("TreeBaseChance", this.baseChance[0]);
            tag.method_10569("TreeMinimumDistance", this.minimumDistance[0]);
            tag.method_10582("TreeLogState", ServerCustomBlocks.serialize(this.logState));
        }
    }

    public static final class FakeWorldGenLevel
    implements class_5281 {
        private final class_638 level;
        private ChunkedBlockRegion blockRegion;
        private final class_6756<class_2248> blockTicks;
        private final class_6756<class_3611> fluidTicks;
        private final class_5217 levelData;

        public FakeWorldGenLevel(class_638 level) {
            this.level = level;
            this.blockTicks = new DummyTickAccess<class_2248>();
            this.fluidTicks = new DummyTickAccess<class_3611>();
            this.levelData = new FakeLevelData();
        }

        public void setBlockRegion(ChunkedBlockRegion blockRegion) {
            this.blockRegion = blockRegion;
        }

        public long method_8412() {
            return 0L;
        }

        public class_3218 method_8410() {
            throw new UnsupportedOperationException();
        }

        public long method_39224() {
            return 0L;
        }

        public class_6756<class_2248> method_8397() {
            return this.blockTicks;
        }

        public class_6756<class_3611> method_8405() {
            return this.fluidTicks;
        }

        public class_5217 method_8401() {
            return this.levelData;
        }

        public class_1266 method_8404(class_2338 blockPos) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public MinecraftServer method_8503() {
            throw new UnsupportedOperationException();
        }

        public class_2802 method_8398() {
            throw new UnsupportedOperationException();
        }

        public class_5819 method_8409() {
            throw new UnsupportedOperationException();
        }

        public void method_8396(@Nullable class_1657 player, class_2338 blockPos, class_3414 soundEvent, class_3419 soundSource, float f, float g2) {
        }

        public void method_8406(class_2394 particleOptions, double d, double e, double f, double g2, double h2, double i) {
        }

        public void method_8444(@Nullable class_1657 player, int i, class_2338 blockPos, int j) {
        }

        public void method_32888(class_5712 gameEvent, class_243 vec3, class_5712.class_7397 context) {
        }

        public float method_24852(class_2350 direction, boolean bl) {
            throw new UnsupportedOperationException();
        }

        public class_3568 method_22336() {
            throw new UnsupportedOperationException();
        }

        public class_2784 method_8621() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public class_2586 method_8321(class_2338 blockPos) {
            return null;
        }

        public class_2680 method_8320(class_2338 blockPos) {
            return this.blockRegion.getBlockStateOrDelegate(blockPos, (class_1937)this.level);
        }

        public class_3610 method_8316(class_2338 blockPos) {
            return this.method_8320(blockPos).method_26227();
        }

        public List<class_1297> method_8333(@Nullable class_1297 entity, class_238 aABB, Predicate<? super class_1297> predicate) {
            return List.of();
        }

        public <T extends class_1297> List<T> method_18023(class_5575<class_1297, T> entityTypeTest, class_238 aABB, Predicate<? super T> predicate) {
            return List.of();
        }

        public List<? extends class_1657> method_18456() {
            return List.of();
        }

        @Nullable
        public class_2791 method_8402(int i, int j, class_2806 chunkStatus, boolean bl) {
            throw new UnsupportedOperationException();
        }

        public int method_8624(class_2902.class_2903 types, int i, int j) {
            return this.level.method_8624(types, i, j);
        }

        public int method_8594() {
            return 0;
        }

        public class_4543 method_22385() {
            throw new UnsupportedOperationException();
        }

        public class_6880<class_1959> method_22387(int i, int j, int k) {
            throw new UnsupportedOperationException();
        }

        public boolean method_8608() {
            throw new UnsupportedOperationException();
        }

        public int method_8615() {
            throw new UnsupportedOperationException();
        }

        public class_2874 method_8597() {
            return this.level.method_8597();
        }

        public class_5455 method_30349() {
            throw new UnsupportedOperationException();
        }

        public class_7699 method_45162() {
            throw new UnsupportedOperationException();
        }

        public boolean method_16358(class_2338 blockPos, Predicate<class_2680> predicate) {
            return predicate.test(this.method_8320(blockPos));
        }

        public boolean method_35237(class_2338 blockPos, Predicate<class_3610> predicate) {
            return predicate.test(this.method_8316(blockPos));
        }

        public boolean method_30092(class_2338 blockPos, class_2680 blockState, int i, int j) {
            this.blockRegion.addBlock(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), blockState);
            return true;
        }

        public boolean method_8650(class_2338 blockPos, boolean bl) {
            return false;
        }

        public boolean method_30093(class_2338 blockPos, boolean bl, @Nullable class_1297 entity, int i) {
            return false;
        }
    }

    public static class FakeChunkGenerator
    extends class_2794 {
        private final class_638 clientLevel;

        public FakeChunkGenerator(class_638 clientLevel) {
            super(null);
            this.clientLevel = clientLevel;
        }

        protected Codec<? extends class_2794> method_28506() {
            throw new UnsupportedOperationException();
        }

        public void method_12108(class_3233 worldGenRegion, long l, class_7138 randomState, class_4543 biomeManager, class_5138 structureManager, class_2791 chunkAccess, class_2893.class_2894 carving) {
        }

        public void method_12110(class_3233 worldGenRegion, class_5138 structureManager, class_7138 randomState, class_2791 chunkAccess) {
        }

        public void method_12107(class_3233 worldGenRegion) {
        }

        public int method_12104() {
            return this.clientLevel.method_31605();
        }

        public CompletableFuture<class_2791> method_12088(Executor executor, class_6748 blender, class_7138 randomState, class_5138 structureManager, class_2791 chunkAccess) {
            throw new UnsupportedOperationException();
        }

        public int method_16398() {
            return this.clientLevel.method_8615();
        }

        public int method_33730() {
            return this.clientLevel.method_31607();
        }

        public int method_16397(int i, int j, class_2902.class_2903 types, class_5539 levelHeightAccessor, class_7138 randomState) {
            throw new UnsupportedOperationException();
        }

        public class_4966 method_26261(int i, int j, class_5539 levelHeightAccessor, class_7138 randomState) {
            throw new UnsupportedOperationException();
        }

        public void method_40450(List<String> list, class_7138 randomState, class_2338 blockPos) {
            throw new UnsupportedOperationException();
        }
    }

    public static class DummyTickAccess<T>
    implements class_6756<T> {
        public boolean method_8677(class_2338 blockPos, T object) {
            return false;
        }

        public void method_39363(class_6760<T> scheduledTick) {
        }

        public boolean method_8674(class_2338 blockPos, T object) {
            return false;
        }

        public int method_20825() {
            return 0;
        }
    }

    public static class FakeLevelData
    implements class_5217 {
        public int method_215() {
            return 0;
        }

        public int method_144() {
            return 0;
        }

        public int method_166() {
            return 0;
        }

        public float method_30656() {
            return 0.0f;
        }

        public long method_188() {
            return 0L;
        }

        public long method_217() {
            return 0L;
        }

        public boolean method_203() {
            return false;
        }

        public boolean method_156() {
            return false;
        }

        public void method_157(boolean bl) {
        }

        public boolean method_152() {
            return false;
        }

        public class_1928 method_146() {
            throw new UnsupportedOperationException();
        }

        public class_1267 method_207() {
            throw new UnsupportedOperationException();
        }

        public boolean method_197() {
            return false;
        }
    }
}

