/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.text;

import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.block_maps.HDVoxelMap;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.gizmo.Gizmo;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.ChunkRenderOverrider;
import com.moulberry.axiom.render.Shapes;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.text.TextDrawing;
import com.moulberry.axiom.utils.AsyncFileDialogs;
import com.moulberry.axiom.utils.NbtGetter;
import com.moulberry.axiom.utils.RegionHelper;
import imgui.ImGui;
import imgui.type.ImString;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class TextTool
implements Tool {
    private final PositionSet cutout = new PositionSet();
    private final ChunkedBlockRegion blocks = new ChunkedBlockRegion();
    @Nullable
    private Gizmo gizmo = null;
    private class_2680 oldActiveBlock = null;
    private Path oldCustomFont = null;
    private final ImString text = new ImString(256);
    private final int[] direction = new int[]{0};
    private final int[] size = new int[]{64};
    private boolean useFullBlocks = false;
    private boolean useBuiltinFont = true;
    private Path customFont = null;

    @Override
    public void reset() {
        if (this.gizmo != null) {
            ChunkRenderOverrider.INSTANCE.release("text_tool");
            this.gizmo = null;
        }
        this.blocks.clear();
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                RayCaster.RaycastResult result = Tool.raycastBlock();
                if (result != null) {
                    if (this.gizmo == null) {
                        ChunkRenderOverrider.INSTANCE.acquire("text_tool");
                    }
                    this.gizmo = new Gizmo(result.getBlockPos());
                    this.drawText();
                }
                return UserAction.ActionResult.USED_STOP;
            }
            case REDO: {
                if (this.gizmo == null) break;
                return UserAction.ActionResult.USED_STOP;
            }
            case ESCAPE: 
            case DELETE: 
            case UNDO: {
                if (this.gizmo == null) {
                    return UserAction.ActionResult.NOT_HANDLED;
                }
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
            case ENTER: {
                if (this.gizmo != null && !this.blocks.isEmpty()) {
                    class_2487 sourceInfo = Tool.getSourceInfo(this);
                    String countString = NumberFormat.getInstance().format(this.blocks.count());
                    String historyDescription = AxiomI18n.get("axiom.history_description.text_tool", countString);
                    if (this.direction[0] == 0 || this.direction[0] == 1) {
                        int minX = this.blocks.min().method_10263();
                        int minZ = this.blocks.min().method_10260();
                        RegionHelper.pushBlockRegionChangeOffset(this.blocks, this.gizmo.getTargetPosition().method_10069(-minX, 0, -minZ), historyDescription, sourceInfo, 0);
                    } else {
                        int maxX = this.blocks.max().method_10263();
                        int maxZ = this.blocks.max().method_10260();
                        RegionHelper.pushBlockRegionChangeOffset(this.blocks, this.gizmo.getTargetPosition().method_10069(-maxX, 0, -maxZ), historyDescription, sourceInfo, 0);
                    }
                    this.reset();
                }
                return UserAction.ActionResult.USED_STOP;
            }
            case LEFT_MOUSE: {
                if (this.leftClick()) {
                    return UserAction.ActionResult.USED_STOP;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case SCROLL: {
                if (this.gizmo == null) break;
                UserAction.ScrollAmount scrollObject = (UserAction.ScrollAmount)object;
                this.handleScroll(scrollObject.scrollX(), scrollObject.scrollY());
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    private boolean leftClick() {
        if (this.gizmo == null) {
            return false;
        }
        return this.gizmo.leftClick();
    }

    public void handleScroll(int xScroll, int yScroll) {
        if (this.gizmo == null || EditorUI.isCtrlOrCmdDown() && !this.gizmo.isGrabbed()) {
            return;
        }
        if (this.gizmo != null) {
            class_243 lookDirection = Tool.getLookDirection();
            if (lookDirection == null) {
                return;
            }
            class_2338 oldPosition = this.gizmo.getTargetPosition();
            this.gizmo.handleScroll(xScroll, yScroll, EditorUI.isCtrlOrCmdDown(), lookDirection);
            if (!oldPosition.equals((Object)this.gizmo.getTargetPosition())) {
                if (this.direction[0] == 0 || this.direction[0] == 1) {
                    int minX = this.blocks.min().method_10263();
                    int minZ = this.blocks.min().method_10260();
                    ChunkRenderOverrider.INSTANCE.cutoutBoolean(this.cutout, this.gizmo.getTargetPosition().method_10069(-minX, 0, -minZ));
                } else {
                    int maxX = this.blocks.max().method_10263();
                    int maxZ = this.blocks.max().method_10260();
                    ChunkRenderOverrider.INSTANCE.cutoutBoolean(this.cutout, this.gizmo.getTargetPosition().method_10069(-maxX, 0, -maxZ));
                }
            }
        }
    }

    public void drawText() {
        if (this.gizmo == null) {
            return;
        }
        this.oldActiveBlock = Tool.getActiveBlock();
        this.oldCustomFont = this.customFont;
        float size = this.size[0];
        if (size < 8.0f) {
            size = 8.0f;
        }
        if (size > 256.0f) {
            size = 256.0f;
        }
        String text = ImGuiHelper.getString(this.text);
        this.blocks.clear();
        HDVoxelMap.HDVoxelBaseBlocks blocks = HDVoxelMap.getAssociatedBlocks(this.oldActiveBlock.method_26204());
        if (blocks != null && !this.useFullBlocks) {
            TextDrawing.drawFancy(this.blocks, this.useBuiltinFont ? null : this.customFont, blocks, text, this.direction[0], size);
        } else {
            TextDrawing.drawSimple(this.blocks, this.useBuiltinFont ? null : this.customFont, this.oldActiveBlock, text, this.direction[0], size / 2.0f);
        }
        if (this.blocks.isEmpty()) {
            this.cutout.clear();
            ChunkRenderOverrider.INSTANCE.clear();
        } else {
            this.cutout.clear();
            this.blocks.forEachEntry((x, y, z, block) -> this.cutout.add(x, y, z));
            if (this.direction[0] == 0 || this.direction[0] == 1) {
                int minX = this.blocks.min().method_10263();
                int minZ = this.blocks.min().method_10260();
                ChunkRenderOverrider.INSTANCE.cutoutBoolean(this.cutout, this.gizmo.getTargetPosition().method_10069(-minX, 0, -minZ));
            } else {
                int maxX = this.blocks.max().method_10263();
                int maxZ = this.blocks.max().method_10260();
                ChunkRenderOverrider.INSTANCE.cutoutBoolean(this.cutout, this.gizmo.getTargetPosition().method_10069(-maxX, 0, -maxZ));
            }
        }
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        if (this.oldActiveBlock != Tool.getActiveBlock()) {
            this.drawText();
        }
        if (this.customFont != this.oldCustomFont) {
            this.drawText();
        }
        if (this.gizmo != null) {
            class_243 lookDirection = Tool.getLookDirection();
            boolean isLeftDown = Tool.isMouseDown(0);
            boolean isCtrlDown = EditorUI.isCtrlOrCmdDown();
            boolean showGizmo = !EditorUI.isActive() || !isCtrlDown;
            class_2338 oldPosition = this.gizmo.getTargetPosition();
            this.gizmo.update(time, lookDirection, isLeftDown, isCtrlDown, showGizmo);
            this.gizmo.setAxisDirections(camera.method_19326().field_1352 > (double)this.gizmo.getTargetPosition().method_10263(), camera.method_19326().field_1351 > (double)this.gizmo.getTargetPosition().method_10264(), camera.method_19326().field_1350 > (double)this.gizmo.getTargetPosition().method_10260());
            if (!this.blocks.isEmpty()) {
                class_243 two;
                class_243 one;
                class_243 blockOffset;
                int minX;
                if (!oldPosition.equals((Object)this.gizmo.getTargetPosition())) {
                    if (this.direction[0] == 0 || this.direction[0] == 1) {
                        minX = this.blocks.min().method_10263();
                        int minZ = this.blocks.min().method_10260();
                        ChunkRenderOverrider.INSTANCE.cutoutBoolean(this.cutout, this.gizmo.getTargetPosition().method_10069(-minX, 0, -minZ));
                    } else {
                        int maxX = this.blocks.max().method_10263();
                        int maxZ = this.blocks.max().method_10260();
                        ChunkRenderOverrider.INSTANCE.cutoutBoolean(this.cutout, this.gizmo.getTargetPosition().method_10069(-maxX, 0, -maxZ));
                    }
                }
                minX = this.blocks.min().method_10263();
                int minY = this.blocks.min().method_10264();
                int minZ = this.blocks.min().method_10260();
                int maxX = this.blocks.max().method_10263();
                int maxY = this.blocks.max().method_10264();
                int maxZ = this.blocks.max().method_10260();
                if (this.direction[0] == 0 || this.direction[0] == 1) {
                    blockOffset = this.gizmo.getInterpPosition().method_1023(0.5, 0.5, 0.5).method_1023((double)minX, 0.0, (double)minZ);
                    one = this.gizmo.getInterpPosition().method_1023(0.5, 0.5, 0.5).method_1031(0.0, (double)minY, 0.0);
                    two = this.gizmo.getInterpPosition().method_1031(0.5, 0.5, 0.5).method_1031((double)(maxX - minX), (double)maxY, (double)(maxZ - minZ));
                } else {
                    blockOffset = this.gizmo.getInterpPosition().method_1023(0.5, 0.5, 0.5).method_1023((double)maxX, 0.0, (double)maxZ);
                    one = this.gizmo.getInterpPosition().method_1023(0.5, 0.5, 0.5).method_1031((double)(minX - maxX), (double)minY, (double)(minZ - maxZ));
                    two = this.gizmo.getInterpPosition().method_1031(0.5, 0.5, 0.5).method_1031(0.0, (double)maxY, 0.0);
                }
                this.blocks.render(camera, blockOffset, null, matrices, projection, 1.0f, 0.0f, false);
                this.renderBoundingBox(camera, time, matrices, one, two);
            }
            if (this.gizmo.isGrabbed() || showGizmo) {
                this.gizmo.render(matrices, camera, isCtrlDown);
            }
        }
    }

    private void renderBoundingBox(class_4184 camera, long time, class_4587 matrices, class_243 one, class_243 two) {
        float minX = (float)Math.min(one.method_10216(), two.method_10216()) - 1.0E-4f;
        float minY = (float)Math.min(one.method_10214(), two.method_10214()) - 1.0E-4f;
        float minZ = (float)Math.min(one.method_10215(), two.method_10215()) - 1.0E-4f;
        float maxX = (float)Math.max(one.method_10216(), two.method_10216()) + 1.0E-4f;
        float maxY = (float)Math.max(one.method_10214(), two.method_10214()) + 1.0E-4f;
        float maxZ = (float)Math.max(one.method_10215(), two.method_10215()) + 1.0E-4f;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        matrices.method_22903();
        matrices.method_22904(-camera.method_19326().field_1352, -camera.method_19326().field_1351, -camera.method_19326().field_1350);
        matrices.method_46416(minX, minY, minZ);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.lineWidth((float)2.0f);
        RenderSystem.disableCull();
        RenderSystem.setShader(class_757::method_34535);
        RenderSystem.enableDepthTest();
        bufferBuilder.method_1328(class_293.class_5596.field_27377, class_290.field_29337);
        Shapes.lineBox(matrices, (class_4588)bufferBuilder, 0.0f, 0.0f, 0.0f, maxX - minX, maxY - minY, maxZ - minZ, 1.0f, 1.0f, 1.0f, 0.5f, 1.0f, 1.0f, 1.0f);
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        RenderSystem.disableDepthTest();
        bufferBuilder.method_1328(class_293.class_5596.field_27377, class_290.field_29337);
        Shapes.lineBox(matrices, (class_4588)bufferBuilder, 0.0f, 0.0f, 0.0f, maxX - minX, maxY - minY, maxZ - minZ, 1.0f, 1.0f, 1.0f, 0.15f, 1.0f, 1.0f, 1.0f);
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        matrices.method_22909();
    }

    @Override
    public void displayImguiOptions() {
        class_2680 activeBlock;
        Object selectFontText;
        boolean changed = false;
        changed |= ImGui.inputText(AxiomI18n.get("axiom.tool.text.text_input"), this.text);
        changed |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.text.direction"), this.direction, new String[]{"+X", "+Z", "-X", "-Z"});
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.text.font"));
        changed |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.text.text_size"), this.size, 12, 256);
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.text.use_builtin_font"), this.useBuiltinFont)) {
            this.useBuiltinFont = !this.useBuiltinFont;
            changed = true;
        }
        if (!this.useBuiltinFont && ImGui.button((String)(selectFontText = this.customFont != null ? AxiomI18n.get("axiom.tool.text.font") + ": " + this.customFont.getFileName().toString() : AxiomI18n.get("axiom.tool.text.select_font")))) {
            String separator;
            Path fontDirectory = this.getDefaultFontDirectory();
            Object defaultPath = fontDirectory.toString();
            if (!((String)defaultPath).endsWith(separator = fontDirectory.getFileSystem().getSeparator())) {
                defaultPath = (String)defaultPath + separator;
            }
            CompletableFuture<String> future = AsyncFileDialogs.openFileDialog((String)defaultPath, "TrueType Font", "ttf", "otf");
            future.thenAccept(path -> {
                this.customFont = Path.of(path, new String[0]);
            });
        }
        if (HDVoxelMap.getAssociatedBlocks((activeBlock = Tool.getActiveBlock()).method_26204()) != null) {
            ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.text.rasterization"));
            if (ImGui.checkbox(AxiomI18n.get("axiom.tool.text.use_full_blocks"), this.useFullBlocks)) {
                this.useFullBlocks = !this.useFullBlocks;
                changed = true;
            }
        }
        if (changed) {
            this.drawText();
        }
    }

    private Path getDefaultFontDirectory() {
        ArrayList<Path> possiblePaths = new ArrayList<Path>();
        switch (class_156.method_668()) {
            case field_1135: 
            case field_1134: {
                Path path = Path.of("/usr", "share", "fonts");
                if (Files.exists(path, new LinkOption[0])) {
                    possiblePaths.add(path);
                }
                if (Files.exists(path = Path.of("/usr", "local", "share", "fonts"), new LinkOption[0])) {
                    possiblePaths.add(path);
                }
                if (!Files.exists(path = Path.of(System.getProperty("user.home"), ".local", "share", "fonts"), new LinkOption[0])) break;
                possiblePaths.add(path);
                break;
            }
            case field_1133: {
                Path path = Path.of("C:/Windows", "Fonts");
                if (!Files.exists(path, new LinkOption[0])) break;
                possiblePaths.add(path);
                break;
            }
            case field_1137: {
                Path path = Path.of("/Library", "Fonts");
                if (Files.exists(path, new LinkOption[0])) {
                    possiblePaths.add(path);
                }
                if (Files.exists(path = Path.of("/System", "Library", "Fonts"), new LinkOption[0])) {
                    possiblePaths.add(path);
                }
                if (!Files.exists(path = Path.of(System.getProperty("user.home"), "Library", "Fonts"), new LinkOption[0])) break;
                possiblePaths.add(path);
            }
        }
        int highestCount = 0;
        Path bestPath = null;
        for (Path possiblePath : possiblePaths) {
            int pathCount = this.countFontFiles(possiblePath);
            if (bestPath != null && pathCount <= highestCount) continue;
            bestPath = possiblePath;
            highestCount = pathCount;
        }
        if (bestPath != null) {
            return bestPath;
        }
        return FabricLoader.getInstance().getGameDir();
    }

    private int countFontFiles(Path path) {
        if (!Files.exists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) {
            return 0;
        }
        try {
            int count = 0;
            for (Path child : Files.newDirectoryStream(path)) {
                String childName = child.getFileName().toString();
                if (!childName.endsWith(".ttf") && !childName.endsWith(".otf")) continue;
                ++count;
            }
            return count;
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public String listenForEsc() {
        if (this.gizmo == null) {
            return null;
        }
        return AxiomI18n.get("axiom.widget.cancel");
    }

    @Override
    public String listenForEnter() {
        if (this.gizmo == null || this.blocks.isEmpty()) {
            return null;
        }
        return AxiomI18n.get("axiom.widget.confirm");
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.text");
    }

    @Override
    public void writeSourceInfo(class_2487 tag, boolean includeSettings) {
        tag.method_10582("SourceName", "Text Tool");
        if (includeSettings) {
            class_2487 settings = new class_2487();
            this.writeSettings(settings);
            tag.method_10566("SourceSettings", (class_2520)settings);
        }
    }

    @Override
    public void writeSettings(class_2487 tag) {
        tag.method_10569("Size", this.size[0]);
        tag.method_10556("UseFullBlocks", this.useFullBlocks);
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.size[0] = NbtGetter.getIntOrDefault(tag, "Size", 64);
        this.useFullBlocks = NbtGetter.getBoolOrDefault(tag, "UseFullBlocks", false);
        this.useBuiltinFont = true;
    }

    @Override
    public char iconChar() {
        return '\ue901';
    }

    @Override
    public String keybindId() {
        return "text";
    }
}

