/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.utils;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.world_modification.BlockBuffer;
import net.minecraft.class_1208;
import net.minecraft.class_155;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2359;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2841;
import net.minecraft.class_2960;
import net.minecraft.class_3551;

public class DFUHelper {
    private static final int DATA_VERSION = class_155.method_16673().method_37912().method_38494();

    public static void checkContainerFormat() {
        class_2841 container = new class_2841((class_2359)class_2248.field_10651, (Object)class_2246.field_10560.method_9564(), class_2841.class_6563.field_34569);
        class_2520 encoded = (class_2520)BlockBuffer.BLOCK_STATE_CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)container).getOrThrow(false, Axiom.LOGGER::error);
        if (!(encoded instanceof class_2487)) {
            throw new RuntimeException("Encoded PalettedContainer isn't a CompoundTag");
        }
        class_2487 compoundTag = (class_2487)encoded;
        if (!DFUHelper.hasExpectedPaletteTag(compoundTag)) {
            throw new RuntimeException("Encoded PalettedContainer doesn't have palette");
        }
        class_2499 paletteList = compoundTag.method_10554("palette", 10);
        if (paletteList.isEmpty()) {
            throw new RuntimeException("Encoded PalettedContainer's palette is empty");
        }
        for (class_2520 entry : paletteList) {
            if (!(entry instanceof class_2487)) {
                throw new RuntimeException("Encoded PalettedContainer's palette element isn't a CompoundTag");
            }
            class_2487 entryCompound = (class_2487)entry;
            if (!entryCompound.method_10545("Name")) {
                throw new RuntimeException("Encoded PalettedContainer's palette element doesn't contain 'Name'");
            }
            if (entryCompound.method_10545("Properties")) continue;
            throw new RuntimeException("Encoded PalettedContainer's palette element doesn't contain 'Properties'");
        }
    }

    public static class_2487 updatePalettedContainer(class_2487 tag, int fromVersion) {
        if (!DFUHelper.hasExpectedPaletteTag(tag)) {
            Axiom.LOGGER.warn("'palette' tag missing from PalettedContainer NBT, unable to upgrade...");
            return tag;
        }
        if (fromVersion == DATA_VERSION) {
            return tag;
        }
        tag = tag.method_10553();
        class_2499 newPalette = new class_2499();
        for (class_2520 entry : tag.method_10554("palette", 10)) {
            Dynamic dynamic = new Dynamic((DynamicOps)class_2509.field_11560, (Object)entry);
            Dynamic output = class_3551.method_15450().update(class_1208.field_5720, dynamic, fromVersion, DATA_VERSION);
            newPalette.add((Object)((class_2520)output.getValue()));
        }
        tag.method_10566("palette", (class_2520)newPalette);
        return tag;
    }

    public static DataResult<class_2680> updateBlockState(class_2487 tag, int fromVersion) {
        Dynamic dynamic = new Dynamic((DynamicOps)class_2509.field_11560, (Object)tag);
        Dynamic output = class_3551.method_15450().update(class_1208.field_5720, dynamic, fromVersion, DATA_VERSION);
        return class_2680.field_24734.parse(output);
    }

    public static class_2487 createBlockTag(String input) throws CommandSyntaxException {
        class_2487 blockTag = new class_2487();
        StringReader reader = new StringReader(input);
        class_2960 blockResourceLocation = class_2960.method_12835((StringReader)reader);
        blockTag.method_10582("Name", blockResourceLocation.toString());
        class_2487 properties = new class_2487();
        if (reader.canRead() && reader.peek() == '[') {
            reader.skip();
            reader.skipWhitespace();
            while (reader.canRead() && reader.peek() != ']') {
                reader.skipWhitespace();
                String property = reader.readString();
                if (!reader.canRead() || reader.peek() != '=') {
                    throw new RuntimeException("Expected =");
                }
                reader.skip();
                reader.skipWhitespace();
                String value = reader.readString();
                properties.method_10582(property, value);
                reader.skipWhitespace();
                if (!reader.canRead()) break;
                if (reader.peek() == ',') {
                    reader.skip();
                    continue;
                }
                if (reader.peek() != ']') continue;
                break;
            }
        }
        blockTag.method_10566("Properties", (class_2520)properties);
        return blockTag;
    }

    private static boolean hasExpectedPaletteTag(class_2487 tag) {
        if (!tag.method_10573("palette", 9)) {
            return false;
        }
        class_2499 listTag = (class_2499)tag.method_10580("palette");
        if (listTag == null) {
            return false;
        }
        return listTag.isEmpty() || listTag.method_10601() == 10;
    }
}

