/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.utils;

import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class IntMatrix {
    public int m00;
    public int m01;
    public int m02;
    public int m10;
    public int m11;
    public int m12;
    public int m20;
    public int m21;
    public int m22;

    public IntMatrix() {
        this.m00 = 1;
        this.m11 = 1;
        this.m22 = 1;
    }

    public IntMatrix(IntMatrix other) {
        this.m00 = other.m00;
        this.m01 = other.m01;
        this.m02 = other.m02;
        this.m10 = other.m10;
        this.m11 = other.m11;
        this.m12 = other.m12;
        this.m20 = other.m20;
        this.m21 = other.m21;
        this.m22 = other.m22;
    }

    public boolean isIdentity() {
        if (this.m00 != 1) {
            return false;
        }
        if (this.m01 != 0) {
            return false;
        }
        if (this.m02 != 0) {
            return false;
        }
        if (this.m10 != 0) {
            return false;
        }
        if (this.m11 != 1) {
            return false;
        }
        if (this.m12 != 0) {
            return false;
        }
        if (this.m20 != 0) {
            return false;
        }
        if (this.m21 != 0) {
            return false;
        }
        return this.m22 == 1;
    }

    public void identity() {
        this.m00 = 1;
        this.m01 = 0;
        this.m02 = 0;
        this.m10 = 0;
        this.m11 = 1;
        this.m12 = 0;
        this.m20 = 0;
        this.m21 = 0;
        this.m22 = 1;
    }

    public IntMatrix copy() {
        return new IntMatrix(this);
    }

    public void invert() {
        int a = this.m00 * this.m11 - this.m01 * this.m10;
        int b = this.m02 * this.m10 - this.m00 * this.m12;
        int c = this.m01 * this.m12 - this.m02 * this.m11;
        int d = a * this.m22 + b * this.m21 + c * this.m20;
        int nm00 = (this.m11 * this.m22 - this.m21 * this.m12) / d;
        int nm01 = (this.m21 * this.m02 - this.m01 * this.m22) / d;
        int nm02 = c / d;
        int nm10 = (this.m20 * this.m12 - this.m10 * this.m22) / d;
        int nm11 = (this.m00 * this.m22 - this.m20 * this.m02) / d;
        int nm12 = b / d;
        int nm20 = (this.m10 * this.m21 - this.m20 * this.m11) / d;
        int nm21 = (this.m20 * this.m01 - this.m00 * this.m21) / d;
        int nm22 = a / d;
        this.m00 = nm00;
        this.m01 = nm01;
        this.m02 = nm02;
        this.m10 = nm10;
        this.m11 = nm11;
        this.m12 = nm12;
        this.m20 = nm20;
        this.m21 = nm21;
        this.m22 = nm22;
    }

    public class_2338 transform(class_2338 pos) {
        int lx = pos.method_10263();
        int ly = pos.method_10264();
        int lz = pos.method_10260();
        return new class_2338(lx * this.m00 + ly * this.m10 + lz * this.m20, lx * this.m01 + ly * this.m11 + lz * this.m21, lx * this.m02 + ly * this.m12 + lz * this.m22);
    }

    public int transformX(int x, int y, int z) {
        return x * this.m00 + y * this.m10 + z * this.m20;
    }

    public int transformY(int x, int y, int z) {
        return x * this.m01 + y * this.m11 + z * this.m21;
    }

    public int transformZ(int x, int y, int z) {
        return x * this.m02 + y * this.m12 + z * this.m22;
    }

    public float transformFloatX(float x, float y, float z) {
        return x * (float)this.m00 + y * (float)this.m10 + z * (float)this.m20;
    }

    public float transformFloatY(float x, float y, float z) {
        return x * (float)this.m01 + y * (float)this.m11 + z * (float)this.m21;
    }

    public float transformFloatZ(float x, float y, float z) {
        return x * (float)this.m02 + y * (float)this.m12 + z * (float)this.m22;
    }

    public void rotateY(int count) {
        if ((count %= 4) < 0) {
            count += 4;
        }
        if (count == 1) {
            int nm00 = this.m02;
            int nm10 = this.m12;
            int nm20 = this.m22;
            this.m02 = -this.m00;
            this.m12 = -this.m10;
            this.m22 = -this.m20;
            this.m00 = nm00;
            this.m10 = nm10;
            this.m20 = nm20;
        } else if (count == 2) {
            this.m02 *= -1;
            this.m12 *= -1;
            this.m22 *= -1;
            this.m00 *= -1;
            this.m10 *= -1;
            this.m20 *= -1;
        } else if (count == 3) {
            int nm00 = -this.m02;
            int nm10 = -this.m12;
            int nm20 = -this.m22;
            this.m02 = this.m00;
            this.m12 = this.m10;
            this.m22 = this.m20;
            this.m00 = nm00;
            this.m10 = nm10;
            this.m20 = nm20;
        }
    }

    public void flip(class_2350.class_2351 axis) {
        switch (axis) {
            case field_11048: {
                this.m00 *= -1;
                this.m10 *= -1;
                this.m20 *= -1;
                break;
            }
            case field_11052: {
                this.m01 *= -1;
                this.m11 *= -1;
                this.m21 *= -1;
                break;
            }
            case field_11051: {
                this.m02 *= -1;
                this.m12 *= -1;
                this.m22 *= -1;
            }
        }
    }

    public String toString() {
        return "IntMatrix{m00=" + this.m00 + ", m01=" + this.m01 + ", m02=" + this.m02 + ", m10=" + this.m10 + ", m11=" + this.m11 + ", m12=" + this.m12 + ", m20=" + this.m20 + ", m21=" + this.m21 + ", m22=" + this.m22 + "}";
    }
}

