/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.world_properties;

import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2359;
import net.minecraft.class_2540;
import net.minecraft.class_3902;
import net.minecraft.class_7923;

public abstract class WorldPropertyDataType<T> {
    public static WorldPropertyDataType<Boolean> BOOLEAN = new WorldPropertyDataType<Boolean>(){

        @Override
        public int getTypeId() {
            return 0;
        }

        @Override
        public byte[] serialize(Boolean value) {
            return new byte[]{value != false ? (byte)1 : 0};
        }

        @Override
        public Boolean deserialize(byte[] bytes) {
            return bytes[0] != 0;
        }
    };
    public static WorldPropertyDataType<Integer> INTEGER = new WorldPropertyDataType<Integer>(){

        @Override
        public int getTypeId() {
            return 1;
        }

        @Override
        public byte[] serialize(Integer value) {
            class_2540 buf = new class_2540(Unpooled.buffer((int)8));
            buf.method_10804(value.intValue());
            byte[] bytes = new byte[buf.writerIndex()];
            buf.getBytes(0, bytes);
            return bytes;
        }

        @Override
        public Integer deserialize(byte[] bytes) {
            class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])bytes));
            return buf.method_10816();
        }
    };
    public static WorldPropertyDataType<String> STRING = new WorldPropertyDataType<String>(){

        @Override
        public int getTypeId() {
            return 2;
        }

        @Override
        public byte[] serialize(String value) {
            return value.getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public String deserialize(byte[] bytes) {
            return new String(bytes, StandardCharsets.UTF_8);
        }
    };
    public static WorldPropertyDataType<class_1792> ITEM = new WorldPropertyDataType<class_1792>(){

        @Override
        public int getTypeId() {
            return 3;
        }

        @Override
        public byte[] serialize(class_1792 value) {
            class_2540 buf = new class_2540(Unpooled.buffer((int)8));
            buf.method_42065((class_2359)class_7923.field_41178, (Object)value);
            byte[] bytes = new byte[buf.writerIndex()];
            buf.getBytes(0, bytes);
            return bytes;
        }

        @Override
        public class_1792 deserialize(byte[] bytes) {
            class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])bytes));
            return (class_1792)buf.method_42064((class_2359)class_7923.field_41178);
        }
    };
    public static WorldPropertyDataType<class_2248> BLOCK = new WorldPropertyDataType<class_2248>(){

        @Override
        public int getTypeId() {
            return 4;
        }

        @Override
        public byte[] serialize(class_2248 value) {
            class_2540 buf = new class_2540(Unpooled.buffer((int)8));
            buf.method_42065((class_2359)class_7923.field_41175, (Object)value);
            byte[] bytes = new byte[buf.writerIndex()];
            buf.getBytes(0, bytes);
            return bytes;
        }

        @Override
        public class_2248 deserialize(byte[] bytes) {
            class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])bytes));
            return (class_2248)buf.method_42064((class_2359)class_7923.field_41175);
        }
    };
    public static WorldPropertyDataType<class_3902> EMPTY = new WorldPropertyDataType<class_3902>(){

        @Override
        public int getTypeId() {
            return 5;
        }

        @Override
        public byte[] serialize(class_3902 value) {
            return new byte[0];
        }

        @Override
        public class_3902 deserialize(byte[] bytes) {
            return class_3902.field_17274;
        }
    };

    public abstract int getTypeId();

    public abstract byte[] serialize(T var1);

    public abstract T deserialize(byte[] var1);
}

